/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.ma.budget.BgAnalyseHelper;
import com.kingdee.eas.ma.budget.BgConstants;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgItemAnalyseParam;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.BgItemReqUseAnalyseInfo;
import com.kingdee.eas.ma.budget.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.FilterParam;
import com.kingdee.eas.ma.budget.VisualItemInfo;
import com.kingdee.eas.ma.budget.client.BgAnalyseFilterBaseUI;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.client.AbstractBgItemReqUseAnalyseUI;
import com.kingdee.eas.ma.nbudget.client.BgItemReqUseAnalyseFilterUI;
import com.kingdee.util.StringUtils;
import edu.emory.mathcs.backport.java.util.Collections;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.security.SecureRandom;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgItemReqUseAnalyseUI
extends AbstractBgItemReqUseAnalyseUI {
    private static final long serialVersionUID = 4664584931920192567L;
    private static final Logger logger = CoreUIObject.getLogger(BgItemReqUseAnalyseUI.class);
    private Map muMap = new HashMap();
    private BigDecimal coefficient = BgNConstants.ONE;
    private int decimal = 8;
    private DecimalFormat decFormat = null;
    private static Map dataMap = null;
    private static boolean isNeedExpand = true;

    protected void setUITitle() {
        this.setUITitle(BgAnalyseHelper.getMessage((String)"bgItemReqUseAnalyse"));
    }

    protected String getQueryMainName() {
        return BgItemReqUseAnalyseUI.class.getName();
    }

    protected BgAnalyseFilterBaseUI getFilterUI() {
        if (this.defaultFilterUI == null) {
            try {
                this.defaultFilterUI = new BgItemReqUseAnalyseFilterUI((Object)this);
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
        }
        return this.defaultFilterUI;
    }

    protected int getWidthOfDialog() {
        return 300;
    }

    protected int getHeightOfDialog() {
        return 400;
    }

    public BigDecimal getCoefficient() {
        return this.coefficient;
    }

    public void setCoefficient(BigDecimal coefficient) {
        this.coefficient = coefficient;
    }

    public void setDecimal(int decimal) {
        this.decimal = decimal;
    }

    public int getDecimal() {
        return this.decimal;
    }

    public void setDecFormat(DecimalFormat decFormat) {
        this.decFormat = decFormat;
    }

    public DecimalFormat getDecFormat() {
        return this.decFormat;
    }

    protected void executeQuery() {
        FilterParam _filterParam = this.getFilterParam();
        if (_filterParam == null && !(_filterParam instanceof BgItemAnalyseParam)) {
            return;
        }
        this.init(_filterParam);
        try {
            dataMap = this.getInterface().queryBgItemReqUse(null, (Object)_filterParam);
        }
        catch (Exception ex) {
            this.handUIExceptionAndAbort(ex);
        }
        finally {
            this.initData(dataMap);
        }
    }

    private void initData(Map dataMap) {
        this.initData(dataMap, false);
    }

    protected void init(FilterParam filterParam) {
        BgItemAnalyseParam _itemAnalyseParam = (BgItemAnalyseParam)filterParam;
        this.setDecimal(_itemAnalyseParam.getCurrency().getPrecision());
        this.setDecFormat(BgNationalFormatUIUtil.getDecimalFormat((int)this.getDecimal()));
        this.initMeasureUnitMap(filterParam);
        this.clearAnalyseSheet();
        this.initAnalyseData(filterParam);
    }

    protected void initMeasureUnitMap(FilterParam filterParam) {
        this.muMap.clear();
        BgItemAnalyseParam _itemAnalyseParam = (BgItemAnalyseParam)filterParam;
        if (_itemAnalyseParam.getBgTemplateInfo() != null && _itemAnalyseParam.getBgTemplateInfo().getDefaultMeasureUnit() != null) {
            this.setCoefficient(_itemAnalyseParam.getBgTemplateInfo().getDefaultMeasureUnit().getCoefficient());
        }
        if (_itemAnalyseParam.getMuMap() != null) {
            Map.Entry _entry2 = null;
            BgElementInfo elementInfo = null;
            MeasureUnitInfo unitInfo = null;
            for (Map.Entry _entry2 : _itemAnalyseParam.getMuMap().entrySet()) {
                elementInfo = (BgElementInfo)_entry2.getKey();
                unitInfo = (MeasureUnitInfo)_entry2.getValue();
                if (elementInfo == null || unitInfo == null) continue;
                this.muMap.put(elementInfo.getNumber(), unitInfo.getCoefficient());
            }
        }
    }

    protected void initAnalyseData(FilterParam filterParam) {
        BgItemAnalyseParam _itemAnalyseParam = (BgItemAnalyseParam)filterParam;
        OrgUnitInfo orgUnitInfo2 = null;
        OrgUnitInfo[] orgUnitInfos = null;
        KDTable sheet = null;
        orgUnitInfos = _itemAnalyseParam.getOrgUnits();
        if (orgUnitInfos != null) {
            for (OrgUnitInfo orgUnitInfo2 : orgUnitInfos) {
                sheet = this.addAnalyseSheet(orgUnitInfo2.getId().toString(), orgUnitInfo2.getName());
                this.initHeadOfSheet(sheet);
            }
        }
    }

    protected void initHeadOfSheet(KDTable sheet) {
        if (sheet == null) {
            return;
        }
        sheet.getSelectManager().setSelectMode(10);
        IRow row = null;
        sheet.setRefresh(false);
        sheet.checkParsed();
        sheet.getGroupManager().setGroup(true);
        sheet.addColumns(2);
        sheet.getColumn(0).setWidth(100);
        sheet.getColumn(0).getStyleAttributes().setLocked(true);
        sheet.getColumn(0).setMergeable(true);
        sheet.getColumn(0).setGroup(true);
        sheet.getColumn(1).setWidth(250);
        sheet.getColumn(1).getStyleAttributes().setLocked(true);
        row = sheet.addHeadRow();
        row.getCell(0).setValue((Object)BgAnalyseHelper.getMessage((String)"bgPeriod"));
        row.getCell(1).setValue((Object)BgAnalyseHelper.getMessage((String)"bgitem"));
        row = sheet.addHeadRow();
        sheet.getHeadMergeManager().mergeBlock(0, 0, 1, 0);
        sheet.getHeadMergeManager().mergeBlock(0, 1, 1, 1);
        sheet.reLayoutAndPaint();
    }

    @Override
    public void actionExpand_actionPerformed(ActionEvent e) throws Exception {
        isNeedExpand = !isNeedExpand;
        this.initData(dataMap, true);
    }

    public String[] getMergeColumnKeys() {
        return new String[0];
    }

    private void initData(Map dataMap, boolean isExpandOperator) {
        if (dataMap == null || dataMap.isEmpty()) {
            return;
        }
        String _bgPeriod = null;
        boolean period_rowCount = false;
        List periodList = null;
        List bgList = null;
        List bgReqList = null;
        List bgUseList = null;
        HashMap bgEleMap = new HashMap();
        Map bgItemInfoMap = (Map)dataMap.get("BGITEM_INFO");
        Map bgEleInfoMap = (Map)dataMap.get("BGELEMENT_INFO");
        KDTable sheet = null;
        int in = this.getSheetSize();
        for (int i = 0; i < in; ++i) {
            sheet = (KDTable)this.getSheet(i);
            sheet.removeRows();
            int col = 2;
            while (col < sheet.getColumnCount()) {
                sheet.removeColumn(col);
            }
            bgEleMap.clear();
            if (sheet == null || !dataMap.containsKey(sheet.getID())) continue;
            periodList = (List)dataMap.get(sheet.getID() + "_PERIOD");
            bgList = (List)dataMap.get(sheet.getID());
            bgReqList = (List)dataMap.get(sheet.getID() + "_BGREQ");
            bgUseList = (List)dataMap.get("BGUSE");
            if (!isExpandOperator) {
                this.dealNeedGather(periodList, bgReqList, bgUseList, bgList);
            }
            ArrayList tempBgReqList = new ArrayList();
            ArrayList tempBgReqList1 = new ArrayList();
            if (bgReqList != null && bgReqList.size() > 0) {
                for (int t = 0; t < bgReqList.size(); ++t) {
                    tempBgReqList.add(bgReqList.get(t));
                    tempBgReqList1.add(bgReqList.get(t));
                }
            }
            ArrayList tempBgUseList = new ArrayList();
            ArrayList tempBgUseList1 = new ArrayList();
            if (bgUseList != null && bgUseList.size() > 0) {
                for (int t = 0; t < bgUseList.size(); ++t) {
                    tempBgUseList.add(bgUseList.get(t));
                    tempBgUseList1.add(bgUseList.get(t));
                }
            }
            sheet.setRefresh(false);
            int jn = periodList.size();
            for (int j = 0; j < jn; ++j) {
                _bgPeriod = periodList.get(j).toString();
                this.fillSheet(sheet, bgEleMap, _bgPeriod, bgList, tempBgReqList, tempBgUseList, bgItemInfoMap, bgEleInfoMap);
            }
            if (isNeedExpand) {
                this.fillSheetDetail(sheet, bgEleMap, periodList, bgList, tempBgReqList1, tempBgUseList1, bgItemInfoMap, bgEleInfoMap);
            }
            sheet.setRefresh(true);
        }
    }

    private Map productMapByPeriod(List periodList, List bgReqList, List bgUseList, List bgList) {
        if (bgReqList == null || bgList == null || periodList == null || bgReqList.isEmpty() || periodList.isEmpty() || bgList.isEmpty()) {
            return null;
        }
        HashMap result = new HashMap();
        ArrayList tempList = null;
        BgItemReqUseAnalyseInfo bgReqPara = null;
        BgItemReqUseAnalyseInfo temp = null;
        Object bgPara = null;
        BgItemReqUseAnalyseInfo bgUse2 = null;
        ArrayList<String> allBgItemNumber = new ArrayList<String>();
        for (int x = 0; x < periodList.size(); ++x) {
            String period = periodList.get(x).toString();
            HashMap tempMap = new HashMap();
            if (allBgItemNumber.isEmpty()) {
                for (int n = 0; n < bgList.size(); ++n) {
                    tempList = (ArrayList)bgList.get(n);
                    for (int t = 0; t < tempList.size(); ++t) {
                        bgReqPara = (BgItemReqUseAnalyseInfo)tempList.get(t);
                        if (bgReqPara == null || !bgReqPara.getBgPeriodName().equals(period)) continue;
                        allBgItemNumber.add(bgReqPara.getBgItemNumber());
                    }
                }
            }
            String number = null;
            Iterator it = null;
            HashMap<String, BgItemReqUseAnalyseInfo> reqMap = new HashMap<String, BgItemReqUseAnalyseInfo>();
            HashMap<String, BgItemReqUseAnalyseInfo> useMap = new HashMap<String, BgItemReqUseAnalyseInfo>();
            for (int n = 0; n < bgReqList.size(); ++n) {
                temp = (BgItemReqUseAnalyseInfo)bgReqList.get(n);
                number = temp.getBgItemNumber();
                if (!allBgItemNumber.contains(number) || !temp.getBgPeriodName().equals(period)) continue;
                reqMap.put(number, temp);
                for (BgItemReqUseAnalyseInfo bgUse2 : bgUseList) {
                    if (!bgUse2.getBgReqBillEntryId().equals(temp.getBgReqBillEntryId())) continue;
                    useMap.put(number, bgUse2);
                }
            }
            tempMap.put("reqMap", reqMap);
            if (useMap != null && !useMap.isEmpty()) {
                tempMap.put("useMap", useMap);
            }
            result.put(period, tempMap);
        }
        return result;
    }

    private void dealNeedGather(List periodList, List bgReqList, List bgUseList, List bgList) {
        if (bgReqList == null || bgList == null || periodList == null || bgReqList.isEmpty() || periodList.isEmpty() || bgList.isEmpty()) {
            return;
        }
        ArrayList<String> allBgItemNumber = new ArrayList<String>();
        BgItemReqUseAnalyseInfo bgReqPara = null;
        BgItemReqUseAnalyseInfo bgPara = null;
        HashMap<String, BgItemReqUseAnalyseInfo> bgReqMap = new HashMap<String, BgItemReqUseAnalyseInfo>();
        String itemNumber = null;
        String[] itemNumbers = null;
        Map allFatherItem = null;
        ArrayList tempList = null;
        HashMap existMap = new HashMap();
        for (int p = 0; p < periodList.size(); ++p) {
            String period = periodList.get(p).toString();
            if (bgReqList.isEmpty()) continue;
            for (int n = 0; n < bgList.size(); ++n) {
                tempList = (ArrayList)bgList.get(n);
                for (int t = 0; t < tempList.size(); ++t) {
                    bgReqPara = (BgItemReqUseAnalyseInfo)tempList.get(t);
                    if (bgReqPara == null || !bgReqPara.getBgPeriodName().equals(period)) continue;
                    allBgItemNumber.add(bgReqPara.getBgItemNumber());
                    bgReqMap.put(bgReqPara.getBgItemNumber(), bgReqPara);
                }
            }
            if (!bgReqMap.isEmpty()) {
                for (Object obj : bgReqMap.keySet()) {
                    if (obj == null || (itemNumbers = (itemNumber = obj.toString()).split(",")).length <= 1) continue;
                    allBgItemNumber.remove(itemNumber);
                    bgReqPara = (BgItemReqUseAnalyseInfo)bgReqMap.get(itemNumber);
                    for (int k = 0; k < itemNumbers.length; ++k) {
                        allBgItemNumber.add(itemNumbers[k]);
                    }
                }
            }
            if (allFatherItem == null) {
                try {
                    allFatherItem = this.getInterface().getFatherBgItem(allBgItemNumber);
                }
                catch (Exception e) {
                    logger.error((Object)"", (Throwable)e);
                    this.handUIExceptionAndAbort(e);
                }
            }
            if (allFatherItem == null || allFatherItem.isEmpty()) continue;
            String[] tempNumbers = null;
            String tempNumber = null;
            BgItemInfo info = null;
            String currencySonBgItemNumber = null;
            Iterator allIt = allFatherItem.keySet().iterator();
            while (allIt.hasNext()) {
                currencySonBgItemNumber = allIt.next().toString();
                info = (BgItemInfo)allFatherItem.get(currencySonBgItemNumber);
                for (int t = 0; t < bgList.size(); ++t) {
                    tempList = (ArrayList)bgList.get(t);
                    for (int a = 0; a < tempList.size(); ++a) {
                        bgPara = (BgItemReqUseAnalyseInfo)tempList.get(a);
                        if (!bgPara.getBgPeriodName().equals(period) || existMap.containsKey(info.getNumber() + "_" + currencySonBgItemNumber + period)) continue;
                        tempNumbers = bgPara.getBgItemNumber().split(",");
                        for (int y = 0; y < tempNumbers.length; ++y) {
                            tempNumber = tempNumbers[y];
                            if (!tempNumber.equals(info.getNumber()) || (bgReqPara = this.getBgReqParameter(bgPara, bgReqList)) == null) continue;
                            this.dealBgRequestBillAdd(currencySonBgItemNumber, bgReqPara, bgReqList, bgUseList);
                            if (BigDecimal.ZERO.intValue() == bgReqPara.getBValue().intValue()) continue;
                            existMap.put(info.getNumber() + "_" + currencySonBgItemNumber + period, null);
                        }
                    }
                }
            }
        }
    }

    private BgItemReqUseAnalyseInfo getBgReqParameter(BgItemReqUseAnalyseInfo bgPara, List bgReqList) {
        if (bgReqList == null || bgReqList.isEmpty() || bgPara == null) {
            return null;
        }
        BgItemReqUseAnalyseInfo temp = null;
        boolean isInclude = false;
        for (int n = 0; n < bgReqList.size(); ++n) {
            temp = (BgItemReqUseAnalyseInfo)bgReqList.get(n);
            if (!bgPara.getBgPeriodName().equals(temp.getBgPeriodName()) || !bgPara.getBgItemNumber().equals(temp.getBgItemNumber())) continue;
            isInclude = true;
            break;
        }
        if (isInclude) {
            return temp;
        }
        BgItemReqUseAnalyseInfo info = new BgItemReqUseAnalyseInfo();
        info.setBgElementNumber(bgPara.getBgElementNumber());
        info.setBgItemNumber(bgPara.getBgItemNumber());
        info.setBgPeriodName(bgPara.getBgPeriodName());
        info.setBgReqBillEntryId(this.randomMarker());
        info.setBotpBillId(bgPara.getBotpBillId());
        info.setBotpBillName(bgPara.getBotpBillName());
        info.setBotpBillType(bgPara.getBotpBillType());
        info.setReqOrgUnit(bgPara.getReqOrgUnit());
        info.setBValue(BgConstants.BIGZERO);
        bgReqList.add(info);
        return info;
    }

    private String randomMarker() {
        String str = "1234567890abcdefghigklmnopqrstuvwxyzABCDEFGHIGKLMNOPQRSTUVWXYZ=";
        char[] result = new char[11];
        SecureRandom random = new SecureRandom();
        for (int n = 0; n < 11; ++n) {
            result[n] = str.charAt((int)(random.nextDouble() * (double)str.length()));
        }
        return String.valueOf(result);
    }

    private void dealBgRequestBillAdd(String currencySonBgItemNumber, BgItemReqUseAnalyseInfo fatherReqUserAnalyseInfo, List bgReqList, List bgUseList) {
        if (fatherReqUserAnalyseInfo == null || StringUtils.isEmpty((String)currencySonBgItemNumber) || bgReqList == null || bgReqList.isEmpty()) {
            return;
        }
        boolean isIncludeUseBgReq = true;
        if (bgUseList == null || bgUseList.isEmpty()) {
            isIncludeUseBgReq = false;
        }
        BgItemReqUseAnalyseInfo reqInfo = null;
        BgItemReqUseAnalyseInfo tempSonUseInfo = null;
        Object tempFatherUseInfo = null;
        BgItemReqUseAnalyseInfo sonUseInfo = null;
        Object fatherUseInfo = null;
        String[] bgItemNumbers = null;
        String bgItemNumber = null;
        HashMap parentMap = new HashMap();
        for (int n = 0; n < bgReqList.size(); ++n) {
            reqInfo = (BgItemReqUseAnalyseInfo)bgReqList.get(n);
            if (!reqInfo.getBgPeriodName().equals(fatherReqUserAnalyseInfo.getBgPeriodName())) continue;
            bgItemNumbers = reqInfo.getBgItemNumber().split(",");
            for (int k = 0; k < bgItemNumbers.length; ++k) {
                bgItemNumber = bgItemNumbers[k];
                if (!currencySonBgItemNumber.equals(bgItemNumber) || reqInfo.getBValue().intValue() == BigDecimal.ZERO.intValue()) continue;
                fatherReqUserAnalyseInfo.setBValue(fatherReqUserAnalyseInfo.getBValue().add(reqInfo.getBValue()));
                if (!isIncludeUseBgReq) continue;
                ArrayList<BgItemReqUseAnalyseInfo> useInfos = new ArrayList<BgItemReqUseAnalyseInfo>();
                for (int p = 0; p < bgUseList.size(); ++p) {
                    tempSonUseInfo = (BgItemReqUseAnalyseInfo)bgUseList.get(p);
                    if (!tempSonUseInfo.getBgReqBillEntryId().equals(reqInfo.getBgReqBillEntryId()) || reqInfo.getBValue().compareTo(BgConstants.BIGZERO) != 1) continue;
                    sonUseInfo = tempSonUseInfo;
                    useInfos.add(sonUseInfo);
                }
                if (useInfos != null && !useInfos.isEmpty() && !parentMap.containsKey(reqInfo.getBgItemNumber())) {
                    this.dealWithReqUse(fatherReqUserAnalyseInfo, bgUseList, useInfos);
                    parentMap.put(reqInfo.getBgItemNumber(), null);
                }
                tempSonUseInfo = null;
                tempFatherUseInfo = null;
                sonUseInfo = null;
                fatherUseInfo = null;
            }
        }
    }

    private void dealWithReqUse(BgItemReqUseAnalyseInfo fatherReqInofo, List bgUseList, List useInfos) {
        if (bgUseList == null || bgUseList.isEmpty() || useInfos == null || useInfos.isEmpty()) {
            return;
        }
        BgItemReqUseAnalyseInfo son2 = null;
        for (BgItemReqUseAnalyseInfo son2 : useInfos) {
            BgItemReqUseAnalyseInfo fatherUseInfo = this.getBgUseParameter(son2, fatherReqInofo, bgUseList);
            if (son2 == null || fatherUseInfo == null) continue;
            fatherUseInfo.setBValue(fatherUseInfo.getBValue().add(son2.getBValue()));
        }
    }

    private BgItemReqUseAnalyseInfo getBgUseParameter(BgItemReqUseAnalyseInfo sonUseInfo, BgItemReqUseAnalyseInfo fatherReqUserAnalyseInfo, List bgUseList) {
        if (fatherReqUserAnalyseInfo == null || bgUseList == null || bgUseList.isEmpty()) {
            return null;
        }
        BgItemReqUseAnalyseInfo temp = null;
        boolean isInclude = false;
        for (int n = 0; n < bgUseList.size(); ++n) {
            temp = (BgItemReqUseAnalyseInfo)bgUseList.get(n);
            if (fatherReqUserAnalyseInfo.getBgReqBillEntryId() == null || sonUseInfo.getBotpBillId() == null) break;
            if (!fatherReqUserAnalyseInfo.getBgReqBillEntryId().equals(temp.getBgReqBillEntryId()) || !sonUseInfo.getBotpBillId().equals(temp.getBotpBillId())) continue;
            isInclude = true;
            break;
        }
        if (isInclude) {
            return temp;
        }
        BgItemReqUseAnalyseInfo info = new BgItemReqUseAnalyseInfo();
        info.setBgElementNumber(fatherReqUserAnalyseInfo.getBgElementNumber());
        info.setBgItemNumber(fatherReqUserAnalyseInfo.getBgItemNumber());
        info.setBgPeriodName(fatherReqUserAnalyseInfo.getBgPeriodName());
        info.setBgReqBillEntryId(fatherReqUserAnalyseInfo.getBgReqBillEntryId());
        info.setBgReqBillId(fatherReqUserAnalyseInfo.getBgReqBillId());
        info.setBotpBillId(fatherReqUserAnalyseInfo.getBotpBillId());
        info.setBotpBillName(fatherReqUserAnalyseInfo.getBotpBillName());
        info.setBotpBillType(fatherReqUserAnalyseInfo.getBotpBillType());
        info.setReqOrgUnit(fatherReqUserAnalyseInfo.getReqOrgUnit());
        info.setBValue(BgConstants.BIGZERO);
        bgUseList.add(info);
        return info;
    }

    private int getMaxRowByPeriod(String period, List bgList, List bgReqList, List bgUseList) {
        if (period == null || bgList.size() < 1 || bgReqList == null || bgReqList.size() < 1) {
            return 1;
        }
        String bgReqBillId = null;
        String bgReqBillEntryId = null;
        String bgElemNum = null;
        List tmpList = null;
        List<String> reqCountList = null;
        List<String> useCountList = null;
        HashMap<String, List<String>> reqCountMap = new HashMap<String, List<String>>();
        HashMap<String, List<String>> useCountMap = new HashMap<String, List<String>>();
        BgItemReqUseAnalyseInfo info = null;
        for (int i = 0; i < bgList.size(); ++i) {
            tmpList = (List)bgList.get(i);
            int xn = tmpList.size();
            for (int x = 0; x < xn; ++x) {
                info = (BgItemReqUseAnalyseInfo)tmpList.get(x);
                if (!info.getBgPeriodName().equals(period)) continue;
                bgElemNum = info.getBgElementNumber();
                for (int j = 0; j < bgReqList.size(); ++j) {
                    info = (BgItemReqUseAnalyseInfo)bgReqList.get(j);
                    if (!info.getBgPeriodName().equals(period) || !info.getBgElementNumber().equals(bgElemNum)) continue;
                    bgReqBillId = info.getBgReqBillId();
                    bgReqBillEntryId = info.getBgReqBillEntryId();
                    if (reqCountMap.containsKey(bgElemNum)) {
                        reqCountList = (List)reqCountMap.get(bgElemNum);
                    } else {
                        reqCountList = new ArrayList();
                        reqCountMap.put(bgElemNum, reqCountList);
                    }
                    if (reqCountList.contains(bgReqBillId)) continue;
                    reqCountList.add(bgReqBillId);
                    if (bgUseList == null || bgUseList.size() <= 0) continue;
                    for (int k = 0; k < bgUseList.size(); ++k) {
                        info = (BgItemReqUseAnalyseInfo)bgUseList.get(k);
                        if (!info.getBgReqBillId().equals(bgReqBillId) || !info.getBgReqBillEntryId().equals(bgReqBillEntryId)) continue;
                        if (useCountMap.containsKey(bgReqBillId)) {
                            useCountList = (List)useCountMap.get(bgReqBillId);
                        } else {
                            useCountList = new ArrayList();
                            useCountMap.put(bgReqBillId, useCountList);
                        }
                        if (useCountList.contains(info.getBotpBillId())) continue;
                        useCountList.add(info.getBotpBillId());
                    }
                }
            }
        }
        int count = 0;
        Iterator useIter = null;
        boolean hasBotpBill = false;
        ArrayList<Integer> resultList = new ArrayList<Integer>();
        Iterator reqIter = reqCountMap.entrySet().iterator();
        while (reqIter.hasNext()) {
            count = 0;
            Map.Entry reqEntry = reqIter.next();
            reqCountList = (ArrayList)reqEntry.getValue();
            for (int i = 0; i < reqCountList.size(); ++i) {
                hasBotpBill = false;
                String billId = reqCountList.get(i).toString();
                for (Map.Entry useEntry : useCountMap.entrySet()) {
                    String key = useEntry.getKey().toString();
                    if (!key.equals(billId)) continue;
                    useCountList = (ArrayList)useEntry.getValue();
                    count += useCountList.size();
                    hasBotpBill = true;
                }
                if (hasBotpBill) continue;
                ++count;
            }
            resultList.add(new Integer(count));
        }
        if (resultList != null && resultList.size() > 0) {
            return (Integer)Collections.max(resultList);
        }
        return 1;
    }

    private void fillSheetDetail(KDTable sheet, Map bgEleMap, List periodList, List bgList, List bgReqList, List bgUseList, Map bgItemInfoMap, Map bgEleInfoMap) {
        int tableRow;
        boolean _indexCol = false;
        Object tmpList = null;
        IRow row = null;
        Object bgItem = null;
        BgItemReqUseAnalyseInfo info = null;
        Object itemInfo = null;
        if (bgList.isEmpty() || bgList.size() <= 0) {
            return;
        }
        sheet.setRefresh(true);
        int rowCount = tableRow = sheet.getRowCount();
        HashMap<String, ArrayList> tmpbgEleMap = new HashMap<String, ArrayList>();
        for (int i = 0; i < rowCount; ++i) {
            String elementNumber;
            String itemnumber;
            row = sheet.getRow(i);
            String periodname = row.getCell(0).getValue().toString();
            String item = row.getCell(1).getValue().toString();
            tmpbgEleMap.clear();
            for (int j = 0; j < bgReqList.size(); ++j) {
                ArrayList<BigDecimal> detail;
                String entryid;
                HashMap _tmpReqDetailMap;
                HashMap _tmpReqMap;
                ArrayList tmreqinfo;
                info = (BgItemReqUseAnalyseInfo)bgReqList.get(j);
                itemnumber = info.getBgItemNumber();
                elementNumber = info.getBgElementNumber();
                if (!bgItemInfoMap.containsKey(itemnumber) || !info.getBgPeriodName().equals(periodname) || !bgItemInfoMap.get(itemnumber).toString().equals(item)) continue;
                if (tmpbgEleMap.containsKey(elementNumber)) {
                    tmreqinfo = (ArrayList)tmpbgEleMap.get(elementNumber);
                    _tmpReqMap = (HashMap)tmreqinfo.get(0);
                    _tmpReqDetailMap = (HashMap)tmreqinfo.get(2);
                    entryid = info.getBgReqBillId() + "-" + info.getBgReqBillEntryId();
                    if (_tmpReqMap.containsKey(entryid)) {
                        BigDecimal value = (BigDecimal)_tmpReqMap.get(entryid);
                        _tmpReqMap.put(entryid, info.getBValue().add(value));
                        ArrayList detail2 = (ArrayList)_tmpReqDetailMap.get(entryid);
                        detail2.add(info.getBValue());
                    } else {
                        _tmpReqMap.put(entryid, info.getBValue());
                        detail = new ArrayList<BigDecimal>();
                        detail.add(info.getBValue());
                        _tmpReqDetailMap.put(entryid, detail);
                    }
                } else {
                    tmreqinfo = new ArrayList();
                    _tmpReqMap = new HashMap();
                    _tmpReqDetailMap = new HashMap();
                    entryid = info.getBgReqBillId() + "-" + info.getBgReqBillEntryId();
                    _tmpReqMap.put(entryid, info.getBValue());
                    tmreqinfo.add(_tmpReqMap);
                    tmreqinfo.add(new HashMap());
                    tmreqinfo.add(_tmpReqDetailMap);
                    detail = new ArrayList();
                    detail.add(info.getBValue());
                    _tmpReqDetailMap.put(entryid, detail);
                    tmpbgEleMap.put(elementNumber, tmreqinfo);
                }
                bgReqList.remove(bgReqList.get(j));
                --j;
            }
            for (int k = 0; k < bgUseList.size(); ++k) {
                ArrayList tmpusr;
                ArrayList tmreqinfo;
                HashMap _tmpReqMap;
                info = (BgItemReqUseAnalyseInfo)bgUseList.get(k);
                itemnumber = info.getBgItemNumber();
                elementNumber = info.getBgElementNumber();
                String entryid = info.getBgReqBillId() + "-" + info.getBgReqBillEntryId();
                if (!tmpbgEleMap.containsKey(elementNumber) || !(_tmpReqMap = (HashMap)(tmreqinfo = (ArrayList)tmpbgEleMap.get(elementNumber)).get(0)).containsKey(entryid)) continue;
                HashMap tmpusrinfo = (HashMap)tmreqinfo.get(1);
                if (tmpusrinfo.containsKey(entryid)) {
                    tmpusr = (ArrayList)tmpusrinfo.get(entryid);
                    tmpusr.add(info.getBValue());
                } else {
                    tmpusr = new ArrayList();
                    tmpusr.add(info.getBValue());
                    tmpusrinfo.put(entryid, tmpusr);
                }
                bgUseList.remove(bgUseList.get(k));
                --k;
            }
            int maxRow = 0;
            int tmpRow = 0;
            if (tmpbgEleMap.size() <= 0) continue;
            Iterator iter = tmpbgEleMap.entrySet().iterator();
            while (iter.hasNext()) {
                tmpRow = 0;
                Map.Entry entry = iter.next();
                ArrayList val = (ArrayList)entry.getValue();
                HashMap req = (HashMap)val.get(0);
                tmpRow = req.size();
                HashMap used = (HashMap)val.get(1);
                for (Map.Entry entryused : used.entrySet()) {
                    ArrayList valused = (ArrayList)entryused.getValue();
                    tmpRow = tmpRow + valused.size() - 1;
                }
                if (maxRow >= tmpRow) continue;
                maxRow = tmpRow;
            }
            int beginrow = i;
            int endrow = i + maxRow;
            int metop = beginrow;
            int botton = endrow - 1;
            for (int n = 0; n < maxRow; ++n) {
                sheet.addRow(i);
                ++i;
                ++rowCount;
            }
            sheet.getMergeManager().mergeBlock(metop, 0, endrow, 0);
            sheet.getMergeManager().mergeBlock(metop, 1, endrow, 1);
            iter = bgEleMap.entrySet().iterator();
            while (iter.hasNext()) {
                int tmpbegin = beginrow;
                int tmpend = endrow;
                int begincol = 0;
                Map.Entry entry = iter.next();
                String key = (String)entry.getKey();
                for (int c = 0; c < sheet.getColumns().size(); ++c) {
                    if (sheet.getColumn(c).getUserObject() == null || !sheet.getColumn(c).getUserObject().equals(key)) continue;
                    begincol = c;
                    break;
                }
                sheet.getMergeManager().mergeBlock(metop, begincol, botton, begincol);
                sheet.getMergeManager().mergeBlock(metop, begincol + 3, botton, begincol + 3);
                sheet.getMergeManager().mergeBlock(metop, begincol + 4, botton, begincol + 4);
                sheet.getMergeManager().mergeBlock(metop, begincol + 7, botton, begincol + 7);
                sheet.getMergeManager().mergeBlock(metop, begincol + 6, botton, begincol + 6);
                if (!tmpbgEleMap.containsKey(key)) continue;
                ArrayList val = (ArrayList)tmpbgEleMap.get(key);
                HashMap req = (HashMap)val.get(0);
                HashMap used = (HashMap)val.get(1);
                HashMap detail = (HashMap)val.get(2);
                for (Map.Entry reqtmp : req.entrySet()) {
                    String regkey = (String)reqtmp.getKey();
                    Object bvalue2 = reqtmp.getValue();
                    sheet.getCell(beginrow, begincol + 2).setValue(bvalue2);
                    sheet.getCell(beginrow, begincol + 2).setUserObject((Object)(info != null ? info.getBgElementNumber() : null));
                    ArrayList list = (ArrayList)detail.get(regkey);
                    Iterator det = list.iterator();
                    String _det = "";
                    while (det.hasNext()) {
                        _det = _det + "\r\n" + new DecimalFormat("###,###,###.00", BgNationalFormatUIUtil.getDecimalFormatSymbols()).format(det.next());
                    }
                    sheet.getCell(beginrow, begincol + 1).setValue((Object)_det);
                    int rq = beginrow++;
                    if (!used.containsKey(regkey)) continue;
                    --beginrow;
                    ArrayList valused = (ArrayList)used.get(regkey);
                    int rqend = 0;
                    for (Object bvalue2 : valused) {
                        sheet.getCell(beginrow, begincol + 5).setValue(bvalue2);
                        sheet.getCell(beginrow, begincol + 5).setUserObject((Object)(info != null ? info.getBgElementNumber() : null));
                        rqend = beginrow++;
                    }
                    sheet.getMergeManager().mergeBlock(rq, begincol + 2, rqend, begincol + 2);
                    sheet.getMergeManager().mergeBlock(rq, begincol + 1, rqend, begincol + 1);
                }
            }
        }
    }

    private void fillSheet(KDTable sheet, Map bgEleMap, String period, List bgList, List bgReqList, List bgUseList, Map bgItemInfoMap, Map bgEleInfoMap) {
        int _indexCol = 0;
        List tmpList = null;
        IRow row = null;
        StringBuffer bgItem = null;
        String bgReqBillEntryId = null;
        BigDecimal bgValue = new BigDecimal(0);
        BigDecimal bgReqValue = new BigDecimal(0);
        BigDecimal bgUseValue = new BigDecimal(0);
        BigDecimal resultValue = new BigDecimal(0);
        BgItemReqUseAnalyseInfo info = null;
        BgItemReqUseAnalyseInfo infoBgReq = null;
        BgItemReqUseAnalyseInfo infoBgUse = null;
        VisualItemInfo itemInfo = null;
        sheet.setRefresh(true);
        bgItem = new StringBuffer();
        for (int i = 0; i < bgList.size(); ++i) {
            tmpList = (List)bgList.get(i);
            if (tmpList.size() <= 0 || !(info = (BgItemReqUseAnalyseInfo)tmpList.get(0)).getBgPeriodName().equals(period)) continue;
            row = sheet.addRow();
            int xn = tmpList.size();
            for (int x = 0; x < xn; ++x) {
                info = (BgItemReqUseAnalyseInfo)tmpList.get(x);
                bgItem = new StringBuffer();
                itemInfo = BgSHelper.getBgItemCombinInfo((String)info.getBgItemNumber(), (Map)bgItemInfoMap);
                if (itemInfo != null && bgItem.indexOf(itemInfo.getName()) == -1) {
                    bgItem.append(itemInfo.getName());
                }
                row.getCell(0).setValue((Object)period);
                row.getCell(1).setValue((Object)bgItem);
                if (bgEleMap.containsKey(info.getBgElementNumber())) {
                    _indexCol = (Integer)bgEleMap.get(info.getBgElementNumber());
                } else {
                    _indexCol = this.addColumns(sheet, info, bgEleInfoMap);
                    bgEleMap.put(info.getBgElementNumber(), new Integer(_indexCol));
                }
                if (row.getCell(_indexCol).getValue() != null) {
                    row.getCell(_indexCol).setValue((Object)((BigDecimal)row.getCell(_indexCol).getValue()).add(info.getBValue()));
                } else {
                    row.getCell(_indexCol).setValue((Object)info.getBValue());
                }
                row.getCell(_indexCol).setUserObject((Object)info.getBgElementNumber());
            }
            for (Map.Entry entry : bgEleMap.entrySet()) {
                String elemNum = entry.getKey().toString();
                _indexCol = Integer.parseInt(entry.getValue().toString());
                for (int j = 0; j < bgReqList.size(); ++j) {
                    infoBgReq = (BgItemReqUseAnalyseInfo)bgReqList.get(j);
                    if (!infoBgReq.getBgPeriodName().equals(period) || !infoBgReq.getBgElementNumber().equals(elemNum) || !infoBgReq.getBgItemNumber().equals(info.getBgItemNumber())) continue;
                    if (row.getCell(_indexCol + 2).getValue() != null) {
                        row.getCell(_indexCol + 2).setValue((Object)((BigDecimal)row.getCell(_indexCol + 2).getValue()).add(infoBgReq.getBValue()));
                    } else {
                        row.getCell(_indexCol + 2).setValue((Object)infoBgReq.getBValue());
                    }
                    String bValue = new DecimalFormat("###,###,###.00", BgNationalFormatUIUtil.getDecimalFormatSymbols()).format(infoBgReq.getBValue());
                    if (row.getCell(_indexCol + 1).getValue() != null) {
                        row.getCell(_indexCol + 1).setValue((Object)(row.getCell(_indexCol + 1).getValue() + "\r\n" + bValue));
                    } else {
                        row.getCell(_indexCol + 1).setValue((Object)bValue);
                    }
                    row.getCell(_indexCol + 2).setUserObject((Object)infoBgReq.getBgElementNumber());
                    bgReqBillEntryId = infoBgReq.getBgReqBillEntryId();
                    for (int k = 0; k < bgUseList.size(); ++k) {
                        infoBgUse = (BgItemReqUseAnalyseInfo)bgUseList.get(k);
                        if (!infoBgUse.getBgReqBillEntryId().equals(bgReqBillEntryId)) continue;
                        if (row.getCell(_indexCol + 5).getValue() != null) {
                            row.getCell(_indexCol + 5).setValue((Object)((BigDecimal)row.getCell(_indexCol + 5).getValue()).add(infoBgUse.getBValue()));
                        } else {
                            row.getCell(_indexCol + 5).setValue((Object)infoBgUse.getBValue());
                        }
                        row.getCell(_indexCol + 5).setUserObject((Object)infoBgUse.getBgElementNumber());
                        bgUseList.remove(bgUseList.get(k));
                        --k;
                    }
                    bgReqList.remove(bgReqList.get(j));
                    --j;
                }
            }
            for (Map.Entry entry : bgEleMap.entrySet()) {
                int indexCol = Integer.parseInt(entry.getValue().toString());
                bgValue = (BigDecimal)row.getCell(indexCol).getValue();
                bgReqValue = (BigDecimal)row.getCell(indexCol + 2).getValue();
                bgUseValue = (BigDecimal)row.getCell(indexCol + 5).getValue();
                if (bgValue == null || bgReqValue == null) continue;
                resultValue = new BigDecimal(0);
                if (bgValue.compareTo(resultValue) != 0) {
                    resultValue = new BigDecimal(bgReqValue.doubleValue() / bgValue.doubleValue() * 100.0);
                }
                row.getCell(indexCol + 4).setValue((Object)(resultValue.setScale(2, 4).doubleValue() + "%"));
                if (bgUseValue == null) continue;
                resultValue = new BigDecimal(0);
                if (bgReqValue.compareTo(resultValue) != 0) {
                    resultValue = new BigDecimal(bgUseValue.doubleValue() / bgReqValue.doubleValue() * 100.0);
                }
                row.getCell(indexCol + 6).setValue((Object)(resultValue.setScale(2, 4).doubleValue() + "%"));
                resultValue = new BigDecimal(0);
                if (bgValue.compareTo(resultValue) != 0) {
                    resultValue = new BigDecimal(bgUseValue.doubleValue() / bgValue.doubleValue() * 100.0);
                }
                row.getCell(indexCol + 7).setValue((Object)(resultValue.setScale(2, 4).doubleValue() + "%"));
            }
        }
    }

    private void fillSheetDetail(KDTable sheet, Map bgEleMap, String period, int rowCount, List bgList, List bgReqList, List bgUseList, Map bgItemInfoMap, Map bgEleInfoMap) {
    }

    private List getBotpList(String bgReqBillId, Object bgReqBillEntryId, List bgUseList) {
        if (bgReqBillId == null || bgReqBillEntryId == null || bgUseList == null) {
            return null;
        }
        ArrayList<BgItemReqUseAnalyseInfo> botpEntryList = null;
        ArrayList<BgItemReqUseAnalyseInfo> botpList = null;
        String[] entryId = bgReqBillEntryId.toString().split(",");
        BgItemReqUseAnalyseInfo info = null;
        BgItemReqUseAnalyseInfo info2 = null;
        if (bgUseList != null && bgUseList.size() > 0) {
            botpEntryList = new ArrayList<BgItemReqUseAnalyseInfo>();
            for (int k = 0; k < bgUseList.size(); ++k) {
                info = (BgItemReqUseAnalyseInfo)bgUseList.get(k);
                if (!info.getBgReqBillId().equals(bgReqBillId)) continue;
                for (int j = 0; j < entryId.length; ++j) {
                    if (!info.getBgReqBillEntryId().equals(entryId[j]) || botpEntryList.contains(info)) continue;
                    botpEntryList.add(info);
                }
            }
        }
        String botpBillId = null;
        String botpName = null;
        boolean isRepeatBotp = false;
        if (botpEntryList != null && botpEntryList.size() > 0) {
            botpList = new ArrayList<BgItemReqUseAnalyseInfo>();
            BigDecimal bValue = new BigDecimal(0);
            for (int i = 0; i < botpEntryList.size(); ++i) {
                info = (BgItemReqUseAnalyseInfo)botpEntryList.get(i);
                botpBillId = info.getBotpBillId();
                botpName = info.getBotpBillName();
                bValue = info.getBValue();
                if (botpList.size() < 1) {
                    info2 = new BgItemReqUseAnalyseInfo();
                    info2.setBotpBillId(botpBillId);
                    info2.setBotpBillName(botpName);
                    info2.setBValue(bValue);
                    botpList.add(info2);
                    continue;
                }
                for (int j = 0; j < botpList.size(); ++j) {
                    info2 = (BgItemReqUseAnalyseInfo)botpList.get(j);
                    if (!info2.getBotpBillId().equals(botpBillId)) continue;
                    info2.setBValue(info2.getBValue().add(bValue));
                    info2.setBotpBillName(botpName);
                    info2.setBotpBillId(botpBillId);
                    isRepeatBotp = true;
                }
                if (isRepeatBotp) continue;
                info2 = new BgItemReqUseAnalyseInfo();
                info2.setBotpBillId(botpBillId);
                info2.setBotpBillName(botpName);
                info2.setBValue(bValue);
                botpList.add(info2);
                isRepeatBotp = false;
            }
        }
        return botpList;
    }

    private int addColumns(KDTable sheet, BgItemReqUseAnalyseInfo info, Map bgEleInfoMap) {
        int _indexCol = 0;
        IColumn column = null;
        BgElementInfo elementInfo = null;
        column = sheet.addColumn();
        _indexCol = column.getColumnIndex();
        column.getStyleAttributes().setLocked(true);
        column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        column.getStyleAttributes().setWrapText(true);
        elementInfo = (BgElementInfo)bgEleInfoMap.get(info.getBgElementNumber());
        sheet.getHeadRow(0).getCell(column.getColumnIndex()).setValue((Object)elementInfo.getName());
        sheet.getHeadRow(1).getCell(column.getColumnIndex()).setValue((Object)BgAnalyseHelper.getMessage((String)"bValue"));
        column.setUserObject((Object)elementInfo.getNumber());
        column.setWidth(80);
        column = sheet.addColumn();
        sheet.getHeadRow(0).getCell(column.getColumnIndex()).setValue((Object)elementInfo.getName());
        sheet.getHeadRow(1).getCell(column.getColumnIndex()).setValue((Object)BgAnalyseHelper.getMessage((String)"bgRequestDetail"));
        column.getStyleAttributes().setWrapText(true);
        column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        column.getStyleAttributes().setHided(true);
        column = sheet.addColumn();
        column.getStyleAttributes().setLocked(true);
        column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        sheet.getHeadRow(0).getCell(column.getColumnIndex()).setValue((Object)elementInfo.getName());
        sheet.getHeadRow(1).getCell(column.getColumnIndex()).setValue((Object)BgAnalyseHelper.getMessage((String)"bgRequest"));
        column.setUserObject((Object)elementInfo.getNumber());
        column = sheet.addColumn();
        sheet.getHeadRow(0).getCell(column.getColumnIndex()).setValue((Object)elementInfo.getName());
        sheet.getHeadRow(1).getCell(column.getColumnIndex()).setValue((Object)"bgReqBillId");
        column.getStyleAttributes().setHided(true);
        column = sheet.addColumn();
        column.getStyleAttributes().setLocked(true);
        column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        sheet.getHeadRow(0).getCell(column.getColumnIndex()).setValue((Object)elementInfo.getName());
        sheet.getHeadRow(1).getCell(column.getColumnIndex()).setValue((Object)BgAnalyseHelper.getMessage((String)"bgReqProgress"));
        column = sheet.addColumn();
        column.getStyleAttributes().setLocked(true);
        column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        sheet.getHeadRow(0).getCell(column.getColumnIndex()).setValue((Object)elementInfo.getName());
        sheet.getHeadRow(1).getCell(column.getColumnIndex()).setValue((Object)BgAnalyseHelper.getMessage((String)"bgReqUse"));
        column.setUserObject((Object)elementInfo.getNumber());
        column.setWidth(115);
        column = sheet.addColumn();
        column.getStyleAttributes().setLocked(true);
        column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        sheet.getHeadRow(0).getCell(column.getColumnIndex()).setValue((Object)elementInfo.getName());
        sheet.getHeadRow(1).getCell(column.getColumnIndex()).setValue((Object)BgAnalyseHelper.getMessage((String)"bgReqUseProgress"));
        column.setWidth(115);
        column = sheet.addColumn();
        column.getStyleAttributes().setLocked(true);
        column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        sheet.getHeadRow(0).getCell(column.getColumnIndex()).setValue((Object)elementInfo.getName());
        sheet.getHeadRow(1).getCell(column.getColumnIndex()).setValue((Object)BgAnalyseHelper.getMessage((String)"bgExecProgress"));
        sheet.getHeadMergeManager().mergeBlock(0, _indexCol, 0, _indexCol + 7);
        return _indexCol;
    }

    protected Object formatCellDisplay(int rowIndex, int colIndex, ICell cell, Object value) {
        if (colIndex > 1) {
            if (value instanceof BigDecimal) {
                BigDecimal tmpValue = null;
                tmpValue = this.getMeasureUnit(rowIndex, colIndex, cell);
                tmpValue = ((BigDecimal)value).divide(tmpValue, 8, 4);
                value = this.getDecFormat().format(tmpValue.doubleValue());
            }
            return value;
        }
        return super.formatCellDisplay(rowIndex, colIndex, cell, value);
    }

    protected BigDecimal getMeasureUnit(int rowIndex, int colIndex, ICell cell) {
        if (cell == null || cell.getUserObject() == null) {
            return this.getCoefficient();
        }
        if (this.muMap.containsKey(cell.getUserObject())) {
            return (BigDecimal)this.muMap.get(cell.getUserObject());
        }
        return this.getCoefficient();
    }

    public boolean destroyWindow() {
        boolean re = super.destroyWindow();
        if (re) {
            this.muMap.clear();
        }
        return re;
    }
}

