/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.excel.AbstractDataWrapper;
import com.kingdee.bos.ctrl.kdf.excel.BookDataWrapper;
import com.kingdee.bos.ctrl.kdf.excel.wrapper.SXSSFExportWrapper;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.export.ExporterParameter;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.OrgViewUtils;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.budget.BgActualRecordFactory;
import com.kingdee.eas.ma.budget.BgActualRecordInfo;
import com.kingdee.eas.ma.budget.BgFacadeFactory;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgMeasureUnitInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.client.LongTimeDialog;
import com.kingdee.eas.ma.nbudget.BgExportHelper;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgPermissionHelper;
import com.kingdee.eas.ma.nbudget.client.AbstractBgNActualRecordExportUI;
import com.kingdee.eas.ma.nbudget.client.BgExportResultUI;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.ma.nbudget.client.Excel2007FileFilter;
import com.kingdee.eas.ma.nbudget.client.ExcelFileFilter;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.TreeModel;
import org.apache.log4j.Logger;

public class BgNActualRecordExportUI
extends AbstractBgNActualRecordExportUI {
    private static final Logger logger = CoreUIObject.getLogger(BgNActualRecordExportUI.class);
    private Map bgNActualRecordsMap = null;
    private String fileFormat = ".xls";

    protected static IBgForm getFormInterface() throws Exception {
        return BgFormFactory.getRemoteInstance();
    }

    protected static IPermission getPermissionInterface() throws Exception {
        return PermissionFactory.getRemoteInstance();
    }

    protected String getMessageStr(String key) {
        return !StringUtils.isEmpty((String)key) ? EASResource.getString((String)"com.kingdee.eas.ma.nbudget.client.BgNFormResource", (String)key) : "";
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.txtFilepath.setText(BgExportHelper.getDefaultDirtory());
        this.bgNActualRecordsMap = (Map)this.getUIContext().get("ORGUNIT_ID");
    }

    protected void verify() throws Exception {
        if (StringUtils.isEmpty((String)this.txtFilepath.getText())) {
            this.txtFilepath.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgIEResource", "selectOutFilepath"));
            SysUtil.abort();
        } else {
            File file = new File(this.txtFilepath.getText());
            if (!file.isDirectory()) {
                this.txtFilepath.requestFocus();
                MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgIEResource", "errorFilepath"));
                SysUtil.abort();
            }
        }
    }

    @Override
    protected void btnSelectPath_actionPerformed(ActionEvent e) throws Exception {
        String path = this.txtFilepath.getText();
        KDFileChooser fc = new KDFileChooser();
        fc.setFileSelectionMode(1);
        fc.setDialogTitle(BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgIEResource", "export"));
        fc.addChoosableFileFilter((FileFilter)new Excel2007FileFilter());
        fc.addChoosableFileFilter((FileFilter)new ExcelFileFilter());
        fc.setAcceptAllFileFilterUsed(false);
        fc.setCurrentDirectory(new File(path));
        if (fc.showSaveDialog((Component)((Object)this)) == 0) {
            File file = fc.getSelectedFile();
            FileFilter fileFilter = fc.getFileFilter();
            this.txtFilepath.setText(file.getPath());
            if (fileFilter instanceof ExcelFileFilter) {
                this.fileFormat = ".xls";
            }
            if (fileFilter instanceof Excel2007FileFilter) {
                this.fileFormat = ".xlsx";
            }
        }
    }

    @Override
    protected void btnExport_actionPerformed(ActionEvent e) throws Exception {
        this.verify();
        LongTimeDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (win instanceof Frame) {
            dialog = new LongTimeDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new LongTimeDialog((Dialog)win);
        }
        if (dialog == null) {
            return;
        }
        dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                IObjectPK pk = LogUtil.beginLog(null, (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.budget.client.BgFormResource", "batchExport"), (BOSObjectType)new BgFormInfo().getBOSType(), null, (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.budget.client.BgFormResource", "batchExport"), (String)"bgScheme_export");
                List reList = BgNActualRecordExportUI.this.exportFile(BgNActualRecordExportUI.this.txtFilepath.getText(), BgNActualRecordExportUI.this.bgNActualRecordsMap);
                LogUtil.afterLog(null, (IObjectPK)pk);
                return reList;
            }

            public void afterExec(Object result) throws Exception {
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put((Object)"EXAMINE_DATA", result);
                IUIWindow uiWindow = UIFactory.createUIFactory((String)BgNActualRecordExportUI.this.getModel()).create(BgExportResultUI.class.getName(), (Map)uiContext);
                uiWindow.show();
            }
        });
        dialog.show();
        this.getUIWindow().close();
    }

    protected String getModel() {
        if (this.getUIWindow() instanceof Frame) {
            return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
        }
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List exportFile(String filepath, Map bgNActualRecordsMap) throws Exception {
        ArrayList _exportInfoList = new ArrayList();
        HashSet<BOSUuid> _orgPermissionSet = new HashSet<BOSUuid>();
        FullOrgUnitCollection _fullOrgColl = null;
        CostCenterOrgUnitInfo _ccOrgUnitInfo = SysContext.getSysContext().getCurrentCostUnit();
        UserInfo _userInfo = SysContext.getSysContext().getCurrentUserInfo();
        TreeModel model = null;
        DefaultKingdeeTreeNode root = null;
        FullOrgUnitCollection orgColPer = BgFacadeFactory.getRemoteInstance().getAuthorizedOrg((IObjectPK)new ObjectUuidPK(_userInfo.getId()), OrgType.CostCenter, null, "bg_actralRecord_view");
        try {
            model = BgNFSHelper.getOrgTreeModel(_ccOrgUnitInfo.getId().toString(), null);
            root = (DefaultKingdeeTreeNode)model.getRoot();
            _fullOrgColl = BgNFSHelper.getOrgPermission((IObjectPK)new ObjectUuidPK(_userInfo.getId()));
            if (_ccOrgUnitInfo != null) {
                for (int i = 0; i < _fullOrgColl.size(); ++i) {
                    _orgPermissionSet.add(_fullOrgColl.get(i).getId());
                }
            }
            this.exportOrgUnitFile(orgColPer, root, _orgPermissionSet, _exportInfoList, filepath, bgNActualRecordsMap);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return _exportInfoList;
    }

    protected void exportOrgUnitFile(FullOrgUnitCollection orgColPer, DefaultKingdeeTreeNode root, Set permissionSet, List exportInfoList, String filepath, Map bgNActualRecordsMap) {
        block4: {
            FullOrgUnitInfo _orgUnitInfo;
            String[] _tmpbgFormInfo;
            String[] _exportInfo;
            String _tmpOrgUnitId;
            block5: {
                if (root == null || OrgViewUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)root)) {
                    return;
                }
                String _tmpFilepath = null;
                _tmpOrgUnitId = null;
                String _tmpbgFormId = null;
                _exportInfo = null;
                _tmpbgFormInfo = null;
                _orgUnitInfo = null;
                DefaultKingdeeTreeNode _node = null;
                OrgStructureInfo _oui = (OrgStructureInfo)root.getUserObject();
                if (_oui.getUnit() == null) break block4;
                _orgUnitInfo = _oui.getUnit();
                _tmpOrgUnitId = _orgUnitInfo.getId().toString();
                if (!permissionSet.contains(_orgUnitInfo.getId())) break block5;
                this.exportDirectory(filepath, _orgUnitInfo);
                if (bgNActualRecordsMap.containsKey(_tmpOrgUnitId)) {
                    this.exportExcelFile(orgColPer, _orgUnitInfo, filepath, bgNActualRecordsMap, exportInfoList);
                }
                _tmpFilepath = filepath + "/" + _orgUnitInfo.getName().replaceAll(" ", "");
                int in = root.getChildCount();
                for (int i = 0; i < in; ++i) {
                    _node = (DefaultKingdeeTreeNode)root.getChildAt(i);
                    this.exportOrgUnitFile(orgColPer, _node, permissionSet, exportInfoList, _tmpFilepath, bgNActualRecordsMap);
                }
                break block4;
            }
            if (!bgNActualRecordsMap.containsKey(_tmpOrgUnitId)) break block4;
            Map _tmpBgFormIdsMap = (Map)bgNActualRecordsMap.get(_tmpOrgUnitId);
            for (String _tmpbgFormId : _tmpBgFormIdsMap.keySet()) {
                _tmpbgFormInfo = (String[])_tmpBgFormIdsMap.get(_tmpbgFormId);
                _exportInfo = new String[]{_orgUnitInfo.getName(), _tmpbgFormInfo[1] + " - " + _tmpbgFormInfo[2], EASResource.getString((String)"com.kingdee.eas.ma.nbudget.client.BgIEResource", (String)"errorPermission")};
                exportInfoList.add(_exportInfo);
            }
        }
    }

    protected void exportDirectory(String filepath, FullOrgUnitInfo orgUnitInfo) {
        if (StringUtils.isEmpty((String)filepath) || orgUnitInfo == null) {
            return;
        }
        File _file = new File(filepath + "/" + orgUnitInfo.getName().replaceAll(" ", ""));
        if (!_file.exists()) {
            _file.mkdir();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportExcelFile(FullOrgUnitCollection orgColPer, FullOrgUnitInfo orgUnitInfo, String filepath, Map bgNActualRecordsMap, List exportInfoList) {
        if (orgUnitInfo == null || StringUtils.isEmpty((String)filepath)) {
            return;
        }
        String _bgNActualRecordId2 = null;
        StringBuffer filename = new StringBuffer();
        BgFormInfo _bgFormInfo = null;
        ExportManager em = null;
        Book _book = null;
        Book tmpBook = null;
        KDSBook _kdsBook = null;
        String[] _exportInfo = null;
        BigDecimal _coefficient = null;
        if (orgColPer.contains((Object)orgUnitInfo.getId())) {
            HashMap<String, BigDecimal> _muMap = new HashMap<String, BigDecimal>();
            Map _tmpNActualRecordsMap = (Map)bgNActualRecordsMap.get(orgUnitInfo.getId().toString());
            for (String _bgNActualRecordId2 : _tmpNActualRecordsMap.keySet()) {
                try {
                    BgActualRecordInfo _bgActualRecordInfo = BgActualRecordFactory.getRemoteInstance().getBgActualRecordInfo((IObjectPK)new ObjectStringPK(_bgNActualRecordId2), this.getSelector());
                    _bgFormInfo = _bgActualRecordInfo.getBgForm();
                    _coefficient = _bgActualRecordInfo.getMeasureUnit().getCoefficient();
                    if (_bgFormInfo.getBgMeasureUnit() != null) {
                        BgMeasureUnitInfo _muInfo2 = null;
                        for (BgMeasureUnitInfo _muInfo2 : _bgFormInfo.getBgMeasureUnit()) {
                            _muMap.put(_muInfo2.getBgElement().getNumber(), _muInfo2.getMeasureUnit().getCoefficient());
                        }
                    }
                    filename = new StringBuffer();
                    filename.append(_bgActualRecordInfo.getNumber().trim());
                    filename.append("_");
                    filename.append(_bgActualRecordInfo.getName().trim());
                    filename.append("_");
                    filename.append(orgUnitInfo.getName().trim());
                    filename.append("_");
                    filename.append(_bgFormInfo.getBgScheme().getName().trim());
                    filename.append("_");
                    filename.append(_bgFormInfo.getBgTemplate().getName().trim());
                    filename.append("_");
                    filename.append(_bgFormInfo.getBgPeriod().getName().trim());
                    filename.append("_");
                    filename.append(_bgFormInfo.getCurrency().getName().trim());
                    _book = _bgActualRecordInfo.getBook();
                    _book.getProtection().deleteOperations();
                    Book book = null;
                    book = _bgFormInfo.getCreator().getId().toString().equals(SysContext.getSysContext().getCurrentUserInfo().getId().toString()) ? _book : this.verifyBookPermission(_bgFormInfo, _book);
                    BgNFSHelper.disableCal(book);
                    BgNFSHelper.disableUndo(book);
                    HashMap<String, Object> _tmpMap = new HashMap<String, Object>();
                    _tmpMap.put("EXPORT_BOOK", book);
                    _tmpMap.put("EXPORT_COEFFICIENT", _coefficient);
                    _tmpMap.put("EXPORT_MEASUREUNIT", _muMap);
                    _tmpMap.put("EXPORT_BGFORMULA", null);
                    _tmpMap.put("EXPORT_DATA", Boolean.FALSE);
                    _kdsBook = BgNFCHelper.exportExcel(_tmpMap);
                    if (this.fileFormat != null && ".xls".equals(this.fileFormat)) {
                        filename.append(".xls");
                        em = new ExportManager();
                        em.setExporterParmeter(ExporterParameter.BOOLEAN_VALUE_TRUE, (Object)"true");
                        em.setExporterParmeter(ExporterParameter.BOOLEAN_VALUE_FALSE, (Object)"true");
                        em.setExporterParmeter(ExporterParameter.EXPORT_FORMAT, (Object)"true");
                        em.setExporterParmeter(ExporterParameter.EXPORT_STYLE, (Object)"true");
                        if (this.rbDataANDExpression.isSelected()) {
                            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"true");
                            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA_VALUE, (Object)"true");
                            em.setExporterParmeter(ExporterParameter.EXPORT_CUSTOM_FORMULA, (Object)"true");
                        } else if (this.rbDataANDExcelExpression.isSelected()) {
                            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"true");
                            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA_VALUE, (Object)"true");
                            em.setExporterParmeter(ExporterParameter.EXPORT_CUSTOM_FORMULA, (Object)"false");
                        } else if (this.rbData.isSelected()) {
                            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"false");
                        }
                        em.exportToExcel(_kdsBook, filepath + ("/" + orgUnitInfo.getName() + "/" + filename.toString()).replaceAll(" ", ""));
                    } else if (this.fileFormat != null && ".xlsx".equals(this.fileFormat)) {
                        filename.append(".xlsx");
                        tmpBook = BgNFCHelper.exportExcel2007(_tmpMap);
                        BookDataWrapper bookDataWrapper = new BookDataWrapper(_book);
                        if (this.rbDataANDExpression.isSelected()) {
                            bookDataWrapper.setExportFormula(true);
                            bookDataWrapper.setExportCustomerFomulas(true);
                            bookDataWrapper.setShowValue(true);
                        } else if (this.rbDataANDExcelExpression.isSelected()) {
                            bookDataWrapper.setExportFormula(true);
                            bookDataWrapper.setExportCustomerFomulas(true);
                            bookDataWrapper.setShowValue(false);
                        } else if (this.rbData.isSelected()) {
                            bookDataWrapper.setExportFormula(false);
                            bookDataWrapper.setExportCustomerFomulas(false);
                            bookDataWrapper.setShowValue(true);
                        }
                        bookDataWrapper.setExportHideCols(true);
                        bookDataWrapper.setExportHideRows(true);
                        SXSSFExportWrapper booksc = new SXSSFExportWrapper((AbstractDataWrapper)bookDataWrapper);
                        booksc.write(filepath + ("/" + orgUnitInfo.getName() + "/" + filename.toString()).replaceAll(" ", ""));
                    }
                    _exportInfo = new String[]{orgUnitInfo.getName(), _bgFormInfo.getNumber() + " - " + _bgFormInfo.getName(), EASResource.getString((String)"com.kingdee.eas.ma.nbudget.client.BgIEResource", (String)"export_succeed")};
                    exportInfoList.add(_exportInfo);
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                    _exportInfo = new String[]{orgUnitInfo.getName(), _bgFormInfo.getNumber() + " - " + _bgFormInfo.getName(), EASResource.getString((String)"com.kingdee.eas.ma.nbudget.client.BgIEResource", (String)"export_error")};
                    exportInfoList.add(_exportInfo);
                }
                finally {
                    _kdsBook = null;
                }
            }
        } else {
            _exportInfo = new String[]{this.getMessageStr("bgNtemplaetExportOrgs"), orgUnitInfo.getName(), this.getMessageStr("ExportBgNActualRecordOrgNoViewPer")};
            exportInfoList.add(_exportInfo);
        }
    }

    public boolean destroyWindow() {
        boolean re = super.destroyWindow();
        if (re && this.bgNActualRecordsMap != null) {
            this.bgNActualRecordsMap.clear();
        }
        return re;
    }

    protected SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("bgForm.id");
        sic.add("bgForm.bgScheme.id");
        sic.add("bgForm.bgScheme.name");
        sic.add("bgForm.bgTemplate.id");
        sic.add("bgForm.bgTemplate.name");
        sic.add("bgForm.bgPeriod.id");
        sic.add("bgForm.bgPeriod.name");
        sic.add("bgForm.currency.id");
        sic.add("bgForm.currency.name");
        sic.add("measureUnit.id");
        sic.add("measureUnit.name");
        sic.add("measureUnit.number");
        sic.add("measureUnit.coefficient");
        sic.add("bgForm.bgMeasureUnit.id");
        sic.add("bgForm.bgMeasureUnit.bgElement.id");
        sic.add("bgForm.bgMeasureUnit.bgElement.name");
        sic.add("bgForm.bgMeasureUnit.bgElement.number");
        sic.add("bgForm.bgMeasureUnit.measureUnit.id");
        sic.add("bgForm.bgMeasureUnit.measureUnit.name");
        sic.add("bgForm.bgMeasureUnit.measureUnit.number");
        sic.add("bgForm.bgMeasureUnit.measureUnit.coefficient");
        sic.add("bgForm.*");
        sic.add("*");
        return sic;
    }

    private Book verifyBookPermission(BgFormInfo bgFormInfo, Book _book) throws Exception {
        boolean isSheetPer = BgSHelper.isBgSheetPermissionUsed();
        Map sheetPer = null;
        Sheet _sheet = null;
        if (isSheetPer) {
            sheetPer = this.myAddBgSheetPermissions(bgFormInfo.getBgTemplate().getId().toString());
            String user = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            if (_book != null) {
                int sheetIndex = 0;
                int sheetSize = _book.getSheetCount();
                for (sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
                    _sheet = _book.getSheet(sheetIndex);
                    if (_sheet == null || !this.checkSheetsDelete(_sheet, sheetPer, user, _book)) continue;
                    --sheetIndex;
                }
            }
        }
        return _book;
    }

    private Map myAddBgSheetPermissions(String bgTemplateId) {
        if (bgTemplateId == null) {
            return null;
        }
        Map hasPer = new HashMap<String, Object>();
        Map sheetPer = new HashMap();
        try {
            hasPer.put(bgTemplateId, null);
            hasPer = BgPermissionHelper.getBgTemplateSheetPermission(null, hasPer);
            if (hasPer != null && hasPer.get(bgTemplateId) != null) {
                sheetPer = (Map)hasPer.get(bgTemplateId);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return sheetPer;
    }

    protected boolean checkSheetsDelete(Sheet _sheet, Map sheetPer, String user, Book _book) {
        boolean flage = false;
        String sheetCreater = null;
        if (sheetPer != null && sheetPer.containsKey(BgNFSHelper.getSheetSign(_sheet))) {
            _sheet.setHide(false);
        } else {
            sheetCreater = (String)_sheet.getUserObjectValue("SHEET_CREATER_ID");
            if (sheetCreater != null) {
                if (!sheetCreater.equals(user)) {
                    _book.removeSheet(_sheet.getSheetIndex());
                    flage = true;
                }
            } else {
                _book.removeSheet(_sheet.getSheetIndex());
                flage = true;
            }
        }
        return flage;
    }
}

