/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.agent.AgentUtility;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ProcessDefInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.biz.trans.ActivityDefPartialInfo;
import com.kingdee.bos.workflow.biz.trans.AssignatePersonsInfo;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.participant.ActivityPersonsInfo;
import com.kingdee.bos.workflow.participant.ParticipantUtils;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.bos.workflow.util.ApplicationUtil;
import com.kingdee.eas.base.multiapprove.client.DesignatePerformerUI;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.BgFormCollection;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.IBgFormFacade;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgNCWfHelper {
    private static final Logger logger = CoreUIObject.getLogger(BgNCWfHelper.class);
    public static final String PARAM_KEY = "BG058";
    public static final String FUNCTION_NAME = "com.kingdee.eas.ma.budget.BgFormFunction";
    public static final String ACTION_NAME = "ActionSubmitNextPerson";
    public static final String NEXT_PERSONS = "nextpersons";

    public static boolean submitFormWork(BOSUuid bgFormId, CoreUI ui, IBgFormFacade facade, ICoreBase bizInterface) throws BOSException, EASBizException, Exception {
        if (BgNCWfHelper.isNextPersonSubmit()) {
            CoreBaseInfo editData = bizInterface.getValue((IObjectPK)new ObjectUuidPK(bgFormId));
            if (editData == null) {
                SysUtil.abort();
            }
            return BgNCWfHelper.submitFormWork(editData, ui, facade);
        }
        return facade.submitForm(bgFormId);
    }

    public static boolean submitFormWork(CoreBaseInfo editData, CoreUI ui, IBgFormFacade facade) throws BOSException, EASBizException, Exception {
        if (BgNCWfHelper.isNextPersonSubmit()) {
            return BgNCWfHelper.submitFormWorkNextPerson(editData, ui, facade);
        }
        return facade.submitForm(editData.getId());
    }

    public static boolean submitFormWorkNextPerson4Batch(Object bgFormId, String nextPersonInfo, IBgFormFacade facade, ICoreBase bizInterface) throws BOSException, EASBizException, Exception {
        boolean flag = false;
        if (bgFormId != null) {
            CoreBaseInfo editData = bizInterface.getValue((IObjectPK)new ObjectStringPK(bgFormId.toString()));
            if (nextPersonInfo != null) {
                editData.setExtendedProperty("DesignateNextActivityPerformerWhenSubmit", nextPersonInfo);
            }
            flag = facade.submitFormWorkNextPerson((BgFormInfo)editData);
        }
        return flag;
    }

    private static boolean submitFormWorkNextPerson(CoreBaseInfo editData, CoreUI ui, IBgFormFacade facade) throws BOSException, EASBizException, Exception {
        BgNCWfHelper.checkPostActivityPersons(editData, ui, facade.getContext());
        return facade.submitFormWorkNextPerson((BgFormInfo)editData);
    }

    public static String getNextPersonInfo4Batch(List billIds, CoreUI ui, Context context) throws BOSException, EASBizException, Exception {
        String res = null;
        if (BgNCWfHelper.isNextPersonSubmit() && billIds != null && !billIds.isEmpty()) {
            BgFormInfo info = BgFormFactory.getRemoteInstance().getBgFormInfo((IObjectPK)new ObjectStringPK(billIds.get(0).toString()));
            BgNCWfHelper._checkPostActivityPersons((CoreBaseInfo)info, ui, context);
            res = info.getExtendedProperty("DesignateNextActivityPerformerWhenSubmit");
        }
        return res;
    }

    private static void checkPostActivityPersons(CoreBaseInfo editData, CoreUI ui, Context context) throws BOSException, EASBizException, Exception {
        BgNCWfHelper._checkPostActivityPersons(editData, ui, context);
        ui.getUIContext().put("DesignateNextActivityPerformerWhenSubmit", null);
        ui.getUIContext().remove(NEXT_PERSONS);
    }

    private static void _checkPostActivityPersons(CoreBaseInfo editData, CoreUI ui, Context context) throws BOSException, EASBizException, Exception {
        int option;
        String oStr;
        String partStr = (String)ui.getUIContext().get("DesignateNextActivityPerformerWhenSubmit");
        if (!StringUtils.isEmpty((String)partStr) && StringUtils.isEmpty((String)(oStr = editData.getExtendedProperty("DesignateNextActivityPerformerWhenSubmit")))) {
            editData.setExtendedProperty("DesignateNextActivityPerformerWhenSubmit", partStr);
        }
        StringBuffer msg = new StringBuffer();
        IObjectValue bizObj = AgentUtility.getNoAgentValue((IObjectValue)editData);
        IEnactmentService service = EnactmentServiceFactory.createRemoteEnactService();
        String hashValue = BgNCWfHelper.getNextPersonHashValue(service, bizObj, ui, msg);
        if (hashValue != null && (option = MsgBox.showConfirm3(null, (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.client.BgNFormResource", (String)"bgFormIsNeedNextPerson"), (String)msg.toString())) == 0) {
            Map map = DesignatePerformerUI.process((CoreUIObject)ui, (AbstractObjectValue)editData, (String)hashValue, (String)FUNCTION_NAME, (String)ACTION_NAME, null);
            if (map != null) {
                if (context != null) {
                    context.put((Object)"DesignateNextActivityPerformerWhenSubmit", (Object)map);
                }
                BgNCWfHelper.reDesignateNextPerson(service, editData);
                BgNCWfHelper._checkPostActivityPersons(editData, ui, context);
            } else {
                SysUtil.abort();
            }
        }
    }

    private static String getNextPersonHashValue(IEnactmentService service, IObjectValue bizObj, CoreUI ui, StringBuffer msg) throws Exception {
        String res = null;
        String id = bizObj.getString(bizObj.getPKField()).toString();
        res = BgNCWfHelper.getNewWfPersonHashValue(service, bizObj, ui, msg, id);
        if (res == null) {
            res = BgNCWfHelper.getOldWfPersonHashValue(service, bizObj, ui, msg, id);
        }
        return res;
    }

    private static String getOldWfPersonHashValue(IEnactmentService service, IObjectValue bizObj, CoreUI ui, StringBuffer msg, String id) throws BOSException, WfException, Exception {
        String res = null;
        return res;
    }

    private static String getNewWfPersonHashValue(IEnactmentService service, IObjectValue bizObj, CoreUI ui, StringBuffer msg, String id) throws WfException, Exception {
        boolean isNeeded = false;
        AssignatePersonsInfo assignatePersons = service.checkPostActivitiesPersonsResult(bizObj, SysContext.getSysContext().getCurrentUserInfo().getId().toString(), id, FUNCTION_NAME, ACTION_NAME);
        if (assignatePersons != null) {
            ActivityPersonsInfo[] persons;
            Map perMap = DesignatePerformerUI.getPerformList((AbstractObjectValue)((AbstractObjectValue)bizObj), (CoreUIObject)ui);
            List unitActDef = BgNCWfHelper.getNeedAssignateUnitActDef(assignatePersons.getUnitScopeActDefCol(), perMap, assignatePersons.getProcDefHashValue());
            if (unitActDef != null && unitActDef.size() > 0) {
                isNeeded = true;
            }
            if ((persons = assignatePersons.getActivityPersons()) != null && persons.length > 0) {
                for (int i = 0; i < persons.length; ++i) {
                    List l;
                    Person[] actPersons;
                    ActivityPersonsInfo personsInfo = persons[i];
                    if (!personsInfo.isCanSpecifyNextActivityPerformer() || (actPersons = personsInfo.getPersons()) != null && actPersons.length > 0 || perMap != null && (l = (List)perMap.get(ParticipantUtils.createDesignatePerformerKey((String)personsInfo.getProcDefHashValue(), (String)personsInfo.getActDefID()))) != null && !l.isEmpty()) continue;
                    msg.append(personsInfo.getActDefName()).append(" -").append(personsInfo.getProcDefName()).append("\u3001 ");
                    isNeeded = true;
                }
            }
            if (msg != null && msg.length() > 0) {
                msg.deleteCharAt(msg.length() - 1);
            }
            msg.append(BgNCWfHelper.constructUnitActTip(unitActDef));
        }
        if (isNeeded) {
            return assignatePersons.getProcDefHashValue();
        }
        return null;
    }

    private static void reDesignateNextPerson(IEnactmentService service, CoreBaseInfo editData) throws Exception {
        String billId;
        ProcessInstInfo[] procInsts;
        if (editData.getId() != null && (procInsts = service.getProcessInstanceByHoldedObjectId(billId = editData.getId().toString())) != null && procInsts.length > 0) {
            ProcessInstInfo openProcInst = null;
            for (int j = 0; j < procInsts.length; ++j) {
                ProcessInstInfo processInstInfo = procInsts[j];
                if (!"open".equalsIgnoreCase(processInstInfo.getState().substring(0, 4))) continue;
                openProcInst = processInstInfo;
                break;
            }
            if (openProcInst == null) {
                return;
            }
            Map map = new HashMap();
            String value = editData.getExtendedProperty("DesignateNextActivityPerformerWhenSubmit");
            if (!StringUtils.isEmpty((String)value)) {
                byte[] fieldValueByteArray = StringUtils.hexFromString((String)value);
                ByteArrayInputStream bis = new ByteArrayInputStream(fieldValueByteArray);
                ObjectInputStream ois = new ObjectInputStream(bis);
                map = (Map)ois.readObject();
                for (Map.Entry entry : map.entrySet()) {
                    service.setProcessContext(openProcInst.getProcInstId(), entry.getKey().toString(), entry.getValue());
                }
            }
        }
    }

    private static List getNeedAssignateUnitActDef(ActivityDefPartialInfo[] unitScopeActDefCol, Map perMap, String procDefHashValue) {
        if (unitScopeActDefCol == null || unitScopeActDefCol.length <= 0) {
            return null;
        }
        ArrayList<ActivityDefPartialInfo> unitActDef = new ArrayList<ActivityDefPartialInfo>();
        for (int i = 0; i < unitScopeActDefCol.length; ++i) {
            List persons = (List)perMap.get(ParticipantUtils.createDesignatePerformerKey((String)procDefHashValue, (String)unitScopeActDefCol[i].getActDefId()));
            if (persons != null && !persons.isEmpty()) continue;
            unitActDef.add(unitScopeActDefCol[i]);
        }
        return unitActDef;
    }

    public static ProcessDef getBindWfProcessDef(IEnactmentService service, IObjectValue editData) throws BOSException {
        IObjectValue bizObj = AgentUtility.getNoAgentValue((IObjectValue)editData);
        String procDefId = service.findSubmitProcDef(SysContext.getSysContext().getCurrentUserInfo().getId().toString(), bizObj, FUNCTION_NAME, ACTION_NAME);
        if (procDefId == null) {
            return null;
        }
        ProcessDefInfo procDefInfo = service.getProcessDefInfo(procDefId);
        ProcessDef procDef = ApplicationUtil.getProcessDefByDefHashValue((String)procDefInfo.getMd5HashValue());
        return procDef;
    }

    private static String constructUnitActTip(List unitActDef) {
        if (unitActDef == null || unitActDef.size() <= 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n" + EASResource.getString((String)"com.kingdee.eas.ma.nbudget.client.BgNFormResource", (String)"bgFormNextPersonMsg") + "\n");
        for (int i = 0; i < unitActDef.size(); ++i) {
            ActivityDefPartialInfo info = (ActivityDefPartialInfo)unitActDef.get(i);
            buffer.append(info.getActDefName());
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public static ProcessInstInfo getCurrentProcessInst(IEnactmentService service, String id) throws BOSException {
        int i;
        int n;
        ProcessInstInfo processInstInfo = null;
        ProcessInstInfo[] procInsts = service.getProcessInstanceByHoldedObjectId(id);
        if (procInsts != null) {
            n = procInsts.length;
            for (i = 0; i < n; ++i) {
                if (!"open".equalsIgnoreCase(procInsts[i].getState().substring(0, 4))) continue;
                processInstInfo = procInsts[i];
            }
        }
        if (processInstInfo == null) {
            procInsts = service.getAllProcessInstancesByBizobjId(id);
            n = procInsts.length;
            for (i = 0; i < n; ++i) {
                if (processInstInfo != null && !procInsts[i].getLastStateTime().after(processInstInfo.getLastStateTime())) continue;
                processInstInfo = procInsts[i];
            }
            if (processInstInfo == null && (id = BgNCWfHelper.getAdjustID(id)) != null) {
                procInsts = service.getAllProcessInstancesByBizobjId(id);
                n = procInsts.length;
                for (i = 0; i < n; ++i) {
                    if (processInstInfo != null && !procInsts[i].getLastStateTime().after(processInstInfo.getLastStateTime())) continue;
                    processInstInfo = procInsts[i];
                }
            }
        }
        return processInstInfo;
    }

    private static String getAdjustID(String id) throws BOSException {
        IBgForm iBgForm = BgFormFactory.getRemoteInstance();
        BgFormCollection col = iBgForm.getBgFormCollection("select id, versionNo where adjust.id = '" + id + "' and id <> '" + id + "' order by versionNo DESC");
        if (col == null || col.isEmpty()) {
            return null;
        }
        return col.get(0).getId().toString();
    }

    public static boolean isNextPersonSubmit() {
        String paramValue = null;
        try {
            paramValue = ParamManager.getParamValue(null, null, (String)PARAM_KEY);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        boolean flag = StringUtils.isEmpty((String)paramValue) ? false : Boolean.valueOf(paramValue);
        return flag;
    }
}

