/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.message.client.MessageCenterUI;
import com.kingdee.eas.base.multiapprove.client.MultiApproveListUI;
import com.kingdee.eas.base.multiapprove.client.MultiApproveUI;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.INewOrgViewFacade;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.CheckedStatusEnum;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.ma.budget.BgConstants;
import com.kingdee.eas.ma.budget.BgElementCollection;
import com.kingdee.eas.ma.budget.BgElementFactory;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgFormDataSourceEnum;
import com.kingdee.eas.ma.budget.BgFormFacadeFactory;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgFormStateEnum;
import com.kingdee.eas.ma.budget.BgMeasureUnitInfo;
import com.kingdee.eas.ma.budget.BgPeriodHelper;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgTemFormTypeEnum;
import com.kingdee.eas.ma.budget.BgTemMeasureUnitInfo;
import com.kingdee.eas.ma.budget.BgTemplateCollection;
import com.kingdee.eas.ma.budget.BgTemplateFactory;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.IBgElement;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.IBgFormFacade;
import com.kingdee.eas.ma.budget.IBgTemplate;
import com.kingdee.eas.ma.budget.client.BgPeriodDialog;
import com.kingdee.eas.ma.nbudget.BgNFFacadeFactory;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgPermissionHelper;
import com.kingdee.eas.ma.nbudget.IBgNFFacade;
import com.kingdee.eas.ma.nbudget.client.AbstractBgNEditUI;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.ma.nbudget.client.BgNFormAdjustProcessUI;
import com.kingdee.eas.ma.nbudget.client.BgNFormProcessUI;
import com.kingdee.eas.ma.nbudget.utils.BgCodeRuleCUtils;
import com.kingdee.eas.ma.view.client.BgReportViewAdjustAuditProcessUI;
import com.kingdee.eas.ma.view.client.BgReportViewAuditProcessUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class BgNEditUI
extends AbstractBgNEditUI {
    private static final long serialVersionUID = 7161666467816700373L;
    private static final Logger logger = CoreUIObject.getLogger(BgNEditUI.class);
    private String ccOprtState = null;
    protected FullOrgUnitInfo ccOrgUnitInfo = null;
    private boolean hasFund = false;
    private boolean hasSubmit = false;
    private BgCodeRuleCUtils codeRule = new BgCodeRuleCUtils(true);

    public BgCodeRuleCUtils getCodeRule() {
        return this.codeRule;
    }

    protected IObjectValue createNewData() {
        BgFormInfo bgFormInfo = new BgFormInfo();
        bgFormInfo.setId(BOSUuid.create((BOSObjectType)bgFormInfo.getBOSType()));
        bgFormInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        bgFormInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        bgFormInfo.setStartDate(new Date());
        bgFormInfo.setEndDate(bgFormInfo.getStartDate());
        bgFormInfo.setState(BgFormStateEnum.Edited);
        bgFormInfo.setDataSource(BgFormDataSourceEnum.CURRENTWORKOUT);
        bgFormInfo.setName(this.txtName.getText());
        bgFormInfo.setOrgUnit((FullOrgUnitInfo)this.getUIContext().get("ORGUNIT_INFO"));
        bgFormInfo.setCU((CtrlUnitInfo)this.getUIContext().get("ORGUNIT_CU"));
        CompanyOrgUnitInfo companyInfo = null;
        try {
            FullOrgUnitInfo orgInfo = bgFormInfo.getOrgUnit();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("number");
            sic.add("name");
            sic.add("longnumber");
            sic.add("isCompanyOrgUnit");
            FullOrgUnitInfo tempOrg = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgInfo.getId().toString()), sic);
            companyInfo = this.getCompanyByOrgUnit((OrgUnitInfo)tempOrg);
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        if (companyInfo != null) {
            bgFormInfo.setCompany(companyInfo);
        } else {
            bgFormInfo.setCompany(SysContext.getSysContext().getCurrentFIUnit());
        }
        bgFormInfo.setAdjust(bgFormInfo);
        bgFormInfo.setVersionNo(BgConstants.ONE);
        bgFormInfo.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
        bgFormInfo.setCheckedStatus(CheckedStatusEnum.UNCHECKED);
        bgFormInfo.setSourceType(RptSrcTypeEnum.BGFORMREPORT);
        bgFormInfo.setPeriodType(RptPeriodTypeEnum.YEARLY);
        return bgFormInfo;
    }

    protected void loadData() throws Exception {
        super.loadData();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            String OUID = this.editData.getOrgUnit().getId().toString();
            this.getNumberByCodingRule((IObjectValue)this.editData, OUID);
        }
    }

    protected void getNumberByCodingRule(IObjectValue caller, String orgId) {
        BgFormInfo _calller = new BgFormInfo();
        _calller.setSourceType(RptSrcTypeEnum.BGFORMREPORT);
        this.getCodeRule().applyNumber(this.txtNumber, (IObjectValue)_calller, orgId, "sourceType", null);
        this.getCodeRule().applyNumber(this.txtName, (IObjectValue)_calller, orgId, "sourceType", "name");
    }

    protected CompanyOrgUnitInfo getCompanyByOrgUnit(OrgUnitInfo orgUnitInfo) throws Exception {
        if (orgUnitInfo.isIsCompanyOrgUnit()) {
            return CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitInfo.getId()), this.getCompanySelectors());
        }
        OrgUnitInfo parent = this.getOrgFacadeInterface().getParent(orgUnitInfo.getId().toString(), OrgViewType.COSTCENTER);
        if (parent != null) {
            return this.getCompanyByOrgUnit(parent);
        }
        return null;
    }

    protected SelectorItemCollection getCompanySelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("isBizUnit");
        sic.add("accountPeriodType.id");
        return sic;
    }

    protected void prepareNumber(IObjectValue caller, String number) {
        if (number != null && number.length() > 0) {
            caller.put("number", (Object)number);
            this.txtNumber.setText(number);
        }
    }

    protected void setNumberTextEnabled() {
        this.txtNumber.setEnabled(true);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgFormFactory.getRemoteInstance();
    }

    protected IBgForm getBgFormInterface() throws Exception {
        return (IBgForm)this.getBizInterface();
    }

    protected IBgFormFacade getFacadeInterface() throws Exception {
        return BgFormFacadeFactory.getRemoteInstance();
    }

    protected IBgNFFacade getNFacadeInterface() throws Exception {
        return BgNFFacadeFactory.getRemoteInstance();
    }

    protected IBgTemplate getBgTemplateInterface() throws Exception {
        return BgTemplateFactory.getRemoteInstance();
    }

    protected IBgElement getBgElementInterface() throws Exception {
        return BgElementFactory.getRemoteInstance();
    }

    protected IMeasureUnit getMeasureUnitInterface() throws Exception {
        return MeasureUnitFactory.getRemoteInstance();
    }

    protected INewOrgViewFacade getOrgFacadeInterface() throws Exception {
        return NewOrgViewFacadeFactory.getRemoteInstance();
    }

    protected String getMessageStr(String key) {
        return !StringUtils.isEmpty((String)key) ? EASResource.getString((String)"com.kingdee.eas.ma.nbudget.client.BgNFormResource", (String)key) : "";
    }

    protected String getMessageStr(String sourceStr, String key) {
        return !StringUtils.isEmpty((String)key) ? EASResource.getString((String)sourceStr, (String)key) : "";
    }

    public boolean isHasFund() {
        return this.hasFund;
    }

    public void setHasFund(boolean hasFund) {
        this.hasFund = hasFund;
    }

    public boolean isHasSubmit() {
        return this.hasSubmit;
    }

    public void setHasSubmit(boolean hasSubmit) {
        this.hasSubmit = hasSubmit;
    }

    public void onLoad() throws Exception {
        this.beforeLoad();
        super.onLoad();
        this.afterLoad();
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        if (!OprtState.ADDNEW.equals(this.getOprtState()) && this.ccOrgUnitInfo == null) {
            this.ccOrgUnitInfo = ((BgFormInfo)dataObject).getOrgUnit();
        }
        super.setDataObject(dataObject);
    }

    protected void initTitle() {
        this.setUITitle(this.getMessageStr("Title") + " - " + this.getMessageStr(this.getCcOprtState()));
        this.contNumber.setBoundLabelText(this.getMessageStr("TitleNumber"));
        this.contName.setBoundLabelText(this.getMessageStr("TitleName"));
        this.contBgScheme.setBoundLabelText(this.getMessageStr("TitleBgScheme"));
        this.contBgTemplate.setBoundLabelText(this.getMessageStr("TitleBgTemplate"));
        this.contCurrency.setBoundLabelText(this.getMessageStr("TitleCurrency"));
        this.contBgType.setBoundLabelText(this.getMessageStr("TitleType"));
        this.contBgPeriod.setBoundLabelText(this.getMessageStr("TitleBgPeriod"));
        this.contMeasureUnit.setBoundLabelText(this.getMessageStr("TitleMeasureUnit"));
        this.contCreator.setBoundLabelText(this.getMessageStr("TitleCreator"));
        this.contCreateDate.setBoundLabelText(this.getMessageStr("TitleCreateDate"));
    }

    protected void initMenu() {
        this.menuBar.setEnabled(false);
        this.menuBar.setVisible(false);
        this.menuItemAddNew.setVisible(false);
        this.menuItemEdit.setVisible(false);
        this.menuItemSave.setVisible(false);
        this.menuItemCopy.setVisible(false);
        this.menuItemRemove.setVisible(false);
        this.menuItemPageSetup.setVisible(false);
        this.menuItemPrint.setVisible(false);
        this.menuItemPrintPreview.setVisible(false);
        this.menuItemFirst.setVisible(false);
        this.menuItemPre.setVisible(false);
        this.menuItemNext.setVisible(false);
        this.menuItemLast.setVisible(false);
        this.menuItemCancel.setVisible(false);
        this.menuItemCancelCancel.setVisible(false);
    }

    protected void initButton() {
        this.btnAddNew.setVisible(false);
        this.btnEdit.setVisible(false);
        this.btnSave.setVisible(false);
        this.btnCopy.setVisible(false);
        this.btnRemove.setVisible(false);
        this.btnPageSetup.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnFirst.setVisible(false);
        this.btnPre.setVisible(false);
        this.btnNext.setVisible(false);
        this.btnLast.setVisible(false);
        this.btnCancel.setVisible(false);
        this.btnCancelCancel.setVisible(false);
    }

    protected void initAction() {
        this.actionAddNew.setEnabled(false);
        this.actionEdit.setEnabled(false);
        this.actionSave.setEnabled(false);
        this.actionCopy.setEnabled(false);
        this.actionRemove.setEnabled(false);
        this.actionPageSetup.setEnabled(false);
        this.actionPrint.setEnabled(false);
        this.actionPrintPreview.setEnabled(false);
        this.actionFirst.setEnabled(false);
        this.actionPre.setEnabled(false);
        this.actionNext.setEnabled(false);
        this.actionLast.setEnabled(false);
        this.actionCancel.setEnabled(false);
        this.actionCancelCancel.setEnabled(false);
    }

    protected void beforeLoad() throws Exception {
        this.ccOprtState = this.getOprtState();
        this.initTitle();
        this.initMenu();
        this.initButton();
        if (this.getUIContext().get("ORGUNIT_INFO") != null) {
            this.ccOrgUnitInfo = (FullOrgUnitInfo)this.getUIContext().get("ORGUNIT_INFO");
        }
        this.setHasFund(false);
    }

    protected void afterLoad() throws Exception {
        this.initSystemInfo();
        this.initSystemData();
        this.initFormWorking();
    }

    protected void initSystemInfo() throws Exception {
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            if (this.getCodeRule().isNumberOrIsName()) {
                this.txtNumber.setEnabled(false);
            } else {
                this.txtNumber.setEnabled(true);
            }
            this.prmtOrgUnit.setRequired(true);
            this.prmtBgScheme.setRequired(true);
            this.prmtBgPeriod.setRequired(true);
            this.prmtCreator.setRequired(true);
            this.comMeasureUnit.setEnabled(false);
            this.prmtBgType.setEnabled(false);
            this.tblMeasureUnit.setEnabled(false);
        } else {
            this.txtNumber.setEnabled(false);
            this.prmtOrgUnit.setEnabled(false);
            this.prmtBgScheme.setEnabled(false);
            this.comBgTemplate.setEnabled(false);
            this.comCurrency.setEnabled(false);
            this.prmtBgType.setEnabled(false);
            this.prmtBgPeriod.setEnabled(false);
            this.comMeasureUnit.setEnabled(false);
            this.tblMeasureUnit.setEnabled(false);
        }
    }

    protected void initSystemData() throws Exception {
        if (this.ccOrgUnitInfo == null) {
            this.ccOrgUnitInfo = this.editData.getOrgUnit();
        }
        this.initBgSchemeInfo();
        this.initCurrencyInfo();
        this.initBgPeriodInfo();
        this.initMeasureUnitInfo();
    }

    protected void initBgSchemeInfo() {
        EntityViewInfo view = null;
        FilterInfo filter = null;
        if (this.ccOrgUnitInfo != null) {
            view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.ccOrgUnitInfo.getId().toString()));
            filter.setMaskString("#0");
            if (this.isHasFund()) {
                filter.getFilterItems().add(new FilterItemInfo("period", (Object)new Integer(4), CompareType.NOTEQUALS));
                filter.setMaskString("#0 and #1");
            }
            if (BgSHelper.isBgPermissionUsed()) {
                HashSet<String> orgSet = new HashSet<String>();
                orgSet.add(this.ccOrgUnitInfo.getId().toString());
                filter = BgPermissionHelper.addBgSchemePermission(this.getUserPk().toString(), orgSet, filter);
            }
            view.setFilter(filter);
            this.prmtBgScheme.setEntityViewInfo(view);
        }
    }

    protected void initCurrencyInfo() {
        BgNFCHelper.setCurrency(this.comCurrency, this.ccOrgUnitInfo.getId(), true);
        if (!OprtState.ADDNEW.equals(this.getOprtState()) && this.editData.getCurrency() != null) {
            BgNFCHelper.setSelectObject(this.comCurrency, this.editData.getCurrency());
        }
    }

    protected void initBgPeriodInfo() {
        BgPeriodDialog dialog = new BgPeriodDialog((CoreUIObject)this);
        this.prmtBgPeriod.setSelector((KDPromptSelector)dialog);
    }

    protected void initMeasureUnitInfo() throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet<Integer> dataType = new HashSet<Integer>();
        dataType.add(new Integer(0));
        dataType.add(new Integer(1));
        dataType.add(new Integer(2));
        filter.getFilterItems().add(new FilterItemInfo("dataType", dataType, CompareType.INCLUDE));
        view.setFilter(filter);
        SorterItemCollection sic = new SorterItemCollection();
        SorterItemInfo sort = new SorterItemInfo("number");
        sic.add(sort);
        view.setSorter(sic);
        IRow row = null;
        BgElementInfo eInfo2 = null;
        BgElementCollection bgECol = null;
        this.tblMeasureUnit.setRefresh(false);
        this.tblMeasureUnit.checkParsed();
        bgECol = this.getBgElementInterface().getBgElementCollection(view);
        if (bgECol != null && !bgECol.isEmpty()) {
            this.tblMeasureUnit.getColumn(0).getStyleAttributes().setLocked(true);
            this.tblMeasureUnit.getColumn(1).getStyleAttributes().setLocked(true);
            this.tblMeasureUnit.getColumn(2).getStyleAttributes().setLocked(true);
            this.tblMeasureUnit.getColumn(3).getStyleAttributes().setLocked(true);
            for (BgElementInfo eInfo2 : bgECol) {
                row = this.tblMeasureUnit.addRow();
                row.getCell(0).setValue((Object)eInfo2.getId().toString());
                row.getCell(1).setValue((Object)eInfo2.getNumber());
                row.getCell(2).setValue((Object)eInfo2.getName());
                row.getCell(3).setValue((Object)eInfo2.getDataType().getAlias());
                row.setUserObject((Object)eInfo2);
            }
        }
        this.tblMeasureUnit.setRefresh(false);
        this.tblMeasureUnit.reLayoutAndPaint();
        EntityViewInfo muView = new EntityViewInfo();
        FilterInfo muFilter = new FilterInfo();
        muFilter.getFilterItems().add(new FilterItemInfo("measureUnitGroup.number", (Object)"BUDGET", CompareType.EQUALS));
        muFilter.getFilterItems().add(new FilterItemInfo("isDisabled", (Object)Boolean.FALSE, CompareType.EQUALS));
        muView.setFilter(muFilter);
        muView.getSorter().add(new SorterItemInfo("coefficient"));
        MeasureUnitInfo muInfo2 = null;
        MeasureUnitCollection muCol = null;
        KDTDefaultCellEditor editor = null;
        KDComboBox comboBox = new KDComboBox();
        DefaultComboBoxModel<MeasureUnitInfo> model = new DefaultComboBoxModel<MeasureUnitInfo>();
        try {
            muCol = this.getMeasureUnitInterface().getMeasureUnitCollection(muView);
            this.comMeasureUnit.removeAllItems();
            if (muCol != null && !muCol.isEmpty()) {
                for (MeasureUnitInfo muInfo2 : muCol) {
                    this.comMeasureUnit.addItem((Object)muInfo2);
                    model.addElement(muInfo2);
                }
            }
            comboBox.setModel(model);
            editor = new KDTDefaultCellEditor((JComboBox)comboBox);
            this.tblMeasureUnit.getColumn(4).setEditor((ICellEditor)editor);
            if (!OprtState.ADDNEW.equals(this.getCcOprtState())) {
                if (this.editData.getMeasureUnit() != null) {
                    BgNFCHelper.setSelectObject(this.comMeasureUnit, this.editData.getMeasureUnit());
                }
                this.loadMeasureUnitInfo(this.editData);
            }
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (EASBizException ex) {
            throw ex;
        }
    }

    protected void initFormWorking() throws Exception {
        Object _owner = this.getUIContext().get("Owner");
        String uiModel = "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
        String uiName = BgNFormProcessUI.class.getName();
        String status = "1";
        String justUIName = BgNFormAdjustProcessUI.class.getName();
        if (!OprtState.ADDNEW.equals(this.oprtState) && this.editData.getBgTemplate() != null && BgTemFormTypeEnum.VIEWFORM.equals((Object)this.editData.getBgTemplate().getFormType())) {
            uiModel = "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
            uiName = BgReportViewAuditProcessUI.class.getName();
            status = "1";
            justUIName = BgReportViewAdjustAuditProcessUI.class.getName();
        }
        if (_owner != null) {
            if (_owner instanceof MultiApproveUI || _owner instanceof MultiApproveListUI) {
                this.txtNumber.setEnabled(false);
                this.txtName.setEnabled(false);
                this.prmtOrgUnit.setEnabled(false);
                this.prmtBgScheme.setEnabled(false);
                this.comBgTemplate.setEnabled(false);
                this.comCurrency.setEnabled(false);
                this.prmtBgType.setEnabled(false);
                this.prmtBgPeriod.setEnabled(false);
                this.comMeasureUnit.setEnabled(false);
                this.tblMeasureUnit.setEnabled(false);
                String _oprtState = OprtState.VIEW;
                Object _isNew = this.getUIContext().get("isNewWindow");
                if (_isNew != null && _isNew instanceof Boolean && ((Boolean)_isNew).booleanValue()) {
                    Object _openState = this.getUIContext().get("customBizUIStatus");
                    if (_openState != null && OprtState.EDIT.equals(_openState)) {
                        _oprtState = OprtState.EDIT;
                    }
                    UIContext uiContext = new UIContext(_owner);
                    uiContext.put((Object)"ID", this.getUIContext().get("ID"));
                    uiContext.put((Object)"BGFORM_WORKING_OPEN", (Object)Boolean.TRUE);
                    uiContext.put((Object)"STATUS_CELL", (Object)status);
                    IUIWindow uiWindow = null;
                    uiWindow = this.editData != null && this.editData.getId() != null && BgNFSHelper.checkHasAdjust(this.editData.getId()) ? UIFactory.createUIFactory((String)uiModel).create(justUIName, (Map)uiContext, null, _oprtState) : UIFactory.createUIFactory((String)uiModel).create(uiName, (Map)uiContext, null, _oprtState);
                    uiWindow.show();
                    this.setOprtState(OprtState.VIEW);
                    SysUtil.abort();
                }
            } else if (_owner instanceof MessageCenterUI) {
                String _oprtState = (String)this.getUIContext().get("customUIStatus");
                _oprtState = _oprtState != null && OprtState.EDIT.equals(_oprtState) ? OprtState.EDIT : OprtState.VIEW;
                UIContext uiContext = new UIContext(_owner);
                uiContext.put((Object)"ID", this.getUIContext().get("ID"));
                uiContext.put((Object)"BGFORM_WORKING_OPEN", (Object)Boolean.TRUE);
                uiContext.put((Object)"STATUS_CELL", (Object)status);
                IUIWindow uiWindow = null;
                uiWindow = this.editData != null && this.editData.getId() != null && BgNFSHelper.checkHasAdjust(this.editData.getId()) ? UIFactory.createUIFactory((String)uiModel).create(justUIName, (Map)uiContext, null, _oprtState) : UIFactory.createUIFactory((String)uiModel).create(uiName, (Map)uiContext, null, _oprtState);
                uiWindow.show();
                this.setOprtState(OprtState.VIEW);
                SysUtil.abort();
            } else if (_owner instanceof Frame) {
                String _oprtState = (String)this.getUIContext().get("customUIStatus");
                _oprtState = _oprtState != null && OprtState.EDIT.equals(_oprtState) ? OprtState.EDIT : OprtState.VIEW;
                UIContext uiContext = new UIContext(_owner);
                uiContext.put((Object)"ID", this.getUIContext().get("ID"));
                uiContext.put((Object)"BGFORM_WORKING_OPEN", (Object)Boolean.TRUE);
                uiContext.put((Object)"STATUS_CELL", (Object)status);
                IUIWindow uiWindow = null;
                uiWindow = this.editData != null && this.editData.getId() != null && BgNFSHelper.checkHasAdjust(this.editData.getId()) ? UIFactory.createUIFactory((String)uiModel).create(justUIName, (Map)uiContext, null, _oprtState) : UIFactory.createUIFactory((String)uiModel).create(uiName, (Map)uiContext, null, _oprtState);
                uiWindow.show();
                this.setOprtState(OprtState.VIEW);
                SysUtil.abort();
            }
        }
    }

    public String getCcOprtState() {
        return this.ccOprtState;
    }

    public FullOrgUnitInfo getCcOrgUnitInfo() {
        return this.ccOrgUnitInfo;
    }

    @Override
    protected void prmtBgScheme_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgScheme_dataChanged(e);
        Object obj = this.prmtBgScheme.getData();
        if (obj != null && obj instanceof BgSchemeInfo) {
            BgSchemeInfo _bgSchemeInfo = (BgSchemeInfo)this.prmtBgScheme.getData();
            this.initTemplateFormBgScheme(_bgSchemeInfo);
            BgPeriodDialog dialog = null;
            if (this.prmtBgPeriod.getSelector() != null) {
                dialog = (BgPeriodDialog)this.prmtBgPeriod.getSelector();
                dialog.close();
            }
            dialog = new BgPeriodDialog((CoreUIObject)this);
            dialog.setBgPeriodBeginDate(_bgSchemeInfo.getDateFrom());
            dialog.setBgPeriodEndDate(_bgSchemeInfo.getDateTo());
            this.prmtBgPeriod.setSelector((KDPromptSelector)dialog);
            if (OprtState.ADDNEW.equals(this.getCcOprtState())) {
                this.prmtBgPeriod.setValue((Object)BgPeriodHelper.getNextPeriodOfDate((int)_bgSchemeInfo.getPeriod().getValue(), (Date)_bgSchemeInfo.getDateFrom(), (Date)_bgSchemeInfo.getDateTo(), null));
            }
        } else {
            this.prmtBgScheme.setData(null);
            this.comBgTemplate.removeAllItems();
        }
    }

    protected void initTemplateFormBgScheme(BgSchemeInfo bgSchemeInfo) throws Exception {
        this.comBgTemplate.removeAllItems();
        BgTemplateCollection bgTemplateColl = null;
        try {
            bgTemplateColl = this.getBgTemplateOfBgScheme(bgSchemeInfo.getId(), this.ccOrgUnitInfo.getId().toString());
            if (OprtState.ADDNEW.equals(this.getCcOprtState())) {
                for (int i = bgTemplateColl.size() - 1; i >= 0; --i) {
                    if (this.checkBgTemplateType(bgTemplateColl.get(i).getFormType().getValue())) continue;
                    bgTemplateColl.removeObject(i);
                }
            }
            if (bgTemplateColl != null && !bgTemplateColl.isEmpty()) {
                this.comBgTemplate.addItems(bgTemplateColl.toArray());
            }
            if (!OprtState.ADDNEW.equals(this.getCcOprtState()) && this.editData.getBgTemplate() != null) {
                BgNFCHelper.setSelectObject(this.comBgTemplate, this.editData.getBgTemplate());
            }
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (EASBizException ex) {
            throw ex;
        }
    }

    protected boolean checkBgTemplateType(int bgTemplateFormType) {
        return 1 == bgTemplateFormType || 0 == bgTemplateFormType || 2 == bgTemplateFormType;
    }

    protected BgTemplateCollection getBgTemplateOfBgScheme(BOSUuid bgSchemeId, String orgId) throws Exception {
        return this.getNFacadeInterface().getBgTemplateInfo(bgSchemeId, orgId);
    }

    @Override
    protected void comBgTemplate_actionPerformed(ActionEvent e) throws Exception {
        super.comBgTemplate_actionPerformed(e);
        Object obj = this.comBgTemplate.getSelectedItem();
        if (obj != null && obj instanceof BgTemplateInfo) {
            BgTemplateInfo _bgTemplateInfo = (BgTemplateInfo)this.comBgTemplate.getSelectedItem();
            _bgTemplateInfo = this.getBgTemplateInfo(_bgTemplateInfo.getId(), false, true);
            this.prmtBgType.setData((Object)_bgTemplateInfo.getBgType());
            BgNFCHelper.setSelectObject(this.comMeasureUnit, _bgTemplateInfo.getDefaultMeasureUnit());
            this.initMeasureUnitInfo(_bgTemplateInfo);
            this.updateBgFormName();
        }
    }

    protected BgTemplateInfo getBgTemplateInfo(BOSUuid bgTemplateId, boolean hasLoadData, boolean hasExpandData) throws Exception {
        if (hasExpandData) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("name");
            sic.add("number");
            sic.add("data");
            sic.add("lastUpdateTime");
            sic.add("bgType.id");
            sic.add("bgType.name");
            sic.add("bgType.number");
            sic.add("bgMeasureUnit.bgElement.id");
            sic.add("bgMeasureUnit.measureUnit.*");
            sic.add("defaultMeasureUnit.id");
            sic.add("defaultMeasureUnit.*");
            sic.add("formType");
            return this.getBgTemplateInterface().getBgTemplateInfo((IObjectPK)new ObjectUuidPK(bgTemplateId), sic);
        }
        return this.getNFacadeInterface().getBgTemplateInfo(bgTemplateId, hasLoadData);
    }

    protected void initMeasureUnitInfo(BgTemplateInfo bgTemplateInfo) throws Exception {
        IRow row = null;
        BgElementInfo bgElementInfo = null;
        BgTemMeasureUnitInfo measure2 = null;
        if (bgTemplateInfo.getBgMeasureUnit() == null || bgTemplateInfo.getBgMeasureUnit().isEmpty()) {
            int rowCount = this.tblMeasureUnit.getRowCount();
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                row = this.tblMeasureUnit.getRow(rowIndex);
                row.getCell(4).setValue(null);
            }
        } else {
            HashMap<BOSUuid, MeasureUnitInfo> bgElementMuMap = new HashMap<BOSUuid, MeasureUnitInfo>();
            for (BgTemMeasureUnitInfo measure2 : bgTemplateInfo.getBgMeasureUnit()) {
                bgElementMuMap.put(measure2.getBgElement().getId(), measure2.getMeasureUnit());
            }
            int rowCount = this.tblMeasureUnit.getRowCount();
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                row = this.tblMeasureUnit.getRow(rowIndex);
                bgElementInfo = (BgElementInfo)row.getUserObject();
                if (bgElementMuMap.containsKey(bgElementInfo.getId())) {
                    row.getCell(4).setValue(bgElementMuMap.get(bgElementInfo.getId()));
                    continue;
                }
                row.getCell(4).setValue(null);
            }
        }
    }

    protected void loadMeasureUnitInfo(BgFormInfo bgFormInfo) throws Exception {
        IRow row = null;
        BgElementInfo bgElementInfo = null;
        BgMeasureUnitInfo measure2 = null;
        if (bgFormInfo.getBgMeasureUnit() == null || bgFormInfo.getBgMeasureUnit().isEmpty()) {
            int rowCount = this.tblMeasureUnit.getRowCount();
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                row = this.tblMeasureUnit.getRow(rowIndex);
                row.getCell(4).setValue(null);
            }
        } else {
            HashMap<BOSUuid, MeasureUnitInfo> bgElementMuMap = new HashMap<BOSUuid, MeasureUnitInfo>();
            for (BgMeasureUnitInfo measure2 : bgFormInfo.getBgMeasureUnit()) {
                bgElementMuMap.put(measure2.getBgElement().getId(), measure2.getMeasureUnit());
            }
            int rowCount = this.tblMeasureUnit.getRowCount();
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                row = this.tblMeasureUnit.getRow(rowIndex);
                bgElementInfo = (BgElementInfo)row.getUserObject();
                if (bgElementMuMap.containsKey(bgElementInfo.getId())) {
                    row.getCell(4).setValue(bgElementMuMap.get(bgElementInfo.getId()));
                    continue;
                }
                row.getCell(4).setValue(null);
            }
        }
    }

    protected CompanyOrgUnitInfo getCompanyFromOrgUnit(OrgUnitInfo orgUnitInfo) throws Exception {
        if (orgUnitInfo.isIsCompanyOrgUnit()) {
            return (CompanyOrgUnitInfo)orgUnitInfo.cast(CompanyOrgUnitInfo.class);
        }
        OrgUnitInfo parent = this.getOrgFacadeInterface().getParent(orgUnitInfo.getId().toString(), OrgViewType.COSTCENTER);
        if (parent != null) {
            return this.getCompanyFromOrgUnit(parent);
        }
        return null;
    }

    @Override
    protected void prmtBgPeriod_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgPeriod_dataChanged(e);
        Object obj = this.prmtBgPeriod.getData();
        if (obj != null && obj instanceof BgPeriodInfo) {
            this.updateBgFormName();
        }
    }

    protected void updateBgFormName() {
        if (OprtState.ADDNEW.equals(this.getCcOprtState()) && this.checkCreateName() && this.txtName.isEnabled()) {
            this.txtName.setText(this.getBgFormName());
        }
    }

    protected boolean checkCreateName() {
        return this.comBgTemplate.getSelectedItem() != null && this.comBgTemplate.getSelectedItem() instanceof BgTemplateInfo && this.prmtBgPeriod.getData() != null && this.prmtBgPeriod.getData() instanceof BgPeriodInfo && this.editData.getCU() != null;
    }

    protected String getBgFormName() {
        String bgFormName = null;
        BgTemplateInfo bgTemplateInfo = (BgTemplateInfo)this.comBgTemplate.getSelectedItem();
        BgPeriodInfo bgPeriodInfo = (BgPeriodInfo)this.prmtBgPeriod.getData();
        bgFormName = this.editData.getCU().getId().equals((Object)this.getCcOrgUnitInfo().getId()) ? new StringBuffer(this.editData.getCU().getName()).append("-").append(bgPeriodInfo.getName()).append("-").append(bgTemplateInfo.getName()).toString().trim() : new StringBuffer(this.editData.getCU().getName()).append("-").append(this.getCcOrgUnitInfo().getName()).append("-").append(bgPeriodInfo.getName()).append("-").append(bgTemplateInfo.getName()).toString().trim();
        return bgFormName.length() > this.txtName.getMaxLength() ? bgFormName.substring(1, this.txtName.getMaxLength()) : bgFormName;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("measureUnit.id");
        sic.add("measureUnit.name");
        sic.add("measureUnit.number");
        sic.add("measureUnit.coefficient");
        sic.add("bgMeasureUnit.id");
        sic.add("bgMeasureUnit.bgElement.id");
        sic.add("bgMeasureUnit.bgElement.name");
        sic.add("bgMeasureUnit.bgElement.number");
        sic.add("bgMeasureUnit.measureUnit.id");
        sic.add("bgMeasureUnit.measureUnit.name");
        sic.add("bgMeasureUnit.measureUnit.number");
        sic.add("bgMeasureUnit.measureUnit.coefficient");
        sic.add("bgTemplate.formType");
        return sic;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        if (handler != null) {
            RequestContext request = (RequestContext)handler.getRequestContext();
            this.ccOrgUnitInfo = (FullOrgUnitInfo)this.getUIContext().get("ORGUNIT_INFO");
            request.put("ORGUNIT_INFO", (Object)this.ccOrgUnitInfo);
            request.put("USER_ID", (Object)this.getUserPk().toString());
        }
        return handler;
    }

    public boolean isPrepareDestoryWindow() {
        return true;
    }
}

