/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.ma.budget.BgFormCollection;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgGatherHelper;
import com.kingdee.eas.ma.nbudget.client.AbstractBgNFAfterBatchGatherUI;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgNFAfterBatchGatherUI
extends AbstractBgNFAfterBatchGatherUI {
    private static final Logger logger = CoreUIObject.getLogger(BgNFAfterBatchGatherUI.class);

    public void onShow() throws Exception {
        super.onShow();
        this.initTable();
    }

    protected void initTable() throws BOSException, ParserException {
        HashMap mapInfo = (HashMap)this.getUIContext().get("listInfo");
        Set orgUnits = (Set)this.getUIContext().get("GATHER_ORGUNIT");
        BgFormCollection bgForms = (BgFormCollection)this.getUIContext().get("GATHER_BGFORM");
        if (mapInfo == null || mapInfo.size() == 0 || orgUnits == null || orgUnits.size() == 0 || bgForms == null || bgForms.size() == 0) {
            return;
        }
        this.kDTable1.getMergeManager().setMergeMode(5);
        SelectorItemCollection selector = BgGatherHelper.getSimpleSelectors();
        EntityViewInfo view = new EntityViewInfo("order by number");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)orgUnits, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(selector);
        FullOrgUnitCollection orgColl = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitCollection(view);
        for (int i = 0; i < bgForms.size(); ++i) {
            BgFormInfo bgForm = bgForms.get(i);
            String bgFormId = bgForm.getId().toString();
            if (!mapInfo.containsKey(bgFormId)) continue;
            Map gatherCantOrgMap = (Map)((Map)mapInfo.get(bgFormId)).get("GATHER_CHECK_CANT_ORGUNIT");
            for (int j = 0; j < orgColl.size(); ++j) {
                FullOrgUnitInfo org = orgColl.get(j);
                String orgId = org.getId().toString();
                if (!gatherCantOrgMap.containsKey(orgId)) continue;
                IRow iRow = this.kDTable1.addRow();
                iRow.getCell(0).setValue((Object)bgForm.getNumber());
                iRow.getCell(1).setValue((Object)bgForm.getName());
                iRow.getCell(2).setValue((Object)org.getNumber());
                iRow.getCell(3).setValue((Object)org.getName());
            }
        }
        this.kDTable1.getMergeManager().setMergeMode(1);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnOk.setEnabled(true);
        this.btnOk.setVisible(true);
        this.actionOk.setEnabled(true);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnOk.setEnabled(true);
        this.btnOk.setVisible(true);
        this.actionOk.setEnabled(true);
    }

    @Override
    public void actionOk_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }
}

