/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.ZipUtil;
import com.kingdee.bos.ctrl.excel.impl.ToolBarManager;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.newrpt.client.designer.IMenuStrategy;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgFormHelper;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgFormStateEnum;
import com.kingdee.eas.ma.budget.client.BgAdjustViewUI;
import com.kingdee.eas.ma.budget.client.BgFormAuditIdeaEditUI;
import com.kingdee.eas.ma.budget.client.BgItemImportByBaseUI;
import com.kingdee.eas.ma.budget.client.LongTimeDialog;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNFormException;
import com.kingdee.eas.ma.nbudget.BudgetProvider;
import com.kingdee.eas.ma.nbudget.IBgNData;
import com.kingdee.eas.ma.nbudget.client.AbstractBgNFormAuditProcessUI;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.ma.nbudget.client.BgParamCHelper;
import com.kingdee.eas.ma.nbudget.client.BudgetAuditMenuManager;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class BgNFormAuditProcessUI
extends AbstractBgNFormAuditProcessUI {
    private static final long serialVersionUID = 4440968881592311791L;
    private static final Logger logger = CoreUIObject.getLogger(BgNFormAuditProcessUI.class);
    private String xNum = null;
    private BOSUuid[] uuids = null;

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        String strKey = null;
        KeyStroke ks = null;
        strKey = "CTRL_I";
        ks = KeyStroke.getKeyStroke(73, 128, false);
        this.getActionMap().put(strKey, (Action)this.actionImport);
        this.getInputMap(2).put(ks, strKey);
        strKey = "CTRL_U";
        ks = KeyStroke.getKeyStroke(85, 128, false);
        this.getActionMap().put(strKey, (Action)((Object)this.actionAntiAudit));
        this.getInputMap(2).put(ks, strKey);
        strKey = "SHIFT_F3";
        ks = KeyStroke.getKeyStroke(114, 64, false);
        this.getActionMap().put(strKey, (Action)this.actionAttachement);
        this.getInputMap(2).put(ks, strKey);
        strKey = "CTRL_SHIFT_O";
        ks = KeyStroke.getKeyStroke(79, 192, false);
        this.getActionMap().put(strKey, (Action)((Object)this.actionGather));
        this.getInputMap(2).put(ks, strKey);
    }

    @Override
    public void onShow() {
        super.onShow();
        this.setUITitle(BgNFCHelper.getMessageStr("Title") + " - " + BgNFCHelper.getMessageStr("AUDIT") + " - " + this.getBookProvider().getEditValue().get("name").toString());
        this.actionItemInput.setVisible(false);
        this.actionItemInput.setEnabled(false);
    }

    @Override
    public IMenuStrategy getBudgetMenuStrategy() {
        return new BudgetAuditMenuManager((Component)((Object)this));
    }

    protected void releaseNetControl() {
        Object _obj;
        if (!OprtState.ADDNEW.equals(this.getOprtState()) && this.getUIContext() != null && (_obj = this.getUIContext().get("BGFORM_AUDIT_TYPE")) != null && (_obj.equals("BGFORM_AUDIT") || _obj.equals("BGFORM_ANTIAUDIT"))) {
            super.releaseNetControl();
        }
    }

    @Override
    protected boolean checkBeforeWindowClosing() {
        boolean bclose = super.checkBeforeWindowClosing();
        this.releaseNetControl();
        return bclose;
    }

    @Override
    protected void initSystemOtherInfo() throws Exception {
        super.initSystemOtherInfo();
        Object obj = this.getUIContext().get("BGFORM_AUDIT_TYPE");
        if (obj != null) {
            if ("BGFORM_AUDIT".equals(obj)) {
                this.actionAudit.setEnabled(true);
            } else if ("BGFORM_ANTIAUDIT".equals(obj)) {
                this.actionAntiAudit.setEnabled(true);
            } else {
                this.actionAudit.setEnabled(false);
                this.actionAntiAudit.setEnabled(false);
            }
        }
    }

    @Override
    protected void initToolbarAction() {
        ToolBarManager toolBarManager = this.getSpreadManager().getSpreadContainer().getToolBarManager();
        this.actionAntiAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_unaudit"));
        toolBarManager.addFirstGroupItem((Action)((Object)this.actionAntiAudit), "common");
        this.actionAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_audit"));
        toolBarManager.addFirstGroupItem((Action)((Object)this.actionAudit), "common");
        this.actionViewAdjust.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_view"));
        this.actionViewAdjust.putValue("ShortDescription", EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"adjustRecord"));
        toolBarManager.addLastGroupItem((Action)((Object)this.actionViewAdjust), "common");
        this.actionBgExamineCheck.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_examinecheck"));
        toolBarManager.addLastGroupItem((Action)((Object)this.actionBgExamineCheck), "common");
        if (BgItemImportByBaseUI.hasFDCSubSystem()) {
            this.actionQueryBizBill.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_seechecklist"));
            toolBarManager.addLastGroupItem((Action)((Object)this.actionQueryBizBill), "common");
            this.actionQueryBizBill.setVisible(true);
            this.actionQueryBizBill.setEnabled(true);
            this.menuItemQueryBizBill.setVisible(true);
            this.menuItemQueryBizBill.setEnabled(true);
        } else {
            this.actionQueryBizBill.setVisible(false);
            this.actionQueryBizBill.setEnabled(false);
            this.menuItemQueryBizBill.setVisible(false);
            this.menuItemQueryBizBill.setEnabled(false);
        }
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.menuItemBgAudit.setIcon(EASResource.getIcon((String)"imgTbtn_audit"));
        this.menuItemBgAntiAudit.setIcon(EASResource.getIcon((String)"imgTbtn_unaudit"));
    }

    @Override
    protected void showAllBook() throws Exception {
        super.showAllBook();
    }

    @Override
    protected void fillCellValue(Cell cell, IBgNData data) {
        if (cell != null && data != null) {
            if (data.getAdjustValue() != null) {
                BgNFSHelper.setValue(cell, data.getAdjustValue());
            } else {
                BgNFSHelper.setValue(cell, data.getBudgetValue());
            }
        }
    }

    @Override
    protected void beforeLockedAndProtection() {
        BgNFSHelper.setBookLANDP(this.getBook(), true, null, BgNFSHelper.getOnlySelectCellOperation());
    }

    @Override
    protected void setBookTypeSign() {
    }

    @Override
    protected void afterLockedAndProtection() {
        BgNFSHelper.setBookLANDP(this.getBook(), true, null, BgNFSHelper.getOnlySelectCellOperation());
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionAudit_actionPerformed(e);
        String billId = this.getBillId();
        BOSUuid bgFormId = BOSUuid.read((String)billId);
        if (BgFormHelper.checkInProInst((String)billId)) {
            throw new BgNFormException(BgNFormException.CANTAUDITBYINPOST);
        }
        this.getNFacadeInterface().checkCanAudit(bgFormId);
        int re = MsgBox.showConfirm2((String)(this.getMessageStr("com.kingdee.eas.ma.budget.client.BgAuditIdeaResource", "auditIdea") + ((BgFormInfo)this.getEditData()).getName() + this.getMessageStr("com.kingdee.eas.ma.budget.client.BgAuditIdeaResource", "bgForm")));
        if (re == 1 || re == 2) {
            return;
        }
        if (BgParamCHelper.isCompulsionReportCheck()) {
            if (!this.isCheckReportPass(null, false)) {
                this.setSheetCheck(false);
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"cantAuditOfCheck"));
                SysUtil.abort();
            } else {
                this.setSheetCheck(true);
            }
        } else {
            this.setSheetCheck(true);
        }
        this.uuids = this.getBgFormInfo().getState().equals((Object)BgFormStateEnum.Adjusted) ? new BOSUuid[]{this.getBgFormInfo().getAdjust().getId()} : new BOSUuid[]{this.getReportId()};
        IUIWindow uiWindow = null;
        if (this.getExamineInterface().canExamine(this.uuids)) {
            this.xNum = BgNFCHelper.returnExamineX(this.uuids, this);
            LongTimeDialog dialog = null;
            Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
            if (win instanceof Frame) {
                dialog = new LongTimeDialog((Frame)win);
            } else if (win instanceof Dialog) {
                dialog = new LongTimeDialog((Dialog)win);
            }
            if (dialog == null) {
                return;
            }
            dialog.setLongTimeTask(new ILongTimeTask(){

                public Object exec() throws Exception {
                    Object[] result = BgNFormAuditProcessUI.this.getExamineInterface().examines(BgNFormAuditProcessUI.this.uuids, BgNFormAuditProcessUI.this.xNum);
                    HashMap<String, Object> bgExamineCheckMap = new HashMap<String, Object>();
                    bgExamineCheckMap.put("BgExamineChecked", result[0]);
                    bgExamineCheckMap.put("BgExamineCheckResult", result[1]);
                    return bgExamineCheckMap;
                }

                public void afterExec(Object result) throws Exception {
                    if (result != null && result instanceof HashMap) {
                        BgNFormAuditProcessUI.this.openBgExamineViewUI(result);
                        Map bgExamineCheckMap = (Map)result;
                        Boolean bgExCheck = (Boolean)bgExamineCheckMap.get("BgExamineChecked");
                        if (bgExCheck.booleanValue()) {
                            BgNFormAuditProcessUI.this.setBgExmaineCheck(true);
                        } else {
                            BgNFormAuditProcessUI.this.setBgExmaineCheck(false);
                        }
                    } else {
                        MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineCheckResource", (String)"error"));
                    }
                }
            });
            dialog.show();
            if (this.isSheetCheck() && this.isBgExmaineCheck()) {
                UIContext uiContext = new UIContext((Object)dialog);
                uiContext.put((Object)"BGFORM_PROCESSUI", (Object)this);
                uiContext.put((Object)"BGFORM_AUDIT_TYPE", (Object)"BGFORM_AUDIT");
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgFormAuditIdeaEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
                uiWindow.show();
            } else {
                MsgBox.showInfo((String)this.getMessageStr("com.kingdee.eas.ma.budget.client.BgExamineCheckResource", "cantAudit"));
            }
        } else if (this.isSheetCheck()) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"BGFORM_PROCESSUI", (Object)this);
            uiContext.put((Object)"BGFORM_AUDIT_TYPE", (Object)"BGFORM_AUDIT");
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgFormAuditIdeaEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
        } else {
            MsgBox.showInfo((String)this.getMessageStr("com.kingdee.eas.ma.budget.client.BgExamineCheckResource", "cantAudit"));
        }
        if (uiWindow != null && uiWindow.getUIObject() instanceof BgFormAuditIdeaEditUI && !((BgFormAuditIdeaEditUI)uiWindow.getUIObject()).isCancel()) {
            this.getUIWindow().close();
        }
    }

    @Override
    public void actionBgExamineCheck_actionPerformed(ActionEvent e) throws Exception {
        if (!OprtState.VIEW.equals(this.getOprtState()) && (this.getBook().getUndoManager().canUndo() || OprtState.ADDNEW.equals(this.getOprtState()))) {
            this.actionSave_actionPerformed(e);
        }
        this.uuids = this.getBgFormInfo().getState().equals((Object)BgFormStateEnum.Adjusted) ? new BOSUuid[]{this.getBgFormInfo().getAdjust().getId()} : new BOSUuid[]{this.getReportId()};
        if (this.getExamineInterface().canExamine(this.uuids)) {
            this.xNum = BgNFCHelper.returnExamineX(this.uuids, this);
            Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
            LongTimeDialog dialog = null;
            if (win instanceof Frame) {
                dialog = new LongTimeDialog((Frame)win);
            } else if (win instanceof Dialog) {
                dialog = new LongTimeDialog((Dialog)win);
            }
            if (dialog == null) {
                return;
            }
            dialog.setLongTimeTask(new ILongTimeTask(){

                public Object exec() throws Exception {
                    Object[] result = BgNFormAuditProcessUI.this.getExamineInterface().examines(BgNFormAuditProcessUI.this.uuids, BgNFormAuditProcessUI.this.xNum);
                    HashMap<String, Object> bgExamineCheckMap = new HashMap<String, Object>();
                    bgExamineCheckMap.put("BgExamineChecked", result[0]);
                    bgExamineCheckMap.put("BgExamineCheckResult", result[1]);
                    return bgExamineCheckMap;
                }

                public void afterExec(Object result) throws Exception {
                    if (result != null && result instanceof HashMap) {
                        BgNFormAuditProcessUI.this.openBgExamineViewUI(result);
                    } else {
                        MsgBox.showWarning((String)BgNFormAuditProcessUI.this.getMessageStr("com.kingdee.eas.ma.budget.client.BgExamineCheckResource", "error"));
                    }
                }
            });
            dialog.show();
        } else {
            MsgBox.showInfo((String)this.getMessageStr("com.kingdee.eas.ma.budget.client.BgExamineCheckResource", "cantCheckBgExamine"));
        }
    }

    @Override
    public void actionAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionAntiAudit_actionPerformed(e);
        String billId = this.getBillId();
        BOSUuid bgFormId = BOSUuid.read((String)billId);
        if (BgFormHelper.checkInProInst((String)billId)) {
            throw new BgNFormException(BgNFormException.CANTANTIAUDITBYINPOST);
        }
        this.getNFacadeInterface().checkCanAntiAudit(bgFormId);
        int re = MsgBox.showConfirm2((String)(this.getMessageStr("com.kingdee.eas.ma.budget.client.BgAuditIdeaResource", "unAuditIdea") + ((BgFormInfo)this.getEditData()).getName() + this.getMessageStr("com.kingdee.eas.ma.budget.client.BgAuditIdeaResource", "bgForm")));
        if (re == 1 || re == 2) {
            return;
        }
        try {
            UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
            if (((BudgetProvider)this.getBookProvider()).antiAudit(bgFormId, userInfo.getId(), null)) {
                MsgBox.showInfo((Component)((Object)this), (String)(((BgFormInfo)this.getEditData()).getName() + this.getMessageStr("com.kingdee.eas.ma.budget.client.BgAuditIdeaResource", "noPass")));
            }
        }
        catch (BOSException ex) {
            throw new BgFormException(BgFormException.SAVEERROR);
        }
        this.getUIWindow().close();
    }

    @Override
    protected void init() throws Exception {
        super.init();
        if (this.getBgFormInfo() != null && BgNFSHelper.checkHasAdjust((IObjectValue)this.getBgFormInfo())) {
            this.loadDiversityInfo();
        }
    }

    protected void loadDiversityInfo() throws Exception {
        if (this.getEditData() != null) {
            byte[] data = ((BgFormInfo)this.getEditData()).getAdjustMapData();
            if (data == null || data.length == 0) {
                this.setAdjustMap(new HashMap());
            } else {
                InputStream is = ZipUtil.unpack((byte[])data);
                ObjectInputStream ois = new ObjectInputStream(is);
                this.setAdjustMap((HashMap)ois.readObject());
                is.close();
                ois.close();
                if (this.getAdjustMap() == null) {
                    throw new BgFormException(BgFormException.LOADDIVERSITYERROR);
                }
            }
        } else {
            throw new BgFormException(BgFormException.NOBGFORMINFO);
        }
    }

    @Override
    public void actionViewAdjust_actionPerformed(ActionEvent e) throws Exception {
        BgFormInfo info = this.getBgFormInfo();
        if (info == null || info.getId() == null) {
            return;
        }
        if (BgNFSHelper.checkHasAdjust((IObjectValue)info)) {
            String formulaString = null;
            Cell cell = this.getBook().getActiveSheet().getActiveCell();
            if (BgNFSHelper.checkHasFormulaOfCell(cell)) {
                formulaString = BgNFSHelper.getFormulaOfCell(cell);
            }
            BgFormInfo _bgFormInfo = (BgFormInfo)this.getEditData();
            UIContext uiContext = new UIContext((Object)this);
            if (((BgFormInfo)this.getEditData()).getState().getValue() == 2 && formulaString != null && formulaString.trim().length() > 0) {
                uiContext.put((Object)"formulaRecord", (Object)formulaString);
                uiContext.put((Object)"formulaFormId", (Object)this.getReportId());
                uiContext.put((Object)"formulaOrgUnit", (Object)_bgFormInfo.getOrgUnit().getId());
                uiContext.put((Object)"formulaScheme", (Object)_bgFormInfo.getBgScheme().getId());
            } else if (_bgFormInfo.getState().getValue() == 4 || _bgFormInfo.getState().getValue() == 35) {
                uiContext.put((Object)"bgFormAdjust", (Object)this.getAdjustMap());
                uiContext.put((Object)"formulaRecord", (Object)formulaString);
            } else if (_bgFormInfo.getState().getValue() == 2) {
                uiContext.put((Object)"bgFormPastRecord", (Object)this.getBillId());
            }
            uiContext.put((Object)"states", (Object)this.menuItemSave.isEnabled());
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgAdjustViewUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        } else {
            super.actionViewAdjust_actionPerformed(e);
        }
    }

    @Override
    public boolean destroyWindow() {
        this.getSpreadManager().getModifyManager().discardAllEdits();
        return super.destroyWindow();
    }

    @Override
    protected String getHideUnHidePermItem() {
        return "bg_formAudit05_hide_unhide";
    }

    @Override
    public void actionCalculate_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    public void actionCalculateSelectedSheet_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    protected synchronized void Calculate() {
    }
}

