/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.client.servicebinding.ActionProxyFactory;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.core.ICellDisplayProvider;
import com.kingdee.bos.ctrl.excel.core.ICellEditorProvider;
import com.kingdee.bos.ctrl.excel.impl.ActionManager;
import com.kingdee.bos.ctrl.excel.impl.FacadeManager;
import com.kingdee.bos.ctrl.excel.impl.PopMenuManager;
import com.kingdee.bos.ctrl.excel.impl.ToolBarManager;
import com.kingdee.bos.ctrl.excel.impl.action.NotifyEvent;
import com.kingdee.bos.ctrl.excel.impl.action.NotifyListener;
import com.kingdee.bos.ctrl.excel.impl.action.SpreadAction;
import com.kingdee.bos.ctrl.excel.impl.facade.editor.ICellEditor;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeListener;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeListener;
import com.kingdee.bos.ctrl.swing.KDToggleButton;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.newrpt.client.designer.CalculateOptionUI;
import com.kingdee.eas.fi.newrpt.client.designer.IBookProvider;
import com.kingdee.eas.fi.newrpt.client.designer.IItemFormulaProvider;
import com.kingdee.eas.fi.newrpt.client.designer.IMenuStrategy;
import com.kingdee.eas.fi.newrpt.client.designer.render.IRenderProvider;
import com.kingdee.eas.fi.newrpt.designer.IReportVariableProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.util.BookProperties;
import com.kingdee.eas.fi.rpt.util.VariableEntry;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.client.UIActionPostman;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.BgItemCollection;
import com.kingdee.eas.ma.budget.BgItemFactory;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.BgPermissionFactory;
import com.kingdee.eas.ma.budget.BgRptReportPropertyAdapter;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.client.BgEnumerateRender;
import com.kingdee.eas.ma.budget.client.BgOrgBasedListUI;
import com.kingdee.eas.ma.nbudget.BgItemShowLevelEnum;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNTemplateHelper;
import com.kingdee.eas.ma.nbudget.BgPermissionHelper;
import com.kingdee.eas.ma.nbudget.BudgetVariableProvider;
import com.kingdee.eas.ma.nbudget.SheetInfo;
import com.kingdee.eas.ma.nbudget.client.AbstractBgNProcessUI;
import com.kingdee.eas.ma.nbudget.client.BgCommentEditUI;
import com.kingdee.eas.ma.nbudget.client.BgNCHelper;
import com.kingdee.eas.ma.nbudget.client.BgParamCHelper;
import com.kingdee.eas.ma.nbudget.client.BgUserCellDisplayProvider;
import com.kingdee.eas.ma.nbudget.client.BgViewCellUI;
import com.kingdee.eas.ma.nbudget.client.IGetFormula;
import com.kingdee.eas.ma.nbudget.client.IToolbarStrategy;
import com.kingdee.eas.ma.nbudget.client.UserItemRenderProvider;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public abstract class BgNProcessUI
extends AbstractBgNProcessUI
implements IGetFormula {
    private static final long serialVersionUID = -9004791436474733173L;
    private static final Logger logger = CoreUIObject.getLogger(BgNProcessUI.class);
    private boolean isSelectItem = false;
    private OrgUnitInfo ccOrgUnitInfo = null;
    private List SYSTEMINFO_DATA = null;
    private Map formulaMap = null;
    private Component component = null;
    private IToolbarStrategy toolbarStrategy = null;
    private ICellEditor editor = null;
    private boolean isEnumerate = false;
    private boolean isScript = false;
    private boolean isCalculateTag = false;
    private boolean isFirstOnload = false;

    public BgNProcessUI() throws Exception {
        this.setMenuStrategy(this.getBudgetMenuStrategy());
        this.setToolbarStrategy(this.getBudgetToolbarStrategy());
        this.setBookProvider(this.getBudgetProvider());
        this.setVariableProvider(this.getBudgetVariableProvider());
        this.setPropertyAdapter(this.getBudgetPropertyAdapter());
    }

    public void onLoad() throws Exception {
        this.initSystemInfo();
        Object obj = this.getUIContext().get("ORGUNIT_INFO");
        if (obj != null && obj instanceof OrgUnitInfo) {
            this.setOrgUnitInfo((OrgUnitInfo)obj);
        }
        super.onLoad();
        BookProperties p = this.getBookProperties();
        IUIWindow ui = CalculateOptionUI.createUI((Object)this);
        CalculateOptionUI option = (CalculateOptionUI)ui.getUIObject();
        option.setErrorProvider(p.getErrorProvider());
        VariableEntry entry = p.getVariables().get("autoCalculateState", this.getBook().getName());
        boolean isAuto = entry == null ? false : Boolean.valueOf(entry.getValue());
        this.setCalculateTag(isAuto);
        this.autoCalculate(this.getBook());
        this.init();
        this.getSpreadManager().getSpreadContainer().addBookChangeListener(new BookChangeListener(){

            public void changed(BookChangeEvent e) {
                if (e.isSheetDeactive()) {
                    BgNProcessUI.this.onSheetDeactive(e.getSheet());
                }
            }
        });
        this.itemShowLevelComboBox.setVisible(true);
        this.itemShowLevelComboBox.setEnabled(true);
        this.isFirstOnload = true;
        this.itemShowLevelComboBox.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.ma.nbudget.BgItemShowLevelEnum").toArray());
        this.menuTool.remove((JMenuItem)this.menuReportRound);
        this.toolBar.remove((Component)this.btnBalance);
    }

    protected void initToolbar() {
        super.initToolbar();
        ToolBarManager toolBarManager = this.getSpreadManager().getSpreadContainer().getToolBarManager();
        toolBarManager.addLastGroupItem((Component)this.itemShowLevelComboBox, "common");
    }

    @Override
    public void actionShowLevel_actionPerformed(ActionEvent e) throws Exception {
        if (this.isFirstOnload) {
            this.isFirstOnload = false;
            return;
        }
        Sheet _sheet = this.getBook().getActiveSheet();
        int colIndex = _sheet.getActiveCol();
        Cell cell = _sheet.getActiveCell();
        Cell _cell = null;
        BgItemShowLevelEnum levelEnum = (BgItemShowLevelEnum)((Object)this.itemShowLevelComboBox.getSelectedItem());
        if (levelEnum != null && levelEnum.getValue() == 100) {
            Sheet sheet = this.getBook().getActiveSheet();
            for (int rowIndex = 0; rowIndex <= sheet.getMaxRowIndex(); ++rowIndex) {
                sheet.getRowRange(rowIndex, rowIndex).setHidden(false, true);
            }
            this.getSpreadManager().getSpreadContainer().repaint();
            return;
        }
        OrgUnitInfo cco = SysContext.getSysContext().getCurrentOrgUnit();
        String[] info = BgNFSHelper.getBgItemInfo(cell);
        if (info != null) {
            String number = info[1];
            String sql = "select LongNumber, level where number = '" + number + "' and orgunit.id = '" + cco.getId().toString() + "'";
            BgItemInfo bgItemInfo = BgItemFactory.getRemoteInstance().getBgItemInfo(sql);
            String longNumber = bgItemInfo.getLongNumber();
            int level = bgItemInfo.getLevel();
            sql = "select number,level where LongNumber like '" + longNumber + "!%' ";
            BgItemCollection collection = BgItemFactory.getRemoteInstance().getBgItemCollection(sql);
            HashMap<String, Integer> levelMap = new HashMap<String, Integer>();
            for (int i = 0; i < collection.size(); ++i) {
                levelMap.put(collection.get(i).getNumber(), new Integer(collection.get(i).getLevel()));
            }
            int maxRow = _sheet.getMaxRowIndex();
            int lev = 0;
            int firstRow = 0;
            CellBlock merge = cell.getMerge(true);
            firstRow = merge != null ? merge.getRow2() : _sheet.getActiveRow();
            int rowIndex = firstRow + 1;
            while (rowIndex <= maxRow) {
                _cell = _sheet.getCell(rowIndex, colIndex, false);
                if (_cell == null) {
                    ++rowIndex;
                    continue;
                }
                String[] itemInfo = BgNFSHelper.getBgItemInfo(_cell);
                if (itemInfo != null && levelMap.containsKey(itemInfo[1])) {
                    merge = _cell.getMerge(true);
                    lev = (Integer)levelMap.get(itemInfo[1]);
                    if (merge != null) {
                        int row = merge.getRow();
                        int row2 = merge.getRow2();
                        if (lev <= levelEnum.getValue() + level) {
                            _cell.getSheet().getRowRange(row, row2).setHidden(false, true);
                        } else {
                            _cell.getSheet().getRowRange(row, row2).setHidden(true, true);
                        }
                        rowIndex = rowIndex + (row2 - row) + 1;
                        continue;
                    }
                    if (lev <= levelEnum.getValue() + level) {
                        _cell.getSheet().getRowRange(rowIndex, rowIndex).setHidden(false, true);
                    } else {
                        _cell.getSheet().getRowRange(rowIndex, rowIndex).setHidden(true, true);
                    }
                    ++rowIndex;
                    continue;
                }
                ++rowIndex;
            }
        }
        this.getSpreadManager().getSpreadContainer().repaint();
    }

    protected void autoCalculate(Book book) throws Exception {
        Boolean autoCalculate = null;
        try {
            autoCalculate = Boolean.valueOf(this.getVariables().get("autoCalculateState", book.getName()).getValue());
        }
        catch (Exception e) {
            autoCalculate = Boolean.FALSE;
        }
        book.setCalculate(autoCalculate.booleanValue());
    }

    public String getTemplateId() {
        return null;
    }

    protected Map addBgSheetPermission() {
        if (this.getTemplateId() == null) {
            return null;
        }
        Map hasPer = new HashMap<String, Object>();
        Map sheetPer = new HashMap();
        try {
            hasPer.put(this.getTemplateId(), null);
            hasPer = BgPermissionHelper.getBgTemplateSheetPermission(null, hasPer);
            if (hasPer != null && hasPer.get(this.getTemplateId()) != null) {
                sheetPer = (Map)hasPer.get(this.getTemplateId());
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return sheetPer;
    }

    public void onShow() {
        ToolBarManager toolBarManager = this.getSpreadManager().getSpreadContainer().getToolBarManager();
        KDToolBar toolBar = toolBarManager.getToolBar("common");
        toolBar.setIsControlByParent(false);
        toolBar.setTextIconDisStyle((short)2);
        toolBar = toolBarManager.getToolBar("style");
        toolBar.setIsControlByParent(false);
        toolBar.setTextIconDisStyle((short)2);
        super.onShow();
        if (this.getUIWindow() instanceof Dialog) {
            ((Dialog)this.getUIWindow()).setSize(Toolkit.getDefaultToolkit().getScreenSize());
        }
        this.getSpreadManager().setItemFormulaProvider(new IItemFormulaProvider(){

            public String getDisplayingItemFormula(Range range, int viewMode) {
                Object obj = range.getUserObject("ITEM");
                if (obj != null && obj instanceof ItemFormula) {
                    return BgNProcessUI.this.getShowBgFormula(((ItemFormula)obj).getFormula());
                }
                return null;
            }

            public String defaultItemFormula() {
                return "=BgItem()";
            }

            public boolean editable() {
                return BgNProcessUI.this.editableFormulaBar();
            }
        });
        boolean isHide = false;
        for (int i = this.getBook().getSheetCount() - 1; i >= 0; --i) {
            isHide = this.getBook().getSheet(i).isHide();
            this.getBook().getSheet(i).getRange(0, 0).select();
            this.getBook().getSheet(i).setHide(isHide);
        }
        this.regeditWizzardUI();
    }

    protected void regeditWizzardUI() {
        try {
            this.getSpreadManager().getSpreadContainer().getFacadeManager().putWizzard(FacadeManager.WIZZARD_Comment, (ISpreadWizzard)BgCommentEditUI.createCommentUI(this, this.getSpreadManager().getSpreadContainer()));
        }
        catch (UIException ex) {
            this.handleException((Exception)((Object)ex));
        }
    }

    protected void onSheetActive(Sheet sheet) {
        super.onSheetActive(sheet);
    }

    protected void onSheetDeactive(Sheet sheet) {
    }

    protected boolean editableFormulaBar() {
        return true;
    }

    public IMenuStrategy getBudgetMenuStrategy() {
        return null;
    }

    public void setToolbarStrategy(IToolbarStrategy toolbarStrategy) {
        this.toolbarStrategy = toolbarStrategy;
    }

    public IToolbarStrategy getToolbarStrategy() {
        return this.toolbarStrategy;
    }

    public IToolbarStrategy getBudgetToolbarStrategy() {
        return null;
    }

    public boolean isCalculateTag() {
        return this.isCalculateTag;
    }

    public void setCalculateTag(boolean isCalculateTag) {
        this.isCalculateTag = isCalculateTag;
    }

    public IBookProvider getBudgetProvider() {
        return null;
    }

    public IReportVariableProvider getBudgetVariableProvider() {
        return new BudgetVariableProvider();
    }

    public IReportPropertyAdapter getBudgetPropertyAdapter() {
        return new BgRptReportPropertyAdapter();
    }

    protected String getShowBgFormula(String formulaStr) {
        if (StringUtils.isEmpty((String)formulaStr)) {
            return null;
        }
        String[] parameter = BgNFSHelper.parseFormulaPara(this.getFormulaMap(), formulaStr);
        if (parameter != null) {
            StringBuffer _formulaStr = new StringBuffer();
            if (parameter.length == 6) {
                _formulaStr.append("=BgItem(\"" + parameter[0] + "\",\"" + parameter[1] + "\",\"" + parameter[2] + "\",\"" + parameter[5] + "\")");
                return _formulaStr.toString();
            }
            if (parameter.length == 4) {
                _formulaStr.append("=BgItem(\"" + parameter[0] + "\",\"" + parameter[1] + "\",\"" + parameter[2] + "\",\"" + parameter[3] + "\")");
                return _formulaStr.toString();
            }
        }
        return formulaStr;
    }

    protected void modified() {
        this.getSpreadManager().getModifyManager().setModified();
    }

    protected void discardModify() {
        this.getSpreadManager().getModifyManager().discardAllEdits();
    }

    protected void disabledWorkButton(KDToolBar toolBar, String name) {
        this.dealWorkButton(toolBar, name, false, false);
    }

    protected void enabledWorkButton(KDToolBar toolbar, String name) {
        this.dealWorkButton(toolbar, name, false, false);
    }

    protected void dealWorkButton(KDToolBar toolbar) {
        if (toolbar == null) {
            return;
        }
        KDWorkButton tk = null;
        Component component2 = null;
        for (Component component2 : toolbar.getComponents()) {
            String classname;
            if (!(component2 instanceof KDWorkButton) || (tk = (KDWorkButton)component2).getAction() == null) continue;
            String actionname = tk.getAction().getClass().getName();
            int index = actionname.indexOf("$");
            if (index <= 0) {
                index = actionname.lastIndexOf(".");
            }
            if (index <= 0 || !(classname = actionname.substring(0, index)).equals("com.kingdee.eas.ma.nbudget.client.AbstractBgNFProcessUI")) continue;
            try {
                tk.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)tk.getAction(), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
            }
            catch (Exception e) {
                tk.setAction(tk.getAction());
            }
        }
    }

    protected void dealWorkButton(KDToolBar toolbar, String name, boolean action, boolean visible) {
        if (toolbar == null || StringUtils.isEmpty((String)name)) {
            return;
        }
        Component component2 = null;
        for (Component component2 : toolbar.getComponents()) {
            if (!name.equalsIgnoreCase(component2.getName())) continue;
            component2.setEnabled(action);
            component2.setVisible(visible);
            break;
        }
    }

    protected void disabledToggleButton(KDToolBar toolbar, String actionName, boolean action, boolean visable) {
        if (toolbar == null || StringUtils.isEmpty((String)actionName)) {
            return;
        }
        KDToggleButton tb = null;
        Component component2 = null;
        for (Component component2 : toolbar.getComponents()) {
            if (component2 == null || !(component2 instanceof KDToggleButton) || (tb = (KDToggleButton)component2).getAction() == null || !tb.getAction().getClass().getName().equalsIgnoreCase(actionName)) continue;
            tb.getAction().setEnabled(action);
            tb.setVisible(visable);
            break;
        }
    }

    @Override
    public Map getFormulaMap() {
        return this.formulaMap;
    }

    public void setFormulaMap(Map formulaMap) {
        this.formulaMap = formulaMap;
    }

    protected void init() throws Exception {
        this.loadCalculate();
        this.showToolbar();
        this.showMenus();
        this.showRCMenus();
        this.showAction();
        this.showVarialbes();
        this.initSystemOtherInfo();
        this.regBillId();
        this.showAllBook();
        this.initSpreadListener();
    }

    protected void loadCalculate() {
    }

    protected void saveCalculate() {
        this.getBook().setUserObject("AUTO_CALCULATOR", (Object)this.getBook().isAutoCalculate());
    }

    protected void showToolbar() {
        if (this.getToolbarStrategy() != null) {
            this.getToolbarStrategy().applyToolbarState(this.getOprtState());
        }
    }

    protected void showMenus() {
        this.menuItemAttachement.setAccelerator(KeyStroke.getKeyStroke(114, 64, false));
        this.menuItemImport.setAccelerator(KeyStroke.getKeyStroke(73, 128, false));
        this.menuItemExport.setAccelerator(KeyStroke.getKeyStroke(69, 192, false));
        this.menuItemCopy.setAccelerator(KeyStroke.getKeyStroke(67, 128, false));
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke(123, 192, false));
    }

    protected void showAction() {
    }

    protected void showRCMenus() {
        PopMenuManager pm = this.getSpreadManager().getSpreadContainer().getPopMenuManager();
        JMenuItem item = pm.getItem("MenuItem_Insert");
        item.getAction().putValue("Action_Lock", "true");
        item.setVisible(false);
        pm.setItemVisible(item, false);
        item = pm.getItem("MenuItem_Delete");
        item.getAction().putValue("Action_Lock", "true");
        item.setVisible(false);
        pm.setItemVisible(item, false);
    }

    protected void showVarialbes() {
    }

    protected void initSystemInfo() throws Exception {
        this.setSYSTEMINFO_DATA(new ArrayList());
        this.setFormulaMap(new HashMap());
        this.getSYSTEMINFO_DATA().add(this.getFormulaMap());
    }

    protected void initSystemOtherInfo() throws Exception {
    }

    protected void regBillId() throws Exception {
        Object obj = this.getUIContext().get("Owner");
        if (obj != null && obj instanceof Component && obj instanceof BgOrgBasedListUI) {
            this.component = (Component)obj;
            if (this.component != null) {
                Method method = null;
                try {
                    method = this.component.getClass().getMethod("addSelectedKeyValue", String.class);
                    if (method != null) {
                        method.invoke((Object)this.component, this.getBillId());
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                    this.handUIException(ex);
                }
            }
        }
    }

    public List getSYSTEMINFO_DATA() {
        return this.SYSTEMINFO_DATA;
    }

    public void setSYSTEMINFO_DATA(List systeminfo_data) {
        this.SYSTEMINFO_DATA = systeminfo_data;
    }

    public boolean isSelectItem() {
        return this.isSelectItem;
    }

    public void setSelectItem(boolean isSelectItem) {
        this.isSelectItem = isSelectItem;
    }

    public OrgUnitInfo getOrgUnitInfo() {
        return this.ccOrgUnitInfo;
    }

    public void setOrgUnitInfo(OrgUnitInfo orgUnitInfo) {
        this.ccOrgUnitInfo = orgUnitInfo;
    }

    public void setEditor(ICellEditor editor) {
        this.editor = editor;
    }

    public ICellEditor getEditor() {
        return this.editor;
    }

    protected void updateExpr(Book book) {
        for (int i = 0; i < book.getSheetCount(); ++i) {
            Sheet sheet = book.getSheet(i);
            Sheet.ICellsIterator ci = sheet.getCellsIterator(null, false, true);
            while (ci.hasNext()) {
                Variant v;
                Cell cll = ci.next();
                if (cll.getValue() instanceof Variant && ((v = cll.getValue()).getValue() instanceof Calendar || v.getValue() instanceof Date)) continue;
                cll.updateExpr(true);
            }
        }
    }

    protected void showCtrl(Sheet sheet) {
        if (sheet == null) {
            return;
        }
        Range range = sheet.getRange(0, 0);
        if (range != null) {
            range.select();
        }
    }

    protected void showCtrlSelected() {
        this.getSpreadManager().getSpreadContainer().getSpread().scrollCellVisible(0, 0);
    }

    protected boolean isActualRecordUI() {
        return false;
    }

    protected void showAllBook() throws Exception {
        Book _book = null;
        Sheet _sheet = null;
        boolean isSheetPer = BgParamCHelper.isBgSheetPermissionUsed();
        Map sheetPer = null;
        boolean bg022 = BgSHelper.isBgPermissionUsed();
        boolean bg02201 = BgSHelper.isBgTemplatePerimissionForUse();
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        OrgUnitInfo orgUnitInfo = SysContext.getSysContext().getCurrentOrgUnit();
        HashSet<String> set = new HashSet<String>();
        set.add(orgUnitInfo.getId().toString());
        String per = BgPermissionFactory.getRemoteInstance().getBgPermissionSqlLong(userInfo.getId().toString(), set);
        if (isSheetPer && bg022 && bg02201 && per == null) {
            isSheetPer = false;
        }
        if (isSheetPer) {
            sheetPer = this.addBgSheetPermission();
        }
        String user = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        _book = this.getBook();
        boolean isShowSheet = false;
        if (_book != null) {
            int sheetIndex = 0;
            int sheetSize = _book.getSheetCount();
            for (sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
                _sheet = _book.getSheet(sheetIndex);
                if (isSheetPer) {
                    if (!isShowSheet) {
                        isShowSheet = this.hideSheet(_sheet, sheetPer, user);
                    } else {
                        this.hideSheet(_sheet, sheetPer, user);
                    }
                }
                this.showAllSheet(_sheet);
            }
        }
        this.getSpreadManager().getModifyManager().discardAllEdits();
        if (isSheetPer && !isShowSheet && !this.isActualRecordUI()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BgSpecialFormResource", (String)"hasnotPermissionSheet"));
            SysUtil.abort();
        }
        this.getSpreadManager().getSpreadContainer().clearQueue();
    }

    protected boolean hideSheet(Sheet _sheet, Map sheetPer, String user) {
        String sheetCreater = null;
        boolean isShowSheet = false;
        if (sheetPer != null && sheetPer.containsKey(BgNFSHelper.getSheetSign(_sheet))) {
            _sheet.setHide(false);
            isShowSheet = true;
        } else {
            sheetCreater = (String)_sheet.getUserObjectValue("SHEET_CREATER_ID");
            if (sheetCreater != null) {
                if (!sheetCreater.equals(user)) {
                    _sheet.setHide(true);
                } else {
                    _sheet.setHide(false);
                    isShowSheet = true;
                }
            } else {
                _sheet.setHide(true);
                isShowSheet = true;
            }
        }
        return isShowSheet;
    }

    protected void showAllSheet(Sheet sheet) throws Exception {
        if (sheet == null) {
            return;
        }
        Cell cell = null;
        int rowIndex = 0;
        int colIndex = 0;
        int rowCount = sheet.getMaxRowIndex();
        int colCount = sheet.getMaxColIndex();
        for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
            for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                cell = sheet.getCell(rowIndex, colIndex, false);
                this.showCell(cell);
            }
        }
    }

    protected void showCell(Cell cell) throws Exception {
    }

    protected void initSpreadListener() {
        this.getSpreadManager().registerCellDisplayProvider((ICellDisplayProvider)this.getCellDisplayRender());
        this.getSpreadManager().getSpreadContainer().getEditManager().setEditorProvider(new ICellEditorProvider(){

            public ICellEditor getEditor(Sheet sheet, int row, int col) {
                return BgNProcessUI.this.getCellEditor(sheet, row, col);
            }
        });
        this.getSpreadManager().addKDSBlockInvalidListener(new SheetChangeListener(){

            public void changed(SheetChangeEvent e) {
                if (e.hasState(SheetChangeEvent.Changed_Content)) {
                    try {
                        BgNProcessUI.this.cell_Content_Changed(e);
                    }
                    catch (Exception ex) {
                        logger.error((Object)ex);
                        BgNProcessUI.this.handleException(ex);
                    }
                }
                if (e.hasState(SheetChangeEvent.Changed_Selection) || e.hasState(SheetChangeEvent.Changed_SelectionActive)) {
                    try {
                        BgNProcessUI.this.cell_Selection_Changed(e);
                    }
                    catch (Exception ex) {
                        logger.error((Object)ex);
                        BgNProcessUI.this.handleException(ex);
                    }
                }
            }
        });
        AbstractAction actionViewCell = new AbstractAction(){
            private static final long serialVersionUID = 2750933550496592004L;

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    BgNProcessUI.this.actionViewCell_actionPerformed(e);
                }
                catch (Exception ex) {
                    BgNProcessUI.this.handleException(ex);
                }
            }
        };
        String strKey = "CTRL_SHIFT_V";
        KeyStroke ks = KeyStroke.getKeyStroke(86, 192, false);
        this.getActionMap().put(strKey, actionViewCell);
        this.getInputMap(2).put(ks, strKey);
        AbstractAction actionRomveRow = new AbstractAction(){
            private static final long serialVersionUID = 2750933550496592005L;

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    BgNProcessUI.this.actionRomveRow_actionPerformed(e);
                }
                catch (Exception ex) {
                    BgNProcessUI.this.handleException(ex);
                }
            }
        };
        String strXKey = "CTRL_SHIFT_X";
        KeyStroke ksX = KeyStroke.getKeyStroke(88, 192, false);
        this.getActionMap().put(strXKey, actionRomveRow);
        this.getInputMap(2).put(ksX, strXKey);
    }

    protected BgUserCellDisplayProvider getCellDisplayRender() {
        BgUserCellDisplayProvider render = new BgUserCellDisplayProvider();
        BgUserCellDisplayProvider.addRenderProvider((IRenderProvider)new UserItemRenderProvider());
        BgUserCellDisplayProvider.addRenderProvider((IRenderProvider)new BgEnumerateRender());
        return render;
    }

    protected ICellEditor getCellEditor(Sheet sheet, int rowIndex, int colIndex) {
        return null;
    }

    protected void cell_Content_Changed(SheetChangeEvent e) throws Exception {
    }

    protected void cell_Selection_Changed(SheetChangeEvent e) throws Exception {
    }

    public String getBillId() {
        return this.getBookProvider().getEditValue().get(this.getBookProvider().getEditValue().getPKField()).toString();
    }

    protected SheetInfo[] getSheets() {
        int i;
        SheetInfo sheetInfo = null;
        SheetInfo[] sheets = null;
        ArrayList<SheetInfo> tmpList = new ArrayList<SheetInfo>();
        Book _book = null;
        Sheet _sheet = null;
        _book = this.getBook();
        boolean isSheetPer = BgParamCHelper.isBgSheetPermissionUsed();
        Map sheetPer = null;
        if (isSheetPer) {
            sheetPer = this.getSheetPermessionMap(this.getBook(), this.getTemplateId());
        }
        int in = _book.getSheetCount();
        for (i = 0; i < in; ++i) {
            _sheet = _book.getSheet(i);
            if (isSheetPer && sheetPer != null && !sheetPer.containsKey(_sheet.getID())) continue;
            sheetInfo = new SheetInfo();
            sheetInfo.setBgFormId(this.getBillId());
            sheetInfo.setSheetId(_sheet.getID());
            sheetInfo.setSheetName(_sheet.getSheetName());
            tmpList.add(sheetInfo);
        }
        sheets = new SheetInfo[tmpList.size()];
        int size = tmpList.size();
        for (i = 0; i < size; ++i) {
            sheets[i] = (SheetInfo)tmpList.get(i);
        }
        tmpList.clear();
        return sheets;
    }

    private Map getSheetPermessionMap(Book _book, String templateId) {
        Map sheetPer = null;
        sheetPer = this.addBgSheetPermission(templateId);
        Sheet _sheet = null;
        String user = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        if (_book != null) {
            int sheetIndex = 0;
            int sheetSize = _book.getSheetCount();
            for (sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
                _sheet = _book.getSheet(sheetIndex);
                this.hideSheet1(_sheet, sheetPer, user);
            }
        }
        return sheetPer;
    }

    protected Map addBgSheetPermission(String bgTemplateId) {
        if (bgTemplateId == null) {
            return null;
        }
        Map hasPer = new HashMap<String, Object>();
        Map sheetPer = new HashMap();
        try {
            hasPer.put(bgTemplateId, null);
            hasPer = BgPermissionHelper.getBgTemplateSheetPermission(null, hasPer);
            if (hasPer != null && hasPer.get(bgTemplateId) != null) {
                sheetPer = (Map)hasPer.get(bgTemplateId);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return sheetPer;
    }

    protected void hideSheet1(Sheet _sheet, Map sheetPer, String user) {
        String sheetCreater = null;
        if (sheetPer != null && sheetPer.containsKey(BgNFSHelper.getSheetSign(_sheet))) {
            sheetPer.put(_sheet.getID(), null);
        } else {
            sheetCreater = (String)_sheet.getUserObjectValue("SHEET_CREATER_ID");
            if (sheetCreater != null && sheetCreater.equals(user)) {
                sheetPer.put(_sheet.getID(), null);
            }
        }
    }

    protected void destroyBillId() {
        if (this.component != null) {
            Method method = null;
            try {
                String billId = this.getBillId();
                method = this.component.getClass().getMethod("removeSelectKeyValue", String.class);
                if (method != null && !StringUtils.isEmpty((String)billId)) {
                    method.invoke((Object)this.component, billId);
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                this.handUIException(ex);
            }
        }
    }

    public boolean destroyWindow() {
        boolean re = super.destroyWindow();
        if (re) {
            this.clearSystemInfo();
            this.destroyBillId();
            BgNCHelper.refreshListUI((CoreUI)this);
        }
        return re;
    }

    protected void clearSystemInfo() {
        this.getSYSTEMINFO_DATA().clear();
    }

    protected String getMessageStr(String key) {
        return !StringUtils.isEmpty((String)key) ? EASResource.getString((String)this.getMessageFile(), (String)key) : "";
    }

    protected String getMessageStr(String sourceStr, String key) {
        return !StringUtils.isEmpty((String)key) ? EASResource.getString((String)sourceStr, (String)key) : "";
    }

    protected String getMessageFile() {
        return "com.kingdee.eas.ma.nbudget.client.BgNFormResource";
    }

    public void actionBgFormulaFill_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", null);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.rpt.client.BgFormulaBatchFill", (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    protected abstract void actionAfterInsertCell(NotifyEvent var1) throws Exception;

    protected abstract void actionAfterInsertRow(NotifyEvent var1) throws Exception;

    protected abstract void actionAfterDeleteRow(NotifyEvent var1) throws Exception;

    protected abstract void actionAfterInsertCol(NotifyEvent var1) throws Exception;

    protected abstract void actionBeforeDeleteCol(NotifyEvent var1) throws Exception;

    protected abstract void actionBeforeDeleteRow(NotifyEvent var1) throws Exception;

    protected abstract void actionBeforeDeleteCell(NotifyEvent var1) throws Exception;

    protected abstract void actionBeforeCellMerge(NotifyEvent var1) throws Exception;

    protected void initAction() {
        ActionManager actionManager = this.getSpreadManager().getSpreadContainer().getActionManager();
        SpreadAction colInsertAction = actionManager.getAction("Insert_Col");
        SpreadAction colDeleteAction = actionManager.getAction("Delete_Col");
        SpreadAction rowInsertAction = actionManager.getAction("Insert_Row");
        SpreadAction rowDeleteAction = actionManager.getAction("Delete_Row");
        SpreadAction cellInsertAction = actionManager.getAction("Insert_Cell");
        SpreadAction cellDeleteAction = actionManager.getAction("Delete_Cell");
        SpreadAction cellMergeAction = actionManager.getAction("Merge");
        colDeleteAction.setBeforeAction(new NotifyListener(){

            public void doNotify(NotifyEvent evt) {
                try {
                    BgNProcessUI.this.actionBeforeDeleteCol(evt);
                }
                catch (Exception e) {
                    BgNProcessUI.this.handUIExceptionAndAbort(e);
                }
            }
        });
        rowDeleteAction.setBeforeAction(new NotifyListener(){

            public void doNotify(NotifyEvent evt) {
                try {
                    BgNProcessUI.this.actionBeforeDeleteRow(evt);
                }
                catch (Exception e) {
                    BgNProcessUI.this.handUIExceptionAndAbort(e);
                }
            }
        });
        rowDeleteAction.setAfterAction(new NotifyListener(){

            public void doNotify(NotifyEvent evt) {
                try {
                    BgNProcessUI.this.actionAfterDeleteRow(evt);
                }
                catch (Exception e) {
                    BgNProcessUI.this.handUIExceptionAndAbort(e);
                }
            }
        });
        cellDeleteAction.setBeforeAction(new NotifyListener(){

            public void doNotify(NotifyEvent evt) {
                try {
                    BgNProcessUI.this.actionBeforeDeleteCell(evt);
                }
                catch (Exception e) {
                    BgNProcessUI.this.handUIExceptionAndAbort(e);
                }
            }
        });
        colInsertAction.setAfterAction(new NotifyListener(){

            public void doNotify(NotifyEvent evt) {
                try {
                    BgNProcessUI.this.actionAfterInsertCol(evt);
                }
                catch (Exception e) {
                    BgNProcessUI.this.handUIExceptionAndAbort(e);
                }
            }
        });
        rowInsertAction.setAfterAction(new NotifyListener(){

            public void doNotify(NotifyEvent evt) {
                try {
                    BgNProcessUI.this.actionAfterInsertRow(evt);
                }
                catch (Exception e) {
                    BgNProcessUI.this.handUIExceptionAndAbort(e);
                }
            }
        });
        cellInsertAction.setAfterAction(new NotifyListener(){

            public void doNotify(NotifyEvent evt) {
                try {
                    BgNProcessUI.this.actionAfterInsertCell(evt);
                }
                catch (Exception e) {
                    BgNProcessUI.this.handUIExceptionAndAbort(e);
                }
            }
        });
        cellMergeAction.setBeforeAction(new NotifyListener(){

            public void doNotify(NotifyEvent evt) {
                try {
                    BgNProcessUI.this.actionBeforeCellMerge(evt);
                }
                catch (Exception e) {
                    BgNProcessUI.this.handUIExceptionAndAbort(e);
                }
            }
        });
    }

    public boolean isPrepareCustomAction() {
        return false;
    }

    public IUIActionPostman prepareCustomAction(IUIObject uiObject, IItemAction action) {
        IUIActionPostman handler = UIActionPostman.getInstance((IUIObject)this);
        handler.setAvailabe(this.isPrepareCustomAction());
        String actionName = null;
        String methodName = null;
        Method _method = null;
        RequestContext request = null;
        actionName = this.getActionName(action.getItemAction());
        try {
            methodName = "prepare" + actionName;
            _method = uiObject.getClass().getMethod(methodName, IItemAction.class);
            if (_method != null) {
                request = (RequestContext)_method.invoke((Object)this, action);
            }
        }
        catch (Exception ex) {
            this.handUIExceptionAndAbort(ex);
        }
        if (request != null) {
            request.setMethodName("handle" + actionName);
            request.setClassName(this.getUIHandlerClassName());
        }
        handler.setRequestContext(request);
        return handler;
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        Book book = this.getBook();
        if (book != null) {
            Sheet sheet = null;
            int in = book.getSheetCount();
            for (int i = 0; i < in; ++i) {
                int re;
                sheet = book.getSheet(i);
                int maxRowCount = sheet.getMaxRowIndex();
                int maxColCount = sheet.getMaxColIndex();
                if (maxRowCount <= 5000 && maxColCount <= 512 || (re = MsgBox.showConfirm2((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.ma.nbudget.client.BgNFormResource", (String)"sheetRowOrColRange"), sheet.getSheetName()))) == 0) continue;
                return;
            }
        }
        super.actionSave_actionPerformed(e);
    }

    protected void actionViewCell_actionPerformed(ActionEvent e) throws Exception {
        IObjectValue value;
        Sheet _sheet = this.getBook().getActiveSheet();
        Cell _cell = _sheet.getActiveCell();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"CELL", (Object)_cell);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgViewCellUI.class.getName(), (Map)uiContext);
        uiWindow.show();
        String bgItemNumber = ((BgViewCellUI)uiWindow.getUIObject()).getBgItemNumber();
        if (bgItemNumber != null && ((BgViewCellUI)uiWindow.getUIObject()).isConfirm() && (value = BgItemFactory.getRemoteInstance().getBgItemName(SysContext.getSysContext().getCurrentCostUnit().getId(), bgItemNumber)) != null) {
            BgNFSHelper.setBgItemInfo(_cell, bgItemNumber, value.getString("id"));
        }
    }

    protected void actionRomveRow_actionPerformed(ActionEvent e) throws Exception {
        Sheet _sheet = this.getBook().getActiveSheet();
        Range range = _sheet.getSelectionRange();
        if (range == null) {
            return;
        }
        HashMap removeRows = new HashMap();
        CellBlock cellBlock = null;
        Row row = null;
        Cell cell = null;
        boolean canRemove = true;
        int maxColIndex = _sheet.getMaxColIndex() + 1;
        int j = range.size();
        for (int i = 0; i < j; ++i) {
            cellBlock = range.getBlock(i);
            int n = cellBlock.getRow2();
            for (int m = cellBlock.getRow(); m <= n; ++m) {
                canRemove = true;
                row = _sheet.getRow(m, false);
                if (row == null) {
                    removeRows.put(new Integer(m), null);
                    continue;
                }
                for (int s = 0; s < maxColIndex; ++s) {
                    cell = row.getCell(s, false);
                    if (cell == null || BgNFSHelper.checkIsEmptyValue(cell) && !BgNFSHelper.checkHasItemFormula(cell) && !BgNFSHelper.checkHasExpression(cell) && !BgNFSHelper.checkHasEnumerateOfCell(cell) && !BgNFSHelper.checkHasComment(cell) && cell.getUserObjectValue("ScriptBeginCell") == null) continue;
                    canRemove = false;
                }
                if (!canRemove) continue;
                removeRows.put(new Integer(m), null);
            }
        }
        StringBuffer removeStr = new StringBuffer(EASResource.getString((String)"com.kingdee.eas.ma.nbudget.NBUDGETAutoGenerateResource", (String)"92_BgNProcessUI"));
        if (!removeRows.isEmpty()) {
            for (int maxRowIndex = _sheet.getMaxRowIndex(); maxRowIndex >= 0; --maxRowIndex) {
                if (!removeRows.containsKey(new Integer(maxRowIndex))) continue;
                BgNFSHelper.removeRow(_sheet, maxRowIndex);
                removeStr.append(maxRowIndex + " , ");
            }
            MsgBox.showInfo((Component)((Object)this), (String)removeStr.toString().substring(0, removeStr.length() - 2));
        }
    }

    public boolean isEnumerate() {
        return this.isEnumerate;
    }

    public void setEnumerate(boolean isEnumerate) {
        this.isEnumerate = isEnumerate;
    }

    public boolean isScript() {
        return this.isScript;
    }

    public void setScript(boolean isScript) {
        this.isScript = isScript;
    }

    protected void checkAllEditRange4Force() {
        Sheet sheet = this.getBook().getActiveSheet();
        Range range = this.getBook().getActiveSheet().getSelectionRange();
        String longnumber = SysContext.getSysContext().getCurrentOrgUnit().castToFullOrgUnitInfo().getLongNumber();
        for (int i = 0; i < range.size(); ++i) {
            CellBlock block = range.getBlock(i);
            for (int j = block.getRow(); j <= block.getRow2(); ++j) {
                for (int k = block.getCol(); k <= block.getCol2(); ++k) {
                    Cell currentIteratorCell = sheet.getCell(j, k, false);
                    if (currentIteratorCell == null) continue;
                    this.checkEditForForceLock(currentIteratorCell, longnumber);
                }
            }
        }
    }

    protected void checkEditForForceLock(Cell currentIteratorCell, String orgLongnumber) {
        if (!BgNTemplateHelper.canEditForForceLock(currentIteratorCell, orgLongnumber)) {
            this.showErrorMsg(EASResource.getString((String)"com.kingdee.eas.ma.nbudget.client.BgNFormResource", (String)"bgTemplateCannotEdit"));
            SysUtil.abort();
        }
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        if (handler != null) {
            // empty if block
        }
        return handler;
    }

    protected boolean isBOSTypeConfiged() throws BOSException, EASBizException {
        return false;
    }

    protected class CheckForceLockBeforeNotify
    implements NotifyListener {
        protected CheckForceLockBeforeNotify() {
        }

        public void doNotify(NotifyEvent evt) {
            try {
                this.actionBeforeClearAllAction(evt);
            }
            catch (Exception e) {
                BgNProcessUI.this.handUIExceptionAndAbort(e);
            }
        }

        private void actionBeforeClearAllAction(NotifyEvent evt) {
            BgNProcessUI.this.checkAllEditRange4Force();
        }
    }
}

