/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.swing.event.TreePopupMenuEvent;
import com.kingdee.bos.ctrl.swing.event.TreePopupMenuListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.base.permission.IOrgRange;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.IPermissionServiceProvider;
import com.kingdee.eas.base.permission.OrgRangeCollection;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.PermissionServiceProviderFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.INewOrgViewFacade;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.OrgViewUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.ma.budget.BgExamineFacadeFactory;
import com.kingdee.eas.ma.budget.BgFPeriodFacadeFactory;
import com.kingdee.eas.ma.budget.BgFacadeFactory;
import com.kingdee.eas.ma.budget.BgFormCollection;
import com.kingdee.eas.ma.budget.BgFormFacadeFactory;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgGatherFacadeFactory;
import com.kingdee.eas.ma.budget.BgGatherHelper;
import com.kingdee.eas.ma.budget.BgTypeInfo;
import com.kingdee.eas.ma.budget.IBgExamineFacade;
import com.kingdee.eas.ma.budget.IBgFPeriodFacade;
import com.kingdee.eas.ma.budget.IBgFacade;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.IBgFormFacade;
import com.kingdee.eas.ma.budget.IBgGatherFacade;
import com.kingdee.eas.ma.budget.client.AssignSolutionUI;
import com.kingdee.eas.ma.budget.client.BgClientHelper;
import com.kingdee.eas.ma.budget.client.BgOrgBasedListUI;
import com.kingdee.eas.ma.budget.client.BgSubOrgUnitSelectUIForBatchGather;
import com.kingdee.eas.ma.budget.client.ProgressDialogUI;
import com.kingdee.eas.ma.nbudget.BgNFFacadeFactory;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNFormFacadeFactory;
import com.kingdee.eas.ma.nbudget.BgNSHelper;
import com.kingdee.eas.ma.nbudget.IBgNFormFacade;
import com.kingdee.eas.ma.nbudget.client.AbstractBgPredictBaseUI;
import com.kingdee.eas.ma.nbudget.client.BgFormQueryProcessor;
import com.kingdee.eas.ma.nbudget.client.BgNFAfterBatchGatherUI;
import com.kingdee.eas.ma.nbudget.client.BgNFAfterGatherUI;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class BgPredictBaseUI
extends AbstractBgPredictBaseUI {
    private static final long serialVersionUID = 4836979093270676705L;
    private static final Logger logger = CoreUIObject.getLogger(BgOrgBasedListUI.class);
    private static final String CHILD_ORG_ERROR = "childOrgCountException";
    private boolean isInit = false;
    private Set permissionOrg = null;
    private Map permissionOrgMap = new HashMap();
    private Map paramValue = null;
    private String permissionNum = null;
    private Set useIds = new HashSet();

    public Map getPermissionOrgMap() {
        return this.permissionOrgMap;
    }

    protected void initWorkButton() {
        super.initWorkButton();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgFormFactory.getRemoteInstance();
    }

    protected IQuerySolutionFacade getQuerySolutionInterface() throws Exception {
        return QuerySolutionFacadeFactory.getRemoteInstance();
    }

    protected IBgGatherFacade getGatherInterface() throws Exception {
        return BgGatherFacadeFactory.getRemoteInstance();
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = super.initCommonQueryDialog();
        dialog.setProcessor((IProcessor)new BgFormQueryProcessor((IUIObject)this));
        return dialog;
    }

    protected IBgFacade getBgFacadeInterface() throws Exception {
        return BgFacadeFactory.getRemoteInstance();
    }

    protected IPermission getPermissionInterface() throws Exception {
        return PermissionFactory.getRemoteInstance();
    }

    protected IPermissionServiceProvider getPermissionSerInterface() throws Exception {
        return PermissionServiceProviderFactory.getRemoteInstance();
    }

    protected IBgExamineFacade getBgExamineInterface() throws Exception {
        return BgExamineFacadeFactory.getRemoteInstance();
    }

    protected IBgForm getFormInterface() throws Exception {
        return BgFormFactory.getRemoteInstance();
    }

    protected IBgFormFacade getFacadeInterface() throws Exception {
        return BgFormFacadeFactory.getRemoteInstance();
    }

    protected IBgNFormFacade getNFacadeInterface() throws Exception {
        return BgNFormFacadeFactory.getRemoteInstance();
    }

    protected IBgFPeriodFacade getBgFPEInterface() throws Exception {
        return BgFPeriodFacadeFactory.getRemoteInstance();
    }

    protected IFullOrgUnit getFullOrgUnitInterface() throws Exception {
        return FullOrgUnitFactory.getRemoteInstance();
    }

    protected INewOrgViewFacade getOrgViewInterface() throws Exception {
        return NewOrgViewFacadeFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return null;
    }

    public void setParamValue(Map paramValue) {
        this.paramValue = paramValue;
    }

    public Map getParamValue() {
        return this.paramValue;
    }

    protected void refreshOrgUnitTree() throws Exception {
        TreeModel treeModel = null;
        String rootUnitID = null;
        CostCenterOrgUnitInfo ccoui = SysContext.getSysContext().getCurrentCostUnit();
        rootUnitID = ccoui != null ? BgNFFacadeFactory.getRemoteInstance().firstCostCenterAndCU(ccoui.getId()).toString() : SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        try {
            treeModel = BgNFSHelper.getOrgTreeModel(rootUnitID, this.treeOrgUnit);
        }
        catch (Exception ex) {
            this.handUIExceptionAndAbort(ex);
        }
        try {
            this.treeOrgUnit.setModel(treeModel);
        }
        catch (Exception ex) {
            this.handUIExceptionAndAbort(ex);
        }
    }

    protected IObjectPK getOrgPK() {
        CompanyOrgUnitInfo info = SysContext.getSysContext().getCurrentFIUnit();
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getLastSelectedPathComponent();
        if (node != null) {
            OrgStructureInfo oui = (OrgStructureInfo)node.getUserObject();
            FullOrgUnitInfo org = oui.getUnit();
            org.setLongNumber(oui.getLongNumber());
            if (org.isIsCompanyOrgUnit()) {
                return new ObjectUuidPK(org.getId());
            }
        }
        return info != null ? new ObjectUuidPK(info.getId()) : null;
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        String _orgUnitId = this.getOrgUnitId();
        if (StringUtils.isEmpty((String)_orgUnitId) || SysContext.getSysContext().getCurrentCostUnit() == null) {
            return new ObjectUuidPK(SysContext.getSysContext().getCurrentOrgUnit().getId());
        }
        return new ObjectUuidPK(_orgUnitId);
    }

    protected FilterInfo getImmSelectedQueryFilterInfo(EntityViewInfo viewInfo) {
        FilterInfo filter = this.getDefaultFilterForQuery();
        filter = this.getQueryFilterInfo(filter);
        if (this.permissionOrg == null) {
            this.permissionOrg = new HashSet();
        } else {
            this.permissionOrg.clear();
        }
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getLastSelectedPathComponent();
        if (node != null && !OrgViewUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)node)) {
            HashSet<String> orgUnitIdSet = new HashSet<String>();
            OrgStructureInfo _oui = null;
            FullOrgUnitInfo _orgUnitInfo = null;
            DefaultKingdeeTreeNode _node = null;
            _oui = (OrgStructureInfo)node.getUserObject();
            _orgUnitInfo = _oui.getUnit();
            if (this.permissionOrgMap.containsKey(_orgUnitInfo.getId())) {
                orgUnitIdSet.add(_orgUnitInfo.getId().toString());
                this.permissionOrg.add(_orgUnitInfo.getId().toString());
            }
            if (!node.isLeaf()) {
                for (int i = 0; i < node.getChildCount(); ++i) {
                    _node = (DefaultKingdeeTreeNode)node.getChildAt(i);
                    if (_node == null || OrgViewUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)_node) || !this.permissionOrgMap.containsKey((_orgUnitInfo = (_oui = (OrgStructureInfo)_node.getUserObject()).getUnit()).getId())) continue;
                    orgUnitIdSet.add(_orgUnitInfo.getId().toString());
                    this.permissionOrg.add(_orgUnitInfo.getId().toString());
                }
            }
            FilterItemInfo item = null;
            item = orgUnitIdSet.isEmpty() ? new FilterItemInfo("orgunit.id".toLowerCase(), (Object)"000000000000000000000000000=", CompareType.EQUALS) : new FilterItemInfo("orgunit.id".toLowerCase(), orgUnitIdSet, CompareType.INCLUDE);
            this.replaceFilterItems(filter, item);
        }
        return filter;
    }

    public void onLoad() throws Exception {
        FullOrgUnitCollection orgCol = null;
        this.setParamValue(BgNSHelper.getAllParamValue());
        if (this.getPermissionNum() != null) {
            orgCol = this.getBgFacadeInterface().getAuthorizedOrg((IObjectPK)new ObjectUuidPK(this.getUserInfo().getId()), OrgType.CostCenter, null, this.getPermissionNum());
            this.getPermissionOrg(orgCol);
        }
        this.initTreePopMenu();
        this.treeOrgUnit.setModel(null);
        this.treeOrgUnit.setEnabled(false);
        super.onLoad();
        this.initComboxOrgType();
        this.refreshOrgUnitTree();
        this.locateCurrentOrg();
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getLastSelectedPathComponent();
        boolean isPerimess = true;
        if (node != null) {
            isPerimess = !OrgViewUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)node);
        }
        this.treeOrgUnit.setEnabled(true);
        this.isInit = true;
        this.applyPreference();
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                BgPredictBaseUI.this.tblMain_afterDataFill(e);
            }
        });
    }

    protected void tblMain_afterDataFill(KDTDataRequestEvent e) {
        if (this.getUIContext().containsKey(CHILD_ORG_ERROR)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgCommonResource", (String)CHILD_ORG_ERROR));
            this.getUIContext().remove(CHILD_ORG_ERROR);
        }
    }

    private void getPermissionOrg(FullOrgUnitCollection orgCol) {
        if (orgCol != null && orgCol.size() > 0) {
            for (int i = 0; i < orgCol.size(); ++i) {
                this.permissionOrgMap.put(orgCol.get(i).getId(), null);
            }
        }
    }

    protected void initComboxOrgType() {
        this.comboxOrgType.addItem((Object)OrgViewType.COSTCENTER);
        if (this.isUseForElim()) {
            this.comboxOrgType.addItem((Object)OrgViewType.UNIONDEBT);
            this.comboxOrgType.setSelectedItem((Object)OrgViewType.COSTCENTER);
        } else {
            this.comboxOrgType.setSelectedItem((Object)OrgViewType.COSTCENTER);
        }
        this.comboxOrgType.setEnabled(false);
        this.treeViewOrgUnit.setTitle(OrgViewType.RESPONSECENTER.getAlias());
    }

    protected FullOrgUnitInfo getBGOrgUnitInfo() {
        OrgStructureInfo oui;
        FullOrgUnitInfo info = null;
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getLastSelectedPathComponent();
        if (node != null && !OrgViewUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)node) && (oui = (OrgStructureInfo)node.getUserObject()) != null && oui.getUnit() != null) {
            info = oui.getUnit();
            String id = info.getId().toString();
            try {
                FullOrgUnitInfo info1 = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo("select CU.id, CU.name where id='" + id + "'");
                info.setCU(info1.getCU());
            }
            catch (Exception ex) {
                this.handUIException(ex);
            }
            info.setLongNumber(oui.getLongNumber());
        }
        return info;
    }

    protected FullOrgUnitInfo getOrgUnitInfo(DefaultKingdeeTreeNode node) {
        OrgStructureInfo oui;
        FullOrgUnitInfo orgInfo = null;
        if (node != null && !OrgViewUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)node) && (oui = (OrgStructureInfo)node.getUserObject()) != null && oui.getUnit() != null) {
            orgInfo = oui.getUnit();
            orgInfo.setLongNumber(oui.getLongNumber());
        }
        return orgInfo;
    }

    protected FullOrgUnitInfo getOrgUnitInfo() {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getLastSelectedPathComponent();
        return this.getOrgUnitInfo(node);
    }

    protected String getOrgUnitId() {
        FullOrgUnitInfo orgUnitInfo = this.getOrgUnitInfo();
        if (orgUnitInfo != null) {
            return orgUnitInfo.getId().toString();
        }
        return null;
    }

    protected OrgViewType getOrgViewType() {
        return (OrgViewType)this.comboxOrgType.getSelectedItem();
    }

    protected Vector getOrgIDPath() throws EASBizException, BOSException {
        TreePath path = this.treeOrgUnit.getSelectionPath();
        if (path == null) {
            return null;
        }
        Object[] pathObj = path.getPath();
        if (pathObj == null) {
            return null;
        }
        int length = pathObj.length;
        Vector<String> result = new Vector<String>(length);
        int treeType = -1;
        String firstOrgId = "";
        for (int i = length - 1; i >= 0; --i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)pathObj[i];
            Object obj = node.getUserObject();
            if (obj == null || !(obj instanceof OrgStructureInfo)) continue;
            OrgStructureInfo oui = (OrgStructureInfo)obj;
            FullOrgUnitInfo orgUnitInfo = oui.getUnit();
            if (treeType == -1) {
                treeType = (Integer)orgUnitInfo.get("treeType");
            }
            firstOrgId = orgUnitInfo.getId().toString();
            result.add(orgUnitInfo.getId().toString());
        }
        INewOrgViewFacade iNew = NewOrgViewFacadeFactory.getRemoteInstance();
        this.getParentId(iNew, firstOrgId, treeType, result);
        return result;
    }

    private void getParentId(INewOrgViewFacade iNew, String firstOrgId, int treeType, Vector result) throws EASBizException, BOSException {
        OrgUnitInfo org = iNew.getParent(firstOrgId, OrgViewType.getEnum((int)treeType));
        if (org == null) {
            return;
        }
        result.add(org.getId().toString());
        firstOrgId = org.getId().toString();
        this.getParentId(iNew, firstOrgId, treeType, result);
    }

    @Override
    protected void comboxOrgType_actionPerformed(ActionEvent e) throws Exception {
    }

    private void locateCurrentOrg() throws BOSException, EASBizException {
        if (this.treeOrgUnit.getRowCount() > 0) {
            this.treeOrgUnit.setSelectionRow(0);
        }
    }

    protected void getCurrentOrgTree(List list, FullOrgUnitInfo currentOrg, FullOrgUnitInfo endOrg, IFullOrgUnit iou, SelectorItemCollection selector) throws BOSException, EASBizException {
        if (list == null || currentOrg == null || endOrg == null || iou == null) {
            return;
        }
        if (currentOrg.getId().equals((Object)endOrg.getId())) {
            list.add(endOrg.getId().toString());
        } else {
            list.add(currentOrg.getId().toString());
            if (currentOrg.getParent() != null) {
                currentOrg = iou.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(currentOrg.getParent().getId()), selector);
                this.getCurrentOrgTree(list, currentOrg, endOrg, iou, selector);
            }
        }
    }

    protected DefaultKingdeeTreeNode expandCurrentOrg(List currOrgTree, DefaultKingdeeTreeNode node) {
        OrgStructureInfo oui;
        DefaultKingdeeTreeNode sub = null;
        DefaultKingdeeTreeNode res = null;
        if (node != null && (oui = (OrgStructureInfo)node.getUserObject()) != null) {
            String id = oui.getUnit().getId().toString();
            if (id.equals(currOrgTree.get(0))) {
                res = node;
            } else if (currOrgTree.contains(id)) {
                this.treeOrgUnit.expandPath(new TreePath(node.getPath()));
                for (int i = 0; i < node.getChildCount() && (res = this.expandCurrentOrg(currOrgTree, sub = (DefaultKingdeeTreeNode)node.getChildAt(i))) == null; ++i) {
                }
            }
        }
        return res;
    }

    private Map initMap() {
        String resource = "com.kingdee.eas.ma.budget.client.BgFormResource";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("actopen", EASResource.getString((String)resource, (String)"actopen"));
        map.put("actclose", EASResource.getString((String)resource, (String)"actclose"));
        map.put("actopenll", EASResource.getString((String)resource, (String)"actopenll"));
        map.put("actopenall", EASResource.getString((String)resource, (String)"actopenall"));
        map.put("actcloseall", EASResource.getString((String)resource, (String)"actcloseall"));
        return map;
    }

    protected void initTreePopMenu() {
        Map map = this.initMap();
        String resource = "com.kingdee.eas.ma.budget.client.BgFormResource";
        String baseStr = "bgFormR";
        for (int i = 0; i < this.treeOrgUnit.getPopupMenu().getComponentCount(); ++i) {
            if (!(this.treeOrgUnit.getPopupMenu().getComponent(i) instanceof JMenuItem)) continue;
            JMenuItem mItem = (JMenuItem)this.treeOrgUnit.getPopupMenu().getComponent(i);
            String text = null;
            try {
                String key = mItem.getActionCommand();
                if (!map.containsKey(key)) continue;
                text = map.get(key).toString();
                mItem.setText(text);
                continue;
            }
            catch (Exception e) {
                logger.debug((Object)"Read resource error:", (Throwable)e);
            }
        }
        this.treeOrgUnit.addTreePopupMenu(new TreePopupMenuListener(){

            public boolean popMenu(TreePopupMenuEvent event) {
                return BgPredictBaseUI.this.isShowTreePopMenu();
            }
        });
    }

    protected boolean isShowTreePopMenu() {
        return true;
    }

    @Override
    protected void treeOrgUnit_valueChanged(TreeSelectionEvent e) throws Exception {
        if (!this.treeOrgUnit.isEnabled()) {
            return;
        }
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getLastSelectedPathComponent();
        if (node != null) {
            if (OrgViewUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)node)) {
                this.tblMain.removeRows();
                if (this.isInit) {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgSchemeResource", (String)"SelectPermiUnit"));
                    SysUtil.abort();
                }
            } else {
                OrgStructureInfo oui = (OrgStructureInfo)node.getUserObject();
                if (oui != null && oui.getUnit() != null) {
                    this.buildTreeFilter();
                    this.execQuery();
                }
            }
        }
    }

    protected void buildTreeFilter() throws Exception {
        if (this.mainQuery.getFilter() == null) {
            this.mainQuery.setFilter(new FilterInfo());
        }
        EntityViewInfo view = null;
        String cureQueryName = BgPredictBaseUI.getQueryInfo((IMetaDataPK)this.mainQueryPK).getFullName();
        QuerySolutionInfo querySolution = this.getQuerySolutionInterface().getDefaultSolution(this.getMetaDataPK().getFullName(), cureQueryName);
        if (querySolution != null) {
            if (querySolution != null && querySolution.getEntityViewInfo() != null) {
                view = Util.getInnerFilterInfo((QuerySolutionInfo)querySolution);
            } else if (this.getDialog() != null && this.getDialog().getEntityViewInfoResult() != null) {
                view = this.getDialog().getEntityViewInfoResult();
            }
        }
        if (view != null) {
            this.mainQuery = this.getEntityViewInfo(view);
        }
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        try {
            if (this.getPermissionNum() != null && this.getOrgPK(null) != null && !this.permissionOrgMap.containsKey(BOSUuid.read((String)this.getOrgPK(null).toString()))) {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)"1", CompareType.NOTEQUALS));
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)"1", CompareType.EQUALS));
                filter.setMaskString("(#0) and (#1)");
                view.setFilter(filter);
                return super.getQueryExecutor(queryPK, view);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
        }
        return super.getQueryExecutor(queryPK, viewInfo);
    }

    public boolean checkPermissionByOrg(OrgUnitInfo orgUnitInfo) throws BOSException {
        boolean isPermiss = false;
        if (orgUnitInfo == null) {
            return isPermiss;
        }
        UserInfo userInfo = this.getUserInfo();
        if (userInfo == null) {
            return isPermiss;
        }
        String strUserId = userInfo.getId().toString();
        String strOrgId = orgUnitInfo.getId().toString();
        IOrgRange iOrgRange = OrgRangeFactory.getRemoteInstance();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("user".toLowerCase(), (Object)strUserId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("org".toLowerCase(), (Object)strOrgId, CompareType.EQUALS));
        filterInfo.setMaskString("#0 and #1");
        entityViewInfo.setFilter(filterInfo);
        OrgRangeCollection orgRangeCollection = iOrgRange.getOrgRangeCollection(entityViewInfo);
        if (orgRangeCollection.size() > 0) {
            isPermiss = true;
        }
        return isPermiss;
    }

    public void checkIsOnCU(boolean isSelectOrg) throws EASBizException, BOSException {
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return new FilterInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FilterInfo getSelectedQueryFilterInfo(EntityViewInfo viewInfo) {
        FilterInfo filter = this.getDefaultFilterForQuery();
        filter = this.getQueryFilterInfo(filter);
        if (this.permissionOrg == null) {
            this.permissionOrg = new HashSet();
        } else {
            this.permissionOrg.clear();
        }
        FilterItemInfo itemInfo = new FilterItemInfo("orgunit.id".toLowerCase(), (Object)"000000000000000000000000000=", CompareType.EQUALS);
        OrgStructureInfo _oui = null;
        FullOrgUnitInfo _orgUnitInfo = null;
        CostCenterOrgUnitInfo _ccOrgUnitInfo = null;
        IObjectCollection _collection = null;
        ArrayList<FullOrgUnitInfo> list = new ArrayList<FullOrgUnitInfo>();
        try {
            int i;
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getLastSelectedPathComponent();
            if (node != null && !OrgViewUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)node)) {
                _oui = (OrgStructureInfo)node.getUserObject();
                _orgUnitInfo = _oui.getUnit();
                list.add(_orgUnitInfo);
                _collection = BgFacadeFactory.getRemoteInstance().getOrgAllChildren(_orgUnitInfo.getId());
                if (_collection != null && !_collection.isEmpty()) {
                    int in = _collection.size();
                    for (i = 0; i < in; ++i) {
                        _ccOrgUnitInfo = (CostCenterOrgUnitInfo)_collection.getObject(i);
                        if (_ccOrgUnitInfo.isIsSealUp()) continue;
                        _orgUnitInfo = new FullOrgUnitInfo();
                        _orgUnitInfo.setId(_ccOrgUnitInfo.getId());
                        list.add(_orgUnitInfo);
                    }
                    _collection.clear();
                }
            }
            for (i = 0; i < list.size(); ++i) {
                _orgUnitInfo = (FullOrgUnitInfo)list.get(i);
                if (!this.permissionOrgMap.containsKey(_orgUnitInfo.getId())) continue;
                this.permissionOrg.add(_orgUnitInfo.getId().toString());
            }
            if (this.permissionOrg.size() > this.getMaxOrgNumber()) {
                this.getUIContext().put(CHILD_ORG_ERROR, CHILD_ORG_ERROR);
            } else {
                this.getUIContext().remove(CHILD_ORG_ERROR);
                if (!this.permissionOrg.isEmpty()) {
                    itemInfo = new FilterItemInfo("orgunit.id".toLowerCase(), (Object)this.permissionOrg, CompareType.INCLUDE);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"getSelectedQueryFilterInfo", (Throwable)e);
        }
        finally {
            this.replaceFilterItems(filter, itemInfo);
        }
        return filter;
    }

    protected int getMaxOrgNumber() {
        return 200;
    }

    protected FilterInfo getImmSelectedQueryFilterInfo() {
        FilterInfo filter = this.getDefaultFilterForQuery();
        filter = this.getQueryFilterInfo(filter);
        if (this.permissionOrg == null) {
            this.permissionOrg = new HashSet();
        } else {
            this.permissionOrg.clear();
        }
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getLastSelectedPathComponent();
        if (node != null && !OrgViewUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)node)) {
            HashSet<String> orgUnitIdSet = new HashSet<String>();
            OrgStructureInfo _oui = null;
            FullOrgUnitInfo _orgUnitInfo = null;
            DefaultKingdeeTreeNode _node = null;
            _oui = (OrgStructureInfo)node.getUserObject();
            _orgUnitInfo = _oui.getUnit();
            if (this.permissionOrgMap.containsKey(_orgUnitInfo.getId())) {
                orgUnitIdSet.add(_orgUnitInfo.getId().toString());
                this.permissionOrg.add(_orgUnitInfo.getId().toString());
            }
            if (!node.isLeaf()) {
                for (int i = 0; i < node.getChildCount(); ++i) {
                    _node = (DefaultKingdeeTreeNode)node.getChildAt(i);
                    if (_node == null || OrgViewUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)_node) || !this.permissionOrgMap.containsKey((_orgUnitInfo = (_oui = (OrgStructureInfo)_node.getUserObject()).getUnit()).getId())) continue;
                    orgUnitIdSet.add(_orgUnitInfo.getId().toString());
                    this.permissionOrg.add(_orgUnitInfo.getId().toString());
                }
            }
            FilterItemInfo item = null;
            item = orgUnitIdSet.isEmpty() ? new FilterItemInfo("orgunit.id".toLowerCase(), (Object)"000000000000000000000000000=", CompareType.EQUALS) : new FilterItemInfo("orgunit.id".toLowerCase(), orgUnitIdSet, CompareType.INCLUDE);
            this.replaceFilterItems(filter, item);
        }
        return filter;
    }

    protected FilterInfo getUnSelectedQueryFilterInfo(EntityViewInfo viewInfo) {
        FilterInfo filter = this.getDefaultFilterForQuery();
        filter = this.getQueryFilterInfo(filter);
        if (this.permissionOrg == null) {
            this.permissionOrg = new HashSet();
        } else {
            this.permissionOrg.clear();
        }
        String billId = this.getOrgUnitId();
        if (billId != null && this.permissionOrgMap.containsKey(BOSUuid.read((String)this.getOrgUnitId()))) {
            this.permissionOrg.add(this.getOrgUnitId());
        }
        FilterItemInfo item = null;
        item = this.permissionOrg.isEmpty() ? new FilterItemInfo("orgunit.id".toLowerCase(), (Object)"000000000000000000000000000=", CompareType.EQUALS) : new FilterItemInfo("orgunit.id".toLowerCase(), (Object)this.getOrgUnitId(), CompareType.EQUALS);
        this.replaceFilterItems(filter, item);
        return filter;
    }

    protected FilterInfo getQueryFilterInfo(FilterInfo filter) {
        if (filter == null) {
            filter = this.getDefaultFilterForQuery();
        }
        EntityViewInfo tmpView = null;
        if (this.getDialog() != null) {
            try {
                tmpView = this.getEntityViewInfo(this.getDialog().getEntityViewInfoResult());
            }
            catch (BOSException ex) {
                logger.error((Object)ex);
            }
            if ((tmpView == null || tmpView.getFilter() == null) && this.getDialog().getCurrentSolutionInfo() != null) {
                if (tmpView == null) {
                    tmpView = new EntityViewInfo();
                }
                try {
                    tmpView.decode(this.getDialog().getCurrentSolutionInfo().getEntityViewInfo());
                }
                catch (Exception ex) {
                    logger.error((Object)this.getDialog().getCurrentSolutionInfo().getEntityViewInfo());
                    logger.error((Object)ex);
                }
            }
        } else {
            tmpView = this.getDefaultEntityViewInfo();
        }
        if (tmpView != null && tmpView.getFilter() != null && tmpView.getFilter().getFilterItems() != null && !tmpView.getFilter().getFilterItems().isEmpty()) {
            filter.getFilterItems().addObjectCollection((IObjectCollection)tmpView.getFilter().getFilterItems());
            if (!StringUtils.isEmpty((String)tmpView.getFilter().getMaskString())) {
                filter.setMaskString("(" + tmpView.getFilter().getMaskString() + ")");
            } else {
                int size = filter.getFilterItems().size();
                if (size <= 1) {
                    filter.setMaskString("#0");
                } else {
                    StringBuffer str = new StringBuffer("#0");
                    int in = size;
                    for (int i = 1; i < in; ++i) {
                        str.append(" and #").append(i);
                    }
                }
            }
        }
        return filter;
    }

    protected final void replaceFilterItems(FilterInfo filter, FilterItemCollection items) {
        if (filter == null || items == null) {
            return;
        }
        if (!items.isEmpty()) {
            Iterator iter = items.iterator();
            while (iter.hasNext()) {
                this.replaceFilterItems(filter, (FilterItemInfo)iter.next());
            }
        }
    }

    protected final void replaceFilterItems(FilterInfo filter, FilterItemInfo item) {
        if (filter == null || item == null) {
            return;
        }
        boolean isReplace = false;
        if (filter.getFilterItems() != null) {
            FilterItemInfo fiInfo = null;
            FilterItemCollection fiCol = filter.getFilterItems();
            int n = fiCol.size();
            for (int i = 0; i < n; ++i) {
                fiInfo = fiCol.get(i);
                if (!fiInfo.getPropertyName().trim().equals(item.getPropertyName().trim())) continue;
                fiInfo.setCompareType(item.getCompareType());
                fiInfo.setCompareValue(item.getCompareValue());
                isReplace = true;
            }
            if (!isReplace) {
                fiCol.add(item);
                int itemsSize = fiCol.size();
                if (itemsSize <= 1) {
                    filter.setMaskString("(#0)");
                } else {
                    filter.setMaskString(filter.getMaskString() + " and (#" + String.valueOf(itemsSize - 1) + ")");
                }
            }
        }
    }

    protected void addFilterItem(FilterInfo filter, FilterItemInfo item) {
        if (filter == null || item == null) {
            return;
        }
        if (filter.getFilterItems() != null) {
            FilterItemCollection fiCol = filter.getFilterItems();
            fiCol.add(item);
            int itemsSize = fiCol.size();
            if (itemsSize <= 1) {
                filter.setMaskString("(#0)");
            } else {
                filter.setMaskString(filter.getMaskString() + " and (#" + String.valueOf(itemsSize - 1) + ")");
            }
        }
    }

    protected void addBgTypeFilterItem(FilterInfo filter, Object objType) {
        if (filter == null) {
            return;
        }
        String typeNumber = null;
        if (objType instanceof BgTypeInfo) {
            BgTypeInfo bgTemGroupInfo = (BgTypeInfo)objType;
            typeNumber = bgTemGroupInfo.getNumber();
        } else if (objType instanceof String) {
            typeNumber = (String)objType;
        }
        if (filter == null || typeNumber == null || typeNumber.trim().equals("")) {
            return;
        }
        if (filter.getFilterItems() != null) {
            FilterItemCollection fiCol = filter.getFilterItems();
            int oldSize = fiCol.size();
            fiCol.add(new FilterItemInfo("bgType.number", (Object)typeNumber, CompareType.EQUALS));
            fiCol.add(new FilterItemInfo("bgType.number", (Object)(typeNumber + ".%"), CompareType.LIKE));
            String numberMask = "((#" + oldSize + ") or (#" + (oldSize + 1) + "))";
            if (oldSize == 0) {
                filter.setMaskString(numberMask);
            } else {
                String oldMaskString = filter.getMaskString();
                if (StringUtils.isEmpty((String)oldMaskString)) {
                    StringBuffer temp = new StringBuffer();
                    for (int i = 0; i < oldSize - 1; ++i) {
                        temp.append("#").append(i).append(" and ");
                    }
                    temp.append("#").append(oldSize - 1);
                    oldMaskString = temp.toString();
                }
                filter.setMaskString("( " + oldMaskString + " ) and " + numberMask);
            }
        }
    }

    @Override
    protected void rbCurrOrgUnit_actionPerformed(ActionEvent e) throws Exception {
        if (this.rbCurrOrgUnit.isSelected()) {
            this.tblMain.refresh();
            this.tblMain.getColumn("OrgUnit.name").getStyleAttributes().setHided(true);
        }
    }

    @Override
    protected void rbImmOrgUnit_actionPerformed(ActionEvent e) throws Exception {
        if (this.rbImmOrgUnit.isSelected()) {
            this.tblMain.refresh();
            this.tblMain.getColumn("OrgUnit.name").getStyleAttributes().setHided(false);
        }
    }

    @Override
    protected void rbAllOrgUnit_actionPerformed(ActionEvent e) throws Exception {
        if (this.rbAllOrgUnit.isSelected()) {
            this.tblMain.refresh();
            this.tblMain.getColumn("OrgUnit.name").getStyleAttributes().setHided(false);
        }
    }

    @Override
    public void actionViewFlow_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewFlow_actionPerformed(e);
        this.checkSelected();
        BgClientHelper.viewFlow((Component)((Object)this), (String)this.getSelectedKeyValue());
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.buildTreeFilter();
    }

    public boolean checkSelectedKeyValue(String billId) {
        if (StringUtils.isEmpty((String)billId)) {
            return true;
        }
        return this.useIds.contains(billId);
    }

    public void addSelectedKeyValue(String billId) {
        if (!StringUtils.isEmpty((String)billId)) {
            this.useIds.add(billId);
        }
    }

    public void removeSelectKeyValue(String billId) {
        if (!StringUtils.isEmpty((String)billId)) {
            this.useIds.remove(billId);
        }
    }

    public boolean destroyWindow() {
        boolean re = super.destroyWindow();
        if (re) {
            // empty if block
        }
        return re;
    }

    public Set getPermissionOrg() {
        return this.permissionOrg;
    }

    public void setPermissionOrg(Set permissionOrg) {
        this.permissionOrg = permissionOrg;
    }

    protected boolean checkReport(String bgFormId) throws Exception {
        if (StringUtils.isEmpty((String)bgFormId)) {
            return false;
        }
        ArrayList<String> _bgFormIds = new ArrayList<String>();
        _bgFormIds.add(bgFormId);
        return this.checkReport(_bgFormIds);
    }

    protected boolean checkReport(List bgFormIds) throws Exception {
        if (bgFormIds == null || bgFormIds.isEmpty()) {
            return false;
        }
        BOSUuid[] _bosUuids = new BOSUuid[bgFormIds.size()];
        int in = bgFormIds.size();
        for (int i = 0; i < in; ++i) {
            _bosUuids[i] = BOSUuid.read((String)bgFormIds.get(i).toString());
        }
        return this.checkReport(_bosUuids);
    }

    protected boolean checkReport(BOSUuid[] bgFormIds) throws Exception {
        List nopass;
        if (bgFormIds == null || bgFormIds.length == 0) {
            return false;
        }
        boolean isCheck = true;
        List check = this.getFormInterface().reportCheck(bgFormIds);
        if (Boolean.TRUE.equals(check.get(0))) {
            return isCheck;
        }
        if (Boolean.FALSE.equals(check.get(0))) {
            isCheck = false;
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"String", (Object)check.get(3).toString());
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create("com.kingdee.eas.fi.gr.cslrpt.client.ShowEditorPanelUI", (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        }
        if (check.size() >= 3 && check.get(2) != null && (nopass = (List)check.get(2)).size() > 0) {
            isCheck = false;
            MsgBox.showWarning((String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.budget.client.BgFormResource", "ReportCheckError"));
        }
        return isCheck;
    }

    protected BOSUuid[] getUuids(List ids) throws Exception {
        if (ids == null || ids.isEmpty()) {
            return null;
        }
        BOSUuid[] _uuids = new BOSUuid[ids.size()];
        try {
            int in = ids.size();
            for (int i = 0; i < in; ++i) {
                _uuids[i] = BOSUuid.read((String)ids.get(i).toString());
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            _uuids = null;
        }
        return _uuids;
    }

    public String getPermissionNum() {
        return this.permissionNum;
    }

    public void setPermissionNum(String permissionNum) {
        this.permissionNum = permissionNum;
    }

    protected String getMessageStr(String key) {
        return !StringUtils.isEmpty((String)key) ? EASResource.getString((String)"com.kingdee.eas.ma.nbudget.client.BgNFormResource", (String)key) : "";
    }

    protected String getMessageStr(String resource, String key) {
        return !StringUtils.isEmpty((String)resource) && !StringUtils.isEmpty((String)key) ? EASResource.getString((String)resource, (String)key) : "";
    }

    protected void actionBatchGather() throws Exception {
        this.checkOrgUnitDisable();
        this.checkIsOnCU(true);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ORGUNIT_CU", (Object)this.getOrgUnitId());
        uiContext.put((Object)"selfPanelUiName", (Object)BgSubOrgUnitSelectUIForBatchGather.class.getName());
        this.prepareGatherContext(uiContext);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(AssignSolutionUI.class.getName(), (Map)uiContext);
        uiWindow.show();
        Map solution = (Map)((AssignSolutionUI)uiWindow.getUIObject()).getReturnData();
        if (solution == null || solution.isEmpty()) {
            return;
        }
        Object[] bgFormIds = (Object[])solution.get("GATHER_BGFORM");
        HashSet<Object> ids = new HashSet<Object>();
        for (int i = 0; i < bgFormIds.length; ++i) {
            ids.add(bgFormIds[i]);
        }
        EntityViewInfo view = new EntityViewInfo("order by number");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection selector = BgGatherHelper.getSimpleSelectors();
        selector.add(new SelectorItemInfo("bgTemplate.formType"));
        view.setSelector(selector);
        BgFormCollection bgForms = BgFormFactory.getRemoteInstance().getBgFormCollection(view);
        Map parameter = this.getGatherParameter(solution);
        parameter.put("GATHER_IS_BUDGET", solution.get("GATHER_IS_BUDGET"));
        Set orgUnits = this.getGatherOrgUnits(solution);
        Map result = this.getGatherInterface().checkBatchGatherInfo(bgFormIds, orgUnits, parameter);
        int re = 0;
        if (this.isGatherShowMsg(solution) && this.isNeedShowDetail(result)) {
            this.createDetailUI4BatchGather(result, orgUnits, bgForms);
            re = MsgBox.showConfirm2((Component)((Object)this), (String)this.getMessageStr("com.kingdee.eas.ma.budget.client.BgFormResource", "isContinue4Gather"));
        }
        if (re == 0) {
            this.beginProcessBatchGather(result, parameter, bgForms);
        }
    }

    protected boolean isNeedShowDetail(Map result) {
        if (result != null && result.size() > 0) {
            for (Map map : result.values()) {
                Map map1;
                if (map == null || !map.containsKey("GATHER_CHECK_CANT_ORGUNIT") || (map1 = (Map)map.get("GATHER_CHECK_CANT_ORGUNIT")) == null || map1.size() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    protected void beginProcessBatchGather(Map result, Map parameter, BgFormCollection bgForms) throws UIException {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ProgressDialogUI.class.getName(), (Map)uiContext);
        if (window != null && window.getUIObject() instanceof ProgressDialogUI) {
            ProgressDialogUI ui = (ProgressDialogUI)window.getUIObject();
            ui.setShowTableMessage(true);
            int paramCount = 4;
            Class[] cla = new Class[paramCount];
            cla[0] = BgFormInfo.class;
            cla[1] = Map.class;
            cla[2] = Map.class;
            cla[3] = BgFormInfo.class;
            ui.setUITitle(BgGatherHelper.getMsg((String)"batchGatherTitle"));
            ui.setInvokeClass(BgGatherHelper.class.getName());
            ui.setInvokeMethod("invokeMethod4Batch");
            ui.setInvokeMethodParmeterType(cla);
            Vector<Object[]> vecPrameterValue = new Vector<Object[]>();
            Map subResult = null;
            BgFormInfo bgForm = null;
            Object[] objOld = null;
            Object[] objNew = new Object[paramCount];
            for (String key : result.keySet()) {
                subResult = (Map)result.get(key);
                bgForm = BgGatherHelper.getInfoFromCol((BgFormCollection)bgForms, (String)key);
                if (objOld != null) {
                    objNew = new Object[paramCount];
                    objNew[0] = objOld[0];
                    objNew[1] = objOld[1];
                    objNew[2] = parameter;
                    objNew[3] = bgForm;
                    objOld = new Object[paramCount];
                    objOld[0] = bgForm;
                    objOld[1] = subResult;
                    objOld[2] = parameter;
                } else {
                    objOld = new Object[paramCount];
                    objOld[0] = bgForm;
                    objOld[1] = subResult;
                    objOld[2] = parameter;
                    objNew = new Object[paramCount];
                    objNew[0] = null;
                    objNew[1] = subResult;
                    objNew[2] = parameter;
                    objNew[3] = bgForm;
                }
                vecPrameterValue.add(objNew);
            }
            if (objOld != null) {
                objNew = new Object[paramCount];
                objNew[0] = objOld[0];
                objNew[1] = objOld[1];
                objNew[2] = objOld[2];
                objNew[3] = bgForm;
                vecPrameterValue.add(objNew);
            }
            int size = vecPrameterValue.size();
            int objNewlength = objNew.length;
            Object[][] valueMethod = new Object[size][objNewlength];
            for (int i = 0; i < size; ++i) {
                Object[] obj = (Object[])vecPrameterValue.get(i);
                for (int j = 0; j < objNewlength; ++j) {
                    valueMethod[i][j] = obj[j];
                }
            }
            ui.setInvokeMethodParmeterValue(valueMethod);
            ui.setCountSum(vecPrameterValue.size() - 1);
            ui.init();
            window.show();
        }
    }

    private void createDetailUI4BatchGather(Map map, Set orgUnits, BgFormCollection bgForms) throws UIException {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"Owner", (Object)this);
        uiContext.put((Object)"listInfo", (Object)map);
        uiContext.put((Object)"GATHER_ORGUNIT", (Object)orgUnits);
        uiContext.put((Object)"GATHER_BGFORM", (Object)bgForms);
        IUIFactory uiFactory = null;
        uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow curDialog = uiFactory.create(BgNFAfterBatchGatherUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        curDialog.show();
    }

    private void creatDetailUI(Map map) throws UIException {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"Owner", (Object)this);
        uiContext.put((Object)"listInfo", (Object)map);
        IUIFactory uiFactory = null;
        uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow curDialog = uiFactory.create(BgNFAfterGatherUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        curDialog.show();
    }

    private boolean isFixedForm(BizEnumValueInfo enumInfo) {
        return enumInfo != null && enumInfo.getInt() == 0;
    }

    protected String getSelectGatherBillId() {
        return this.getSelectedKeyValue();
    }

    protected String getGatherBillId(String billId) {
        return billId;
    }

    protected void prepareGatherContext(UIContext uiContext) {
    }

    protected Set getGatherOrgUnits(Map solution) {
        return (Set)solution.get("GATHER_ORGUNIT");
    }

    protected Map getGatherParameter(Map solution) {
        HashMap<String, Boolean> parameter = new HashMap<String, Boolean>();
        parameter.put("GATHER_TYPE", new Boolean(this.isBudgetData()));
        parameter.put("GATHER_CELL", (Boolean)solution.get("GATHER_CELL"));
        parameter.put("GATHER_FORMULA", (Boolean)solution.get("GATHER_FORMULA"));
        parameter.put("GATHER_ENUMERATE", (Boolean)solution.get("GATHER_ENUMERATE"));
        parameter.put("GATHER_TMPDATA", (Boolean)solution.get("GATHER_TMPDATA"));
        parameter.put("GATHER_SHEET", (Boolean)solution.get("GATHER_SHEET"));
        if (((Boolean)solution.get("GATHER_SHEET")).booleanValue()) {
            parameter.put("GATHER_SHEET_ID", (Boolean)solution.get("GATHER_SHEET_ID"));
        }
        parameter.put("GATHER_SORT", (Boolean)solution.get("GATHER_SORT"));
        parameter.put("GATHER_CLEAR_FORMULA", (Boolean)solution.get("GATHER_CLEAR_FORMULA"));
        parameter.put("GATHER_SCHEME_FORMULA", (Boolean)solution.get("GATHER_SCHEME_FORMULA"));
        return parameter;
    }

    protected boolean isBudgetData() {
        return true;
    }

    protected boolean isGatherShowMsg(Map solution) {
        return (Boolean)solution.get("GATHER_SHOW_MSG");
    }

    protected boolean isGatherType(BizEnumValueInfo enumInfo) {
        return enumInfo != null && enumInfo.getInt() == 1;
    }

    protected String getGatherCantOrgMessage(Map gatherCantOrgMap) {
        int maxIndex;
        String _orgId = null;
        String _orgName = null;
        StringBuffer msg = new StringBuffer();
        int index = 0;
        int size = gatherCantOrgMap.size();
        size = size > (maxIndex = 15) ? (size = maxIndex) : size;
        Iterator iter = gatherCantOrgMap.keySet().iterator();
        while (iter.hasNext()) {
            if (index > size) {
                msg.delete(msg.length() - 1, msg.length());
                msg.append("..." + gatherCantOrgMap.size() + BgNFCHelper.getMessageStr("entries") + " ");
                break;
            }
            _orgId = (String)iter.next();
            _orgName = (String)gatherCantOrgMap.get(_orgId);
            msg.append(_orgName.trim() + "\u3001");
            ++index;
        }
        msg.delete(msg.length() - 1, msg.length());
        msg.append(BgNFCHelper.getMessageStr("gatherMsg"));
        return msg.toString();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkOrgUnitDisable();
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkOrgUnitDisable();
        super.actionRemove_actionPerformed(e);
    }

    protected void checkSelOrgUnit() {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getLastSelectedPathComponent();
        if (node == null) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u8282\u70b9\u3002");
            SysUtil.abort();
        }
    }

    protected boolean checkOrgUnitDisable(DefaultKingdeeTreeNode node) {
        OrgStructureInfo oui;
        DefaultKingdeeTreeNode _node = null;
        FullOrgUnitInfo orgInfo = null;
        _node = node == null ? (DefaultKingdeeTreeNode)this.treeOrgUnit.getLastSelectedPathComponent() : node;
        if (_node != null && !OrgViewUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)_node) && (oui = (OrgStructureInfo)_node.getUserObject()) != null && oui.getUnit() != null) {
            orgInfo = oui.getUnit();
            try {
                orgInfo = this.getFullOrgUnitInterface().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgInfo.getId()));
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
            return orgInfo.isIsOUSealUp();
        }
        return false;
    }

    protected void checkOrgUnitDisable() {
        if (this.checkOrgUnitDisable(null)) {
            MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.budget.client.BgFormResource", "orgUnitDisable"));
            SysUtil.abort();
        }
    }

    protected void enableAction(JButton button, JMenuItem menuItem, Action action) {
        this.setAction(button, menuItem, action, true);
    }

    protected void disableAction(JButton button, JMenuItem menuItem, Action action) {
        this.setAction(button, menuItem, action, false);
    }

    private void setAction(JButton button, JMenuItem menuItem, Action action, boolean enabled) {
        if (button != null) {
            button.setEnabled(enabled);
        }
        if (menuItem != null) {
            menuItem.setEnabled(enabled);
        }
        if (action != null) {
            action.setEnabled(enabled);
        }
    }

    protected void setEnableAction(Action action, JButton button, JMenuItem menu) {
        if (action != null) {
            action.setEnabled(true);
        }
        if (button != null) {
            button.setEnabled(true);
        }
        if (menu != null) {
            menu.setEnabled(true);
        }
    }

    protected void setDisableAction(Action action, JButton button, JMenuItem menu) {
        if (action != null) {
            action.setEnabled(false);
        }
        if (button != null) {
            button.setEnabled(false);
        }
        if (menu != null) {
            menu.setEnabled(false);
        }
    }

    protected void disableVisible(JButton button, JMenuItem menuItem) {
        this.setVisible(button, menuItem, false);
    }

    protected void enableVisible(JButton button, JMenuItem menuItem) {
        this.setVisible(button, menuItem, true);
    }

    protected void setVisible(JButton button, JMenuItem menu, boolean visible) {
        if (button != null) {
            button.setVisible(visible);
        }
        if (menu != null) {
            menu.setVisible(visible);
        }
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        if (handler != null) {
            RequestContext request = (RequestContext)handler.getRequestContext();
            request.put("USER_ID", (Object)this.getUserInfo().getId().toString());
            request.put("ORGUNIT_CU", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
            request.put("PERMISSION_NUM", (Object)this.getPermissionNum());
        }
        return handler;
    }

    public boolean isPrepareDestoryWindow() {
        return true;
    }

    protected boolean isUseForElim() {
        return false;
    }

    protected boolean isOnlyShowGroup() {
        return false;
    }
}

