/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.core.ICellDisplayProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.newrpt.client.designer.render.IRenderProvider;
import com.kingdee.eas.framework.util.UIConfigUtility;
import com.kingdee.eas.ma.budget.BgFormCollection;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.budget.BgTemplateFactory;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.IBgTemplate;
import com.kingdee.eas.ma.budget.client.BgEnumerateRender;
import com.kingdee.eas.ma.budget.client.LongTimeDialog;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgPredictFormDataCollection;
import com.kingdee.eas.ma.nbudget.BgPredictFormDataFactory;
import com.kingdee.eas.ma.nbudget.BgPredictFormDataInfo;
import com.kingdee.eas.ma.nbudget.BgPredictFormRecordFactory;
import com.kingdee.eas.ma.nbudget.BgPredictFormRecordInfo;
import com.kingdee.eas.ma.nbudget.BgPredictFormlistFacadeFactory;
import com.kingdee.eas.ma.nbudget.BudgetDisplayValueProvider;
import com.kingdee.eas.ma.nbudget.IBgPredictFormData;
import com.kingdee.eas.ma.nbudget.IBgPredictFormRecord;
import com.kingdee.eas.ma.nbudget.client.AbstractBgPredictFormProcessUI;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.ma.nbudget.client.BgPredictDataMakeResultUI;
import com.kingdee.eas.ma.nbudget.client.BgUserCellDisplayProvider;
import com.kingdee.eas.ma.nbudget.client.UserItemRenderProvider;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class BgPredictFormProcessUI
extends AbstractBgPredictFormProcessUI {
    private static final long serialVersionUID = -6815006965908355270L;
    private static final Logger logger = CoreUIObject.getLogger(BgPredictFormProcessUI.class);
    private int Ftype = 0;
    private IObjectValue value = null;
    private Map currencyMap = new HashMap();
    private Map formulaMap = new HashMap();
    private Map measureUnitMap = new HashMap();

    protected void initToolbar() {
        this.setPreferredSize(null);
        this.setLayout(new BorderLayout());
        this.add((Component)this.getSpreadManager().getSpreadContainer(), "Center");
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.menuItemXD.setIcon(EASResource.getIcon((String)"imgTbtn_makeknown"));
    }

    public String getTitle() {
        Object obj = this.getUIContext().get("PredictDataTable");
        return this.getBgPredictDataTitle() + (obj != null ? obj.toString() : "");
    }

    private SelectorItemCollection getBgFormSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("createTime");
        sic.add("creator.id");
        sic.add("creator.name");
        sic.add("lastUpdateTime");
        sic.add("lastUpdateUser.id");
        sic.add("lastUpdateUser.name");
        sic.add("state");
        sic.add("auditedStatus");
        sic.add("dataSource");
        sic.add("description");
        sic.add("versionNo");
        sic.add("startDate");
        sic.add("endDate");
        sic.add("data");
        sic.add("orgUnit.id");
        sic.add("orgUnit.name");
        sic.add("orgUnit.number");
        sic.add("company.id");
        sic.add("company.name");
        sic.add("company.number");
        sic.add("company.isBizUnit");
        sic.add("company.accountPeriodType.id");
        sic.add("CU.id");
        sic.add("CU.name");
        sic.add("bgType.id");
        sic.add("bgType.name");
        sic.add("bgType.number");
        sic.add("bgScheme.id");
        sic.add("bgScheme.name");
        sic.add("bgScheme.number");
        sic.add("bgScheme.period");
        sic.add("bgScheme.rootId");
        sic.add("bgScheme.isFormal");
        sic.add("bgTemplate.id");
        sic.add("bgTemplate.name");
        sic.add("bgTemplate.number");
        sic.add("bgTemplate.canModify");
        sic.add("bgTemplate.parent.id");
        sic.add("bgTemplate.rootId");
        sic.add("bgTemplate.formType");
        sic.add("bgPeriod.id");
        sic.add("bgPeriod.name");
        sic.add("bgPeriod.number");
        sic.add("bgPeriod.periodType");
        sic.add("bgPeriod.beginDate");
        sic.add("bgPeriod.endDate");
        sic.add("bgPeriod.year");
        sic.add("bgPeriod.halfYear");
        sic.add("bgPeriod.quarter");
        sic.add("bgPeriod.month");
        sic.add("bgPeriod.week");
        sic.add("periodType");
        sic.add("currency.id");
        sic.add("currency.name");
        sic.add("currency.number");
        sic.add("currency.isoCode");
        sic.add("currency.precision");
        sic.add("measureUnit.id");
        sic.add("measureUnit.name");
        sic.add("measureUnit.number");
        sic.add("measureUnit.coefficient");
        sic.add("bgMeasureUnit.id");
        sic.add("bgMeasureUnit.bgElement.id");
        sic.add("bgMeasureUnit.bgElement.name");
        sic.add("bgMeasureUnit.bgElement.number");
        sic.add("bgMeasureUnit.measureUnit.id");
        sic.add("bgMeasureUnit.measureUnit.name");
        sic.add("bgMeasureUnit.measureUnit.number");
        sic.add("bgMeasureUnit.measureUnit.coefficient");
        return sic;
    }

    private SelectorItemCollection getTemplateSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("createTime");
        sic.add("creator.id");
        sic.add("creator.name");
        sic.add("lastUpdateTime");
        sic.add("lastUpdateUser.id");
        sic.add("lastUpdateUser.name");
        sic.add("isAllowChange");
        sic.add("data");
        sic.add("orgUnit.id");
        sic.add("orgUnit.name");
        sic.add("orgUnit.number");
        sic.add("bgType.id");
        sic.add("bgType.name");
        sic.add("bgType.number");
        sic.add("bgMeasureUnit.id");
        sic.add("bgMeasureUnit.bgTemplate.id");
        sic.add("bgMeasureUnit.bgElement.id");
        sic.add("bgMeasureUnit.bgElement.name");
        sic.add("bgMeasureUnit.bgElement.number");
        sic.add("bgMeasureUnit.measureUnit.id");
        sic.add("bgMeasureUnit.measureUnit.name");
        sic.add("bgMeasureUnit.measureUnit.number");
        sic.add("bgMeasureUnit.measureUnit.coefficient");
        sic.add("defaultMeasureUnit.id");
        sic.add("defaultMeasureUnit.name");
        sic.add("defaultMeasureUnit.number");
        sic.add("defaultMeasureUnit.coefficient");
        sic.add("parent.id");
        sic.add("rootId");
        return sic;
    }

    public void onLoad() throws Exception {
        Book book = null;
        String id = (String)this.getUIContext().get("PredictID");
        IBgPredictFormRecord ibgPredictFormRecord = BgPredictFormRecordFactory.getRemoteInstance();
        BgPredictFormRecordInfo bgPredictFormRecord = ibgPredictFormRecord.getBgPredictFormRecordInfo((IObjectPK)new ObjectUuidPK(id));
        this.initCurrencyInfo();
        IBgForm ibgForm = BgFormFactory.getRemoteInstance();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)bgPredictFormRecord.getOrgUnit().getId()));
        filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgPredictFormRecord.getBgScheme().getId()));
        filter.getFilterItems().add(new FilterItemInfo("bgTemplate.id", (Object)bgPredictFormRecord.getBgTemplate().getId()));
        filter.getFilterItems().add(new FilterItemInfo("bgPeriod.id", (Object)bgPredictFormRecord.getBgPeriod().getId()));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)bgPredictFormRecord.getCurrency().getId()));
        view.getSelector().addObjectCollection((IObjectCollection)this.getBgFormSelectors());
        BgFormCollection bgFormCollection = ibgForm.getBgFormCollection(view);
        if (bgFormCollection != null && bgFormCollection.size() > 0) {
            BgFormInfo formInfo = bgFormCollection.get(0);
            this.value = formInfo;
            this.getMeasureUnitMap().putAll(BgNFSHelper.getMeasureUnitMap(formInfo));
            book = formInfo.getBook();
            this.transBookAndFillValue(book, false, bgPredictFormRecord);
        } else {
            IBgTemplate ibgTemplate = BgTemplateFactory.getRemoteInstance();
            BgTemplateInfo bgtemplateinfo = ibgTemplate.getBgTemplateInfo((IObjectPK)new ObjectUuidPK(bgPredictFormRecord.getBgTemplate().getId()), this.getTemplateSelectors());
            this.value = bgtemplateinfo;
            this.getMeasureUnitMap().putAll(BgNFSHelper.getMeasureUnitMap(bgtemplateinfo));
            book = bgtemplateinfo.getBook();
            this.transBookAndFillValue(book, true, bgPredictFormRecord);
        }
        book.setAutoCalculate(false);
        book.setCalculate(false);
        this.getSpreadManager().getSpreadContainer().setBook(book);
        this.getSpreadManager().getSpreadContainer().getSpread().repaint();
        BgNFSHelper.setLockOfBook(book, true);
        this.getSpreadManager().registerCellDisplayProvider((ICellDisplayProvider)this.getCellDisplayRender());
        this.menuItemExitCurrent.setIcon(EASResource.getIcon((String)"imgTbtn_quit"));
        this.menuItemXD.setIcon(EASResource.getIcon((String)"imgTbtn_makeknown"));
    }

    private BgUserCellDisplayProvider getCellDisplayRender() {
        BgUserCellDisplayProvider render = new BgUserCellDisplayProvider();
        render.setDisplayValueProvider(new BudgetDisplayValueProvider((Component)((Object)this)));
        BgUserCellDisplayProvider.addRenderProvider((IRenderProvider)new UserItemRenderProvider());
        BgUserCellDisplayProvider.addRenderProvider((IRenderProvider)new BgEnumerateRender());
        return render;
    }

    public IObjectValue getEditData() {
        return this.value;
    }

    protected void initCurrencyInfo() throws Exception {
        CurrencyInfo currencyInfo2 = null;
        CurrencyCollection currencyCol = this.getCurrencyInterface().getCurrencyCollection();
        if (currencyCol != null && !currencyCol.isEmpty()) {
            for (CurrencyInfo currencyInfo2 : currencyCol) {
                this.getCurrencyMap().put(currencyInfo2.getNumber(), currencyInfo2);
            }
        }
    }

    public ICurrency getCurrencyInterface() throws Exception {
        return CurrencyFactory.getRemoteInstance();
    }

    public Map getCurrencyMap() {
        return this.currencyMap;
    }

    public Map getFormulaMap() {
        return null;
    }

    public Map getMeasureUnitMap() {
        return this.measureUnitMap;
    }

    protected void transBookAndFillValue(Book book, boolean isTrans, BgPredictFormRecordInfo recordInfo) throws BOSException, EASBizException {
        if (book == null) {
            return;
        }
        Sheet _sheet = null;
        Cell _cell = null;
        String _formulaStr = null;
        String[] _formulaParam = null;
        boolean _isTrans = false;
        HashMap<String, BigDecimal> _formulaMap = new HashMap<String, BigDecimal>();
        BgPeriodInfo periodInfo = null;
        CurrencyInfo currencyInfo = null;
        if (isTrans) {
            periodInfo = BgPeriodFactory.getRemoteInstance().getBgPeriodInfo((IObjectPK)new ObjectUuidPK(recordInfo.getBgPeriod().getId()));
            currencyInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(recordInfo.getCurrency().getId()));
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("BgPredict.id", (Object)recordInfo.getBgPredict().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)recordInfo.getOrgUnit().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)recordInfo.getBgScheme().getId()));
        filter.getFilterItems().add(new FilterItemInfo("Type", (Object)recordInfo.getType().getValue()));
        view.setFilter(filter);
        IBgPredictFormData ibgPredictFormData = BgPredictFormDataFactory.getRemoteInstance();
        BgPredictFormDataCollection bgFormDataCollection = ibgPredictFormData.getBgPredictFormDataCollection(view);
        BgPredictFormDataInfo dataInfo = null;
        if (bgFormDataCollection != null) {
            int in = bgFormDataCollection.size();
            for (int i = 0; i < in; ++i) {
                dataInfo = bgFormDataCollection.get(i);
                _formulaMap.put(dataInfo.getFormula(), dataInfo.getValue());
            }
        }
        int sheetCount = book.getSheetCount();
        for (int sheetIndex = 0; sheetIndex < sheetCount; ++sheetIndex) {
            _sheet = book.getSheet(sheetIndex);
            int rowCount = _sheet.getMaxRowIndex();
            int colCount = _sheet.getMaxColIndex();
            for (int rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                for (int colIndex = 0; colIndex <= colCount; ++colIndex) {
                    _cell = _sheet.getCell(rowIndex, colIndex, false);
                    if (!BgNFSHelper.checkHasFormulaOfCell(_cell)) continue;
                    _formulaStr = BgNFSHelper.getFormulaOfCell(_cell);
                    if (isTrans) {
                        _formulaParam = BgNFSHelper.parseFormulaPara(_formulaStr);
                        _isTrans = false;
                        if (periodInfo != null) {
                            if (StringUtils.isEmpty((String)_formulaParam[1])) {
                                _formulaParam[1] = periodInfo.getNumber();
                                _isTrans = true;
                            } else {
                                String _tmpPeriod = BgPeriodNVariableHelper.getBgPeriodByN((String)periodInfo.getNumber(), (String)_formulaParam[1], (int)periodInfo.getPeriodType().getValue());
                                if (_tmpPeriod != null && !_formulaParam[1].equals(_tmpPeriod)) {
                                    _formulaParam[1] = _tmpPeriod;
                                    _isTrans = true;
                                }
                            }
                        }
                        if (StringUtils.isEmpty((String)_formulaParam[5]) && currencyInfo != null) {
                            _formulaParam[5] = currencyInfo.getNumber();
                            _isTrans = true;
                        }
                        if (_isTrans) {
                            _formulaStr = BgNFSHelper.getFormulaFromParam(_formulaParam);
                            BgNFSHelper.setFormulaOfCell(_cell, _formulaStr);
                            BgNFSHelper.setEditFormulaOfCell(_cell, false);
                        }
                    }
                    if (!_formulaMap.containsKey(_formulaStr)) continue;
                    BgNFSHelper.setValue(_cell, _formulaMap.get(_formulaStr));
                }
            }
        }
    }

    public void onShow() {
        this.setUITitle(this.getTitle());
    }

    protected String getBgPredictDataTitle() {
        StringBuffer title = new StringBuffer();
        title.append(BgNFCHelper.getMessageStr("Title")).append(" - ").append(BgNFCHelper.getMessageStr(this.getOprtState())).append(" - ");
        return title.toString();
    }

    @Override
    public void actionXD_actionPerformed(ActionEvent e) throws Exception {
        final HashMap<String, String> map = new HashMap<String, String>();
        String BgPreidctFormRecordIDS = this.getUIContext().get("PredictID").toString();
        if (BgPreidctFormRecordIDS != null) {
            map.put("BgPreidctFormRecordIDS", BgPreidctFormRecordIDS);
            int re = MsgBox.showConfirm2((String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.BgPredictItemResource", "isMake"));
            if (re == 1 || re == 2) {
                return;
            }
            LongTimeDialog dialog = null;
            Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
            if (win instanceof Frame) {
                dialog = new LongTimeDialog((Frame)win);
            } else if (win instanceof Dialog) {
                dialog = new LongTimeDialog((Dialog)win);
            }
            if (dialog == null) {
                return;
            }
            dialog.setLongTimeTask(new ILongTimeTask(){

                public Object exec() throws Exception {
                    Map result = BgPredictFormlistFacadeFactory.getRemoteInstance().predictDataXD((String)map.get("BgPreidctFormRecordIDS"));
                    return result;
                }

                public void afterExec(Object result) throws Exception {
                    BgPredictFormProcessUI.this.makePredictData((Map)result);
                }
            });
            dialog.show();
        }
    }

    private void makePredictData(Map map) throws BOSException {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"name", map.get("name"));
        uiContext.put((Object)"date", map.get("date"));
        uiContext.put((Object)"header", map.get("header"));
        uiContext.put((Object)"xdresult", map.get("xdresult"));
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(BgPredictDataMakeResultUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected String getEditUIModal() {
        String openModel = UIConfigUtility.getOpenModel();
        if (openModel != null) {
            return openModel;
        }
        return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
    }

    protected boolean isBOSTypeConfiged() throws BOSException, EASBizException {
        return false;
    }
}

