/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IUserCellDisplayParser;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.client.UIActionPostman;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.FilterParam;
import com.kingdee.eas.ma.budget.VisualItemInfo;
import com.kingdee.eas.ma.budget.client.BgPeriodDialog;
import com.kingdee.eas.ma.budget.client.LongTimeDialog;
import com.kingdee.eas.ma.budget.client.NewBgItemDialog;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgPermissionHelper;
import com.kingdee.eas.ma.nbudget.BgPredictExpressionInfo;
import com.kingdee.eas.ma.nbudget.BgPredictItemFactory;
import com.kingdee.eas.ma.nbudget.BgPredictItemInfo;
import com.kingdee.eas.ma.nbudget.BgPredictItemListFacadeFactory;
import com.kingdee.eas.ma.nbudget.BgSimulatePredictFacadeFactory;
import com.kingdee.eas.ma.nbudget.IBgPredictItem;
import com.kingdee.eas.ma.nbudget.client.AbstractBgPredictItemListUI;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.ma.nbudget.client.BgNFormEditUI;
import com.kingdee.eas.ma.nbudget.client.BgPredictItemPredictDataMakeUI;
import com.kingdee.eas.ma.nbudget.client.BgPredictItemPredictDataViewUI;
import com.kingdee.eas.ma.nbudget.client.BgPredictItemPredictSampleUI;
import com.kingdee.eas.ma.nbudget.client.BgPredictItemPreviousSchemeUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;

public class BgPredictItemListUI
extends AbstractBgPredictItemListUI {
    private static final long serialVersionUID = 7708029593048168463L;
    public static final String STRRESOURCE = "com.kingdee.eas.ma.nbudget.BgPredictItemResource";
    private CurrencyCollection currencyCol = null;
    private Map currencyMap = new HashMap();
    protected FilterParam defaultFilterParam = null;
    private CommonQueryDialog cqDialog = null;
    private BgPredictItemPredictSampleUI filterUI = null;
    private BgPredictItemPreviousSchemeUI filterUI1 = null;
    private IMetaDataPK mainQueryPk = new MetaDataPK("com.kingdee.eas.ma.budget", "BgElementQuery");

    @Override
    public void onLoad() throws Exception {
        this.currencyCol = CurrencyFactory.getRemoteInstance().getCurrencyCollection();
        int in = this.currencyCol.size();
        for (int i = 0; i < in; ++i) {
            CurrencyInfo info = this.currencyCol.get(i);
            this.currencyMap.put(info.getNumber(), new Integer(info.getPrecision()));
        }
        super.onLoad();
        BgPeriodDialog dialog = new BgPeriodDialog();
        this.prmtBgPeriodBegin.setSelector((KDPromptSelector)dialog);
        this.prmtBgPeriodEnd.setSelector((KDPromptSelector)dialog);
        NewBgItemDialog bgItemSelect = new NewBgItemDialog((IUIObject)this);
        this.prmtBgItemBegin.setSelector((KDPromptSelector)bgItemSelect);
        this.prmtBgItemBegin.setEditFormat("$name$");
        this.prmtBgItemBegin.setDisplayFormat("$name$");
        this.prmtBgItemBegin.setCommitFormat("$id$");
        this.prmtBgItemEnd.setSelector((KDPromptSelector)bgItemSelect);
        this.prmtBgItemEnd.setEditFormat("$name$");
        this.prmtBgItemEnd.setDisplayFormat("$name$");
        this.prmtBgItemEnd.setCommitFormat("$id$");
        this.btnMake.setIcon(EASResource.getIcon((String)"imgTbtn_makeknown"));
        this.tblMain.getColumn("isSelected").getStyleAttributes().setLocked(false);
        this.tblMain.getColumn("id").getStyleAttributes().setHided(true);
        BgNationalFormatUIUtil.setDateTimeOrNumberFormat((KDTable)this.tblMain);
    }

    public void onShow() throws Exception {
        this.getTblMain().setUserCellDisplayParser((IUserCellDisplayParser)new CellDisplayParser());
    }

    protected Object formatCellDisplay(int rowIndex, int colIndex, ICell cell, Object svalue) {
        if (cell != null && cell.getColumnIndex() == this.tblMain.getColumn("value").getColumnIndex()) {
            BigDecimal decimal = null;
            DecimalFormat decFormat = null;
            decimal = cell.getValue() instanceof BigDecimal ? (BigDecimal)cell.getValue() : BgNConstants.ZERO;
            String formula = this.tblMain.getRow(rowIndex).getCell("formula").getValue().toString();
            String currencyNumber = BgNFSHelper.parseFormulaPara(formula)[5];
            int presic = 2;
            if (this.currencyMap.containsKey(currencyNumber)) {
                presic = (Integer)this.currencyMap.get(currencyNumber);
            }
            decFormat = BgNationalFormatUIUtil.getDecimalFormat((int)presic);
            return decFormat.format(decimal);
        }
        return svalue;
    }

    @Override
    public String getPermissionNum() {
        return "bg_form01_list";
    }

    public KDTable getTblMain() {
        return this.tblMain;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return BgFormFactory.getRemoteInstance();
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.btnPredict.setIcon(EASResource.getIcon((String)"imgTbtn_differencedispose"));
        this.btnMake.setIcon(EASResource.getIcon((String)"imgTbtn_makeknown"));
        this.btnClearAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnSelectedAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
    }

    protected void actionLoadBudgetData(ActionEvent e) throws Exception {
        int re = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.NBUDGETAutoGenerateResource", (String)"77_BgNFormListUI"));
        if (re == 0) {
            this.getNFacadeInterface().loadBudgetData(BOSUuid.read((String)this.getSelectedKeyValue()));
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.NBUDGETAutoGenerateResource", (String)"78_BgNFormListUI"));
        }
    }

    protected String getBgOrgUnitId() {
        if (this.rbCurrOrgUnit.isSelected()) {
            return this.getOrgUnitId();
        }
        this.checkSelected();
        Object obj = this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex()).getCell("orgUnit.id").getValue();
        if (obj != null) {
            return (String)obj;
        }
        return this.getOrgUnitId();
    }

    @Override
    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor queryExecutor = null;
        FilterInfo filter = null;
        SorterItemCollection sortCol = new SorterItemCollection();
        if (!viewInfo.getSorter().isEmpty()) {
            sortCol.addObjectCollection((IObjectCollection)viewInfo.getSorter());
        }
        filter = this.rbImmOrgUnit.isSelected() ? this.getImmSelectedQueryFilterInfo(viewInfo) : (this.rbAllOrgUnit.isSelected() ? this.getSelectedQueryFilterInfo(viewInfo) : this.getUnSelectedQueryFilterInfo(viewInfo));
        this.refreshFilter(filter);
        FullOrgUnitInfo orgUnitInfo = this.getOrgUnitInfo();
        String orgUnitID = orgUnitInfo == null ? null : orgUnitInfo.getId().toString();
        String userId = this.getUserInfo().getId().toString();
        try {
            if (!StringUtils.isEmpty((String)orgUnitID)) {
                IUIActionPostman handler = UIActionPostman.getInstance((IUIObject)this);
                if (handler != null) {
                    RequestContext request = new RequestContext();
                    request.setClassName(this.getUIHandlerClassName());
                    request.setMethodName("handleGetQueryExecutor");
                    request.setUIName(this.getMetaDataPK().getFullName());
                    request.put("USER_ID", (Object)userId);
                    request.put("ORGUNIT_ID", (Object)orgUnitID);
                    request.put("PERMISSION_NUM", (Object)this.getPermissionNum());
                    handler.setRequestContext((Serializable)request);
                }
                handler.callHandler();
            }
        }
        catch (Exception ex) {
            this.handUIExceptionAndAbort(ex);
        }
        viewInfo.setFilter(filter);
        String rule = null;
        EntityViewInfo resultEntityViewInfo = null;
        if (!StringUtils.isEmpty((String)orgUnitID)) {
            try {
                rule = this.getPermissionSerInterface().getPermissionRule((IObjectPK)new ObjectUuidPK(this.getUserInfo().getId()), (IObjectPK)new ObjectUuidPK(orgUnitID), this.getPermissionNum());
                if (rule != null && !rule.equals(" WHERE ( id = '00000000-0000-0000-0000-00000000000013B7DE7F' OR id <> '00000000-0000-0000-0000-00000000000013B7DE7F' )")) {
                    resultEntityViewInfo = new EntityViewInfo(rule);
                    viewInfo.getFilter().mergeFilter(resultEntityViewInfo.getFilter(), "AND");
                }
            }
            catch (Exception ex) {
                this.handUIExceptionAndAbort(ex);
            }
        }
        if (!sortCol.isEmpty()) {
            viewInfo.getSorter().clear();
            viewInfo.getSorter().addObjectCollection((IObjectCollection)sortCol);
        }
        viewInfo.setFilter(filter);
        queryExecutor = super.getQueryExecutor(queryPK, viewInfo);
        return queryExecutor;
    }

    @Override
    protected FilterInfo getUnSelectedQueryFilterInfo(EntityViewInfo viewInfo) {
        return super.getUnSelectedQueryFilterInfo(viewInfo);
    }

    @Override
    protected FilterInfo getImmSelectedQueryFilterInfo(EntityViewInfo viewInfo) {
        return super.getImmSelectedQueryFilterInfo(viewInfo);
    }

    @Override
    protected FilterInfo getSelectedQueryFilterInfo(EntityViewInfo viewInfo) {
        return super.getSelectedQueryFilterInfo(viewInfo);
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        FullOrgUnitInfo orgUnitInfo = this.getBGOrgUnitInfo();
        if (orgUnitInfo != null) {
            uiContext.put((Object)"ORGUNIT_INFO", (Object)orgUnitInfo);
            uiContext.put((Object)"ORGUNIT_CU", (Object)orgUnitInfo.getCU());
        }
    }

    protected Map getFullOrgUnitMap(Set orgUnitIdSet) throws Exception {
        if (orgUnitIdSet == null || orgUnitIdSet.isEmpty()) {
            return new HashMap();
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)orgUnitIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("CU.id");
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        HashMap<String, FullOrgUnitInfo> fullOrgUnitMap = new HashMap<String, FullOrgUnitInfo>();
        FullOrgUnitInfo fullOrgUnitInfo2 = null;
        FullOrgUnitCollection fullOrgUnitCol = null;
        fullOrgUnitCol = this.getFullOrgUnitInterface().getFullOrgUnitCollection(view);
        if (fullOrgUnitCol != null && !fullOrgUnitCol.isEmpty()) {
            for (FullOrgUnitInfo fullOrgUnitInfo2 : fullOrgUnitCol) {
                fullOrgUnitMap.put(fullOrgUnitInfo2.getId().toString(), fullOrgUnitInfo2);
            }
        }
        return fullOrgUnitMap;
    }

    public void actionAttribute_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkOrgUnitDisable();
        FullOrgUnitInfo orgUnitInfo = this.getBGOrgUnitInfo();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        uiContext.put((Object)"ORGUNIT_INFO", (Object)orgUnitInfo);
        uiContext.put((Object)"ORGUNIT_CU", (Object)orgUnitInfo.getCU());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(BgNFormEditUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    @Override
    protected void treeOrgUnit_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeOrgUnit_valueChanged(e);
        EntityViewInfo view = null;
        FilterInfo filter = null;
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getLastSelectedPathComponent();
        FullOrgUnitInfo orgUnitInfo = null;
        if (node != null) {
            orgUnitInfo = this.getOrgUnitInfo(node);
            if (node.getParent() == null) {
                this.btnClearPredictData.setVisible(true);
            } else {
                this.btnClearPredictData.setVisible(false);
            }
        }
        if (orgUnitInfo != null) {
            view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitInfo.getId().toString(), CompareType.EQUALS));
            if (BgSHelper.isBgPermissionUsed((Map)this.getParamValue())) {
                String userId = this.getUserInfo().getId().toString();
                Set<String> orgSet = new HashSet<String>();
                if (this.getPermissionOrg() != null) {
                    orgSet = this.getPermissionOrg();
                } else {
                    orgSet.add(orgUnitInfo.getId().toString());
                }
                filter = BgPermissionHelper.addBgSchemePermission(userId, orgSet, filter);
            }
            view.setFilter(filter);
            this.refreshTable();
        }
    }

    @Override
    protected void prmtBgItemBegin_dataChanged(DataChangeEvent e) throws Exception {
        this.refreshTable();
    }

    @Override
    protected void prmtBgItemEnd_dataChanged(DataChangeEvent e) throws Exception {
        this.refreshTable();
    }

    @Override
    protected void prmtBgPeriodBegin_dataChanged(DataChangeEvent e) throws Exception {
        this.verifyPeriod();
        this.refreshTable();
    }

    @Override
    protected void prmtBgPeriodEnd_dataChanged(DataChangeEvent e) throws Exception {
        this.verifyPeriod();
        this.refreshTable();
    }

    private void verifyPeriod() {
        if (this.prmtBgPeriodBegin.getData() != null && this.prmtBgPeriodBegin.getData() instanceof BgPeriodInfo && this.prmtBgPeriodEnd.getData() != null && this.prmtBgPeriodEnd.getData() instanceof BgPeriodInfo) {
            boolean bln;
            BgPeriodInfo beginPeriod = (BgPeriodInfo)this.prmtBgPeriodBegin.getData();
            BgPeriodInfo endPeriod = (BgPeriodInfo)this.prmtBgPeriodEnd.getData();
            if (!beginPeriod.getPeriodType().equals((Object)endPeriod.getPeriodType())) {
                MsgBox.showWarning((Component)((Object)this), (String)this.getMessageStr("com.kingdee.eas.ma.budget.client.BgFormResource", "checkBgPeriodType"));
                SysUtil.abort();
            }
            if (!(bln = BgHelper.compareBgPeriodBegin2End((BgPeriodInfo)beginPeriod, (BgPeriodInfo)endPeriod))) {
                this.prmtBgPeriodEnd.requestFocus();
                MsgBox.showWarning((Component)((Object)this), (String)this.getMessageStr("com.kingdee.eas.ma.budget.client.BgFormResource", "checkBgPeriodOrder"));
                SysUtil.abort();
            }
        }
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.tblMain.refresh();
    }

    private void refreshTable() {
        FilterInfo _filter = new FilterInfo();
        this.refreshFilter(_filter);
        this.mainQuery.setFilter(_filter);
        try {
            this.execQuery();
        }
        catch (Exception ex) {
            this.handUIExceptionAndAbort(ex);
        }
    }

    private void refreshFilter(FilterInfo filter) {
        BgPeriodInfo _bgPeriodInfo;
        if (filter == null) {
            return;
        }
        Object obj = this.prmtBgItemBegin.getData();
        Object objend = this.prmtBgItemEnd.getData();
        if (obj != null && objend != null) {
            String _name;
            VisualItemInfo _bgItemInfo;
            if (obj instanceof VisualItemInfo) {
                _bgItemInfo = (VisualItemInfo)obj;
                filter.getFilterItems().add(new FilterItemInfo("bgPredictItem.bgItemNumber", (Object)_bgItemInfo.getNumber(), CompareType.GREATER_EQUALS));
            } else if (obj instanceof String) {
                _name = (String)obj;
                filter.getFilterItems().add(new FilterItemInfo("bgPredictItem.bgItemNumber", (Object)_name, CompareType.GREATER_EQUALS));
            }
            if (objend instanceof VisualItemInfo) {
                _bgItemInfo = (VisualItemInfo)objend;
                filter.getFilterItems().add(new FilterItemInfo("bgPredictItem.bgItemNumber", (Object)_bgItemInfo.getNumber(), CompareType.LESS_EQUALS));
            } else if (objend instanceof String) {
                _name = (String)objend;
                filter.getFilterItems().add(new FilterItemInfo("bgPredictItem.bgItemNumber", (Object)_name, CompareType.LESS_EQUALS));
            }
            filter.setMaskString("#0 and ( #1 and #2 )");
        }
        if ((obj = this.prmtBgPeriodBegin.getData()) != null && obj instanceof BgPeriodInfo) {
            _bgPeriodInfo = (BgPeriodInfo)obj;
            this.replaceFilterItems(filter, new FilterItemInfo("bgPeriod.beginDate", (Object)_bgPeriodInfo.getBeginDate(), CompareType.GREATER_EQUALS));
        }
        if ((obj = this.prmtBgPeriodEnd.getData()) != null && obj instanceof BgPeriodInfo) {
            _bgPeriodInfo = (BgPeriodInfo)obj;
            this.replaceFilterItems(filter, new FilterItemInfo("bgPeriod.endDate", (Object)_bgPeriodInfo.getEndDate(), CompareType.LESS_EQUALS));
        }
        if (this.prmtBgPeriodBegin.getData() != null || this.prmtBgPeriodEnd.getData() != null) {
            int bgPeriodType = 0;
            bgPeriodType = this.prmtBgPeriodBegin.getData() != null ? ((BgPeriodInfo)this.prmtBgPeriodBegin.getData()).getPeriodType().getValue() : ((BgPeriodInfo)this.prmtBgPeriodEnd.getValue()).getPeriodType().getValue();
            this.replaceFilterItems(filter, new FilterItemInfo("bgPeriod.periodType", (Object)new Integer(bgPeriodType), CompareType.EQUALS));
        }
    }

    @Override
    public boolean destroyWindow() {
        boolean re = super.destroyWindow();
        if (re) {
            if (this.filterUI != null) {
                this.filterUI.destroyWindow();
            }
            if (this.cqDialog != null && this.cqDialog.getWindow() != null) {
                if (this.cqDialog.getWindow().getUIObject() != null) {
                    this.cqDialog.getWindow().getUIObject().destroyWindow();
                }
                this.cqDialog.getWindow().close();
            }
        }
        return re;
    }

    @Override
    public boolean isPrepareInit() {
        return false;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        if (handler != null) {
            RequestContext request = (RequestContext)handler.getRequestContext();
            request.put("USER_ID", (Object)this.getUserInfo().getId().toString());
            request.put("ORGUNIT_ID", (Object)this.getOrgUnitId());
            request.put("PERMISSION_NUM", (Object)this.getPermissionNum());
        }
        return handler;
    }

    @Override
    public boolean isPrepareDestoryWindow() {
        return true;
    }

    @Override
    public void actionSelectedAll_actionPerformed(ActionEvent e) throws Exception {
        int rowcount = this.tblMain.getRowCount();
        if (rowcount > 0) {
            for (int i = 0; i < rowcount; ++i) {
                this.tblMain.getRow(i).getCell("isSelected").setValue((Object)Boolean.TRUE);
            }
        }
    }

    @Override
    public void actionClearAll_actionPerformed(ActionEvent e) throws Exception {
        int rowcount = this.tblMain.getRowCount();
        if (rowcount > 0) {
            for (int i = 0; i < rowcount; ++i) {
                this.tblMain.getRow(i).getCell("isSelected").setValue((Object)Boolean.FALSE);
            }
        }
    }

    @Override
    public void actionClearPredictData_actionPerformed(ActionEvent e) throws Exception {
        int re = MsgBox.showConfirm2((Component)((Object)this), (String)BgNFCHelper.getMessageStr(STRRESOURCE, "clearData"));
        if (re == 1 || re == 2) {
            return;
        }
        BgPredictItemListFacadeFactory.getRemoteInstance().clearPredictData();
        this.refreshTable();
        MsgBox.showInfo((String)EASResource.getString((String)STRRESOURCE, (String)"clearMessage"));
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        int rowcount = this.tblMain.getRowCount();
        boolean isSelected = false;
        StringBuffer message = new StringBuffer();
        String bgPreidctItemRecordIDs = null;
        if (rowcount > 0) {
            for (int i = 0; i < rowcount; ++i) {
                Boolean re;
                if (!(this.tblMain.getRow(i).getCell("isSelected").getValue() instanceof Boolean) || !(re = (Boolean)this.tblMain.getRow(i).getCell("isSelected").getValue()).booleanValue()) continue;
                isSelected = true;
                break;
            }
            if (isSelected) {
                int re = MsgBox.showConfirm2((Component)((Object)this), (String)BgNFCHelper.getMessageStr(STRRESOURCE, "deleteForm"));
                if (re == 1 || re == 2) {
                    return;
                }
                for (int i = 0; i < rowcount; ++i) {
                    Boolean sel;
                    if (!(this.tblMain.getRow(i).getCell("isSelected").getValue() instanceof Boolean) || !(sel = (Boolean)this.tblMain.getRow(i).getCell("isSelected").getValue()).booleanValue()) continue;
                    bgPreidctItemRecordIDs = this.tblMain.getRow(i).getCell("id").getValue().toString();
                    IBgPredictItem ibgPredictItem = BgPredictItemFactory.getRemoteInstance();
                    BgPredictItemInfo bgPredictItem = ibgPredictItem.getBgPredictItemInfo((IObjectPK)new ObjectUuidPK(bgPreidctItemRecordIDs));
                    message.append(bgPredictItem.getBgItemNumber() + ",");
                    BgPredictItemListFacadeFactory.getRemoteInstance().deletePredictItemData(bgPreidctItemRecordIDs);
                }
            }
        }
        if (!isSelected) {
            MsgBox.showWarning((String)EASResource.getString((String)STRRESOURCE, (String)"isselected"));
        } else {
            if (message.length() > 0) {
                message = message.delete(message.length() - 1, message.length());
            }
            MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(BgNFCHelper.getMessageStr(STRRESOURCE, "deleteMessage"), message.toString()));
            this.refreshTable();
        }
    }

    @Override
    public void actionMake_actionPerformed(ActionEvent e) throws Exception {
        int rowcount = this.tblMain.getRowCount();
        String bgPreidctFormRecordIDs = "";
        String orgUnitIDs = "";
        String[] tmpOrgUnitID = null;
        String[] orgUnitID = null;
        if (rowcount > 0) {
            for (int i = 0; i < rowcount; ++i) {
                Boolean sel;
                if (!(this.tblMain.getRow(i).getCell("isSelected").getValue() instanceof Boolean) || !(sel = (Boolean)this.tblMain.getRow(i).getCell("isSelected").getValue()).booleanValue()) continue;
                bgPreidctFormRecordIDs = bgPreidctFormRecordIDs + this.tblMain.getRow(i).getCell("id").getValue().toString() + ",";
                orgUnitIDs = orgUnitIDs + this.tblMain.getRow(i).getCell("orgUnit.id").getValue().toString() + ",";
            }
        }
        if (orgUnitIDs != null) {
            tmpOrgUnitID = orgUnitIDs.split(",");
            orgUnitIDs = "";
            int j = 0;
            orgUnitID = new String[tmpOrgUnitID.length];
            for (int i = 0; i < tmpOrgUnitID.length; ++i) {
                String str = tmpOrgUnitID[i];
                if (j == 0) {
                    orgUnitIDs = orgUnitIDs + str + ",";
                    orgUnitID[j] = str;
                    ++j;
                    continue;
                }
                for (int k = j - 1; k >= 0 && !orgUnitID[k].equals(str); --k) {
                    if (k != 0) continue;
                    orgUnitID[j] = str;
                    orgUnitIDs = orgUnitIDs + str + ",";
                    ++j;
                }
            }
        }
        if (!bgPreidctFormRecordIDs.equals("")) {
            this.makePredictData(bgPreidctFormRecordIDs, orgUnitIDs);
        } else {
            MsgBox.showWarning((String)EASResource.getString((String)STRRESOURCE, (String)"isselected"));
        }
    }

    private void makePredictData(String bgPreidctFormRecordIDs, String orgUnitIDs) throws BOSException {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"BgPredictDataMakes", (Object)bgPreidctFormRecordIDs);
        uiContext.put((Object)"OrgUnit", (Object)orgUnitIDs);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(BgPredictItemPredictDataMakeUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public void actionPredict_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelOrgUnit();
        this.cqDialog = this.getCommonQueryDialog();
        this.cqDialog.init();
        OrgUnitInfo[] orgUnitInfo = null;
        if (this.cqDialog.getUserPanels().get(0) == this.filterUI) {
            ((BgPredictItemPredictSampleUI)this.cqDialog.getUserPanel(0)).setCqDialog(this.cqDialog);
            orgUnitInfo = new OrgUnitInfo[((BgPredictItemPredictSampleUI)this.cqDialog.getUserPanel(0)).getOrgUnitInfo().length];
            orgUnitInfo = ((BgPredictItemPredictSampleUI)this.cqDialog.getUserPanel(0)).getOrgUnitInfo();
            ((BgPredictItemPreviousSchemeUI)this.cqDialog.getUserPanel(1)).setEvi(orgUnitInfo);
        } else {
            ((BgPredictItemPredictSampleUI)((Object)this.cqDialog.getUserPanels().get(1))).setCqDialog(this.cqDialog);
            orgUnitInfo = new OrgUnitInfo[((BgPredictItemPredictSampleUI)this.cqDialog.getUserPanel(1)).getOrgUnitInfo().length];
            orgUnitInfo = ((BgPredictItemPredictSampleUI)this.cqDialog.getUserPanel(1)).getOrgUnitInfo();
            ((BgPredictItemPreviousSchemeUI)this.cqDialog.getUserPanel(0)).setEvi(orgUnitInfo);
        }
        if (this.cqDialog.show()) {
            LongTimeDialog dialog = null;
            Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
            if (win instanceof Frame) {
                dialog = new LongTimeDialog((Frame)win);
            } else if (win instanceof Dialog) {
                dialog = new LongTimeDialog((Dialog)win);
            }
            if (dialog == null) {
                return;
            }
            dialog.setLongTimeTask(new ILongTimeTask(){

                public Object exec() throws Exception {
                    List result = (List)BgSimulatePredictFacadeFactory.getRemoteInstance().predictCalculate(BgPredictItemListUI.this.getParam());
                    return result;
                }

                public void afterExec(Object result) throws Exception {
                    int re = MsgBox.showConfirm2((Component)((Object)BgPredictItemListUI.this), (String)BgNFCHelper.getMessageStr(BgPredictItemListUI.STRRESOURCE, "viewPredictRecord"));
                    if (re == 1 || re == 2) {
                        return;
                    }
                    BgPredictItemListUI.this.viewPredictRecord((List)result);
                }
            });
            dialog.show();
        }
        this.tblMain.refresh();
    }

    private void viewPredictRecord(List ids) throws BOSException {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ids", (Object)ids);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(BgPredictItemPredictDataViewUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    private Map getParam() throws BOSException, EASBizException {
        int i;
        int i2;
        HashMap<String, Object> map = new HashMap<String, Object>();
        BgPredictItemPredictSampleUI predict = null;
        BgPredictItemPreviousSchemeUI previousScheme = null;
        OrgUnitInfo[] orgUnits = null;
        String[] orgUnitID = null;
        String[] itemsFKey = null;
        Object[] bgElements = null;
        String[] bgElementID = null;
        BgSchemeInfo[] historySchemes = null;
        String[] historySchemeID = null;
        if (this.cqDialog.getUserPanels().get(0) == this.filterUI) {
            predict = (BgPredictItemPredictSampleUI)this.cqDialog.getUserPanel(0);
            previousScheme = (BgPredictItemPreviousSchemeUI)this.cqDialog.getUserPanel(1);
        } else {
            predict = (BgPredictItemPredictSampleUI)this.cqDialog.getUserPanel(1);
            previousScheme = (BgPredictItemPreviousSchemeUI)this.cqDialog.getUserPanel(0);
        }
        orgUnits = predict.getOrgUnitInfo();
        orgUnitID = new String[orgUnits.length];
        for (i2 = 0; i2 < orgUnits.length; ++i2) {
            orgUnitID[i2] = orgUnits[i2].getId().toString();
        }
        itemsFKey = predict.getBgItemInfo().split(",");
        bgElements = predict.getBgElements();
        bgElementID = new String[bgElements.length];
        for (i2 = 0; i2 < bgElements.length; ++i2) {
            bgElementID[i2] = ((BgElementInfo)bgElements[i2]).getId().toString();
        }
        historySchemes = previousScheme.getScheme();
        int j = 0;
        for (i = 0; i < historySchemes.length; ++i) {
            if (historySchemes[i] == null) continue;
            ++j;
        }
        historySchemeID = new String[j];
        for (i = 0; i < historySchemes.length; ++i) {
            if (historySchemes[i] == null) continue;
            historySchemeID[i] = historySchemes[i].getId().toString();
        }
        map.put("PRE_METHOD_ID", ((BgPredictExpressionInfo)predict.comboBgPredictMethod.getSelectedItem()).getId());
        map.put("HISTORY_DATA_TYPE", new Integer(predict.comboPreviousDataType.getSelectedIndex()));
        map.put("OU_IDS", orgUnitID);
        map.put("BG_ITEM_IDS", itemsFKey);
        map.put("BG_ELEMENT_IDS", bgElementID);
        map.put("CURRENCY_ID", ((CurrencyInfo)predict.comboCurrency.getSelectedItem()).getId().toString());
        map.put("BG_PERIOD_BEGIN_ID", predict.getBgPeriodBegin());
        map.put("BG_PERIOD_END_ID", predict.getBgPeriodEnd());
        map.put("PRE_TYPE_YEAR", new Integer(predict.kbYear.getSelected() == 32 ? 1 : 0));
        map.put("PRE_TYPE_HALFYEAR", new Integer(predict.kbHarfYear.getSelected() == 32 ? 1 : 0));
        map.put("PRE_TYPE_QUARTER", new Integer(predict.kbSeason.getSelected() == 32 ? 1 : 0));
        map.put("PRE_TYPE_MONTH", new Integer(predict.kbMonth.getSelected() == 32 ? 1 : 0));
        map.put("DATA_SCHEME_IDS", historySchemeID);
        map.put("PREDICT_TYPE", new Integer(2));
        return map;
    }

    protected CommonQueryDialog getCommonQueryDialog() throws Exception {
        this.cqDialog = new CommonQueryDialog();
        this.cqDialog.setOwner((Component)this.getUIContext().get("Owner"));
        this.cqDialog.setParentUIClassName(this.getMetaDataPK().getFullName());
        this.cqDialog.setEntityViewInfo(new EntityViewInfo());
        this.cqDialog.setQueryObjectPK(this.mainQueryPk);
        this.cqDialog.setTitle(EASResource.getString((String)STRRESOURCE, (String)"predictTitle"));
        this.cqDialog.setWidth(385);
        this.cqDialog.setHeight(450);
        BgPredictItemPredictSampleUI predictCondition = this.getBgPredictItemPredictSampleUI();
        this.cqDialog.addUserPanel((KDPanel)predictCondition);
        BgPredictItemPreviousSchemeUI historyScheme = this.getBgPredictItemPreviousSchemeUI();
        this.cqDialog.addUserPanel((KDPanel)historyScheme);
        predictCondition.setBgSchemeFilter(historyScheme);
        this.cqDialog.setShowFilter(false);
        this.cqDialog.setShowSorter(false);
        this.cqDialog.setDisVisiableDefaultView(true);
        this.cqDialog.setMaxReturnCountVisible(false);
        return this.cqDialog;
    }

    protected BgPredictItemPredictSampleUI getBgPredictItemPredictSampleUI() throws Exception {
        HashMap<String, FullOrgUnitInfo> map = new HashMap<String, FullOrgUnitInfo>();
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getLastSelectedPathComponent();
        FullOrgUnitInfo orgUnitInfo = null;
        if (node != null) {
            orgUnitInfo = this.getOrgUnitInfo(node);
        }
        if (orgUnitInfo != null) {
            map.put("CurOrgUnit", orgUnitInfo);
            this.filterUI = new BgPredictItemPredictSampleUI((Object)this, this.getOrgUnitInfo(), map);
            this.filterUI.setPanelName(EASResource.getString((String)STRRESOURCE, (String)"predictCondition"));
        }
        return this.filterUI;
    }

    protected BgPredictItemPreviousSchemeUI getBgPredictItemPreviousSchemeUI() throws Exception {
        this.filterUI1 = new BgPredictItemPreviousSchemeUI((Object)this, this.getOrgUnitInfo());
        this.filterUI1.setPanelName(EASResource.getString((String)STRRESOURCE, (String)"historyScheme"));
        return this.filterUI1;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    protected void rbAllOrgUnit_actionPerformed(ActionEvent e) throws Exception {
        if (this.rbAllOrgUnit.isSelected()) {
            this.tblMain.refresh();
            this.tblMain.getColumn("orgUnit.name").getStyleAttributes().setHided(false);
        }
    }

    @Override
    protected void rbCurrOrgUnit_actionPerformed(ActionEvent e) throws Exception {
        if (this.rbCurrOrgUnit.isSelected()) {
            this.tblMain.refresh();
            this.tblMain.getColumn("orgUnit.name").getStyleAttributes().setHided(true);
        }
    }

    @Override
    protected void rbImmOrgUnit_actionPerformed(ActionEvent e) throws Exception {
        if (this.rbImmOrgUnit.isSelected()) {
            this.tblMain.refresh();
            this.tblMain.getColumn("orgUnit.name").getStyleAttributes().setHided(false);
        }
    }

    private final class CellDisplayParser
    implements IUserCellDisplayParser {
        private CellDisplayParser() {
        }

        public Object parse(int rowIndex, int colIndex, ICell cell, Object value) {
            return BgPredictItemListUI.this.formatCellDisplay(rowIndex, colIndex, cell, value);
        }
    }
}

