/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.ma.budget.BgAnalyseFacadeFactory;
import com.kingdee.eas.ma.budget.BgAnalyseHelper;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgFormulaFacadeFactory;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgItemAnalyseParam;
import com.kingdee.eas.ma.budget.BgItemGroupInfo;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgSchemeCollection;
import com.kingdee.eas.ma.budget.FilterParam;
import com.kingdee.eas.ma.budget.client.BgCostCenterOrgViewF7;
import com.kingdee.eas.ma.budget.client.BgItemGroupInDialog;
import com.kingdee.eas.ma.budget.client.BgPeriodDialog;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgPredictDataSourceTypeEnum;
import com.kingdee.eas.ma.nbudget.BgPredictExpressionCollection;
import com.kingdee.eas.ma.nbudget.BgPredictExpressionFactory;
import com.kingdee.eas.ma.nbudget.BgPredictFilterParam;
import com.kingdee.eas.ma.nbudget.BgSimforecastFilterParam;
import com.kingdee.eas.ma.nbudget.IBgPredictExpression;
import com.kingdee.eas.ma.nbudget.client.AbstractBgPredictItemPredictSampleUI;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.ma.nbudget.client.BgPredictItemPreviousSchemeUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BgPredictItemPredictSampleUI
extends AbstractBgPredictItemPredictSampleUI {
    private static final long serialVersionUID = -5615331111957985048L;
    private static final Logger logger = CoreUIObject.getLogger(BgPredictItemPredictSampleUI.class);
    private OrgUnitInfo defOrgUnitInfo = null;
    FilterItemInfo filterItemInfo = null;
    CommonQueryDialog cqDialog = null;
    protected Object ui = null;
    Map map = new HashMap();
    private OrgUnitInfo currOrgUnit = SysContext.getSysContext().getCurrentOrgUnit();
    private CtrlUnitInfo currCU = SysContext.getSysContext().getCurrentCtrlUnit();
    private CurrencyInfo currencyInfo = null;
    protected static final String resourcePath = "com.kingdee.eas.ma.budget.client.BgRptResource";
    private Vector orgUnitVec;
    private BgPredictItemPreviousSchemeUI panel;
    boolean isBGNFormProcess = true;
    private BgPredictFilterParam filterParam = null;
    private static final String BGPREDICT_ID = "BGPREDICT_ID";
    private static final String HISTORYDATATYPE = "HISTORYDATATYPE";
    private static final String CURR_ORGUNIT_ID = "CURR_ORGUNIT_ID";
    private static final String ORGUNIT_IDS = "ORGUNIT_IDS";
    private static final String BGITEMS = "BGITEMS";
    private static final String BGELEMENT_ID = "BGELEMENT_ID";
    private static final String CURRENCY_ID = "CURRENCY_ID";
    private static final String BGPERIOD_BEGIN_ID = "BGPERIOD_BEGIN_ID";
    private static final String BGPERIOD_END_ID = "BGPERIOD_END_ID";
    private static final String KBYEAR = "KBYEAR";
    private static final String KBHARFYEAR = "KBHAEFYEAR";
    private static final String KBSEASON = "KBSEASON";
    private static final String KBMONTH = "KBMONTH";
    private static final String ISCOMBINE = "ISCOMBINE";

    public BgPredictItemPredictSampleUI() throws Exception {
    }

    public BgPredictItemPredictSampleUI(Object ui) throws Exception {
        this.ui = ui;
    }

    public BgPredictItemPredictSampleUI(Object ui, Object orgUnitInfo, Map map) throws Exception {
        this.ui = ui;
        this.map = map;
        if (map.get("OrgUnit") != null) {
            this.setBGNFormProcess(true);
        } else if (map.get("CurOrgUnit") != null) {
            this.setBGNFormProcess(false);
        }
        this.defOrgUnitInfo = orgUnitInfo != null && orgUnitInfo instanceof OrgUnitInfo ? (OrgUnitInfo)orgUnitInfo : SysContext.getSysContext().getCurrentCostUnit();
    }

    public void setBGNFormProcess(boolean isBGNFormProcess) {
        this.isBGNFormProcess = isBGNFormProcess;
    }

    public boolean setCqDialog(CommonQueryDialog cqDialog) {
        if (cqDialog != null) {
            this.cqDialog = cqDialog;
            return true;
        }
        return false;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initFilter();
    }

    public BgPredictItemPredictSampleUI getDataSimFilter() {
        return this;
    }

    public void setBgSchemeFilter(BgPredictItemPreviousSchemeUI panel) {
        this.panel = panel;
    }

    public OrgUnitInfo[] getOrgUnitInfo() {
        Object obj = this.prmtOrgUnit.getData();
        OrgUnitInfo[] orgUnits = null;
        if (obj instanceof OrgUnitInfo[]) {
            orgUnits = (OrgUnitInfo[])obj;
        } else if (obj instanceof OrgUnitInfo) {
            orgUnits = new OrgUnitInfo[]{(OrgUnitInfo)obj};
        }
        return orgUnits;
    }

    public String getBgItemInfo() throws BOSException, EASBizException {
        String bgItems = "";
        String fKey = "";
        String _tmpStr = null;
        boolean isSelected = this.isCombine.isSelected();
        if (isSelected) {
            HashMap _numberMap = new HashMap();
            HashMap _tmpMap = new HashMap();
            int in = this.tblBgItem.getRowCount();
            for (int i = 0; i < in; ++i) {
                if (this.tblBgItem.getRow(i).getCell("bgItems").getValue() == null) continue;
                _tmpStr = this.tblBgItem.getRow(i).getCell("bgItems").getValue().toString().replaceAll(" ", "");
                String[] _tmpStrs = (_tmpStr = _tmpStr.substring(1, _tmpStr.length() - 1)).split(",");
                if (_tmpStrs == null) continue;
                _tmpMap.clear();
                int jn = _tmpStrs.length;
                for (int j = 0; j < jn; ++j) {
                    _tmpStr = _tmpStrs[j].replaceAll("'", "");
                    if (!_numberMap.isEmpty()) {
                        for (String _tmp : _numberMap.keySet()) {
                            if (_numberMap.containsKey(_tmp = _tmp + "," + _tmpStr)) continue;
                            _tmpMap.put(_tmp, null);
                        }
                    }
                    if (_numberMap.containsKey(_tmpStr)) continue;
                    _tmpMap.put(_tmpStr, null);
                }
                if (_tmpMap.isEmpty()) continue;
                _numberMap.putAll(_tmpMap);
            }
            HashMap<String, Object> newNumberMap = new HashMap<String, Object>();
            for (String tmp : _numberMap.keySet()) {
                int index;
                if (StringUtils.isEmpty((String)tmp) || (index = tmp.indexOf(",")) < 0) continue;
                newNumberMap.put(tmp, null);
            }
            _numberMap = newNumberMap;
            _tmpMap = BgFormulaFacadeFactory.getRemoteInstance().batchParseBgItemCombi(_numberMap, this.defOrgUnitInfo.getId().toString());
            Object[] obj2 = null;
            if (_tmpMap != null) {
                for (Object[] obj2 : _tmpMap.values()) {
                    fKey = fKey + "'" + obj2[0].toString().replaceAll(",", "_") + "',";
                }
            }
        } else {
            int in = this.tblBgItem.getRowCount();
            for (int i = 0; i < in; ++i) {
                if (this.tblBgItem.getRow(i).getCell("bgItems").getValue() == null) continue;
                _tmpStr = this.tblBgItem.getRow(i).getCell("bgItems").getValue().toString().replaceAll(" ", "");
                _tmpStr = _tmpStr.substring(1, _tmpStr.length() - 1);
                bgItems = bgItems + _tmpStr + ",";
            }
            fKey = bgItems;
        }
        if (fKey != null && fKey.length() > 0) {
            fKey = fKey.substring(0, fKey.length() - 1);
        }
        return fKey;
    }

    public Object[] getBgElements() {
        Object[] obj = (Object[])this.prmtBgElement.getData();
        return obj;
    }

    public BgPeriodInfo getBgPeriodBegin() {
        return (BgPeriodInfo)this.prmtBgPeriodBegin.getData();
    }

    public BgPeriodInfo getBgPeriodEnd() {
        return (BgPeriodInfo)this.prmtBgPeriodEnd.getData();
    }

    protected void initFilter() throws Exception {
        this.initPredictMethod();
        this.initHistoryDataType();
        this.initOrgUnit();
        this.initItem();
        this.initBgElement();
        this.initCurrency();
        this.initBgPeriod();
        this.initCheckBox();
        this.kDLabel1.setIcon(EASResource.getIcon((String)"imgLableword_btn"));
        this.btnAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnRemoveLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
    }

    private void initPredictMethod() throws BOSException {
        this.comboBgPredictMethod.removeAllItems();
        IBgPredictExpression predict = BgPredictExpressionFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        SorterItemCollection sort = new SorterItemCollection();
        SorterItemInfo sortInfo = new SorterItemInfo("name");
        sort.add(sortInfo);
        evi.setSorter(sort);
        BgPredictExpressionCollection predictCollection = predict.getBgPredictExpressionCollection(evi);
        this.comboBgPredictMethod.addItems(predictCollection.toArray());
        this.comboBgPredictMethod.setSelectedIndex(0);
    }

    private void initHistoryDataType() {
        this.comboPreviousDataType.removeAllItems();
        this.comboPreviousDataType.addItems(BgPredictDataSourceTypeEnum.getEnumList().toArray());
        this.comboPreviousDataType.setSelectedIndex(0);
    }

    private void initOrgUnit() {
        HashSet<String> checkedOrgIds = new HashSet<String>();
        if (this.map.get("OrgUnit") != null) {
            checkedOrgIds.add(((OrgUnitInfo)this.map.get("OrgUnit")).getId().toString());
        } else if (this.map.get("CurOrgUnit") != null) {
            checkedOrgIds.add(((OrgUnitInfo)this.map.get("CurOrgUnit")).getId().toString());
        } else {
            checkedOrgIds.add((String)this.currOrgUnit.getId());
        }
        BgCostCenterOrgViewF7 orgView = new BgCostCenterOrgViewF7((IUIObject)this);
        orgView.setTitle(BgAnalyseHelper.getMessage((String)"orgUnitTitle"));
        orgView.setCheckedOrgIDs(checkedOrgIds);
        if (this.map.get("CurOrgUnit") != null) {
            orgView.setCuID(((FullOrgUnitInfo)this.map.get("CurOrgUnit")).getId().toString());
        }
        if (this.map.get("OrgUnit") != null) {
            orgView.setCuID(this.getCurrOrgUnit().getId().toString());
        }
        orgView.setMultiSelect(this.isMultiSelect());
        orgView.setReturnSuperior(false);
        if (this.ui != null) {
            orgView.setUIActionPK((IMetaDataPK)new MetaDataPK(this.ui.getClass().getName()), (IMetaDataPK)new MetaDataPK("ActionOnLoad"));
        }
        this.prmtOrgUnit.setSelector((KDPromptSelector)orgView);
        if (this.ui != null) {
            Method method = null;
            try {
                BgSimforecastFilterParam filterParam;
                method = this.ui.getClass().getMethod("getFilterParam", null);
                if (method != null && (filterParam = (BgSimforecastFilterParam)method.invoke(this.ui, null)) != null) {
                    this.prmtOrgUnit.setData((Object)filterParam.getOrgUnits());
                    return;
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
        }
        if (this.map.get("OrgUnit") != null) {
            this.prmtOrgUnit.setData(this.map.get("OrgUnit"));
            this.prmtOrgUnit.setEnabled(false);
            this.prmtOrgUnit.setReadOnly(true);
            this.prmtOrgUnit.setDisplay(true);
            this.prmtOrgUnit.setRequired(false);
        } else if (this.map.get("CurOrgUnit") != null) {
            this.prmtOrgUnit.setData(this.map.get("CurOrgUnit"));
        } else {
            this.prmtOrgUnit.setData((Object)this.currOrgUnit);
        }
        this.prmtOrgUnit.setEditable(false);
    }

    protected boolean isMultiSelect() {
        return true;
    }

    private void initItem() {
        this.tblBgItem.checkParsed();
        BgItemGroupInDialog itemGroup = new BgItemGroupInDialog((IUIObject)this);
        KDBizPromptBox prmtSelect = null;
        prmtSelect = new KDBizPromptBox();
        prmtSelect.setEditable(false);
        prmtSelect.setSelector((KDPromptSelector)itemGroup);
        prmtSelect.setDisplayFormat("$name$");
        this.tblBgItem.getColumn("bgItemGroup").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtSelect));
        this.tblBgItem.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    BgPredictItemPredictSampleUI.this.tblBgItem_tableSelectChanged(e);
                }
                catch (Exception ex) {
                    BgPredictItemPredictSampleUI.this.handUIException(ex);
                }
            }
        });
    }

    @Override
    protected void tblBgItem_tableSelectChanged(KDTSelectEvent e) throws Exception {
        int rowIndex = this.tblBgItem.getSelectManager().getActiveRowIndex();
        if (rowIndex >= 0) {
            KDTEditEvent event = new KDTEditEvent((Object)this.tblBgItem);
            event.setRowIndex(rowIndex);
            event.setColIndex(this.tblBgItem.getColumnIndex("bgItemGroup"));
            this.tblBgItem_editStopped(event);
        }
    }

    @Override
    protected void tblBgItem_editStopped(KDTEditEvent e) throws Exception {
        IRow iRow;
        int colIndex = e.getColIndex();
        int curRow = e.getRowIndex();
        if (colIndex == this.tblBgItem.getColumnIndex("bgItemGroup")) {
            iRow = this.tblBgItem.getRow(curRow);
            ICell iCell = iRow.getCell("bgItemGroup");
            ICell iItems = iRow.getCell("bgItems");
            ICell iReffield = iRow.getCell("reffield");
            if (iCell == null || iCell.getValue() == null) {
                return;
            }
            BgItemGroupInfo itemGroupInfo = (BgItemGroupInfo)iCell.getValue();
            iRow.getCell("reffield").setValue((Object)itemGroupInfo.getRefField());
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = null;
            filterInfo = new FilterInfo();
            if (itemGroupInfo.getRefField() == null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("refField", (Object)"ff", CompareType.EQUALS));
                view.setFilter(filterInfo);
                ((KDBizPromptBox)((KDTDefaultCellEditor)iItems.getEditor()).getComponent()).setEntityViewInfo(view);
                iRow.getCell("bgItems").setValue(null);
                iRow.getCell("reffield").setValue(null);
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.NBUDGETAutoGenerateResource", (String)"36_BgDataAnalyseFilterUI"));
                return;
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("refField", (Object)(iReffield.getValue() == null ? null : iReffield.getValue().toString()), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("isEffective", (Object)Boolean.TRUE, CompareType.EQUALS));
            String orgUnitId = null;
            String longNumber = "";
            if (this.getOrgUnitVec() != null && this.getOrgUnitVec().get(0) instanceof CostCenterOrgUnitInfo) {
                CostCenterOrgUnitInfo ccInfo = (CostCenterOrgUnitInfo)this.getOrgUnitVec().get(0);
                orgUnitId = ccInfo.getId().toString();
                longNumber = ccInfo.getLongNumber();
            } else {
                orgUnitId = this.defOrgUnitInfo.getId().toString();
                longNumber = this.defOrgUnitInfo.getLongNumber();
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("OrgUnitId", (Object)BgSHelper.getIsolateOrg((String)orgUnitId), CompareType.EQUALS));
            if (filterInfo.getMaskString() == null) {
                filterInfo.setMaskString("(#0) AND (#1) AND (#2)");
            } else {
                filterInfo.setMaskString("(" + filterInfo.getMaskString() + ") AND (#" + String.valueOf(filterInfo.getFilterItems().size() - 3) + ") AND (#" + String.valueOf(filterInfo.getFilterItems().size() - 2) + ") AND (#" + String.valueOf(filterInfo.getFilterItems().size() - 1) + ")");
            }
            view.setFilter(filterInfo);
            if (iItems.getEditor() == null) {
                this.inputItemsEditor(curRow);
            }
            ((KDBizPromptBox)((KDTDefaultCellEditor)iItems.getEditor()).getComponent()).setEntityViewInfo(view);
            if (this.haveSameItemGroup(iRow.getCell("reffield").getValue().toString(), curRow)) {
                iRow.getCell("bgItemGroup").setValue(null);
                iRow.getCell("bgItems").setValue(null);
                iRow.getCell("reffield").setValue(null);
            }
            if (e.getOldValue() != null || e.getValue() != null) {
                iRow.getCell("bgItems").setValue(null);
            }
        }
        if (colIndex == this.tblBgItem.getColumnIndex("bgItems")) {
            iRow = this.tblBgItem.getRow(curRow);
            ICell iItems = iRow.getCell("bgItems");
            Object[] itemColl = null;
            String[] itemNums = null;
            String item = null;
            if (iItems == null || iItems.getValue() == null || !(iItems.getValue() instanceof Object[])) {
                return;
            }
            itemColl = (Object[])iItems.getValue();
            itemNums = new String[itemColl.length];
            for (int i = 0; i < itemColl.length; ++i) {
                itemNums[i] = ((BgItemInfo)itemColl[i]).getNumber();
            }
            item = BgHelper.tranArray2String((String[])itemNums);
            iItems.setValue((Object)item);
        }
    }

    @Override
    protected void tblBgItem_editStarting(KDTEditEvent e) throws Exception {
        int colIndex = e.getColIndex();
        int curRow = e.getRowIndex();
        IRow iRow = this.tblBgItem.getRow(curRow);
        if (iRow.getCell("bgItems").getEditor() == null) {
            this.inputItemsEditor(curRow);
        }
        if (colIndex == this.tblBgItem.getColumnIndex("bgItems") && iRow.getCell("bgItemGroup").getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"noHaveBgGroup"));
            return;
        }
    }

    public Vector getOrgUnitVec() {
        return this.orgUnitVec;
    }

    private void inputItemsEditor(int rowIndex) {
        KDBizPromptBox prmtSelect2 = null;
        prmtSelect2 = new KDBizPromptBox();
        prmtSelect2.setEditable(false);
        prmtSelect2.setQueryInfo("com.kingdee.eas.ma.budget.BgItemDataQuery");
        prmtSelect2.setDisplayFormat("$name$");
        prmtSelect2.setEnabledMultiSelection(true);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = null;
        filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("refField", (Object)"ff", CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("isEffective", (Object)Boolean.TRUE, CompareType.EQUALS));
        String orgUnitId = null;
        String longNumber = "";
        try {
            if (this.getOrgUnitVec() != null && this.getOrgUnitVec().get(0) instanceof CostCenterOrgUnitInfo) {
                CostCenterOrgUnitInfo ccInfo = (CostCenterOrgUnitInfo)this.getOrgUnitVec().get(0);
                orgUnitId = ccInfo.getId().toString();
                longNumber = ccInfo.getLongNumber();
            } else {
                orgUnitId = this.defOrgUnitInfo.getId().toString();
                longNumber = this.defOrgUnitInfo.getLongNumber();
            }
        }
        catch (Exception e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("OrgUnitId", (Object)BgSHelper.getIsolateOrg((String)orgUnitId), CompareType.EQUALS));
        filterInfo.setMaskString("(#0) And (#1) And (#2)");
        view.setFilter(filterInfo);
        prmtSelect2.setEntityViewInfo(view);
        this.tblBgItem.getRow(rowIndex).getCell("bgItems").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtSelect2));
    }

    private boolean haveSameItemGroup(String refField, int curRow) {
        for (int i = 0; i < this.tblBgItem.getRowCount(); ++i) {
            if (this.tblBgItem.getRow(i).getCell("reffield").getValue() == null && this.tblBgItem.getRow(i).getCell("bgItems").getValue() == null || !this.tblBgItem.getRow(i).getCell("reffield").getValue().toString().equals(refField) || curRow == i) continue;
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"haveSameItemGroup"));
            return true;
        }
        return false;
    }

    protected void initBgElement() {
        this.prmtBgElement.setEnabledMultiSelection(true);
    }

    private void initCurrency() {
        CurrencyInfo currencyInfo = null;
        OrgUnitInfo unitInfo = this.getCurrOrgUnit();
        BgNFCHelper.setCurrency(this.comboCurrency, null, false);
        if (unitInfo != null) {
            currencyInfo = BgNFCHelper.getBaseCurrency(unitInfo.getId());
            BgNFCHelper.setSelectObject(this.comboCurrency, currencyInfo);
            this.setCurrencyInfo(currencyInfo);
        }
        if (this.ui != null) {
            Method method = null;
            try {
                BgSimforecastFilterParam filterParam;
                method = this.ui.getClass().getMethod("getFilterParam", null);
                if (method != null && (filterParam = (BgSimforecastFilterParam)method.invoke(this.ui, null)) != null) {
                    BgNFCHelper.setSelectObject(this.comboCurrency, filterParam.getCurrencyId());
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
        }
        if (this.map.get("Currency") != null) {
            this.comboCurrency.setEnabled(false);
        }
    }

    public OrgUnitInfo getCurrOrgUnit() {
        return this.currOrgUnit;
    }

    public void setCurrencyInfo(CurrencyInfo currencyInfo) {
        this.currencyInfo = currencyInfo;
    }

    protected void initBgPeriod() throws Exception {
        BgPeriodDialog bgPeriodDialog = new BgPeriodDialog((CoreUIObject)this);
        this.prmtBgPeriodBegin.setSelector((KDPromptSelector)bgPeriodDialog);
        this.prmtBgPeriodEnd.setSelector((KDPromptSelector)bgPeriodDialog);
        this.prmtBgPeriodBegin.setEditable(false);
        this.prmtBgPeriodEnd.setEditable(false);
        if (this.map.get("Period") != null) {
            BgPeriodInfo period = new BgPeriodInfo();
            period = (BgPeriodInfo)this.map.get("Period");
            this.prmtBgPeriodBegin.setData((Object)period);
            this.prmtBgPeriodEnd.setData((Object)period);
        }
    }

    public void initCheckBox() {
        if (this.map.get("periodType") != null) {
            RptPeriodTypeEnum type = (RptPeriodTypeEnum)this.map.get("periodType");
            switch (type.getValue()) {
                case 1: {
                    this.kbYear.setSelected(true);
                    break;
                }
                case 2: {
                    this.kbHarfYear.setSelected(true);
                    break;
                }
                case 3: {
                    this.kbSeason.setSelected(true);
                    break;
                }
                case 4: {
                    this.kbMonth.setSelected(true);
                    break;
                }
            }
        }
    }

    public void restart(OrgUnitInfo orgUnitInfo) throws Exception {
        this.clear();
    }

    public void clear() {
        super.clear();
        if (this.comboBgPredictMethod.getItemCount() > 0) {
            this.comboBgPredictMethod.setSelectedIndex(0);
        }
        if (this.comboPreviousDataType.getItemCount() > 0) {
            this.comboPreviousDataType.setSelectedIndex(0);
        }
        this.prmtOrgUnit.setData((Object)this.currOrgUnit);
        this.tblBgItem.removeRows();
        int i = this.tblBgItem.getRowCount();
        if (i > 0) {
            this.tblBgItem.removeRow(i);
        }
        this.prmtBgElement.setValue(null);
        if (this.comboCurrency.getItemCount() > 0) {
            this.comboCurrency.setSelectedIndex(0);
        }
        this.prmtBgPeriodBegin.setValue(null);
        this.prmtBgPeriodEnd.setValue(null);
        this.kbYear.setSelected(false);
        this.kbHarfYear.setSelected(false);
        this.kbSeason.setSelected(false);
        this.kbMonth.setSelected(false);
        this.isCombine.setSelected(false);
    }

    @Override
    protected void prmtOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        if (!this.prmtOrgUnit.isReadOnly()) {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            OrgUnitInfo _currOrgUnit = SysContext.getSysContext().getCurrentOrgUnit();
            evi.setFilter(filterInfo);
            Set subOrgUnits = new HashSet();
            subOrgUnits = this.getOrgUnitsToBosID();
            BgSchemeCollection bgSchemeCol = null;
            Object bgItemCol = null;
            BOSUuid[] orgids = this.getOrgUnitIds();
            if (subOrgUnits != null) {
                int i;
                HashSet<String> schemes = new HashSet<String>();
                for (i = 0; i < orgids.length; ++i) {
                    if (_currOrgUnit.getId().toString().equals(orgids[0].toString())) continue;
                    _currOrgUnit.setId(orgids[0]);
                }
                bgSchemeCol = this.getBgSchemeInfo(this.currOrgUnit.getId(), subOrgUnits);
                for (i = 0; i < bgSchemeCol.size(); ++i) {
                    schemes.add(bgSchemeCol.get(i).getId().toString());
                }
                filterInfo.getFilterItems().add(new FilterItemInfo("id", schemes, CompareType.INCLUDE));
            }
            if (this.cqDialog != null) {
                BgPredictItemPreviousSchemeUI historyScheme = null;
                historyScheme = this.cqDialog.getUserPanel(0) == this.panel ? (BgPredictItemPreviousSchemeUI)this.cqDialog.getUserPanel(0) : (BgPredictItemPreviousSchemeUI)this.cqDialog.getUserPanel(1);
                historyScheme.initFilter(evi);
            }
        }
        super.prmtOrgUnit_dataChanged(e);
    }

    protected BgSchemeCollection getBgSchemeInfo(BOSUuid currCCOrgUnitId, Set subOrgUnits) throws Exception {
        return BgAnalyseFacadeFactory.getRemoteInstance().getCommonBgScheme(currCCOrgUnitId, subOrgUnits, true);
    }

    public Set getOrgUnits() {
        Object obj = this.prmtOrgUnit.getData();
        HashSet<String> subOrgUnits = null;
        if (obj != null && !(obj instanceof String)) {
            OrgUnitInfo[] orgUnits = null;
            OrgUnitInfo _currOrgUnit = null;
            OrgUnitInfo _tmpOrgUnit2 = null;
            if (obj instanceof OrgUnitInfo) {
                orgUnits = new OrgUnitInfo[]{(OrgUnitInfo)obj};
            } else if (obj instanceof OrgUnitInfo[]) {
                orgUnits = (OrgUnitInfo[])obj;
            }
            subOrgUnits = new HashSet<String>();
            if (orgUnits != null && orgUnits.length >= 1) {
                _currOrgUnit = this.getCurrOrgUnit();
                if (!_currOrgUnit.getId().equals((Object)orgUnits[0].getId())) {
                    _currOrgUnit = orgUnits[0];
                }
                for (OrgUnitInfo _tmpOrgUnit2 : orgUnits) {
                    subOrgUnits.add(_tmpOrgUnit2.getId().toString());
                }
            }
        }
        return subOrgUnits;
    }

    public Set getOrgUnitsToBosID() {
        Object obj = this.prmtOrgUnit.getData();
        HashSet<BOSUuid> subOrgUnits = null;
        if (obj != null && !(obj instanceof String)) {
            OrgUnitInfo[] orgUnits = null;
            OrgUnitInfo _currOrgUnit = null;
            OrgUnitInfo _tmpOrgUnit2 = null;
            if (obj instanceof OrgUnitInfo) {
                orgUnits = new OrgUnitInfo[]{(OrgUnitInfo)obj};
            } else if (obj instanceof OrgUnitInfo[]) {
                orgUnits = (OrgUnitInfo[])obj;
            }
            subOrgUnits = new HashSet<BOSUuid>();
            if (orgUnits != null && orgUnits.length >= 1) {
                _currOrgUnit = this.getCurrOrgUnit();
                if (!_currOrgUnit.getId().equals((Object)orgUnits[0].getId())) {
                    _currOrgUnit = orgUnits[0];
                }
                for (OrgUnitInfo _tmpOrgUnit2 : orgUnits) {
                    subOrgUnits.add(_tmpOrgUnit2.getId());
                }
            }
        }
        return subOrgUnits;
    }

    protected BOSUuid[] getOrgUnitIds() throws Exception {
        BOSUuid[] orgUnitIds = null;
        Object obj = this.prmtOrgUnit.getData();
        if (obj != null && !(obj instanceof String)) {
            OrgUnitInfo[] orgUnits = null;
            OrgUnitInfo _tmpOrgUnit2 = null;
            if (obj instanceof OrgUnitInfo) {
                orgUnitIds = new BOSUuid[]{((OrgUnitInfo)obj).getId()};
            } else if (obj instanceof OrgUnitInfo[]) {
                orgUnits = (OrgUnitInfo[])obj;
                orgUnitIds = new BOSUuid[orgUnits.length];
                for (OrgUnitInfo _tmpOrgUnit2 : orgUnits) {
                    orgUnitIds[i] = _tmpOrgUnit2.getId();
                }
            }
        }
        return orgUnitIds;
    }

    @Override
    protected void comboBgPredictMethod_actionPerformed(ActionEvent e) throws Exception {
        super.comboBgPredictMethod_actionPerformed(e);
    }

    @Override
    protected void prmtOrgUnit_willShow(SelectorEvent e) throws Exception {
        super.prmtOrgUnit_willShow(e);
    }

    @Override
    protected void comboCurrency_actionPerformed(ActionEvent e) throws Exception {
        super.comboCurrency_actionPerformed(e);
    }

    @Override
    protected void prmtBgPeriodBegin_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgPeriodBegin_dataChanged(e);
        this.prmtBgPeriodEnd.setValue(this.prmtBgPeriodBegin.getData());
        this.setDefaultSelected();
    }

    @Override
    protected void prmtBgPeriodEnd_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgPeriodEnd_dataChanged(e);
        this.setDefaultSelected();
    }

    public void setDefaultSelected() {
        if (this.prmtBgPeriodBegin.getData() != null && this.prmtBgPeriodBegin.getData() instanceof BgPeriodInfo && this.prmtBgPeriodEnd.getData() != null && this.prmtBgPeriodEnd.getData() instanceof BgPeriodInfo) {
            boolean bln;
            BgPeriodInfo beginPeriod = (BgPeriodInfo)this.prmtBgPeriodBegin.getData();
            BgPeriodInfo endPeriod = (BgPeriodInfo)this.prmtBgPeriodEnd.getData();
            this.kbYear.setSelected(false);
            this.kbHarfYear.setSelected(false);
            this.kbSeason.setSelected(false);
            this.kbMonth.setSelected(false);
            if (beginPeriod.getPeriodType().equals((Object)endPeriod.getPeriodType()) && (bln = BgHelper.compareBgPeriodBegin2End((BgPeriodInfo)beginPeriod, (BgPeriodInfo)endPeriod))) {
                BgPeriodEnum type = beginPeriod.getPeriodType();
                switch (type.getValue()) {
                    case 1: {
                        this.kbYear.setSelected(true);
                        break;
                    }
                    case 2: {
                        this.kbHarfYear.setSelected(true);
                        break;
                    }
                    case 3: {
                        this.kbSeason.setSelected(true);
                        break;
                    }
                    case 4: {
                        this.kbMonth.setSelected(true);
                        break;
                    }
                }
            }
        }
    }

    protected KDTable getMuTable() {
        return this.tblBgItem;
    }

    @Override
    protected void btnAddLine_actionPerformed(ActionEvent e) throws Exception {
        super.btnAddLine_actionPerformed(e);
        this.tblBgItem.addRow();
        int rowIndex = this.tblBgItem.getRowCount() - 1;
        this.inputItemsEditor(rowIndex);
    }

    @Override
    protected void btnRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblBgItem.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.NBUDGETAutoGenerateResource", (String)"37_BgDataAnalyseFilterUI"));
            return;
        }
        super.btnRemoveLine_actionPerformed(e);
        int index = this.tblBgItem.getSelectManager().getActiveRowIndex();
        this.tblBgItem.removeRow(index);
    }

    public boolean[] getPeriodType() {
        boolean[] periodType = new boolean[]{this.kbYear.getSelected() == 32, this.kbHarfYear.getSelected() == 32, this.kbSeason.getSelected() == 32, this.kbMonth.getSelected() == 32};
        return periodType;
    }

    public boolean getPeriodTypeAndBound() {
        BgPeriodInfo periodbegin = (BgPeriodInfo)this.prmtBgPeriodBegin.getData();
        BgPeriodInfo periodend = (BgPeriodInfo)this.prmtBgPeriodEnd.getData();
        Date beginDate = periodbegin.getBeginDate();
        Date endDate = periodend.getEndDate();
        boolean[] periodType = this.getPeriodType();
        int months = endDate.getMonth() - beginDate.getMonth() + 1;
        if (months < 3 && (periodType[0] || periodType[1] || periodType[2])) {
            return false;
        }
        if (months < 6 && (periodType[0] || periodType[1])) {
            return false;
        }
        return months >= 12 || !periodType[0];
    }

    public boolean verify() {
        boolean re = super.verify();
        if (this.prmtOrgUnit.getData() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"prmtOrgUnitIsNull"));
            return false;
        }
        if (this.tblBgItem.getRowCount() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"haveNullItemGroup"));
            return false;
        }
        re = false;
        for (int i = 0; i < this.tblBgItem.getRowCount(); ++i) {
            if (this.tblBgItem.getRow(i).getCell("bgItems") == null || this.tblBgItem.getRow(i).getCell("bgItems").getValue() == null) continue;
            re = true;
        }
        if (!re) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"haveNullItemGroup"));
            return re;
        }
        if (this.prmtBgElement.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.client.BgPredictItemResource", (String)"BgElementNotNull"));
            return false;
        }
        if (this.prmtBgPeriodBegin.getData() != null && this.prmtBgPeriodBegin.getData() instanceof BgPeriodInfo && this.prmtBgPeriodEnd.getData() != null && this.prmtBgPeriodEnd.getData() instanceof BgPeriodInfo) {
            boolean bln;
            BgPeriodInfo beginPeriod = (BgPeriodInfo)this.prmtBgPeriodBegin.getData();
            BgPeriodInfo endPeriod = (BgPeriodInfo)this.prmtBgPeriodEnd.getData();
            if (!beginPeriod.getPeriodType().equals((Object)endPeriod.getPeriodType())) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"checkBgPeriodType"));
                SysUtil.abort();
            }
            if (!(bln = BgHelper.compareBgPeriodBegin2End((BgPeriodInfo)beginPeriod, (BgPeriodInfo)endPeriod))) {
                this.prmtBgPeriodEnd.requestFocus();
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"checkBgPeriodOrder"));
                SysUtil.abort();
            }
            if (!this.getPeriodTypeAndBound()) {
                this.prmtBgPeriodBegin.requestFocus();
                MsgBox.showWarning((String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.SimForecastFilterResource", "periodTypeAndBound"));
                return false;
            }
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.client.BgPredictItemResource", (String)"bgPeriodNotNull"));
            return false;
        }
        if (this.comboCurrency.getSelectedIndex() == -1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"currencyBoxIsNull"));
            return false;
        }
        if (!(this.kbYear.isSelected() || this.kbHarfYear.isSelected() || this.kbSeason.isSelected() || this.kbMonth.isSelected())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.client.BgPredictItemResource", (String)"checkBoxIsNull"));
            return false;
        }
        return re;
    }

    protected FilterParam createNewFilterParam() {
        return new BgPredictFilterParam();
    }

    protected void setFilterParam(FilterParam filterParam) {
        super.setFilterParam(filterParam);
        if (filterParam != null && filterParam instanceof BgPredictFilterParam) {
            BgPredictFilterParam _filterParam = (BgPredictFilterParam)filterParam;
            _filterParam.setBgPredict(this.comboBgPredictMethod.getSelectedIndex());
            _filterParam.setHistoryDataType(this.comboPreviousDataType.getSelectedIndex());
            _filterParam.setCurrOrgUnitInfo(this.getCurrOrgUnit());
            OrgUnitInfo[] orgUnits = null;
            Object orgObj = this.prmtOrgUnit.getData();
            if (orgObj != null && orgObj instanceof OrgUnitInfo) {
                orgUnits = new OrgUnitInfo[]{(OrgUnitInfo)orgObj};
            } else if (orgObj instanceof OrgUnitInfo[]) {
                orgUnits = (OrgUnitInfo[])orgObj;
            }
            _filterParam.setOrgUnits(orgUnits);
            if (this.tblBgItem != null && this.tblBgItem.getRowCount() > 0) {
                IRow row = null;
                BgItemGroupInfo bgItemGroupInfo = null;
                String bgItems = null;
                String reffield = null;
                HashMap muMap = new HashMap();
                _filterParam.setMuMap(muMap);
                for (int i = 0; i < this.tblBgItem.getRowCount(); ++i) {
                    row = this.tblBgItem.getRow(i);
                    Object _obj = row.getCell(0).getValue();
                    bgItemGroupInfo = _obj instanceof BgItemGroupInfo ? (BgItemGroupInfo)_obj : null;
                    _obj = row.getCell(1).getValue();
                    bgItems = _obj instanceof String ? (String)_obj : null;
                    _obj = row.getCell(2).getValue();
                    reffield = _obj instanceof String ? (String)_obj : null;
                    HashMap<String, String> map = new HashMap<String, String>();
                    if (bgItems != null && reffield != null) {
                        map.put(reffield, bgItems);
                    }
                    if (bgItemGroupInfo == null || map == null || map.isEmpty()) continue;
                    _filterParam.getMuMap().put(bgItemGroupInfo, map);
                }
            }
            BgElementInfo[] bgElements = null;
            Object bgElementObj = this.prmtBgElement.getData();
            if (bgElementObj != null) {
                Object bgElementInfo = null;
                if (bgElementObj != null && bgElementObj instanceof BgElementInfo) {
                    bgElements = new BgElementInfo[]{(BgElementInfo)bgElementObj};
                } else if (bgElementObj instanceof Object[]) {
                    Object[] obj = (Object[])bgElementObj;
                    bgElements = new BgElementInfo[obj.length];
                    for (int i = 0; i < obj.length; ++i) {
                        if (!(obj[i] instanceof BgElementInfo)) continue;
                        bgElements[i] = (BgElementInfo)obj[i];
                    }
                }
                _filterParam.setBgElement(bgElements);
            }
            if (this.comboCurrency.getSelectedItem() != null) {
                _filterParam.setCurrency((CurrencyInfo)this.comboCurrency.getSelectedItem());
            } else {
                _filterParam.setCurrency(null);
            }
            if (this.prmtBgPeriodBegin.getData() != null) {
                _filterParam.setBgPeriodBegin((BgPeriodInfo)this.prmtBgPeriodBegin.getData());
            } else {
                _filterParam.setBgPeriodBegin(null);
            }
            if (this.prmtBgPeriodEnd.getData() != null) {
                _filterParam.setBgPeriodEnd((BgPeriodInfo)this.prmtBgPeriodEnd.getData());
            } else {
                _filterParam.setBgPeriodEnd(null);
            }
            _filterParam.setKbYear(this.kbYear.isSelected());
            _filterParam.setKbHarfYear(this.kbHarfYear.isSelected());
            _filterParam.setKbSeason(this.kbSeason.isSelected());
            _filterParam.setKbMonth(this.kbMonth.isSelected());
            _filterParam.setIsCombine(this.isCombine.isSelected());
        }
    }

    protected void getFilterParamBefore(FilterParam filterParam) {
    }

    protected void getFilterParam(FilterParam filterParam) {
        super.getFilterParam(filterParam);
        if (filterParam != null && filterParam instanceof BgPredictFilterParam) {
            BgPredictFilterParam _filterParam = (BgPredictFilterParam)filterParam;
            this.getFilterParamBefore((FilterParam)_filterParam);
            if (_filterParam.getBgPredict() != 0) {
                this.comboBgPredictMethod.setSelectedIndex(_filterParam.getBgPredict());
            } else {
                this.comboBgPredictMethod.setSelectedIndex(0);
            }
            if (_filterParam.getHistoryDataType() != 0) {
                this.comboPreviousDataType.setSelectedIndex(_filterParam.getHistoryDataType());
            } else {
                this.comboPreviousDataType.setSelectedIndex(0);
            }
            if (_filterParam.getOrgUnits() != null) {
                this.prmtOrgUnit.setData((Object)_filterParam.getOrgUnits());
            } else {
                this.prmtOrgUnit.setData((Object)_filterParam.getCurrOrgUnitInfo());
            }
            this.tblBgItem.removeRows();
            if (_filterParam.getMuMap() != null && !_filterParam.getMuMap().isEmpty() && this.tblBgItem != null) {
                Map.Entry _entry2 = null;
                IRow _row = null;
                for (Map.Entry _entry2 : _filterParam.getMuMap().entrySet()) {
                    _row = this.tblBgItem.addRow();
                    _row.getCell(0).setValue(_entry2.getKey());
                    Map map = (Map)_entry2.getValue();
                    Map.Entry _entry1 = map.entrySet().iterator().next();
                    _row.getCell(1).setValue(_entry1.getValue());
                    _row.getCell(2).setValue(_entry1.getKey());
                }
            }
            if (_filterParam.getBgElement() != null) {
                this.prmtBgElement.setData((Object)_filterParam.getBgElement());
            } else {
                this.prmtBgElement.setData(null);
            }
            if (_filterParam.getCurrency() != null) {
                this.comboCurrency.setSelectedItem((Object)_filterParam.getCurrency());
            } else {
                this.comboCurrency.setSelectedIndex(0);
            }
            if (_filterParam.getBgPeriodBegin() != null) {
                this.prmtBgPeriodBegin.setData((Object)_filterParam.getBgPeriodBegin());
            } else {
                this.prmtBgPeriodBegin.setData(null);
            }
            if (_filterParam.getBgPeriodEnd() != null) {
                this.prmtBgPeriodEnd.setData((Object)_filterParam.getBgPeriodEnd());
            } else {
                this.prmtBgPeriodEnd.setData(null);
            }
            this.kbYear.setSelected(_filterParam.getKbYear() == null ? false : _filterParam.getKbYear());
            this.kbHarfYear.setSelected(_filterParam.getKbHarfYear() == null ? false : _filterParam.getKbHarfYear());
            this.kbSeason.setSelected(_filterParam.getKbSeason() == null ? false : _filterParam.getKbSeason());
            this.kbMonth.setSelected(_filterParam.getKbMonth() == null ? false : _filterParam.getKbMonth());
            this.isCombine.setSelected(_filterParam.getIsCombine() == null ? false : _filterParam.getIsCombine());
        }
    }

    protected void loadCustomerParams(CustomerParams cp, FilterParam filterParam) {
        int i;
        int in;
        super.loadCustomerParams(cp, filterParam);
        if (cp == null || filterParam == null || !(filterParam instanceof BgItemAnalyseParam)) {
            return;
        }
        String tmpStr = null;
        Map tmpMap = null;
        List ids = null;
        BgPredictFilterParam _filterParam = (BgPredictFilterParam)filterParam;
        tmpStr = cp.getCustomerParam(BGPREDICT_ID);
        if (!StringUtils.isEmpty((String)tmpStr)) {
            _filterParam.setBgPredict(Integer.parseInt(tmpStr));
        } else {
            _filterParam.setBgPredict(-1);
        }
        tmpStr = cp.getCustomerParam(HISTORYDATATYPE);
        if (!StringUtils.isEmpty((String)tmpStr)) {
            _filterParam.setHistoryDataType(Integer.parseInt(tmpStr));
        } else {
            _filterParam.setHistoryDataType(-1);
        }
        tmpStr = cp.getCustomerParam(CURR_ORGUNIT_ID);
        if (!StringUtils.isEmpty((String)tmpStr)) {
            _filterParam.setCurrOrgUnit(new FullOrgUnitInfo());
            _filterParam.getCurrOrgUnit().setId(BOSUuid.read((String)tmpStr));
        } else {
            _filterParam.setCurrOrgUnit(null);
        }
        ids = (List)BgAnalyseHelper.getObject((byte[])BgAnalyseHelper.decode((String)cp.getCustomerParam(ORGUNIT_IDS)));
        if (ids != null) {
            _filterParam.setOrgUnits(new OrgUnitInfo[ids.size()]);
            in = ids.size();
            for (i = 0; i < in; ++i) {
                tmpStr = (String)ids.get(i);
                if (StringUtils.isEmpty((String)tmpStr)) continue;
                _filterParam.getOrgUnits()[i] = new OrgUnitInfo();
                _filterParam.getOrgUnits()[i].setId(BOSUuid.read((String)tmpStr));
            }
        } else {
            _filterParam.setOrgUnits(null);
        }
        tmpMap = (Map)BgAnalyseHelper.getObject((byte[])BgAnalyseHelper.decode((String)cp.getCustomerParam(BGITEMS)));
        if (tmpMap != null) {
            _filterParam.setMuMap(tmpMap);
        } else {
            _filterParam.setMuMap(null);
        }
        ids = (List)BgAnalyseHelper.getObject((byte[])BgAnalyseHelper.decode((String)cp.getCustomerParam(BGELEMENT_ID)));
        if (ids != null) {
            _filterParam.setBgElement(new BgElementInfo[ids.size()]);
            in = ids.size();
            for (i = 0; i < in; ++i) {
                tmpStr = (String)ids.get(i);
                if (StringUtils.isEmpty((String)tmpStr)) continue;
                _filterParam.getBgElement()[i] = new BgElementInfo();
                _filterParam.getBgElement()[i].setId(BOSUuid.read((String)tmpStr));
            }
        } else {
            _filterParam.setBgElement(null);
        }
        tmpStr = cp.getCustomerParam(CURRENCY_ID);
        if (!StringUtils.isEmpty((String)tmpStr)) {
            _filterParam.setCurrency(new CurrencyInfo());
            _filterParam.getCurrency().setId(BOSUuid.read((String)tmpStr));
        } else {
            _filterParam.setCurrency(null);
        }
        tmpStr = cp.getCustomerParam(BGPERIOD_BEGIN_ID);
        if (!StringUtils.isEmpty((String)tmpStr)) {
            _filterParam.setBgPeriodBegin(new BgPeriodInfo());
            _filterParam.getBgPeriodBegin().setId(BOSUuid.read((String)tmpStr));
        } else {
            _filterParam.setBgPeriodBegin(null);
        }
        tmpStr = cp.getCustomerParam(BGPERIOD_END_ID);
        if (!StringUtils.isEmpty((String)tmpStr)) {
            _filterParam.setBgPeriodEnd(new BgPeriodInfo());
            _filterParam.getBgPeriodEnd().setId(BOSUuid.read((String)tmpStr));
        } else {
            _filterParam.setBgPeriodEnd(null);
        }
        tmpStr = cp.getCustomerParam(KBYEAR);
        if (!StringUtils.isEmpty((String)tmpStr) && BgNConstants.TRUE_STE.equals(tmpStr)) {
            _filterParam.setKbYear(Boolean.TRUE);
        } else {
            _filterParam.setKbYear(Boolean.FALSE);
        }
        tmpStr = cp.getCustomerParam(KBHARFYEAR);
        if (!StringUtils.isEmpty((String)tmpStr) && BgNConstants.TRUE_STE.equals(tmpStr)) {
            _filterParam.setKbHarfYear(Boolean.TRUE);
        } else {
            _filterParam.setKbHarfYear(Boolean.FALSE);
        }
        tmpStr = cp.getCustomerParam(KBSEASON);
        if (!StringUtils.isEmpty((String)tmpStr) && BgNConstants.TRUE_STE.equals(tmpStr)) {
            _filterParam.setKbSeason(Boolean.TRUE);
        } else {
            _filterParam.setKbSeason(Boolean.FALSE);
        }
        tmpStr = cp.getCustomerParam(KBMONTH);
        if (!StringUtils.isEmpty((String)tmpStr) && BgNConstants.TRUE_STE.equals(tmpStr)) {
            _filterParam.setKbMonth(Boolean.TRUE);
        } else {
            _filterParam.setKbMonth(Boolean.FALSE);
        }
        tmpStr = cp.getCustomerParam(ISCOMBINE);
        if (!StringUtils.isEmpty((String)tmpStr) && BgNConstants.TRUE_STE.equals(tmpStr)) {
            _filterParam.setIsCombine(Boolean.TRUE);
        } else {
            _filterParam.setIsCombine(Boolean.FALSE);
        }
    }

    protected void saveCustomerParams(CustomerParams cp, FilterParam filterParam) {
        super.saveCustomerParams(cp, filterParam);
        if (cp == null || filterParam == null || !(filterParam instanceof BgPredictFilterParam)) {
            return;
        }
        BgPredictFilterParam _filterParam = (BgPredictFilterParam)filterParam;
        HashMap<String, String> tmpMap = null;
        ArrayList<String> tmpList = null;
        Map.Entry _entry2 = null;
        BgItemGroupInfo bgItemGroupInfo = null;
        String bgItems = null;
        String reffield = null;
        OrgUnitInfo _unitInfo = null;
        if (_filterParam.getBgPredict() >= 0) {
            cp.addCustomerParam(BGPREDICT_ID, _filterParam.getBgPredict() + "");
        } else {
            cp.removeCustomerParam(BGPREDICT_ID);
        }
        if (_filterParam.getHistoryDataType() >= 0) {
            cp.addCustomerParam(HISTORYDATATYPE, _filterParam.getHistoryDataType() + "");
        } else {
            cp.removeCustomerParam(HISTORYDATATYPE);
        }
        if (_filterParam.getCurrOrgUnitInfo() != null) {
            cp.addCustomerParam(CURR_ORGUNIT_ID, _filterParam.getCurrOrgUnitInfo().getId().toString());
        } else {
            cp.removeCustomerParam(CURR_ORGUNIT_ID);
        }
        if (_filterParam.getOrgUnits() != null) {
            tmpList = new ArrayList<String>();
            for (int i = 0; i < _filterParam.getOrgUnits().length; ++i) {
                _unitInfo = _filterParam.getOrgUnits()[i];
                if (_unitInfo == null) continue;
                tmpList.add(_unitInfo.getId().toString());
            }
            if (!tmpList.isEmpty()) {
                cp.addCustomerParam(ORGUNIT_IDS, BgAnalyseHelper.encode((byte[])BgAnalyseHelper.getBytes(tmpList)));
            } else {
                cp.removeCustomerParam(ORGUNIT_IDS);
            }
        } else {
            cp.removeCustomerParam(ORGUNIT_IDS);
        }
        if (_filterParam.getMuMap() != null && !_filterParam.getMuMap().isEmpty()) {
            tmpMap = new HashMap<String, String>();
            for (Map.Entry _entry2 : _filterParam.getMuMap().entrySet()) {
                bgItemGroupInfo = (BgItemGroupInfo)_entry2.getKey();
                bgItems = (String)_entry2.getValue();
                reffield = (String)_entry2.getValue();
                tmpMap.put(bgItemGroupInfo.getId().toString(), bgItems);
            }
            if (!tmpMap.isEmpty()) {
                cp.addCustomerParam(BGITEMS, BgAnalyseHelper.encode((byte[])BgAnalyseHelper.getBytes(tmpMap)));
            } else {
                cp.removeCustomerParam(BGITEMS);
            }
        } else {
            cp.removeCustomerParam(BGITEMS);
        }
        if (_filterParam.getBgElement() != null) {
            BgElementInfo bgElementInfo = null;
            tmpList = new ArrayList();
            for (int i = 0; i < _filterParam.getBgElement().length; ++i) {
                bgElementInfo = _filterParam.getBgElement()[i];
                if (bgElementInfo == null) continue;
                tmpList.add(bgElementInfo.getId().toString());
            }
            if (!tmpList.isEmpty()) {
                cp.addCustomerParam(BGELEMENT_ID, BgAnalyseHelper.encode((byte[])BgAnalyseHelper.getBytes(tmpList)));
            } else {
                cp.removeCustomerParam(BGELEMENT_ID);
            }
        } else {
            cp.removeCustomerParam(BGELEMENT_ID);
        }
        if (_filterParam.getCurrency() != null) {
            cp.addCustomerParam(CURRENCY_ID, _filterParam.getCurrency().getId().toString());
        } else {
            cp.removeCustomerParam(CURRENCY_ID);
        }
        if (_filterParam.getBgPeriodBegin() != null) {
            cp.addCustomerParam(BGPERIOD_BEGIN_ID, _filterParam.getBgPeriodBegin().getId().toString());
        } else {
            cp.removeCustomerParam(BGPERIOD_BEGIN_ID);
        }
        if (_filterParam.getBgPeriodEnd() != null) {
            cp.addCustomerParam(BGPERIOD_END_ID, _filterParam.getBgPeriodEnd().getId().toString());
        } else {
            cp.removeCustomerParam(BGPERIOD_END_ID);
        }
        if (_filterParam.getKbYear().booleanValue()) {
            cp.addCustomerParam(KBYEAR, _filterParam.getKbYear().toString());
        } else {
            cp.removeCustomerParam(KBYEAR);
        }
        if (_filterParam.getKbHarfYear().booleanValue()) {
            cp.addCustomerParam(KBHARFYEAR, _filterParam.getKbHarfYear().toString());
        } else {
            cp.removeCustomerParam(KBHARFYEAR);
        }
        if (_filterParam.getKbSeason().booleanValue()) {
            cp.addCustomerParam(KBSEASON, _filterParam.getKbSeason().toString());
        } else {
            cp.removeCustomerParam(KBSEASON);
        }
        if (_filterParam.getKbMonth().booleanValue()) {
            cp.addCustomerParam(KBMONTH, _filterParam.getKbMonth().toString());
        } else {
            cp.removeCustomerParam(KBMONTH);
        }
        if (_filterParam.getIsCombine().booleanValue()) {
            cp.addCustomerParam(ISCOMBINE, _filterParam.getIsCombine().toString());
        } else {
            cp.removeCustomerParam(ISCOMBINE);
        }
    }
}

