/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IUserCellDisplayParser;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.budget.BgSchemeCollection;
import com.kingdee.eas.ma.budget.BgSchemeFactory;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.IBgScheme;
import com.kingdee.eas.ma.nbudget.client.AbstractBgSchemeFilterUI;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class BgSchemeFilterUI
extends AbstractBgSchemeFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(BgSchemeFilterUI.class);
    protected Object ui = null;
    CommonQueryDialog cqDialog = null;
    private OrgUnitInfo currOrgUnit = SysContext.getSysContext().getCurrentOrgUnit();
    private OrgUnitInfo defOrgUnitInfo = null;
    private OrgUnitInfo[] orgUnitInfos = null;

    public void clear() {
        super.clear();
        this.tblSuheme.removeRows();
    }

    public BgSchemeFilterUI() throws Exception {
    }

    public BgSchemeFilterUI(Object ui, Object orgUnitInfo) throws Exception {
        this.ui = ui;
        this.defOrgUnitInfo = orgUnitInfo != null && orgUnitInfo instanceof OrgUnitInfo ? (OrgUnitInfo)orgUnitInfo : SysContext.getSysContext().getCurrentCostUnit();
    }

    public BgSchemeFilterUI(Object ui, CommonQueryDialog cqDialog) throws Exception {
        this.ui = ui;
        this.cqDialog = cqDialog;
        if (this.cqDialog != null) {
            this.onLoad();
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public String getUITitle() {
        return BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.SimForecastFilterResource", "schemeFilterTitle");
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setEvi(this.orgUnitInfos);
    }

    public void setEvi(OrgUnitInfo[] orgUnitInfos) throws Exception {
        EntityViewInfo evi = null;
        if (orgUnitInfos != null) {
            evi = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            evi.setFilter(filterInfo);
            HashSet<String> subOrgUnits = new HashSet<String>();
            if (orgUnitInfos.length >= 1) {
                int n = orgUnitInfos.length;
                for (int i = 0; i < n; ++i) {
                    subOrgUnits.add(orgUnitInfos[i].getId().toString());
                }
            }
            if (subOrgUnits != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.id", subOrgUnits, CompareType.INCLUDE));
            }
        }
        this.initFilter(evi);
    }

    protected void initFilter(EntityViewInfo evi) throws Exception {
        this.tblSuheme.checkParsed();
        this.tblSuheme.removeRows();
        if (evi != null) {
            this.btnAddNew.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
            this.btnRemove.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
            KDBizPromptBox prmtSelect = new KDBizPromptBox();
            prmtSelect.setQueryInfo("com.kingdee.eas.ma.budget.BgSchemeQuery");
            prmtSelect.setVisible(true);
            prmtSelect.setEditable(false);
            prmtSelect.setEditFormat("$number$");
            prmtSelect.setDisplayFormat("$number$");
            prmtSelect.setCommitFormat("$number$");
            prmtSelect.setEntityViewInfo(evi);
            prmtSelect.setEnabledMultiSelection(true);
            prmtSelect.addPreChangeListener((PreChangeListener)new PreChangeHandler());
            this.tblSuheme.getColumn(0).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtSelect));
            this.tblSuheme.setUserCellDisplayParser((IUserCellDisplayParser)new AnalyseCellDisplayParser());
        }
    }

    protected Object formatCellDisplay(int rowIndex, int colIndex, ICell cell, Object value) {
        if (value instanceof Object[]) {
            Object[] _objs = (Object[])value;
            if (_objs[0] != null) {
                return this.formatCellDisplay(rowIndex, colIndex, cell, _objs[0]);
            }
        } else if (value instanceof BgSchemeInfo) {
            return ((BgSchemeInfo)value).getNumber();
        }
        return value;
    }

    public BgSchemeInfo[] getScheme() {
        BgSchemeInfo[] schemes = new BgSchemeInfo[this.tblSuheme.getRowCount()];
        for (int i = 0; i <= this.tblSuheme.getRowCount() - 1; ++i) {
            Object obj = this.tblSuheme.getCell(i, 0).getValue();
            schemes[i] = (BgSchemeInfo)obj;
        }
        return schemes;
    }

    public boolean verify() {
        boolean re = super.verify();
        if (re && this.tblSuheme.getRowCount() < 1) {
            this.tblSuheme.requestFocus();
            MsgBox.showWarning((String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.SimForecastFilterResource", "schemeFilter"));
            return false;
        }
        return re;
    }

    protected BgSchemeCollection getBgSchemeInfo() throws Exception {
        EntityViewInfo muView = new EntityViewInfo();
        FilterInfo muFilter = new FilterInfo();
        muFilter.getFilterItems().add(new FilterItemInfo("measureUnitGroup.number", (Object)"BUDGET", CompareType.EQUALS));
        muView.setFilter(muFilter);
        return null;
    }

    protected IBgScheme getSchemeInterface() throws Exception {
        return BgSchemeFactory.getRemoteInstance();
    }

    protected KDTable getMuTable() {
        return this.tblSuheme;
    }

    @Override
    protected void btnAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.btnAddNew_actionPerformed(e);
        if (this.getMuTable() != null) {
            this.getMuTable().addRow();
        }
    }

    @Override
    protected void btnRemove_actionPerformed(ActionEvent e) throws Exception {
        super.btnRemove_actionPerformed(e);
        if (this.getMuTable() != null && this.getMuTable().getSelectManager().getActiveRowIndex() >= 0) {
            this.getMuTable().removeRow(this.getMuTable().getSelectManager().getActiveRowIndex());
        }
    }

    @Override
    protected void tblSuheme_editValuChanged(KDTEditEvent e) throws Exception {
    }

    @Override
    protected void tblShem_editStopped(KDTEditEvent e) throws Exception {
        BgSchemeInfo scheme = new BgSchemeInfo();
        Object obj = this.tblSuheme.getCell(e.getRowIndex(), 0).getValue();
        if (obj != null) {
            for (int i = 0; i < e.getRowIndex(); ++i) {
                Object obj2 = this.tblSuheme.getCell(i, 0).getValue();
                if (obj == null || obj2 == null || !((BgSchemeInfo)obj).getId().toString().equals(((BgSchemeInfo)obj2).getId().toString())) continue;
                this.tblSuheme.getCell(e.getRowIndex(), 0).setValue(null);
                MsgBox.showWarning((String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.SimForecastFilterResource", "noDouble"));
                return;
            }
            scheme = (BgSchemeInfo)obj;
            this.tblSuheme.getCell(e.getRowIndex(), "name").setValue((Object)scheme.getName());
            this.tblSuheme.getCell(e.getRowIndex(), "execu").setValue((Object)scheme.isIsFormal());
            this.tblSuheme.getCell(e.getRowIndex(), "beginTime").setValue((Object)scheme.getDateFrom());
            this.tblSuheme.getCell(e.getRowIndex(), "endTime").setValue((Object)scheme.getDateTo());
        }
    }

    public OrgUnitInfo getCurrOrgUnit() {
        return this.currOrgUnit;
    }

    private final class AnalyseCellDisplayParser
    implements IUserCellDisplayParser {
        private AnalyseCellDisplayParser() {
        }

        public Object parse(int rowIndex, int colIndex, ICell cell, Object value) {
            return BgSchemeFilterUI.this.formatCellDisplay(rowIndex, colIndex, cell, value);
        }
    }

    public class PreChangeHandler
    implements PreChangeListener {
        public void preChange(PreChangeEvent e) {
            Object obj = e.getData();
            int rowIndex = BgSchemeFilterUI.this.tblSuheme.getSelectManager().getActiveRowIndex();
            BgSchemeInfo scheme = null;
            if (obj instanceof Object[]) {
                BgSchemeFilterUI.this.tblSuheme.removeRow(rowIndex);
                int j = rowIndex;
                block0: for (Object o : (Object[])obj) {
                    scheme = (BgSchemeInfo)o;
                    for (int i = 0; i < BgSchemeFilterUI.this.tblSuheme.getRowCount(); ++i) {
                        Object obj2 = BgSchemeFilterUI.this.tblSuheme.getCell(i, 0).getValue();
                        if (obj2 != null && scheme.getId().toString().equals(((BgSchemeInfo)obj2).getId().toString())) continue block0;
                    }
                    BgSchemeFilterUI.this.tblSuheme.addRow(j);
                    BgSchemeFilterUI.this.tblSuheme.getCell(j, "number").setValue((Object)scheme);
                    BgSchemeFilterUI.this.tblSuheme.getCell(j, "name").setValue((Object)scheme.getName());
                    BgSchemeFilterUI.this.tblSuheme.getCell(j, "execu").setValue((Object)scheme.isIsFormal());
                    BgSchemeFilterUI.this.tblSuheme.getCell(j, "beginTime").setValue((Object)scheme.getDateFrom());
                    BgSchemeFilterUI.this.tblSuheme.getCell(j, "endTime").setValue((Object)scheme.getDateTo());
                    ++j;
                }
            }
            e.setResult(0);
        }
    }
}

