/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.budget.BgCollectFacadeFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.budget.IBgCollectFacade;
import com.kingdee.eas.ma.budget.analysiscolumn.DataDealCenter;
import com.kingdee.eas.ma.nbudget.BgInfoHelper;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgSpecialData;
import com.kingdee.eas.ma.nbudget.client.AbstractBgSpecialCollectViewUI;
import com.kingdee.eas.ma.nbudget.client.BgNFormProcessUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgSpecialCollectViewUI
extends AbstractBgSpecialCollectViewUI {
    private static final Logger logger = CoreUIObject.getLogger(BgSpecialCollectViewUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.setBounds(new Rectangle(10, 10, 900, 1390));
        this.processInitSystem();
    }

    protected void initWorkButton() {
        this.txtBgElementName.setEditable(false);
        this.txtBgItemName.setEditable(false);
        this.txtBgItemNumber.setEditable(false);
    }

    private void processInitSystem() {
        ArrayList dataList = null;
        String sign = null;
        if (this.getUIContext().get("BGELEMENT_INFO") != null) {
            this.txtBgElementName.setText(this.getUIContext().get("BGELEMENT_INFO").toString());
        }
        if (this.getUIContext().get("BGITEM_INFO") != null) {
            this.txtBgItemName.setText(this.getUIContext().get("BGITEM_INFO").toString());
        }
        if (this.getUIContext().get("BGITEM_ID") != null) {
            this.txtBgItemNumber.setText(this.getUIContext().get("BGITEM_ID").toString());
        }
        if (this.getUIContext().get("IDS") != null) {
            sign = this.getUIContext().get("IDS").toString();
        }
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("money").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        Class<?> cls = null;
        try {
            cls = Class.forName("com.kingdee.eas.ma.nbudget.client.SpecialDataAnalysisElement");
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        Field f = null;
        Object fieldName = null;
        try {
            if (cls == null) {
                return;
            }
            f = cls.getField(sign);
            this.tblMain.getHeadRow(0).getCell(3).setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.BgFormAnalyseLableResource", (String)f.get(fieldName).toString()));
        }
        catch (SecurityException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        catch (NoSuchFieldException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        if (this.getUIContext().get("GATHER_VIEW_TYPE_ITEM") == null) {
            return;
        }
        dataList = (ArrayList)this.getUIContext().get("GATHER_VIEW_TYPE_ITEM");
        Map bgItemSpecificMap = (Map)this.getUIContext().get("@");
        BgSpecialData specialData = null;
        Iterator iter = dataList.iterator();
        int pecision = Integer.parseInt(this.getUIContext().get("CURRENCY_PRECISION").toString());
        String tmp = "";
        String filldata = "";
        DecimalFormat decFormat = null;
        decFormat = pecision > 0 ? BgNationalFormatUIUtil.getDecimalFormat((int)pecision) : new DecimalFormat("#,##0%", BgNationalFormatUIUtil.getDecimalFormatSymbols());
        while (iter.hasNext()) {
            specialData = (BgSpecialData)iter.next();
            IRow row = this.tblMain.addRow();
            row.getCell(0).setValue((Object)specialData.getOrgUnitName());
            row.getCell(1).setValue((Object)specialData.getBgItemGroupName());
            row.getCell(2).setValue((Object)BgInfoHelper.getBgItemName(specialData.getSpecialNumber(), bgItemSpecificMap));
            if ("col4".equals(sign)) {
                row.getCell(3).getStyleAttributes().setNumberFormat("#,##0." + BgNFSHelper.getNumberFormat("0", pecision));
                row.getCell(3).setValue((Object)specialData.getBudgetValue());
            }
            if ("col0".equals(sign)) {
                row.getCell(3).getStyleAttributes().setNumberFormat("#,##0." + BgNFSHelper.getNumberFormat("0", pecision));
                row.getCell(3).setValue((Object)specialData.getActualValue());
            }
            if ("col6".equals(sign)) {
                row.getCell(3).getStyleAttributes().setNumberFormat("#,##0." + BgNFSHelper.getNumberFormat("0", pecision));
                row.getCell(3).setValue((Object)specialData.getAdjustValue());
            }
            if (specialData.getBudgetValue().compareTo(DataDealCenter.ZERO) == 0) {
                if ("col1".equals(sign) || "co3".equals(sign)) {
                    tmp = decFormat.format(DataDealCenter.ZERO);
                    row.getCell(3).setValue((Object)(tmp + "%"));
                }
            } else {
                if ("col1".equals(sign)) {
                    filldata = decFormat.format(specialData.getActualValue().multiply(new BigDecimal(100)).divide(specialData.getBudgetValue(), pecision, 4));
                    row.getCell(3).setValue((Object)(filldata + "%"));
                }
                if ("col3".equals(sign)) {
                    filldata = decFormat.format(specialData.getBudgetValue().subtract(specialData.getActualValue()).multiply(new BigDecimal(100)).divide(specialData.getBudgetValue(), pecision, 4));
                    row.getCell(3).setValue((Object)(String.valueOf(filldata) + "%"));
                }
            }
            if ("col2".equals(sign)) {
                row.getCell(3).getStyleAttributes().setNumberFormat("#,##0." + BgNFSHelper.getNumberFormat("0", pecision));
                row.getCell(3).setValue((Object)specialData.getExecuteDif());
            }
            row.setUserObject((Object)specialData.getBgFormId());
        }
    }

    @Override
    protected void btnViewRpt_actionPerformed(ActionEvent e) throws Exception {
        this.openReport(OprtState.VIEW);
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.openReport(OprtState.VIEW);
        }
    }

    protected void openReport(String reportState) throws Exception {
        BgFormInfo _bgFormInfo;
        String _billId;
        String _bosType;
        String billId;
        if (this.tblMain.getBody().size() == 0) {
            return;
        }
        int activeRowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (activeRowIndex < 0) {
            activeRowIndex = 0;
        }
        if ((billId = this.tblMain.getRow(activeRowIndex).getUserObject().toString()) != null && !StringUtils.isEmpty((String)billId.toString()) && (_bosType = BOSUuid.read((String)(_billId = billId.toString())).getType().toString()).equals((_bgFormInfo = new BgFormInfo()).getBOSType().toString())) {
            BOSUuid bgFormIdStr = BOSUuid.read((String)_billId.toString());
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ID", (Object)bgFormIdStr.toString());
            String name = BgNFormProcessUI.class.getName();
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(name, (Map)uiContext, null, reportState);
            uiWindow.show();
        }
    }

    protected IBgCollectFacade getBgCollectInterface() throws Exception {
        return BgCollectFacadeFactory.getRemoteInstance();
    }
}

