/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ma.nbudget.BgCellDataTypeEnum;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.client.AbstractBgViewCellUI;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.ma.nbudget.client.BgNFProcessUI;
import com.kingdee.eas.ma.nbudget.client.BgNProcessUI;
import com.kingdee.eas.ma.nbudget.client.BgNTemplateProcessUI;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class BgViewCellUI
extends AbstractBgViewCellUI {
    private static final long serialVersionUID = 799208920198585988L;
    private static final Logger logger = CoreUIObject.getLogger(BgViewCellUI.class);
    private BgNProcessUI ui = null;
    private Cell cell = null;
    private boolean isConfirm = false;

    public void onLoad() throws Exception {
        super.onLoad();
        Object _obj = this.getUIContext().get("Owner");
        if (_obj != null && _obj instanceof BgNProcessUI) {
            this.ui = (BgNProcessUI)_obj;
        }
        if ((_obj = this.getUIContext().get("CELL")) != null && _obj instanceof Cell) {
            this.cell = (Cell)_obj;
        }
        if (this.ui instanceof BgNFProcessUI) {
            if (((BgNFProcessUI)this.ui).getBgFormInfo().getState().getValue() == 1) {
                this.btnClear.setEnabled(true);
            } else {
                this.btnClear.setEnabled(false);
            }
        } else if (this.ui instanceof BgNTemplateProcessUI) {
            this.btnClear.setEnabled(true);
        } else {
            this.btnClear.setEnabled(false);
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        this.loadCellInfo();
        this.tblMain.checkParsed();
        this.tblMain.getColumn(2).getStyleAttributes().setLocked(false);
    }

    protected void loadCellInfo() throws Exception {
        if (this.cell == null || this.ui == null) {
            return;
        }
        IRow _row = null;
        ICell _cell = null;
        BgCellDataTypeEnum _enum = null;
        this.tblMain.removeRows();
        Iterator iter = BgCellDataTypeEnum.iterator();
        while (iter.hasNext()) {
            _enum = (BgCellDataTypeEnum)((Object)iter.next());
            _row = this.tblMain.addRow();
            _row.getCell(0).setValue((Object)Boolean.FALSE);
            _row.getCell(1).setValue((Object)_enum.getAlias());
            _row.getCell(1).setUserObject((Object)_enum);
        }
        int in = this.tblMain.getBody().size();
        for (int i = 0; i < in; ++i) {
            _row = this.tblMain.getRow(i);
            _cell = _row.getCell(2);
            _enum = (BgCellDataTypeEnum)((Object)_row.getCell(1).getUserObject());
            if (_enum.getValue() == 1) {
                this.load_bgFormula(_cell, this.cell);
                _row.getStyleAttributes().setLocked(true);
                continue;
            }
            if (_enum.getValue() == 2) {
                this.load_budget_expression(_cell, this.cell);
                continue;
            }
            if (_enum.getValue() == 3) {
                this.load_actual_expression(_cell, this.cell);
                continue;
            }
            if (_enum.getValue() == 4) {
                this.load_add_expression(_cell, this.cell);
                continue;
            }
            if (_enum.getValue() == 5) {
                this.load_budget_value(_cell, this.cell);
                _row.getStyleAttributes().setLocked(true);
                continue;
            }
            if (_enum.getValue() == 6) {
                this.load_actual_value(_cell, this.cell);
                _row.getStyleAttributes().setLocked(true);
                continue;
            }
            if (_enum.getValue() == 7) {
                this.load_add_value(_cell, this.cell);
                _row.getStyleAttributes().setLocked(true);
                continue;
            }
            if (_enum.getValue() == 8) {
                this.load_bgItem(_cell, this.cell);
                continue;
            }
            if (_enum.getValue() == 9) {
                this.load_bgPeriod(_cell, this.cell);
                continue;
            }
            if (_enum.getValue() == 10) {
                this.load_bgElement(_cell, this.cell);
                continue;
            }
            if (_enum.getValue() == 11) {
                this.load_Currency(_cell, this.cell);
                continue;
            }
            if (_enum.getValue() == 12) {
                this.load_bgLink(_cell, this.cell);
                continue;
            }
            if (_enum.getValue() == 13) {
                this.load_row_sign(_cell, this.cell);
                continue;
            }
            if (_enum.getValue() != 14) continue;
            this.load_col_sign(_cell, this.cell);
        }
    }

    public String getBgItemNumber() {
        ICell cell = this.tblMain.getCell(7, 2);
        if (cell == null) {
            return null;
        }
        Object obj = cell.getValue();
        if (obj == null) {
            return null;
        }
        return (String)cell.getValue();
    }

    protected void load_bgFormula(ICell cell, Cell srcCell) throws Exception {
        if (BgNFSHelper.checkHasFormulaOfCell(srcCell)) {
            cell.setValue((Object)BgNFSHelper.getFormulaOfCell(srcCell));
        }
    }

    protected void load_budget_expression(ICell cell, Cell srcCell) throws Exception {
        if (BgNFSHelper.checkHasExpression(srcCell, 0)) {
            cell.setValue((Object)BgNFSHelper.loadExpression(srcCell, 0));
        }
    }

    protected void load_actual_expression(ICell cell, Cell srcCell) throws Exception {
        if (BgNFSHelper.checkHasExpression(srcCell, 1)) {
            cell.setValue((Object)BgNFSHelper.loadExpression(srcCell, 1));
        }
    }

    protected void load_add_expression(ICell cell, Cell srcCell) throws Exception {
        if (BgNFSHelper.checkHasExpression(srcCell, 2)) {
            cell.setValue((Object)BgNFSHelper.loadExpression(srcCell, 2));
        }
    }

    protected void load_budget_value(ICell cell, Cell srcCell) throws Exception {
        if (BgNFSHelper.checkHasFormulaOfCell(srcCell)) {
            cell.setValue((Object)BgNFSHelper.getBudgetValue(srcCell));
        }
    }

    protected void load_actual_value(ICell cell, Cell srcCell) throws Exception {
        if (BgNFSHelper.checkHasFormulaOfCell(srcCell)) {
            cell.setValue((Object)BgNFSHelper.getActualValue(srcCell));
        }
    }

    protected void load_add_value(ICell cell, Cell srcCell) throws Exception {
        if (BgNFSHelper.checkHasFormulaOfCell(srcCell)) {
            cell.setValue(BgNFSHelper.getValue(srcCell));
        }
    }

    protected void load_bgItem(ICell cell, Cell srcCell) throws Exception {
        if (BgNFSHelper.checkHasBgItemInfo(srcCell)) {
            String[] _bgItem = BgNFSHelper.getBgItemInfo(srcCell);
            cell.setValue((Object)_bgItem[1]);
        }
    }

    protected void load_bgPeriod(ICell cell, Cell srcCell) throws Exception {
        if (BgNFSHelper.checkHasBgPeriodInfo(srcCell)) {
            String[] _bgPeriod = BgNFSHelper.getBgPeriodInfo(srcCell);
            cell.setValue((Object)_bgPeriod[1]);
        }
    }

    protected void load_bgElement(ICell cell, Cell srcCell) throws Exception {
        if (BgNFSHelper.checkHasBgElementInfo(srcCell)) {
            String[] _bgElement = BgNFSHelper.getBgElementInfo(srcCell);
            cell.setValue((Object)_bgElement[1]);
        }
    }

    protected void load_Currency(ICell cell, Cell srcCell) throws Exception {
        if (BgNFSHelper.checkHasCurrencyInfo(srcCell)) {
            String[] _currency = BgNFSHelper.getCurrencyInfo(srcCell);
            cell.setValue((Object)_currency[1]);
        }
    }

    protected void load_bgLink(ICell cell, Cell srcCell) throws Exception {
        if (BgNFSHelper.checkHasLinked(srcCell)) {
            cell.setValue((Object)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgNFormResource", "bglink"));
        }
    }

    protected void load_row_sign(ICell cell, Cell srcCell) throws Exception {
        if (srcCell != null && BgNFSHelper.checkHasSign(srcCell.getSheet().getRow(srcCell.getRow(), false))) {
            cell.setValue((Object)BgNFSHelper.getRowSign(srcCell.getSheet().getRow(srcCell.getRow(), false)));
        }
    }

    protected void load_col_sign(ICell cell, Cell srcCell) throws Exception {
        if (srcCell != null && BgNFSHelper.checkHasSign(srcCell.getSheet().getColumn(srcCell.getCol(), false))) {
            cell.setValue((Object)BgNFSHelper.getColSign(srcCell.getSheet().getColumn(srcCell.getCol(), false)));
        }
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    @Override
    protected void btnClear_actionPerformed(ActionEvent e) throws Exception {
        if (this.cell == null || this.ui == null) {
            return;
        }
        IRow _row = null;
        ICell _cell = null;
        BgCellDataTypeEnum _enum = null;
        Boolean isSelected = null;
        int in = this.tblMain.getBody().size();
        for (int i = 0; i < in; ++i) {
            _row = this.tblMain.getRow(i);
            isSelected = (Boolean)_row.getCell(0).getValue();
            _enum = (BgCellDataTypeEnum)((Object)_row.getCell(1).getUserObject());
            if (_enum.getValue() == 1) continue;
            if (_enum.getValue() == 2) {
                if (!isSelected.booleanValue()) continue;
                this.clear_budget_expression(this.cell);
                continue;
            }
            if (_enum.getValue() == 3) {
                if (!isSelected.booleanValue()) continue;
                this.clear_actual_expression(this.cell);
                continue;
            }
            if (_enum.getValue() == 4) {
                if (!isSelected.booleanValue()) continue;
                this.clear_add_expression(this.cell);
                continue;
            }
            if (_enum.getValue() == 5 || _enum.getValue() == 6 || _enum.getValue() == 7) continue;
            if (_enum.getValue() == 8) {
                if (!isSelected.booleanValue()) continue;
                this.clear_bgitem(this.cell);
                continue;
            }
            if (_enum.getValue() == 9) {
                if (!isSelected.booleanValue()) continue;
                this.clear_bgPeriod(this.cell);
                continue;
            }
            if (_enum.getValue() == 10) {
                if (!isSelected.booleanValue()) continue;
                this.clear_bgElement(this.cell);
                continue;
            }
            if (_enum.getValue() == 11) {
                if (!isSelected.booleanValue()) continue;
                this.clear_currency(this.cell);
                continue;
            }
            if (_enum.getValue() != 12 || !isSelected.booleanValue()) continue;
            this.load_bgLink(_cell, this.cell);
        }
        this.loadCellInfo();
    }

    private void load_SheetCreaterID(ICell cell, Cell srcCell) {
        cell.setValue(srcCell.getSheet().getUserObjectValue("SHEET_CREATER_ID"));
    }

    protected void clear_budget_expression(Cell cell) throws Exception {
        BgNFSHelper.clearExpression(cell, 0);
    }

    protected void clear_actual_expression(Cell cell) throws Exception {
        BgNFSHelper.clearExpression(cell, 1);
    }

    protected void clear_add_expression(Cell cell) throws Exception {
        BgNFSHelper.clearExpression(cell, 2);
    }

    protected void clear_bgitem(Cell cell) throws Exception {
        BgNFSHelper.clearBgItemInfo(cell);
    }

    protected void clear_bgPeriod(Cell cell) throws Exception {
        BgNFSHelper.clearBgPeriodInfo(cell);
    }

    protected void clear_bgElement(Cell cell) throws Exception {
        BgNFSHelper.clearBgElementInfo(cell);
    }

    protected void clear_currency(Cell cell) throws Exception {
        BgNFSHelper.clearCurrencyInfo(cell);
    }

    protected void clear_bglink(Cell cell) throws Exception {
        BgNFSHelper.clearLinkOfCell(cell);
    }

    @Override
    protected void btnClose_actionPerformed(ActionEvent e) throws Exception {
        this.isConfirm = true;
        this.getUIWindow().close();
    }

    public boolean isConfirm() {
        return this.isConfirm;
    }
}

