/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.fi.newrpt.client.designer.IDisplayValueProvider;
import com.kingdee.eas.fi.rpt.ReportCalculateErrorProvider;
import com.kingdee.eas.ma.budget.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNWorkPaperHelper;
import com.kingdee.eas.ma.nbudget.BgWorkPaperInfo;
import com.kingdee.eas.ma.nbudget.BgWorkPaperMeasureUnitCollection;
import com.kingdee.eas.ma.nbudget.BgWorkPaperMeasureUnitInfo;
import com.kingdee.eas.ma.nbudget.client.BgWorkPaperProcessUI;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgWorkPaperDisplayValueProvider
implements IDisplayValueProvider {
    private static final Logger logger = CoreUIObject.getLogger(BgWorkPaperDisplayValueProvider.class);
    private Map currencyMap = new HashMap();
    private Map elementMap = null;
    private BigDecimal defCoefficient = null;
    private int precision = -1;
    private BgWorkPaperProcessUI ownUi = null;
    private BgWorkPaperInfo ownInfo = null;
    private Map formulaMap = new HashMap();

    public BgWorkPaperDisplayValueProvider(BgWorkPaperProcessUI ui) {
        this.ownUi = ui;
    }

    public BgWorkPaperDisplayValueProvider(BgWorkPaperInfo info) {
        this.ownInfo = info;
    }

    protected Map getFormulaMap() {
        return this.formulaMap;
    }

    protected Map getElementMap() {
        BgWorkPaperInfo info;
        if (this.elementMap == null && this.ownUi != null && (info = this.ownUi.getEditData()) != null && info.getWorkPaperMeasureUnit() != null) {
            this.elementMap = new HashMap();
            BgWorkPaperMeasureUnitCollection col = info.getWorkPaperMeasureUnit();
            BgWorkPaperMeasureUnitInfo mu = null;
            for (int i = 0; i < col.size(); ++i) {
                mu = col.get(i);
                if (mu == null || mu.getBgElement() == null || mu.getMeasureUnit() == null) continue;
                this.elementMap.put(mu.getBgElement().getNumber(), mu.getMeasureUnit().getCoefficient());
            }
        }
        return this.elementMap;
    }

    public Object getDisplayValue(Cell cell, int viewMode) {
        if (cell != null) {
            if (viewMode == 0) {
                if (!BgNFSHelper.checkIsEmptyValue(cell)) {
                    if (cell.getValue().getValue() instanceof GregorianCalendar) {
                        return cell.getText();
                    }
                    String _text = cell.getText();
                    if (!StringUtils.isEmpty((String)_text)) {
                        if ("#DIV/0!".equals(_text) || _text.indexOf("#BAD FUNCTION") >= 0) {
                            Object obj = cell.getSheet().getBook().getUserObjectValue("ERRORHANDLER");
                            if (obj instanceof ReportCalculateErrorProvider) {
                                ReportCalculateErrorProvider rcep = (ReportCalculateErrorProvider)obj;
                                if ("#DIV/0!".equals(_text)) {
                                    return rcep.getZeroDivDisplayAs();
                                }
                                if (_text.indexOf("#BAD FUNCTION") >= 0) {
                                    return rcep.getExceptionReplacer();
                                }
                            }
                            return _text;
                        }
                        return this.getDisplayValue(cell);
                    }
                }
            } else {
                if (viewMode == 1) {
                    if (cell.hasFormula()) {
                        return cell.getFormula();
                    }
                    return this.getDisplayValue(cell);
                }
                if (viewMode == 10) {
                    if (BgNFSHelper.checkHasFormulaOfCell(cell)) {
                        return BgNFSHelper.getDisplayFormula(BgNFSHelper.getFormulaOfCell(cell), this.getFormulaMap());
                    }
                    return this.getDisplayValue(cell);
                }
            }
        }
        return null;
    }

    private Object getDisplayValue(Cell cell) {
        Object obj = cell.getValue().getValue();
        String elementNumber = null;
        String[] ec = null;
        if (BgNFSHelper.checkHasPercentage(cell)) {
            return cell.getText();
        }
        elementNumber = BgNWorkPaperHelper.getElementNumber(cell.getSheet().getColumn(cell.getCol(), false));
        if (!StringUtils.isEmpty((String)elementNumber)) {
            return this.getDisplayValue(obj, this.getCoefficient(elementNumber), this.getPrecision(), cell);
        }
        ec = BgNWorkPaperHelper.getExpressElementCurrency(cell);
        if (ec != null) {
            elementNumber = ec[0];
            int precision = this.getPrecision(ec[1]);
            return this.getDisplayValue(obj, this.getCoefficient(elementNumber), precision, cell);
        }
        return this.getDisplayValue(obj, null, this.getPrecision(), cell);
    }

    protected String getDisplayValue(Object obj, BigDecimal coefficient, int precision, Cell cell) {
        String showStr;
        if (cell == null || obj == null) {
            return null;
        }
        if (coefficient == null) {
            return cell.getText();
        }
        if (!BgNFSHelper.checkHasNumbericOfCell(cell) || !BgNFSHelper.checkIsNumericOfCell(cell)) {
            return cell.getText();
        }
        if ("0".equals(obj.toString()) && (showStr = BgNFSHelper.checkShowStrByNumberic(cell)) != null) {
            return showStr;
        }
        precision = BgNFSHelper.getDigitOfNumber(cell, precision);
        String _text = null;
        BigDecimal _value = null;
        DecimalFormat _decFormat = null;
        try {
            _value = BgNationalFormatUIUtil.parseToBigDecimal((Object)obj).divide(coefficient, precision, 4);
            _decFormat = BgNationalFormatUIUtil.getDecimalFormat((int)precision);
            _text = _decFormat.format(_value);
        }
        catch (Exception ex) {
            _text = obj.toString();
        }
        return _text;
    }

    public int getPrecision() {
        BgWorkPaperInfo info;
        if (this.precision >= 0) {
            return this.precision;
        }
        this.precision = 3;
        if (this.ownUi != null && (info = this.ownUi.getEditData()) != null && info.getCurrency() != null) {
            this.precision = info.getCurrency().getPrecision();
        }
        return this.precision;
    }

    public int getPrecision(String currencyNumber) {
        int prec = -1;
        if (!StringUtils.isEmpty((String)currencyNumber)) {
            if (!this.currencyMap.containsKey(currencyNumber)) {
                try {
                    CurrencyCollection currCol = CurrencyFactory.getRemoteInstance().getCurrencyCollection("select id,number,precision where number ='" + currencyNumber + "'");
                    if (currCol != null && !currCol.isEmpty()) {
                        for (int i = 0; i < currCol.size(); ++i) {
                            this.currencyMap.put(currCol.get(i).getNumber(), new Integer(currCol.get(i).getPrecision()));
                        }
                    }
                }
                catch (BOSException e) {
                    logger.error((Object)"", (Throwable)e);
                }
            }
            if (this.currencyMap.containsKey(currencyNumber)) {
                prec = (Integer)this.currencyMap.get(currencyNumber);
            } else {
                this.currencyMap.put(currencyNumber, new Integer(prec));
            }
        }
        if (prec < 0) {
            return this.getPrecision();
        }
        return prec;
    }

    private BigDecimal getCoefficient(String elementNumber) {
        if (!StringUtils.isEmpty((String)elementNumber) && this.getElementMap() != null && this.getElementMap().containsKey(elementNumber)) {
            return (BigDecimal)this.getElementMap().get(elementNumber);
        }
        return this.getDefCoefficient();
    }

    private BigDecimal getDefCoefficient() {
        BgWorkPaperInfo info;
        if (this.defCoefficient == null && this.ownUi != null && (info = this.ownUi.getEditData()) != null && info.getMeasureUnit() != null) {
            this.defCoefficient = info.getMeasureUnit().getCoefficient();
        }
        if (this.defCoefficient == null) {
            return BgNConstants.ONE;
        }
        return this.defCoefficient;
    }
}

