/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Column;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.rpt.RptCell;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.nbudget.BgEliminationHelper;
import com.kingdee.eas.ma.nbudget.BgWorkDataSrcTypeEnum;
import com.kingdee.eas.ma.nbudget.client.AbstractBgWorkTemplateWizard_ShowResult_Items;
import com.kingdee.eas.ma.nbudget.client.BgElimUIUtil;
import com.kingdee.eas.ma.nbudget.client.BgWorkTemplateWizard_ChooseBgElementUI;
import com.kingdee.eas.ma.nbudget.client.BgWorkTemplateWizard_ChooseItemsUI;
import com.kingdee.eas.ma.nbudget.client.BgWorkTemplateWizard_ChooseTableHead;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BgWorkTemplateWizard_ShowResult_Items
extends AbstractBgWorkTemplateWizard_ShowResult_Items {
    private static final Logger logger = CoreUIObject.getLogger(BgWorkTemplateWizard_ShowResult_Items.class);
    private BgItemInfo[] items;
    private Sheet curSheet;
    private boolean hasSingle = false;
    private boolean hasSum = false;
    private boolean hasElim = false;
    private boolean hasManElim = false;
    private boolean hasCsl = false;
    private Vector bgElements = new Vector(0);

    public void onLoad() throws Exception {
        super.onLoad();
        BgElimUIUtil.initGuideImage(this.pnlImage);
        BgElimUIUtil.hmUIs.put(BgWorkTemplateWizard_ShowResult_Items.class.getName(), this);
        this.initParam();
        this.initTable();
        this.btnCancel.setEnabled(true);
        this.btnPreStep.setEnabled(true);
        this.btnNextStep.setEnabled(false);
        this.btnFinished.setEnabled(true);
        this.btnHelp.setVisible(false);
    }

    private void initParam() {
        this.items = this.getItemInfos();
        this.initTableHead();
        this.initBgElement();
        Object obj = BgElimUIUtil.hmUIs.get(BgWorkTemplateWizard_ChooseItemsUI.class.getName());
        if (obj != null && obj instanceof BgWorkTemplateWizard_ChooseItemsUI) {
            BgWorkTemplateWizard_ChooseItemsUI itemUI = (BgWorkTemplateWizard_ChooseItemsUI)((Object)obj);
            this.curSheet = itemUI.curSheet;
        }
    }

    private BgItemInfo[] getItemInfos() {
        Object obj = BgElimUIUtil.hmUIs.get(BgWorkTemplateWizard_ChooseItemsUI.class.getName());
        if (obj != null && obj instanceof BgWorkTemplateWizard_ChooseItemsUI) {
            BgWorkTemplateWizard_ChooseItemsUI itemUI = (BgWorkTemplateWizard_ChooseItemsUI)((Object)obj);
            KDTable table = itemUI.tblItems;
            BgItemInfo[] itemsLocal = new BgItemInfo[table.getRowCount()];
            for (int i = 0; i < table.getRowCount(); ++i) {
                IRow row = table.getRow(i);
                Object cellObj = row.getUserObject();
                itemsLocal[i] = cellObj != null && cellObj instanceof BgItemInfo ? (BgItemInfo)cellObj : null;
            }
            return itemsLocal;
        }
        return null;
    }

    private void initTableHead() {
        Object obj = BgElimUIUtil.hmUIs.get(BgWorkTemplateWizard_ChooseTableHead.class.getName());
        if (obj != null && obj instanceof BgWorkTemplateWizard_ChooseTableHead) {
            BgWorkTemplateWizard_ChooseTableHead headUI = (BgWorkTemplateWizard_ChooseTableHead)((Object)obj);
            if (headUI.chkSingle.isSelected()) {
                this.hasSingle = true;
            }
            if (headUI.chkSum.isSelected()) {
                this.hasSum = true;
            }
            if (headUI.chkElim.isSelected()) {
                this.hasElim = true;
            }
            if (headUI.chkManElim.isSelected()) {
                this.hasManElim = true;
            }
            if (headUI.chkConsolid.isSelected()) {
                this.hasCsl = true;
            }
        }
    }

    private void initBgElement() {
        Object obj = BgElimUIUtil.hmUIs.get(BgWorkTemplateWizard_ChooseBgElementUI.class.getName());
        if (obj != null && obj instanceof BgWorkTemplateWizard_ChooseBgElementUI) {
            BgWorkTemplateWizard_ChooseBgElementUI detailUI = (BgWorkTemplateWizard_ChooseBgElementUI)((Object)obj);
            KDTable table = detailUI.tblMain;
            int size = table.getRowCount();
            for (int i = 0; i < size; ++i) {
                Object cellObj;
                IRow row = table.getRow(i);
                if (!(row.getCell(1).getValue() instanceof Boolean) || !((Boolean)row.getCell(1).getValue()).booleanValue() || (cellObj = row.getUserObject()) == null || !(cellObj instanceof BgElementInfo)) continue;
                this.bgElements.add(cellObj);
            }
        }
    }

    private void initTable() {
        this.tblResult.checkParsed();
        this.tblResult.getStyleAttributes().setLocked(true);
        this.tblResult.getSelectManager().setSelectMode(4);
        this.loadTable(this.tblResult);
        this.tblResult.setFocusable(false);
        this.tblResult1.checkParsed();
        this.tblResult1.getStyleAttributes().setLocked(true);
        this.tblResult1.getSelectManager().setSelectMode(4);
        this.loadTable(this.tblResult1);
        this.tblResult1.setFocusable(false);
    }

    private void loadTable(KDTable table) {
        int top = this.curSheet.getActiveRow();
        int left = this.curSheet.getActiveCol();
        table.removeColumns();
        table.setRowCount(-1);
        table.setHeadDisplayMode(1);
        table.setCellDisplayMode(1);
        Vector vecColumns = null;
        if (table == this.tblResult) {
            vecColumns = this.getColumnParamsByElement();
        } else if (table == this.tblResult1) {
            vecColumns = this.getColumnParamsByOrg();
        }
        if (vecColumns == null || vecColumns.size() == 0) {
            return;
        }
        int rowCount = this.items.length + top;
        int columnCount = vecColumns.size() + left;
        table.addColumns(columnCount + 1);
        table.addRows(rowCount + 1);
        for (int i = top; i <= rowCount; ++i) {
            for (int j = left; j <= columnCount; ++j) {
                RptCell curRptCell;
                Object curCellObj;
                HashMap<String, Object> map;
                ICell curCell = table.getRow(i).getCell(j);
                if (i == top) {
                    RptCell curRptCell2;
                    if (j == left) {
                        RptCell curRptCell3;
                        curCell.setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemResource", (String)"bgItem"));
                        Object curCellObj2 = curCell.getUserObject();
                        if (curCellObj2 != null && curCellObj2 instanceof RptCell) {
                            curRptCell3 = (RptCell)curCellObj2;
                        } else {
                            curRptCell3 = new RptCell(curCell);
                            curCell.setUserObject((Object)curRptCell3);
                        }
                        HashMap<String, String> map2 = new HashMap<String, String>();
                        map2.put("WORK_COL_ITEM", "WORK_COL_ITEM");
                        table.getColumn(j).setUserObject(map2);
                        continue;
                    }
                    SrcAndElement curParam = (SrcAndElement)vecColumns.get(j - left - 1);
                    String param = curParam.dataSrc.getAlias() + "(" + curParam.bgElement.getName() + ")";
                    curCell.setValue((Object)param);
                    Object curCellObj3 = curCell.getUserObject();
                    if (curCellObj3 != null && curCellObj3 instanceof RptCell) {
                        curRptCell2 = (RptCell)curCellObj3;
                    } else {
                        curRptCell2 = new RptCell(curCell);
                        curCell.setUserObject((Object)curRptCell2);
                    }
                    map = new HashMap();
                    HashMap<String, String> props = new HashMap<String, String>();
                    map.put("WORK_COL_DATA", props);
                    table.getColumn(j).setUserObject(map);
                    props.put("WORK_DATA_SRC_TYPE", "" + curParam.dataSrc.getValue());
                    props.put("BG_ELEMENT", curParam.bgElement.getNumber());
                    continue;
                }
                if (j == left) {
                    BgItemInfo item = this.items[i - top - 1];
                    curCell.setValue((Object)item.getName());
                    curCellObj = curCell.getUserObject();
                    if (curCellObj != null && curCellObj instanceof RptCell) {
                        curRptCell = (RptCell)curCellObj;
                    } else {
                        curRptCell = new RptCell(curCell);
                        curCell.setUserObject((Object)curRptCell);
                    }
                    ItemFormula itemFormula = new ItemFormula();
                    itemFormula.setItemNumber(item.getNumber());
                    curRptCell.setItemFormula(itemFormula);
                    map = new HashMap<String, Object>();
                    map.put("WORK_ROW_ITEM", item.getNumber());
                    table.getRow(i).setUserObject(map);
                    continue;
                }
                SrcAndElement type = (SrcAndElement)vecColumns.get(j - left - 1);
                if (!type.dataSrc.equals((Object)BgWorkDataSrcTypeEnum.CONSOLID)) continue;
                curCellObj = curCell.getUserObject();
                BgItemInfo item = this.items[i - top - 1];
                if (curCellObj != null && curCellObj instanceof RptCell) {
                    curRptCell = (RptCell)curCellObj;
                } else {
                    curRptCell = new RptCell(curCell);
                    curCell.setUserObject((Object)curRptCell);
                }
                String formula = this.constructFormula(item, type);
                curRptCell.setItemFormula(formula);
            }
        }
        BgEliminationHelper.saveBasePosition(table, left, top);
    }

    private Vector getColumnParamsByElement() {
        Vector dataSrcs = this.getDataSrc();
        if (this.bgElements.size() == 0 || dataSrcs.size() == 0) {
            return null;
        }
        Vector<SrcAndElement> vecResult = new Vector<SrcAndElement>(0);
        for (int j = 0; j < this.bgElements.size(); ++j) {
            BgElementInfo dataElement = (BgElementInfo)this.bgElements.get(j);
            for (int i = 0; i < dataSrcs.size(); ++i) {
                BgWorkDataSrcTypeEnum dataSrc = (BgWorkDataSrcTypeEnum)((Object)dataSrcs.get(i));
                SrcAndElement srcAndElement = new SrcAndElement(dataSrc, dataElement);
                vecResult.add(srcAndElement);
            }
        }
        return vecResult;
    }

    private Vector getDataSrc() {
        Vector<BgWorkDataSrcTypeEnum> dataSrcs = new Vector<BgWorkDataSrcTypeEnum>(0);
        if (this.hasSingle) {
            dataSrcs.add(BgWorkDataSrcTypeEnum.SINGLE);
        }
        if (this.hasSum) {
            dataSrcs.add(BgWorkDataSrcTypeEnum.SUM);
        }
        if (this.hasElim) {
            dataSrcs.add(BgWorkDataSrcTypeEnum.ELIM);
        }
        if (this.hasManElim) {
            dataSrcs.add(BgWorkDataSrcTypeEnum.MANELIM);
        }
        if (this.hasCsl) {
            dataSrcs.add(BgWorkDataSrcTypeEnum.CONSOLID);
        }
        if (this.bgElements.size() == 0 || dataSrcs.size() == 0) {
            return null;
        }
        return dataSrcs;
    }

    private Vector getColumnParamsByOrg() {
        Vector dataSrcs = this.getDataSrc();
        if (this.bgElements.size() == 0 || dataSrcs.size() == 0) {
            return null;
        }
        Vector<SrcAndElement> vecResult = new Vector<SrcAndElement>(0);
        for (int i = 0; i < dataSrcs.size(); ++i) {
            BgWorkDataSrcTypeEnum dataSrc = (BgWorkDataSrcTypeEnum)((Object)dataSrcs.get(i));
            for (int j = 0; j < this.bgElements.size(); ++j) {
                BgElementInfo dataElement = (BgElementInfo)this.bgElements.get(j);
                SrcAndElement srcAndElement = new SrcAndElement(dataSrc, dataElement);
                vecResult.add(srcAndElement);
            }
        }
        return vecResult;
    }

    private String constructFormula(BgItemInfo bgItem, SrcAndElement type) {
        if (bgItem == null || type == null) {
            return null;
        }
        String bgPeriodNumber = "";
        String currencyNumber = "";
        String formulaLine = "=BgItem(\"" + bgItem.getNumber() + "\",\"" + bgPeriodNumber + "\",\"" + type.bgElement.getNumber() + "\",\"BgData\",true,\"" + currencyNumber + "\")";
        return formulaLine;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnNextStep.setEnabled(false);
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        if (BgElimUIUtil.isCloseWindow((Component)((Object)this))) {
            BgElimUIUtil.closeAllUI();
        }
        this.getUIWindow().close();
    }

    @Override
    protected void btnFinished_actionPerformed(ActionEvent e) throws Exception {
        this.fillData(this.curSheet);
        BgElimUIUtil.closeAllUI();
        this.getUIWindow().close();
    }

    private void fillData(Sheet table) {
        int i;
        int top = this.curSheet.getActiveRow();
        int left = this.curSheet.getActiveCol();
        int sheetRowCount = this.curSheet.getMaxRowIndex() + 1;
        int sheetColCount = this.curSheet.getMaxColIndex() + 1;
        Row row = null;
        Column col = null;
        this.curSheet.getSheetRange().clear(true, true, false, true, new String[0]);
        for (i = 0; i < sheetRowCount; ++i) {
            row = this.curSheet.getRow(i, false);
            if (row == null) continue;
            row.removeUserObject("WORK_ROW_ITEM");
        }
        for (i = 0; i < sheetColCount; ++i) {
            col = this.curSheet.getColumn(i, false);
            if (col == null) continue;
            col.removeUserObject("WORK_COL_ITEM");
            col.removeUserObject("WORK_COL_DATA");
        }
        Vector vecColumns = null;
        if (this.radioBtnData.isSelected()) {
            vecColumns = this.getColumnParamsByElement();
        } else if (this.radioBtnOrg.isSelected()) {
            vecColumns = this.getColumnParamsByOrg();
        }
        if (vecColumns == null || vecColumns.size() == 0) {
            return;
        }
        int rowCount = this.items.length + top;
        int columnCount = vecColumns.size() + left;
        for (int i2 = top; i2 <= rowCount; ++i2) {
            for (int j = left; j <= columnCount; ++j) {
                Cell curCell = table.getCell(i2, j, true);
                Range curRange = table.getRange(curCell);
                if (i2 == top) {
                    if (j == left) {
                        String value = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemResource", (String)"bgItem");
                        curRange.setValue(new Variant((Object)value));
                        table.getColumn(j, true).setUserObject("WORK_COL_ITEM", (Object)"WORK_COL_ITEM");
                        continue;
                    }
                    SrcAndElement curParam = (SrcAndElement)vecColumns.get(j - left - 1);
                    String param = curParam.dataSrc.getAlias() + "(" + curParam.bgElement.getName() + ")";
                    curRange.setValue(new Variant((Object)param));
                    HashMap<String, String> props = new HashMap<String, String>();
                    props.put("WORK_DATA_SRC_TYPE", "" + curParam.dataSrc.getValue());
                    props.put("BG_ELEMENT", curParam.bgElement.getNumber());
                    table.getColumn(j, true).setUserObject("WORK_COL_DATA", props);
                    continue;
                }
                if (j == left) {
                    BgItemInfo item = this.items[i2 - top - 1];
                    curRange.setValue(new Variant((Object)item.getName()));
                    table.getRow(i2, true).setUserObject("WORK_ROW_ITEM", (Object)item.getNumber());
                    continue;
                }
                SrcAndElement type = (SrcAndElement)vecColumns.get(j - left - 1);
                if (!type.dataSrc.equals((Object)BgWorkDataSrcTypeEnum.CONSOLID)) continue;
                BgItemInfo item = this.items[i2 - top - 1];
                String formula = this.constructFormula(item, type);
                ItemFormula itemFormula = new ItemFormula(formula);
                curRange.setUserObject("ITEM", (Object)itemFormula);
            }
        }
        BgEliminationHelper.saveBasePosition(table, left, top);
    }

    @Override
    protected void btnPreStep_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().hide();
        Object obj = BgElimUIUtil.hmUIs.get(this.getPreUIName());
        if (obj != null && obj instanceof CoreUI) {
            CoreUI preUI = (CoreUI)obj;
            preUI.getUIWindow().show();
            this.getUIWindow().hide();
        }
    }

    private String getPreUIName() {
        return BgWorkTemplateWizard_ChooseBgElementUI.class.getName();
    }

    class SrcAndElement {
        BgWorkDataSrcTypeEnum dataSrc;
        BgElementInfo bgElement;

        SrcAndElement(BgWorkDataSrcTypeEnum src, BgElementInfo element) {
            this.dataSrc = src;
            this.bgElement = element;
        }
    }
}

