/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.eas.fi.newrpt.client.designer.render.IRenderProvider;
import com.kingdee.eas.ma.nbudget.BgCourseHelper;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;

public class BudgetCourseProvider
implements IRenderProvider {
    private static final CertificateRender render_cer = new CertificateRender(BgCourseHelper.ITEM_COLOR);
    private static final CertificateRender render_cause = new CertificateRender(BgCourseHelper.CAUSE_COLOR);

    public IBasicRender getRender(Cell cell, int viewMode) {
        if (BgNFSHelper.checkHasFormulaOfCell(cell)) {
            if (BgNFSHelper.checkHasCertificate(cell)) {
                return render_cer;
            }
            if (BgNFSHelper.checkHasCause(cell)) {
                return render_cause;
            }
        }
        return null;
    }

    protected static final class CertificateRender
    implements IBasicRender {
        private Color color = null;
        int[] dx = new int[]{0, 0, 0};
        int[] dy = new int[]{0, 0, 0};

        public CertificateRender(Color color) {
            this.setColor(color);
        }

        public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle) {
            Rectangle bd = clip.getBounds();
            Color cl = graphics.getColor();
            int x = bd.x + bd.width;
            int y = bd.y - 1;
            int offset = 7;
            this.dx[0] = x - offset;
            this.dx[1] = x;
            this.dx[2] = x;
            this.dy[0] = y;
            this.dy[1] = y;
            this.dy[2] = y + offset;
            graphics.setColor(this.getColor());
            graphics.fillPolygon(this.dx, this.dy, 3);
            graphics.setColor(cl);
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public Color getColor() {
            return this.color;
        }
    }
}

