/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ctrl.excel.impl.ToolBarManager;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeEvent;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.eas.ma.budget.BgConstants;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BudgetRequestFormDiversityData;
import com.kingdee.eas.ma.nbudget.client.BgNFormProcessUI;
import com.kingdee.eas.ma.nbudget.client.BudgetFormQueryUI;
import com.kingdee.eas.ma.nbudget.client.BudgetRequestBillEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Action;

public class BudgetFormProcessUI
extends BgNFormProcessUI {
    protected BudgetRequestBillEditUI processUI = null;
    BudgetFormQueryUI queryUI = null;
    protected Map adBudgetCtrlMap = null;
    private static final long serialVersionUID = 1L;

    @Override
    public void onLoad() throws Exception {
        this.setCtrlEnumerate(true);
        super.onLoad();
        this.initToolbarAction();
        ToolBarManager toolBarManager = this.getSpreadManager().getSpreadContainer().getToolBarManager();
        toolBarManager.getToolBar("common").removeAllToolBarComponents();
        toolBarManager.getToolBar("common").add((Action)((Object)this.actionRefer));
        this.actionRefer.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_submit"));
        this.actionRefer.setVisible(true);
        this.actionRefer.setEnabled(true);
    }

    @Override
    protected void init() throws Exception {
        super.init();
        this.processUI = (BudgetRequestBillEditUI)((Object)this.getUIContext().get("BudgetRequestBillUI"));
        this.queryUI = (BudgetFormQueryUI)((Object)this.getUIContext().get("BudgetFormQueryUI"));
    }

    @Override
    protected void initSystemInfo() throws Exception {
        super.initSystemInfo();
        this.setAdjustMap(new LinkedHashMap());
        this.setAdBudgetCtrlMap(new LinkedHashMap());
        this.getSYSTEMINFO_DATA().add(this.getAdjustMap());
        this.getSYSTEMINFO_DATA().add(this.getAdBudgetCtrlMap());
    }

    @Override
    protected void initToolbar() {
        super.initToolbar();
    }

    @Override
    protected void showAllBook() throws Exception {
        super.showAllBook();
    }

    @Override
    protected void cell_Selection_Changed(SheetChangeEvent e) throws Exception {
        if (e.getChangedBlocks() != null && e.getSheet() != null) {
            Sheet _sheet = e.getSheet();
            Cell _cell = null;
            CellBlock _block = null;
            SortedCellBlockArray _blocks = null;
            _blocks = e.getChangedBlocks();
            int size = _blocks.size();
            for (int index = 0; index < size; ++index) {
                _block = _blocks.getBlock(index);
                int rowEnd = _block.getRow2();
                for (int rowBegin = _block.getRow(); rowBegin <= rowEnd; ++rowBegin) {
                    int colEnd = _block.getCol2();
                    for (int colBegin = _block.getCol(); colBegin <= colEnd; ++colBegin) {
                        _cell = _sheet.getCell(rowBegin, colBegin, false);
                        BgNFSHelper.setLockOfCell(_cell, true);
                    }
                }
            }
        }
    }

    @Override
    protected void initToolbarAction() {
        ToolBarManager toolBarManager = this.getSpreadManager().getSpreadContainer().getToolBarManager();
        toolBarManager.getToolBar("style").hide();
    }

    @Override
    public void actionRefer_actionPerformed(ActionEvent e) throws Exception {
        if (this.processUI != null) {
            Sheet.ICellsIterator iterator;
            int i;
            Cell cell = null;
            String formulaString = null;
            String[] parameter = null;
            CellBlock block = null;
            BudgetRequestFormDiversityData divData = null;
            Sheet sheet = this.getBook().getActiveSheet();
            Range range = sheet.getSelectionRange();
            boolean hasItem = false;
            int n = range.size();
            block2: for (i = 0; i < n; ++i) {
                block = (CellBlock)range.getAt(i);
                iterator = sheet.getCellsIterator(block, false, false);
                while (iterator.hasNext()) {
                    cell = iterator.next();
                    if (!BgNFSHelper.checkHasFormulaOfCell(cell)) continue;
                    hasItem = true;
                    continue block2;
                }
            }
            if (!hasItem) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BudgetRequestBillResource", (String)"isHaveFormulaMesg"));
                SysUtil.abort();
            }
            n = range.size();
            for (i = 0; i < n; ++i) {
                block = (CellBlock)range.getAt(i);
                iterator = sheet.getCellsIterator(block, false, false);
                while (iterator.hasNext()) {
                    cell = iterator.next();
                    if (!BgNFSHelper.checkHasFormulaOfCell(cell) || (formulaString = BgNFSHelper.getFormulaOfCell(cell)) == null || formulaString.trim().length() <= 0) continue;
                    parameter = BgNFSHelper.parseFormulaPara(this.getFormulaMap(), formulaString);
                    divData = new BudgetRequestFormDiversityData();
                    divData.setFormula(formulaString);
                    if (cell.getValue() != null && cell.getValue().toString().trim().length() > 0) {
                        divData.setNewValue(new BigDecimal(cell.getValue().toString().trim()));
                    } else {
                        divData.setNewValue(BgConstants.BIGZERO);
                    }
                    divData.setParameter(parameter);
                    this.getAdjustMap().put(formulaString, divData);
                    LinkedHashMap tmp = new LinkedHashMap();
                    this.setCtrlMap(cell, tmp);
                    this.adBudgetCtrlMap.put(formulaString, tmp);
                }
            }
            this.processUI.setBgFormInfo((BgFormInfo)this.getEditData());
            this.processUI.setBudgetInfo(this.getAdjustMap());
            boolean isUpdate = this.processUI.updateBudgetMapInfo();
            if (isUpdate) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BudgetRequestBillResource", (String)"isSuccessSubmitBudgetMesg"));
                if (this.queryUI != null) {
                    this.queryUI.actionExitCurrent_actionPerformed(null);
                }
                this.destroyWindow();
            } else {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BudgetRequestBillResource", (String)"isNewEntryMesg"));
            }
        }
    }

    private void setCtrlMap(Cell cell, HashMap map) {
        Boolean isCtrl = BgNFSHelper.getItemFormula(cell).getExt("isCtrl") == null ? Boolean.FALSE : new Boolean(BgNFSHelper.getItemFormula(cell).getExt("isCtrl").toString());
        Boolean isFlexCtrl = BgNFSHelper.getItemFormula(cell).getExt("isFlexCtrl") == null ? Boolean.FALSE : new Boolean(BgNFSHelper.getItemFormula(cell).getExt("isFlexCtrl").toString());
        BigDecimal flexCtrlParam = BgNFSHelper.getItemFormula(cell).getExt("flexCtrlParam") == null ? new BigDecimal("1.00") : new BigDecimal(BgNFSHelper.getItemFormula(cell).getExt("flexCtrlParam").toString());
        Integer periodCtrlPolicy = BgNFSHelper.getItemFormula(cell).getExt("periodCtrlPolicy") == null ? new Integer(-1) : new Integer(BgNFSHelper.getItemFormula(cell).getExt("periodCtrlPolicy").toString());
        Boolean isGroupCtrl = BgNFSHelper.getItemFormula(cell).getExt("isGroupCtrl") == null ? Boolean.FALSE : new Boolean(BgNFSHelper.getItemFormula(cell).getExt("isGroupCtrl").toString());
        Integer groupNo = new Integer(-1);
        if (BgNFSHelper.getItemFormula(cell).getExt("groupCtrlNo") != null) {
            try {
                groupNo = new Integer(BgNFSHelper.getItemFormula(cell).getExt("groupCtrlNo").toString());
            }
            catch (NumberFormatException e) {
                groupNo = new Integer(-1);
            }
        }
        Boolean isAllowAccess = BgNFSHelper.getItemFormula(cell).getExt("isAllowAccess") == null ? Boolean.TRUE : new Boolean(BgNFSHelper.getItemFormula(cell).getExt("isAllowAccess").toString());
        map.put("isCtrl", isCtrl);
        map.put("isFlexCtrl", isFlexCtrl);
        map.put("flexCtrlParam", flexCtrlParam);
        map.put("periodCtrlPolicy", periodCtrlPolicy);
        map.put("isGroupCtrl", isGroupCtrl);
        map.put("groupCtrlNo", groupNo);
        map.put("isAllowAccess", isAllowAccess);
        if (this.getBgFormInfo() != null && this.getBgFormInfo().getBgTemplate() != null && this.getBgFormInfo().getBgTemplate().getId() != null) {
            map.put("BGTEMPLATE_ID", this.getBgFormInfo().getBgTemplate().getId().toString());
        }
    }

    public Map getAdBudgetCtrlMap() {
        return this.adBudgetCtrlMap;
    }

    public void setAdBudgetCtrlMap(Map adBudgetCtrlMap) {
        this.adBudgetCtrlMap = adBudgetCtrlMap;
    }
}

