/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.EntryFilterType;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgSchemeFactory;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.client.BgCompanyF7;
import com.kingdee.eas.ma.budget.client.BgOrgViewF7;
import com.kingdee.eas.ma.nbudget.client.AbstractBudgetRequestBillFilterUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class BudgetRequestBillFilterUI
extends AbstractBudgetRequestBillFilterUI {
    private static final long serialVersionUID = 8660693128063548536L;
    private static final Logger logger = CoreUIObject.getLogger(BudgetRequestBillFilterUI.class);
    protected Object ui = null;

    public BudgetRequestBillFilterUI() throws Exception {
    }

    public BudgetRequestBillFilterUI(Object ui) throws Exception {
        this.ui = ui;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
    }

    protected void init() {
        BgOrgViewF7 orgView = new BgOrgViewF7((IUIObject)this);
        orgView.setMultiSelect(false);
        orgView.setReturnSuperior(false);
        this.prmtReqOrgUnit.setSelector((KDPromptSelector)orgView);
        this.prmtReqOrgUnit.setEditable(true);
        this.prmtReqOrgUnit.setDisplayFormat("$name$");
        this.prmtReqOrgUnit.setEditFormat("$number$");
        this.prmtReqOrgUnit.setCommitFormat("$number$");
        this.prmtBgScheme.setEditable(true);
        this.prmtBgScheme.setDisplayFormat("$name$");
        this.prmtBgScheme.setEditFormat("$number$");
        this.prmtBgScheme.setCommitFormat("$number$");
        EntityViewInfo view = this.prmtBgScheme.getEntityViewInfo();
        if (view == null) {
            view = new EntityViewInfo();
        }
        FilterInfo filer = new FilterInfo(EntryFilterType.NORMAL);
        filer.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)"", CompareType.EQUALS));
        view.setFilter(filer);
        this.prmtBgScheme.setEntityViewInfo(view);
        BgCompanyF7 companyOrgView = new BgCompanyF7();
        companyOrgView.setMultiSelect(false);
        this.prmtCompany.setSelector((KDPromptSelector)companyOrgView);
        this.prmtCompany.setEditable(true);
        this.prmtCompany.setDisplayFormat("$name$");
        this.prmtCompany.setEditFormat("$number$");
        this.prmtCompany.setCommitFormat("$number$");
        this.prmtReqCompany.setSelector((KDPromptSelector)companyOrgView);
        this.prmtReqCompany.setEditable(true);
        this.prmtReqCompany.setDisplayFormat("$name$");
        this.prmtReqCompany.setEditFormat("$number$");
        this.prmtReqCompany.setCommitFormat("$number$");
        this.pkReqDate.setValue(null);
        this.pkReqToDate.setValue(null);
        this.pkBizDate.setValue(null);
        this.pkBizToDate.setValue(null);
        this.kDRallUser.setSelected(true);
    }

    public boolean verify() {
        if (this.pkReqDate.getValue() != null && this.pkReqToDate.getValue() != null) {
            Date reqDate = BgHelper.getDayBegin((Date)((Date)this.pkReqDate.getValue()));
            Date reqToDate = BgHelper.getDayBegin((Date)((Date)this.pkReqToDate.getValue()));
            if (reqToDate.before(reqDate)) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BudgetRequestBillResource", (String)"isReqDateWrong"));
                this.pkReqDate.requestFocus(true);
                return false;
            }
        }
        if (this.pkBizDate.getValue() != null && this.pkBizToDate.getValue() != null) {
            Date bizDate = BgHelper.getDayBegin((Date)((Date)this.pkBizDate.getValue()));
            Date bizToDate = BgHelper.getDayBegin((Date)((Date)this.pkBizToDate.getValue()));
            if (bizToDate.before(bizDate)) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BudgetRequestBillResource", (String)"isBizDateWrong"));
                this.pkBizToDate.requestFocus(true);
                return false;
            }
        }
        return true;
    }

    @Override
    protected void prmtReqOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtReqOrgUnit_dataChanged(e);
        Object obj = this.prmtReqOrgUnit.getData();
        if (obj == null) {
            EntityViewInfo view = this.prmtBgScheme.getEntityViewInfo();
            if (view == null) {
                view = new EntityViewInfo();
            }
            FilterInfo filer = new FilterInfo(EntryFilterType.NORMAL);
            filer.getFilterItems().add(new FilterItemInfo("orgUnit.id", null, CompareType.EQUALS));
            view.setFilter(filer);
            this.prmtBgScheme.setEntityViewInfo(view);
            return;
        }
        if (!(obj instanceof CostCenterOrgUnitInfo)) {
            return;
        }
        CostCenterOrgUnitInfo org = (CostCenterOrgUnitInfo)obj;
        EntityViewInfo view = this.prmtBgScheme.getEntityViewInfo();
        if (view == null) {
            view = new EntityViewInfo();
        }
        FilterInfo filer = new FilterInfo(EntryFilterType.NORMAL);
        filer.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)org.getId().toString(), CompareType.EQUALS));
        view.setFilter(filer);
        this.prmtBgScheme.setEntityViewInfo(view);
    }

    public FilterInfo getFilterInfo() {
        FilterItemInfo filterReqCompany;
        CompanyOrgUnitInfo _unitInfo;
        String orgUnitId;
        if (this.filterInfo == null) {
            this.filterInfo = new FilterInfo();
        } else {
            this.filterInfo.getFilterItems().clear();
        }
        int formulaIndex = 0;
        StringBuffer sbFormula = new StringBuffer();
        if (this.kDRcurrentUser.isSelected()) {
            String currentId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            FilterItemInfo filterCurrUser = new FilterItemInfo("creator.id", (Object)currentId, CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterCurrUser);
            sbFormula.append(" #" + formulaIndex++);
        } else {
            FilterItemInfo filterAllUser = new FilterItemInfo("creator.id", null, CompareType.NOTEQUALS);
            this.filterInfo.getFilterItems().add(filterAllUser);
            sbFormula.append(" #" + formulaIndex++);
        }
        if (this.prmtReqOrgUnit.getData() != null) {
            CostCenterOrgUnitInfo _reqOrgUnitInfo = (CostCenterOrgUnitInfo)this.prmtReqOrgUnit.getData();
            FilterItemInfo filterReqOrgUnit = new FilterItemInfo("ReqOrgUnit.id", (Object)_reqOrgUnitInfo.getId().toString(), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterReqOrgUnit);
            sbFormula.append("  and  #" + formulaIndex++);
        }
        if (!StringUtils.isEmpty((String)this.txtNumber.getText())) {
            FilterItemInfo filterNum = new FilterItemInfo("number", (Object)this.txtNumber.getText(), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterNum);
            sbFormula.append("  and  #" + formulaIndex++);
        }
        if (this.prmtBgScheme.getData() != null) {
            BgSchemeInfo _bgSchemeInfo = (BgSchemeInfo)this.prmtBgScheme.getData();
            FilterItemInfo filterScheme = new FilterItemInfo("bgScheme.id", (Object)_bgSchemeInfo.getId().toString(), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterScheme);
            sbFormula.append("  and  #" + formulaIndex++);
        }
        if (this.prmtCompany.getData() != null) {
            orgUnitId = "";
            if (this.prmtCompany.getData() instanceof CompanyOrgUnitInfo) {
                _unitInfo = (CompanyOrgUnitInfo)this.prmtCompany.getData();
                orgUnitId = _unitInfo.getId().toString();
            } else if (this.prmtCompany.getData() instanceof FullOrgUnitInfo) {
                _unitInfo = (FullOrgUnitInfo)this.prmtCompany.getData();
                orgUnitId = _unitInfo.getId().toString();
            }
            FilterItemInfo filterCompany = new FilterItemInfo("company.id", (Object)orgUnitId, CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterCompany);
            sbFormula.append("  and  #" + formulaIndex++);
        }
        if (this.prmtReqCompany.getData() != null) {
            orgUnitId = "";
            if (this.prmtReqCompany.getData() instanceof CompanyOrgUnitInfo) {
                _unitInfo = (CompanyOrgUnitInfo)this.prmtReqCompany.getData();
                orgUnitId = _unitInfo.getId().toString();
            } else if (this.prmtReqCompany.getData() instanceof FullOrgUnitInfo) {
                _unitInfo = (FullOrgUnitInfo)this.prmtReqCompany.getData();
                orgUnitId = _unitInfo.getId().toString();
            }
            filterReqCompany = new FilterItemInfo("reqCompany.id", (Object)orgUnitId, CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterReqCompany);
            sbFormula.append("  and  #" + formulaIndex++);
        }
        if (this.prmtPurchaseOrgUnit.getData() != null) {
            PurchaseOrgUnitInfo _unitInfo2 = (PurchaseOrgUnitInfo)this.prmtPurchaseOrgUnit.getData();
            filterReqCompany = new FilterItemInfo("purchaseOrgUnit.id", (Object)_unitInfo2.getId().toString(), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterReqCompany);
            sbFormula.append("  and  #" + formulaIndex++);
        }
        if (this.pkReqDate.getValue() != null) {
            FilterItemInfo filterReqDate = new FilterItemInfo("createTime", (Object)BgHelper.getDayBegin((Date)((Date)this.pkReqDate.getValue())), CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(filterReqDate);
            sbFormula.append("  and  #" + formulaIndex++);
        }
        if (this.pkReqToDate.getValue() != null) {
            FilterItemInfo filterReqToDate = new FilterItemInfo("createTime", (Object)BgHelper.getDayEnd((Date)((Date)this.pkReqToDate.getValue())), CompareType.LESS_EQUALS);
            this.filterInfo.getFilterItems().add(filterReqToDate);
            sbFormula.append("  and  #" + formulaIndex++);
        }
        if (this.pkBizDate.getValue() != null) {
            FilterItemInfo filterBizDate = new FilterItemInfo("bizDate", (Object)BgHelper.getDayBegin((Date)((Date)this.pkBizDate.getValue())), CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(filterBizDate);
            sbFormula.append("  and  #" + formulaIndex++);
        }
        if (this.pkBizToDate.getValue() != null) {
            FilterItemInfo filterBizToDate = new FilterItemInfo("bizDate", (Object)BgHelper.getDayEnd((Date)((Date)this.pkBizToDate.getValue())), CompareType.LESS_EQUALS);
            this.filterInfo.getFilterItems().add(filterBizToDate);
            sbFormula.append("  and  #" + formulaIndex++);
        }
        HashSet<Integer> stateValue = new HashSet<Integer>();
        if (this.chbState0.isSelected()) {
            stateValue.add(new Integer(0));
        }
        if (this.chbState1.isSelected()) {
            stateValue.add(new Integer(1));
        }
        if (this.chbState3.isSelected()) {
            stateValue.add(new Integer(3));
        }
        if (this.chbState5.isSelected()) {
            stateValue.add(new Integer(5));
        }
        if (this.chbState9.isSelected()) {
            stateValue.add(new Integer(9));
        }
        if (this.chbState11.isSelected()) {
            stateValue.add(new Integer(11));
        }
        if (stateValue.size() != 0) {
            FilterItemInfo filterState = new FilterItemInfo("state", stateValue, CompareType.INCLUDE);
            this.filterInfo.getFilterItems().add(filterState);
            sbFormula.append("  and  #" + formulaIndex++);
        }
        this.filterInfo.setMaskString(sbFormula.toString());
        return this.filterInfo;
    }

    public SorterItemCollection getSorterItems() {
        return super.getSorterItems();
    }

    private void clearUI() {
        this.prmtReqOrgUnit.setData(null);
        this.txtNumber.setText(null);
        this.prmtBgScheme.setData(null);
        this.prmtCompany.setData(null);
        this.prmtReqCompany.setData(null);
        this.prmtPurchaseOrgUnit.setData(null);
        this.chbState0.setSelected(false);
        this.chbState1.setSelected(false);
        this.chbState3.setSelected(false);
        this.chbState5.setSelected(false);
        this.chbState9.setSelected(false);
        this.chbState11.setSelected(false);
        this.kDRallUser.setSelected(true);
    }

    public void clear() {
        super.clear();
        this.clearUI();
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.clearUI();
        super.loadData(entityViewInfo);
        FilterItemCollection currentFilterItemCollection = entityViewInfo.getFilter() == null ? new FilterItemCollection() : entityViewInfo.getFilter().getFilterItems();
        for (int i = 0; i < currentFilterItemCollection.size(); ++i) {
            Date date;
            String companyId;
            CostCenterOrgUnitInfo unitInfo;
            FilterItemInfo filterItemInfo = currentFilterItemCollection.get(i);
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("ReqOrgUnit.id")) {
                String unitId = (String)filterItemInfo.getCompareValue();
                try {
                    unitInfo = CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(unitId));
                    this.prmtReqOrgUnit.setData((Object)unitInfo);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("number")) {
                this.txtNumber.setText(filterItemInfo.getCompareValue().toString());
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("bgScheme.id")) {
                String schemeId = filterItemInfo.getCompareValue().toString();
                try {
                    BgSchemeInfo schemeInfo = BgSchemeFactory.getRemoteInstance().getBgSchemeInfo((IObjectPK)new ObjectUuidPK(schemeId));
                    this.prmtBgScheme.setData((Object)schemeInfo);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("company.id")) {
                companyId = filterItemInfo.getCompareValue().toString();
                try {
                    unitInfo = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
                    this.prmtCompany.setData((Object)unitInfo);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("reqCompany.id")) {
                companyId = filterItemInfo.getCompareValue().toString();
                try {
                    unitInfo = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
                    this.prmtReqCompany.setData((Object)unitInfo);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("purchaseOrgUnit.id")) {
                companyId = filterItemInfo.getCompareValue().toString();
                try {
                    unitInfo = PurchaseOrgUnitFactory.getRemoteInstance().getPurchaseOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
                    this.prmtPurchaseOrgUnit.setData((Object)unitInfo);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("createTime")) {
                date = (Date)filterItemInfo.getCompareValue();
                if (CompareType.GREATER_EQUALS.equals((Object)filterItemInfo.getCompareType())) {
                    this.pkReqDate.setValue((Object)date);
                    continue;
                }
                this.pkReqToDate.setValue((Object)date);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("bizDate")) {
                date = (Date)filterItemInfo.getCompareValue();
                if (CompareType.GREATER_EQUALS.equals((Object)filterItemInfo.getCompareType())) {
                    this.pkBizDate.setValue((Object)date);
                    continue;
                }
                this.pkBizToDate.setValue((Object)date);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("state")) {
                HashSet state = (HashSet)filterItemInfo.getCompareValue();
                Iterator iter = state.iterator();
                while (iter.hasNext()) {
                    int stateValue = (Integer)iter.next();
                    if (stateValue == 0) {
                        this.chbState0.setSelected(true);
                        continue;
                    }
                    if (stateValue == 1) {
                        this.chbState1.setSelected(true);
                        continue;
                    }
                    if (stateValue == 3) {
                        this.chbState3.setSelected(true);
                        continue;
                    }
                    if (stateValue == 5) {
                        this.chbState5.setSelected(true);
                        continue;
                    }
                    if (stateValue == 9) {
                        this.chbState9.setSelected(true);
                        continue;
                    }
                    if (stateValue != 11) continue;
                    this.chbState11.setSelected(true);
                }
                continue;
            }
            if (!filterItemInfo.getPropertyName().equalsIgnoreCase("creator.id")) continue;
            if (CompareType.EQUALS.equals((Object)filterItemInfo.getCompareType())) {
                this.kDRcurrentUser.setSelected(true);
                continue;
            }
            this.kDRallUser.setSelected(true);
        }
    }
}

