/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.IPermissionServiceProvider;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.PermissionServiceProviderFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.budget.BgExamineException;
import com.kingdee.eas.ma.budget.BgFormCollection;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.client.BgExamineTemplateProcessUI;
import com.kingdee.eas.ma.nbudget.BgPermissionHelper;
import com.kingdee.eas.ma.nbudget.client.AbstractNewBgSimulatePredictAnalyseFormUI;
import com.kingdee.eas.ma.nbudget.client.BgSimulatePredictDataAnalyseProcessUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class NewBgSimulatePredictAnalyseFormUI
extends AbstractNewBgSimulatePredictAnalyseFormUI {
    private static final Logger logger = CoreUIObject.getLogger(NewBgSimulatePredictAnalyseFormUI.class);
    private FullOrgUnitInfo orgUnitInfo = null;
    private BgFormCollection colls = new BgFormCollection();
    private IPermissionServiceProvider ip = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.kDLabelTemplate.setIcon(EASResource.getIcon((String)"imgLableword_btn"));
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.setEditable(false);
        this.tblMain.getColumn("state").getStyleAttributes().setHided(true);
        this.getColls();
    }

    private void getColls() throws Exception {
        String orgUnitID = (String)this.getUIContext().get("orgId");
        String schemeID = (String)this.getUIContext().get("schemeId");
        boolean isCanOnloud = false;
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        isCanOnloud = iPermission.hasFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)orgUnitID)), "bg_form01_list");
        if (!isCanOnloud) {
            return;
        }
        IBgForm iBgForm = BgFormFactory.getRemoteInstance();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)schemeID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(5), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(15), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(4), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bgTemplate.bgType.id", (Object)"BV/FQwEUEADgABtLwKgSXv9s2OA=", CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bgTemplate.bgType.id", null, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bgTemplate.formType", (Object)new Integer(2), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bgTemplate.formType", null, CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2 and #3 and #4 and ( #5 or #6 )and ( #7 or #8 )");
        if (BgSHelper.isBgPermissionUsed()) {
            HashSet<String> orgSet = new HashSet<String>();
            orgSet.add(orgUnitID);
            String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            filter = BgPermissionHelper.addBgFormPermission(userId, orgSet, filter);
        }
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("rootId"));
        sic.add(new SelectorItemInfo("creator.*"));
        sic.add(new SelectorItemInfo("bgType.*"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("bgTemplate"));
        sic.add(new SelectorItemInfo("bgTemplate.name"));
        sic.add(new SelectorItemInfo("bgPeriod.name"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("bgPeriod"));
        sic.add(new SelectorItemInfo("currency"));
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        String rule = null;
        EntityViewInfo resultEntityViewInfo = null;
        try {
            rule = this.getPermissInterface().getPermissionRule((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)orgUnitID)), "bg_form01_list");
            if (rule != null && !rule.equals(" WHERE ( id = '00000000-0000-0000-0000-00000000000013B7DE7F' OR id <> '00000000-0000-0000-0000-00000000000013B7DE7F' )")) {
                resultEntityViewInfo = new EntityViewInfo(rule);
                view.getFilter().mergeFilter(resultEntityViewInfo.getFilter(), "AND");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        BgFormCollection coll = iBgForm.getBgFormCollection(view);
        this.loadForms(coll);
    }

    protected IPermissionServiceProvider getPermissInterface() throws Exception {
        if (this.ip == null) {
            this.ip = PermissionServiceProviderFactory.getRemoteInstance();
        }
        return this.ip;
    }

    private void loadForms(BgFormCollection coll) {
        this.tblMain.removeRows();
        if (coll != null && coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                BgFormInfo bgFormInfo = coll.get(i);
                IRow iRow = this.tblMain.addRow();
                iRow.setUserObject((Object)bgFormInfo);
                iRow.getCell("select").setValue((Object)Boolean.FALSE);
                iRow.getCell("number").setValue((Object)bgFormInfo.getNumber());
                iRow.getCell("name").setValue((Object)bgFormInfo.getName());
                iRow.getCell("creator").setValue((Object)bgFormInfo.getCreator().getName());
                iRow.getCell("createTime").setValue((Object)bgFormInfo.getCreateTime());
                iRow.getCell("template").setValue((Object)bgFormInfo.getBgTemplate().getName());
                iRow.getCell("period").setValue((Object)bgFormInfo.getBgPeriod().getName());
                iRow.getCell("currency").setValue((Object)bgFormInfo.getCurrency().getName());
                iRow.getCell("state").setValue((Object)bgFormInfo.getState());
                iRow.getCell("id").setValue((Object)bgFormInfo.getId().toString());
            }
        }
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.btnConfirm_actionPerformed(e);
        if (this.getDetailTable() != null) {
            BgFormInfo bgFormInfo;
            if (this.getDetailTable().getBody().size() == 0) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"NoFormThisOrgUnit"));
                SysUtil.abort();
            }
            int rowIndex = -1;
            int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
            if (selectRows.length > 0) {
                rowIndex = selectRows[0];
            }
            if (rowIndex == -1) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"ChooseOneForm"));
                SysUtil.abort();
            }
            if ((bgFormInfo = (BgFormInfo)this.getDetailTable().getRow(rowIndex).getUserObject()) != null) {
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put((Object)"ID", (Object)bgFormInfo.getId().toString());
                uiContext.put((Object)"Owner", (Object)this);
                uiContext.put((Object)"selectOwner", this.getUIContext().get("selectOwner"));
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(BgSimulatePredictDataAnalyseProcessUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
                uiWindow.show();
            } else {
                throw new BgExamineException(BgExamineException.NOBGTEMPLATE);
            }
        }
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        if (e.getType() != 0 && e.getClickCount() == 2) {
            BgFormInfo bgFormInfo;
            int rowIndex = -1;
            int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
            if (selectRows.length > 0) {
                rowIndex = selectRows[0];
            }
            if (rowIndex == -1) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"ChooseOneForm"));
                SysUtil.abort();
            }
            if ((bgFormInfo = (BgFormInfo)this.getDetailTable().getRow(rowIndex).getUserObject()) != null) {
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put((Object)"ID", (Object)bgFormInfo.getId().toString());
                uiContext.put((Object)"selectOwner", this.getUIContext().get("selectOwner"));
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(BgSimulatePredictDataAnalyseProcessUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
                uiWindow.show();
            } else {
                throw new BgExamineException(BgExamineException.NOBGTEMPLATE);
            }
        }
    }

    public String getReportUIName() {
        return BgExamineTemplateProcessUI.class.getName();
    }

    protected KDTable getDetailTable() {
        return this.tblMain;
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.getUIWindow().close();
        SysUtil.abort();
    }
}

