/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ctrl.swing.KDProgressBar;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ma.nbudget.BgUpgradeFacadeFactory;
import com.kingdee.eas.ma.nbudget.IBgUpgradeFacade;
import com.kingdee.eas.ma.nbudget.client.AbstractProgressUpgradeUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class ProgressUpgradeUI
extends AbstractProgressUpgradeUI {
    private static final long serialVersionUID = -8690040448892752312L;
    private static final Logger logger = CoreUIObject.getLogger(ProgressUpgradeUI.class);
    private IBgUpgradeFacade ibgUpgradeFacade = null;
    private static int minValue = 0;
    private static int maxValue = 100;
    private boolean canClose = false;
    private boolean hasCanel = false;

    public void onLoad() throws Exception {
        super.onLoad();
    }

    public IBgUpgradeFacade getFacadeInterface() throws Exception {
        if (this.ibgUpgradeFacade == null) {
            this.ibgUpgradeFacade = BgUpgradeFacadeFactory.getRemoteInstance();
        }
        return this.ibgUpgradeFacade;
    }

    public void setCanClose(boolean canClose) {
        this.canClose = canClose;
    }

    public boolean isCanClose() {
        return this.canClose;
    }

    public void setHasCanel(boolean hasCanel) {
        this.hasCanel = hasCanel;
    }

    public boolean isHasCanel() {
        return this.hasCanel;
    }

    @Override
    protected void btnUpgrade_actionPerformed(ActionEvent e) throws Exception {
        super.btnUpgrade_actionPerformed(e);
        this.btnUpgrade.setEnabled(false);
        UpgradeThread thread = new UpgradeThread((Component)((Object)this), this.getFacadeInterface(), this.progressBar);
        thread.start();
    }

    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.setHasCanel(true);
        this.setCanClose(true);
    }

    public boolean destroyWindow() {
        if (this.isCanClose()) {
            return super.destroyWindow();
        }
        return false;
    }

    class UpgradeThread
    extends Thread {
        private int DELAY = 50;
        private Component component = null;
        private IBgUpgradeFacade facade = null;
        private KDProgressBar progressBar = null;

        public UpgradeThread(Component component, IBgUpgradeFacade facade, KDProgressBar progressBar) {
            this.component = component;
            this.facade = facade;
            this.progressBar = progressBar;
        }

        @Override
        public void run() {
            super.run();
            this.init();
            this.startup();
            this.close();
        }

        private void init() {
            this.progressBar.setValue(minValue);
            this.progressBar.setMaximum(maxValue);
            this.progressBar.setStringPainted(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startup() {
            String bgUpradeId = null;
            String[] bgUpradeIds = null;
            try {
                bgUpradeIds = this.facade.getUpgradeIds();
                maxValue = bgUpradeIds.length;
                this.progressBar.setMaximum(maxValue);
                for (int i = 0; i < maxValue && !ProgressUpgradeUI.this.isHasCanel(); ++i) {
                    bgUpradeId = bgUpradeIds[i];
                    try {
                        this.facade.upgradeModelInfo(bgUpradeId);
                    }
                    catch (Exception ex0) {
                        logger.info((Object)(EASResource.getString((String)"com.kingdee.eas.ma.nbudget.NBUDGETAutoGenerateResource", (String)"102_ProgressUpgradeUI") + bgUpradeId + "'"));
                        logger.error((Object)ex0);
                    }
                    this.progressBar.setValue(i);
                    try {
                        Thread.sleep(this.DELAY);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.progressBar.setValue(maxValue);
            }
            catch (Exception ex) {
                logger.info((Object)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.NBUDGETAutoGenerateResource", (String)"103_ProgressUpgradeUI"));
                logger.error((Object)ex);
            }
        }

        private void close() {
            ((ProgressUpgradeUI)((Object)this.component)).btnCancel.setEnabled(false);
            ((ProgressUpgradeUI)((Object)this.component)).txtTitle.setText(EASResource.getString((String)"com.kingdee.eas.ma.nbudget.NBUDGETAutoGenerateResource", (String)"104_ProgressUpgradeUI"));
            ((ProgressUpgradeUI)((Object)this.component)).setCanClose(true);
        }
    }
}

