/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgTemFormTypeEnum;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.nbudget.client.AbstractReferBgFormListUI;
import com.kingdee.eas.ma.nbudget.client.BgNFormProcessUI;
import com.kingdee.eas.ma.view.client.BgReportViewProcessUI;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.apache.log4j.Logger;

public class ReferBgFormListUI
extends AbstractReferBgFormListUI {
    private static final Logger logger = CoreUIObject.getLogger(ReferBgFormListUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.processReferBgFormInfo();
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                String bgFormId;
                IRow row = null;
                if (e.getClickCount() == 2 && (row = ReferBgFormListUI.this.tblMain.getRow(e.getRowIndex())) != null && row.getCell(5).getValue() != null && !StringUtils.isEmpty((String)(bgFormId = row.getCell(5).getValue().toString()))) {
                    try {
                        ReferBgFormListUI.this.openWindow(bgFormId);
                    }
                    catch (Exception e1) {
                        logger.error((Object)e1);
                        ExceptionHandler.handle((Throwable)e1);
                    }
                }
            }
        });
    }

    private void processReferBgFormInfo() {
        Object objexpsBgForms = this.getUIContext().get("expsBgForms");
        ArrayList<Object[]> sortedList = new ArrayList<Object[]>();
        if (objexpsBgForms == null) {
            return;
        }
        Map expsBgForms = (Map)objexpsBgForms;
        Object bgForms = null;
        Object[] dataObj = null;
        IRow row = null;
        this.tblMain.checkParsed();
        this.tblMain.reLayoutAndPaint();
        this.tblMain.getStyleAttributes().setLocked(true);
        for (Object expName : expsBgForms.keySet()) {
            dataObj = (Object[])expsBgForms.get(expName);
            Object[] sortedObj = new Object[]{dataObj[0], dataObj[1], dataObj[2], dataObj[3], dataObj[4], expName, dataObj[5], dataObj[6]};
            sortedList.add(sortedObj);
        }
        Collections.sort(sortedList, new Comparator(){

            public int compare(Object obj1, Object obj2) {
                Object[] objs1 = (Object[])obj1;
                Object[] objs2 = (Object[])obj2;
                if (objs1 == null || objs2 == null) {
                    return 0;
                }
                String orgUnit1 = (String)objs1[6];
                String orgUnit2 = (String)objs2[6];
                String period1 = (String)objs1[7];
                String period2 = (String)objs2[7];
                int compare1 = orgUnit1.compareToIgnoreCase(orgUnit2);
                if (compare1 != 0) {
                    return compare1;
                }
                return period1.compareToIgnoreCase(period2);
            }
        });
        Object[] cellData2 = null;
        for (Object[] cellData2 : sortedList) {
            Object expName;
            Object bgFormId = cellData2[0];
            Object sourceBgform = cellData2[1];
            Object orgUnit = cellData2[2];
            Object period = cellData2[3];
            Object currency = cellData2[4];
            expName = cellData2[5];
            row = this.tblMain.addRow();
            row.getCell(0).setValue(expName);
            row.getCell(1).setValue(sourceBgform);
            row.getCell(2).setValue(orgUnit);
            row.getCell(3).setValue(period);
            row.getCell(4).setValue(currency);
            row.getCell(5).setValue(bgFormId);
        }
    }

    @Override
    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        String bgFormId;
        super.actionView_actionPerformed(e);
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow row = this.tblMain.getRow(rowIndex);
        if (row != null && row.getCell(5).getValue() != null && !StringUtils.isEmpty((String)(bgFormId = row.getCell(5).getValue().toString()))) {
            this.openWindow(bgFormId);
        }
    }

    protected void openWindow(String bgFormId) throws Exception {
        IBgForm ibgForm = BgFormFactory.getRemoteInstance();
        BgFormInfo info = (BgFormInfo)ibgForm.getValue("select id , bgTemplate.id, bgTemplate.formType where id = '" + bgFormId + "'");
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)bgFormId);
        IUIWindow uiWindow = null;
        uiWindow = BgTemFormTypeEnum.VIEWFORM.equals((Object)info.getBgTemplate().getFormType()) ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(BgReportViewProcessUI.class.getName(), (Map)uiContext, null, OprtState.VIEW) : UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(BgNFormProcessUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }
}

