/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client.utils;

import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.client.IBgNumberCellDisplayHelper;
import com.kingdee.eas.ma.nbudget.client.utils.IMeasureProcesser;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;

public class FixAndMbgFormMeasureProcesser
implements IMeasureProcesser {
    IBgNumberCellDisplayHelper helper = null;

    public FixAndMbgFormMeasureProcesser(IBgNumberCellDisplayHelper helper) {
        this.helper = helper;
    }

    protected IBgNumberCellDisplayHelper getHelper() {
        return this.helper;
    }

    @Override
    public BigDecimal getCoefficient(String _text, Cell _cell) {
        if (!BgNFSHelper.checkHasPercentage(_cell) && !BgNFSHelper.checkHasTextOfCell(_cell)) {
            if (BgNFSHelper.checkHasFormulaOfCell(_cell)) {
                return this.updateMeasureUnitValue(_text, _cell);
            }
            if (BgNFSHelper.checkHasNumbericOfCell(_cell)) {
                return this.updateMeasureUnitValue(_text, _cell);
            }
        }
        return null;
    }

    protected BigDecimal updateDefMeasureUnitValue(String _text, Cell _cell) {
        BigDecimal _value = null;
        BigDecimal _coefficient = null;
        try {
            _value = new BigDecimal(_text.trim().replaceAll(",", ""));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (_value != null && this.getHelper().getMeasureUnit() != null) {
            _coefficient = this.getHelper().getMeasureUnit().getCoefficient();
        }
        return _coefficient;
    }

    protected BigDecimal updateMeasureUnitValue(String _text, Cell _cell) {
        BigDecimal _value = null;
        _value = this.getHelper().getMeasureUnitMap().isEmpty() ? this.updateDefMeasureUnitValue(_text, _cell) : this.updateBgMeasureUnitValue(_text, _cell);
        return _value;
    }

    protected BigDecimal updateBgMeasureUnitValue(String _text, Cell _cell) {
        String _formulaStr = null;
        String _bgElementNumber = null;
        String _tmpStr = null;
        String[] _parameter = null;
        BigDecimal _value = null;
        BigDecimal _coefficient = null;
        _tmpStr = _text.trim().replaceAll(",", "");
        try {
            _value = new BigDecimal(_tmpStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (_value != null) {
            if (this.getHelper().getMeasureUnit() != null) {
                _coefficient = this.getHelper().getMeasureUnit().getCoefficient();
            }
            _formulaStr = BgNFSHelper.getFormulaOfCell(_cell);
            _parameter = BgNFSHelper.parseFormulaPara(this.getHelper().getFormulaMap(), _formulaStr);
            if (_parameter != null && !StringUtils.isEmpty((String)_parameter[2])) {
                _bgElementNumber = _parameter[2];
                _coefficient = this.getCoef(_bgElementNumber, _coefficient);
            }
        }
        return _coefficient;
    }

    protected BigDecimal getCoef(String _bgElementNumber, BigDecimal defaultValue) {
        if (this.getHelper() == null || this.getHelper().getMeasureUnitMap() == null || !this.getHelper().getMeasureUnitMap().containsKey(_bgElementNumber)) {
            return defaultValue;
        }
        if (this.getHelper().getMeasureUnitMap().get(_bgElementNumber) instanceof BigDecimal) {
            return (BigDecimal)this.getHelper().getMeasureUnitMap().get(_bgElementNumber);
        }
        if (this.getHelper().getMeasureUnitMap().get(_bgElementNumber) instanceof MeasureUnitInfo) {
            return ((MeasureUnitInfo)this.getHelper().getMeasureUnitMap().get(_bgElementNumber)).getCoefficient();
        }
        return defaultValue;
    }
}

