/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.request;

import com.kingdee.bos.ctrl.common.util.ZipUtil;
import com.kingdee.eas.base.commonquery.BooleanEnum;
import com.kingdee.eas.ma.nbudget.request.BgBillInfo;
import com.kingdee.eas.ma.nbudget.request.BgFieldInfo;
import com.kingdee.eas.ma.nbudget.request.BgInitValueInfo;
import com.kingdee.eas.ma.nbudget.request.IBgBill;
import com.kingdee.eas.ma.nbudget.request.IBgField;
import com.kingdee.eas.ma.nbudget.request.IBgFieldValue;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.DoubleEnum;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.EnumUtils;
import com.kingdee.util.enums.FloatEnum;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.LongEnum;
import com.kingdee.util.enums.StringEnum;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.apache.log4j.Logger;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class BgFields {
    private static final Logger logger = Logger.getLogger(BgFields.class);
    public static String CONFIG = "budgetRequestConfig";
    public static String FIELD_FIELD = "field";
    public static String FIELD_NAME = "name";
    public static String FIELD_VALUE = "value";
    public static String FIELD_DISPLAY = "display";
    public static String FIELD_DISPLAYNAME = "displayName";
    public static String FIELD_TYPE = "type";
    public static String FIELD_HEAD = "isHead";
    public static String FIELD_REQUEST = "isRequest";
    public static String FIELD_STATE = "state";
    public static String INIT_FIELD = "initValue";
    public static String INIT_CLASSNAME = "classname";
    public static String INIT_ID = "info-id";
    public static String INIT_NAME = "info-name";
    public static String INIT_NUMBER = "info-number";
    public static String INIT_REFFIELD = "info-refField";
    public static String INIT_QUERY = "info-query";
    public static String INIT_DEFVALUE = "def-value";
    public static String INIT_FILTER = "filter";
    public static String INIT_ORDER = "order";
    public static String INIT_EDIT = "edit";
    public static String INIT_EXPRESSION = "expression";
    public static String FIELD_TYPE_OBJ = "obj";
    public static String FIELD_TYPE_NUMBER = "number";
    public static String FIELD_TYPE_DATE = "date";
    public static String FIELD_TYPE_TIME = "time";
    public static String FIELD_TYPE_TEXT = "text";
    public static String FIELD_TYPE_ENUM = "enum";
    public static String FIELD_TYPE_BGITEM = "bgitem";
    public static String FIELD_STATE_LOCK = "lock";
    public static String FIELD_STATE_UNLOCK = "unlock";
    public static String FIELD_NUMBER_CODENUMBER = "codeNumber";
    public static String showType_display_all = "true";
    public static String showType_display_list = "list";
    public static String showType_display_edit = "edit";
    public static String showType_display_no = "false";
    public static String ORGUNIT_CURRORGUNIT = "currOrgUnit";
    public static String ORGUNIT_CURRCOMPANY = "currOrgUnit.Company";
    public static String ORGUNIT_CURRADMIN = "currOrgUnit.admin";
    public static String DATE_APPLY = "apply";
    public static String DATE_BIZ = "biz";
    public static String DATE_DAY = "D";
    public static String DATE_MONTH = "M";
    public static String DATE_YEAR = "Y";
    public static String blank_spaces = "blank_spaces";
    public static String total_row_nums = "total_row_nums";
    public static String total_col_nums = "total_col_nums";

    public static IBgBill getBgBillInfo(InputStream xmlStream, boolean isShowHideField, boolean showType) throws Exception {
        if (xmlStream == null) {
            return null;
        }
        SAXReader reader = new SAXReader();
        Document document = null;
        Element root = null;
        Element element = null;
        Element initElement = null;
        int serial = 0;
        String tmpStr = null;
        BgBillInfo bgBillInfo = new BgBillInfo();
        BgFieldInfo fieldInfo = null;
        BgInitValueInfo initValueInfo = null;
        try {
            document = reader.read(xmlStream);
            root = document.getRootElement();
            Iterator iterator = root.elementIterator();
            while (iterator.hasNext()) {
                element = (Element)iterator.next();
                tmpStr = element.getName();
                if (!FIELD_FIELD.equalsIgnoreCase(tmpStr)) continue;
                fieldInfo = new BgFieldInfo();
                fieldInfo.setSerial(serial++);
                fieldInfo.setName(BgFields.getStringFieldAttribute(element, FIELD_NAME));
                fieldInfo.setValue(BgFields.getStringFieldAttribute(element, FIELD_VALUE));
                fieldInfo.setDisplayType(BgFields.getStringFieldAttribute(element, FIELD_DISPLAY));
                if (!isShowHideField) {
                    fieldInfo.setDisplay(false);
                    if (showType) {
                        if (showType_display_all.equals(fieldInfo.getDisplayType()) || showType_display_list.equals(fieldInfo.getDisplayType())) {
                            fieldInfo.setDisplay(true);
                        }
                    } else if (showType_display_all.equals(fieldInfo.getDisplayType()) || showType_display_edit.equals(fieldInfo.getDisplayType())) {
                        fieldInfo.setDisplay(true);
                    }
                }
                fieldInfo.setDisplayName(BgFields.getStringFieldAttribute(element, FIELD_DISPLAYNAME));
                fieldInfo.setType(BgFields.getStringFieldAttribute(element, FIELD_TYPE));
                fieldInfo.setHead(BgFields.getBooleanFieldAttribute(element, FIELD_HEAD, false));
                fieldInfo.setRequest(BgFields.getBooleanFieldAttribute(element, FIELD_REQUEST, false));
                if (BgFields.getStringFieldAttribute(element, blank_spaces) != null) {
                    fieldInfo.setBlankSpaces(BgFields.getStringFieldAttribute(element, blank_spaces));
                }
                if (BgFields.getStringFieldAttribute(element, total_row_nums) != null) {
                    fieldInfo.setTotalRowNums(BgFields.getStringFieldAttribute(element, total_row_nums));
                }
                if (BgFields.getStringFieldAttribute(element, total_col_nums) != null) {
                    fieldInfo.setTotalColNums(BgFields.getStringFieldAttribute(element, total_col_nums));
                }
                if (FIELD_STATE_LOCK.equals(tmpStr = BgFields.getStringFieldAttribute(element, FIELD_STATE))) {
                    fieldInfo.setLock(true);
                } else {
                    fieldInfo.setLock(false);
                }
                initValueInfo = new BgInitValueInfo();
                initElement = element.element(INIT_FIELD);
                if (initElement != null) {
                    String[] sort;
                    initValueInfo.setClassName(BgFields.getStringFieldElement(initElement, INIT_CLASSNAME));
                    initValueInfo.setQuery(BgFields.getStringFieldElement(initElement, INIT_QUERY));
                    initValueInfo.setId(BgFields.getStringFieldElement(initElement, INIT_ID));
                    if (initValueInfo.getId() != null) {
                        initValueInfo.setName(BgFields.getStringFieldElement(initElement, INIT_NAME));
                        initValueInfo.setNumber(BgFields.getStringFieldElement(initElement, INIT_NUMBER));
                        initValueInfo.setRefField(BgFields.getStringFieldElement(initElement, INIT_REFFIELD));
                    }
                    initValueInfo.setDefValue(BgFields.getStringFieldElement(initElement, INIT_DEFVALUE));
                    initValueInfo.setExpression(BgFields.getStringFieldElement(initElement, INIT_EXPRESSION));
                    tmpStr = BgFields.getStringFieldElement(initElement, INIT_ORDER);
                    if (tmpStr != null && (sort = tmpStr.split(":")) != null) {
                        if (sort.length > 0) {
                            initValueInfo.setOrder(Boolean.valueOf(sort[0]));
                        }
                        if (sort.length > 1) {
                            initValueInfo.setSortType(sort[1]);
                        }
                    }
                    initValueInfo.setFilter(BgFields.getBooleanFieldElement(initElement, INIT_FILTER, false));
                    initValueInfo.setEdit(BgFields.getBooleanFieldElement(initElement, INIT_EDIT, true));
                    if ("enum".equalsIgnoreCase(fieldInfo.getType()) && BgFields.getStringFieldElement(initElement, INIT_CLASSNAME) != null) {
                        ArrayList enumList = new ArrayList();
                        List list = EnumUtils.getEnumList((String)BgFields.getStringFieldElement(initElement, INIT_CLASSNAME));
                        if (list != null && list.size() > 0) {
                            for (int i = 0; i < list.size(); ++i) {
                                HashMap<String, Object> map = new HashMap<String, Object>();
                                if (!(list.get(i) instanceof Enum)) continue;
                                Enum enumItem = (Enum)list.get(i);
                                map.put("key", enumItem.getAlias());
                                map.put("value", BgFields.getEnumValue(enumItem));
                                enumList.add(map);
                            }
                        }
                        initValueInfo.setEnumList(enumList);
                    }
                }
                fieldInfo.setInitValue(initValueInfo);
                if (isShowHideField) {
                    bgBillInfo.getFields().add(fieldInfo);
                    continue;
                }
                if (!fieldInfo.isDisplay()) continue;
                bgBillInfo.getFields().add(fieldInfo);
            }
        }
        catch (DocumentException ex) {
            logger.error((Object)"load BudgetRequestBill Config File Error!", (Throwable)ex);
            throw ex;
        }
        return bgBillInfo;
    }

    public static byte[] getBgBillData(IBgBill bgBillInfo) throws Exception {
        if (bgBillInfo == null || bgBillInfo.getFields().isEmpty()) {
            return null;
        }
        byte[] bytes = null;
        BgFieldInfo fieldInfo = null;
        IBgFieldValue fieldValue = null;
        List<IBgField> fields = bgBillInfo.getFields();
        XMLStreamWriter writer = null;
        try (ByteArrayOutputStream baos = null;){
            baos = new ByteArrayOutputStream();
            writer = XMLOutputFactory.newInstance().createXMLStreamWriter(baos, "UTF-8");
            writer.writeStartDocument("UTF-8", "1.0");
            writer.writeStartElement(CONFIG);
            int xn = fields.size();
            for (int x = 0; x < xn; ++x) {
                fieldInfo = (BgFieldInfo)fields.get(x);
                writer.writeStartElement(FIELD_FIELD);
                writer.writeAttribute(FIELD_NAME, fieldInfo.getName());
                writer.writeAttribute(FIELD_VALUE, fieldInfo.getValue());
                writer.writeAttribute(FIELD_DISPLAY, fieldInfo.getDisplayType());
                if (!StringUtils.isEmpty((String)fieldInfo.getDisplayName())) {
                    writer.writeAttribute(FIELD_DISPLAYNAME, fieldInfo.getDisplayName());
                }
                writer.writeAttribute(FIELD_TYPE, fieldInfo.getType());
                writer.writeAttribute(FIELD_HEAD, String.valueOf(fieldInfo.isHead()));
                writer.writeAttribute(FIELD_REQUEST, String.valueOf(fieldInfo.isRequest()));
                writer.writeAttribute(blank_spaces, String.valueOf(fieldInfo.getBlankSpaces()));
                writer.writeAttribute(total_row_nums, String.valueOf(fieldInfo.getTotalRowNums()));
                writer.writeAttribute(total_col_nums, String.valueOf(fieldInfo.getTotalColNums()));
                if (fieldInfo.isLock()) {
                    writer.writeAttribute(FIELD_STATE, FIELD_STATE_LOCK);
                }
                if ((fieldValue = fieldInfo.getInitValue()) != null) {
                    writer.writeStartElement(INIT_FIELD);
                    if (!StringUtils.isEmpty((String)fieldValue.getClassName())) {
                        writer.writeStartElement(INIT_CLASSNAME);
                        writer.writeCharacters(fieldValue.getClassName());
                        writer.writeEndElement();
                    }
                    if (!StringUtils.isEmpty((String)fieldValue.getId())) {
                        writer.writeStartElement(INIT_ID);
                        writer.writeCharacters(fieldValue.getId());
                        writer.writeEndElement();
                    }
                    if (!StringUtils.isEmpty((String)fieldValue.getName())) {
                        writer.writeStartElement(INIT_NAME);
                        writer.writeCharacters(fieldValue.getName());
                        writer.writeEndElement();
                    }
                    if (!StringUtils.isEmpty((String)fieldValue.getNumber())) {
                        writer.writeStartElement(INIT_NUMBER);
                        writer.writeCharacters(fieldValue.getNumber());
                        writer.writeEndElement();
                    }
                    if (!StringUtils.isEmpty((String)fieldValue.getRefField())) {
                        writer.writeStartElement(INIT_REFFIELD);
                        writer.writeCharacters(fieldValue.getRefField());
                        writer.writeEndElement();
                    }
                    if (!StringUtils.isEmpty((String)fieldValue.getQuery())) {
                        writer.writeStartElement(INIT_QUERY);
                        writer.writeCharacters(fieldValue.getQuery());
                        writer.writeEndElement();
                    }
                    if (!StringUtils.isEmpty((String)fieldValue.getDefValue())) {
                        writer.writeStartElement(INIT_DEFVALUE);
                        writer.writeCharacters(fieldValue.getDefValue());
                        writer.writeEndElement();
                    }
                    if (fieldValue.isFilter()) {
                        writer.writeStartElement(INIT_FILTER);
                        writer.writeCharacters(String.valueOf(fieldValue.isFilter()));
                        writer.writeEndElement();
                    }
                    if (fieldValue.isOrder()) {
                        writer.writeStartElement(INIT_ORDER);
                        writer.writeCharacters(String.valueOf(fieldValue.isOrder()) + ":" + fieldValue.getSortType());
                        writer.writeEndElement();
                    }
                    if (!StringUtils.isEmpty((String)fieldValue.getExpression())) {
                        writer.writeStartElement(INIT_EXPRESSION);
                        writer.writeCharacters(fieldValue.getExpression());
                        writer.writeEndElement();
                    }
                    if (!fieldValue.isEdit()) {
                        writer.writeStartElement(INIT_EDIT);
                        writer.writeCharacters(String.valueOf(fieldValue.isEdit()));
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            writer.writeEndDocument();
            bytes = ZipUtil.pack((ByteArrayOutputStream)baos);
        }
        return bytes;
    }

    private static String getStringFieldAttribute(Element element, String field) {
        if (element == null || field == null) {
            return null;
        }
        Attribute attr = element.attribute(field);
        if (attr != null) {
            return attr.getValue();
        }
        return null;
    }

    private static boolean getBooleanFieldAttribute(Element element, String field, boolean defValue) {
        if (element == null || field == null) {
            return false;
        }
        boolean re = defValue;
        Attribute attr = element.attribute(field);
        if (attr != null && !StringUtils.isEmpty((String)attr.getValue())) {
            try {
                re = Boolean.valueOf(attr.getValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return re;
    }

    private static String getStringFieldElement(Element element, String field) {
        if (element == null) {
            return null;
        }
        Element _element = element.element(field);
        if (_element != null) {
            return _element.getText();
        }
        return null;
    }

    private static boolean getBooleanFieldElement(Element element, String field, boolean defValue) {
        if (element == null || field == null) {
            return defValue;
        }
        boolean re = defValue;
        Element _element = element.element(field);
        if (_element != null && !StringUtils.isEmpty((String)_element.getText())) {
            try {
                re = Boolean.valueOf(_element.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return re;
    }

    public static Object getEnumValue(Enum enumValue) {
        Object value = null;
        if (enumValue instanceof BooleanEnum) {
            value = new Integer(((IntEnum)enumValue).getValue());
        } else if (enumValue instanceof IntEnum) {
            value = new Integer(((IntEnum)enumValue).getValue());
        } else if (enumValue instanceof FloatEnum) {
            value = String.valueOf(((FloatEnum)enumValue).getValue());
        } else if (enumValue instanceof DoubleEnum) {
            value = String.valueOf(((DoubleEnum)enumValue).getValue());
        } else if (enumValue instanceof LongEnum) {
            value = String.valueOf(((LongEnum)enumValue).getValue());
        } else if (enumValue instanceof StringEnum) {
            value = ((StringEnum)enumValue).getValue();
        }
        return value;
    }
}

