/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.util.ParmCodingRule;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;

public abstract class BgBaseCodeRuleUtils {
    public static final String CODERULE_PROPERTY = "sourceType";
    public static final String FIELD_NUMBER = "number";
    public static final String FIELD_NAME = "name";
    private Context ctx = null;
    private boolean hasClient = true;
    private ICodingRuleManager codingRuleManager = null;
    private boolean hasCodeRule = false;
    private boolean hasIntermitNumber = false;
    private boolean hasShowCodeNumber = false;
    private boolean isNumberOrIsName = false;

    protected Context getCtx() {
        return this.ctx;
    }

    protected boolean isHasClient() {
        return this.hasClient;
    }

    protected ICodingRuleManager getCodingRuleManager() throws BOSException {
        if (this.codingRuleManager == null) {
            this.codingRuleManager = this.getCtx() != null ? CodingRuleManagerFactory.getLocalInstance((Context)this.getCtx()) : CodingRuleManagerFactory.getRemoteInstance();
        }
        return this.codingRuleManager;
    }

    protected void setHasCodeRule(boolean hasCodeRule) {
        this.hasCodeRule = hasCodeRule;
    }

    public boolean isHasCodeRule() {
        return this.hasCodeRule;
    }

    protected void setHasIntermitNumber(boolean hasIntermitNumber) {
        this.hasIntermitNumber = hasIntermitNumber;
    }

    public boolean isHasIntermitNumber() {
        return this.hasIntermitNumber;
    }

    protected void setHasShowCodeNumber(boolean hasShowCodeNumber) {
        this.hasShowCodeNumber = hasShowCodeNumber;
    }

    public boolean isHasShowCodeNumber() {
        return this.hasShowCodeNumber;
    }

    public BgBaseCodeRuleUtils(boolean hasClient) {
        this(null, hasClient);
    }

    public BgBaseCodeRuleUtils(Context ctx, boolean hasClient) {
        this.ctx = ctx;
        this.hasClient = hasClient;
    }

    protected void init() {
        this.setHasCodeRule(false);
        this.setHasIntermitNumber(false);
        this.setHasShowCodeNumber(false);
    }

    public boolean isNumberOrIsName() {
        return this.isNumberOrIsName;
    }

    public void setNumberOrIsName(boolean isNumberOrIsName) {
        this.isNumberOrIsName = isNumberOrIsName;
    }

    protected void applyNumber(IObjectValue model, String orgUnitId, String property, String fieldName) throws BOSException, EASBizException {
        if (model == null || StringUtils.isEmpty((String)orgUnitId)) {
            return;
        }
        if (StringUtils.isEmpty((String)fieldName)) {
            fieldName = FIELD_NUMBER;
        }
        if (!StringUtils.isEmpty((String)model.getString(fieldName))) {
            return;
        }
        this.init();
        String number = null;
        if (property == null) {
            this.applyNumber(model, orgUnitId, fieldName);
        } else {
            ParmCodingRule pcr = this.getParmCodingRule(fieldName);
            CodingRuleInfo cr = this.getCodingRuleManager().getCodingRule(model, orgUnitId, property, pcr);
            if (cr == null) {
                this.applyNumber(model, orgUnitId, fieldName);
            } else {
                this.setHasCodeRule(true);
                this.setNumberOrIsName(true);
                this.setRuleField(this.getRuleField(), false);
                if (this.isHasClient()) {
                    if (cr.isIsAddView()) {
                        this.setHasShowCodeNumber(true);
                        number = this.getCodeRuleNumber(model, cr);
                    } else if (cr.isIsDHSelect()) {
                        this.setHasIntermitNumber(true);
                        if (this.getSelector() != null && cr.isIsUserSelect()) {
                            number = this.getUserSelectNumber(model, orgUnitId, property);
                        }
                    }
                } else {
                    number = this.getCodeRuleNumber(model, cr);
                }
            }
            if (StringUtils.isEmpty(number)) {
                number = this.getCustomNumber(model, orgUnitId, fieldName);
            }
            this.prepareNumber(this.getRuleField(), model, fieldName, number);
            if (this.isModifiable(cr)) {
                this.setRuleField(this.getRuleField(), true);
            }
        }
    }

    private void applyNumber(IObjectValue model, String orgUnitId, String fieldName) throws BOSException, EASBizException {
        if (model == null || StringUtils.isEmpty((String)orgUnitId)) {
            return;
        }
        if (StringUtils.isEmpty((String)fieldName)) {
            fieldName = FIELD_NUMBER;
        }
        if (!StringUtils.isEmpty((String)model.getString(fieldName))) {
            return;
        }
        this.init();
        if (this.isNumberOrIsName) {
            this.setHasCodeRule(true);
        }
        String number = null;
        ParmCodingRule pcr = this.getParmCodingRule(fieldName);
        CodingRuleInfo cr = this.getCodingRuleManager().getCodingRule(model, orgUnitId, pcr);
        if (cr != null) {
            this.setHasCodeRule(true);
            this.setRuleField(this.getRuleField(), false);
            if (this.isHasClient()) {
                if (cr.isIsAddView()) {
                    this.setHasShowCodeNumber(true);
                    number = this.getCodeRuleNumber(model, cr);
                } else if (cr.isIsDHSelect()) {
                    this.setHasIntermitNumber(true);
                    if (this.getSelector() != null && cr.isIsUserSelect()) {
                        number = this.getUserSelectNumber(model, orgUnitId, null);
                    }
                }
            } else {
                number = this.getCodeRuleNumber(model, cr);
            }
        } else {
            this.setRuleField(this.getRuleField(), true);
        }
        if (StringUtils.isEmpty(number)) {
            number = this.getCustomNumber(model, orgUnitId, fieldName);
        }
        this.prepareNumber(this.getRuleField(), model, fieldName, number);
        if (this.isModifiable(cr)) {
            this.setRuleField(this.getRuleField(), true);
        }
    }

    protected String getIntermitNumber(IObjectValue model, CodingRuleInfo cr) throws BOSException, EASBizException {
        return this.getCodingRuleManager().getNumber(model, cr);
    }

    protected String getCodeRuleNumber(IObjectValue model, CodingRuleInfo cr) throws BOSException, EASBizException {
        return this.getCodingRuleManager().getNumber(model, cr);
    }

    protected abstract KDPromptSelector getSelector();

    protected boolean isModifiable(CodingRuleInfo cr) throws BOSException, EASBizException {
        if (cr != null) {
            return cr.isIsModifiable();
        }
        return false;
    }

    public void recycleNumber(IObjectValue model, String orgUnitId, String[] numbers, String fieldName, String property) throws BOSException, EASBizException {
        if (this.getCtx() == null || model == null || StringUtils.isEmpty((String)orgUnitId) || numbers == null || numbers.length == 0) {
            return;
        }
        if (StringUtils.isEmpty((String)fieldName)) {
            fieldName = FIELD_NUMBER;
        }
        ParmCodingRule pcr = this.getParmCodingRule(fieldName);
        CodingRuleInfo cr = this.getCodingRuleManager().getCodingRule(model, orgUnitId, property, pcr);
        if (cr == null) {
            this.recycleNumber(model, orgUnitId, numbers, fieldName);
        } else if (this.getCodingRuleManager().isUseIntermitNumber(cr)) {
            this.getCodingRuleManager().recycleBatchNumber(model, orgUnitId, numbers, null, property);
        }
    }

    public void recycleNumber(IObjectValue model, String orgUnitId, String[] numbers, String fieldName) throws BOSException, EASBizException {
        if (this.getCtx() == null || model == null || StringUtils.isEmpty((String)orgUnitId) || numbers == null || numbers.length == 0) {
            return;
        }
        if (StringUtils.isEmpty((String)fieldName)) {
            fieldName = FIELD_NUMBER;
        }
        ParmCodingRule pcr = this.getParmCodingRule(fieldName);
        CodingRuleInfo cr = this.getCodingRuleManager().getCodingRule(model, orgUnitId, pcr);
        if (cr != null && this.getCodingRuleManager().isUseIntermitNumber(cr)) {
            this.getCodingRuleManager().recycleBatchNumber(model, orgUnitId, numbers);
        }
    }

    private ParmCodingRule getParmCodingRule(String fieldName) {
        if (StringUtils.isEmpty((String)fieldName) || FIELD_NUMBER.equals(fieldName)) {
            return null;
        }
        ParmCodingRule pcr = new ParmCodingRule();
        pcr.setCustomProperty(fieldName);
        return pcr;
    }

    protected abstract String getUserSelectNumber(IObjectValue var1, String var2, String var3) throws BOSException, EASBizException;

    protected abstract KDTextField getRuleField();

    protected void setRuleField(KDTextField txtField, boolean enable) {
        if (txtField != null) {
            txtField.setEnabled(enable);
            txtField.setEditable(enable);
        }
    }

    protected String getCustomNumber(IObjectValue model, String orgUnitId, String fieldName) {
        if (FIELD_NUMBER.equals(fieldName)) {
            return "Bg-" + System.currentTimeMillis();
        }
        return null;
    }

    protected void prepareNumber(KDTextField txtField, IObjectValue model, String fieldName, String number) {
        if (StringUtils.isEmpty((String)fieldName)) {
            fieldName = FIELD_NUMBER;
        }
        if (!StringUtils.isEmpty((String)number)) {
            model.setString(fieldName, number);
        }
        if (this.hasShowCodeNumber) {
            this.setRuleField(txtField, false);
        }
        if (this.hasShowCodeNumber && txtField != null) {
            txtField.setText(number);
        }
    }
}

