/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.scmcommon.tools;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Utils {
    public static final String TRANSFERBILL_TASK_CATALOG = "transferbill";
    public static final String ISSUECALCULATE_TASK_CATALOG = "issuecalculate";
    public static final String CLOSEPERIOD_TASK_CATALOG = "closeperiod";
    public static final String UNCLOSEPERIOD_TASK_CATALOG = "uncloseperiod";
    public static final String CLOSEPERIODCHECK_CATALOG = "closeperiodcheck";
    public static final String ISSUECALCULATECHECK_CATALOG = "issuecalculatecheck";
    public static ArrayList<String> taskMutex = new ArrayList<String>(){
        {
            this.add(Utils.TRANSFERBILL_TASK_CATALOG);
            this.add(Utils.ISSUECALCULATE_TASK_CATALOG);
            this.add(Utils.CLOSEPERIOD_TASK_CATALOG);
            this.add(Utils.UNCLOSEPERIOD_TASK_CATALOG);
        }
    };
    public static Map<String, String> taskNameMap = new HashMap<String, String>(){
        {
            this.put(Utils.TRANSFERBILL_TASK_CATALOG, "TRANSFERBILL_TASK_CATALOG");
            this.put(Utils.ISSUECALCULATE_TASK_CATALOG, "ISSUECALCULATE_TASK_CATALOG");
            this.put(Utils.CLOSEPERIOD_TASK_CATALOG, "CLOSEPERIOD_TASK_CATALOG");
            this.put(Utils.UNCLOSEPERIOD_TASK_CATALOG, "UNCLOSEPERIOD_TASK_CATALOG");
            this.put(Utils.CLOSEPERIODCHECK_CATALOG, "CLOSEPERIODCHECK_CATALOG");
            this.put(Utils.ISSUECALCULATECHECK_CATALOG, "ISSUECALCULATECHECK_CATALOG");
        }
    };

    public static String ListToString(List ids, String key) {
        StringBuffer idstring = new StringBuffer();
        String id = null;
        Object value = null;
        for (int i = 0; i < ids.size(); ++i) {
            if (ids.get(i) instanceof String) {
                id = ids.get(i).toString();
            } else if (ids.get(i) instanceof Map) {
                Map temp = (Map)ids.get(i);
                id = temp.get(key).toString();
            }
            if (i == 0) {
                idstring.append("'").append(id).append("'");
                continue;
            }
            idstring.append(",'").append(id).append("'");
        }
        return idstring.toString();
    }

    public static BatchExecuteParamsEntry[] buildBatchParam(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BatchExecuteParamsEntry entry = new BatchExecuteParamsEntry(new Class[]{IObjectPK.class});
        entry.add((Object)pk);
        return new BatchExecuteParamsEntry[]{entry};
    }

    public static ExchangeRateInfo getExchangeRate(CompanyOrgUnitInfo companyOrgUnitInfo, CurrencyInfo sourceCur, Date date) throws EASBizException, BOSException {
        IExchangeRate iexchangRate = null;
        ObjectUuidPK excTablepk = null;
        ObjectUuidPK destCurrpk = null;
        if (sourceCur == null) {
            return null;
        }
        if (companyOrgUnitInfo.getBaseExchangeTable() == null) {
            return null;
        }
        excTablepk = new ObjectUuidPK(companyOrgUnitInfo.getBaseExchangeTable().getId());
        CurrencyInfo baseCur = companyOrgUnitInfo.getBaseCurrency();
        if (baseCur != null) {
            if (baseCur.getId().equals((Object)sourceCur.getId())) {
                return null;
            }
        } else {
            return null;
        }
        destCurrpk = new ObjectUuidPK(baseCur.getId());
        iexchangRate = ExchangeRateFactory.getRemoteInstance();
        ObjectUuidPK sourceCurrpk = new ObjectUuidPK(sourceCur.getId());
        ExchangeRateInfo erInfo = iexchangRate.getExchangeRate((IObjectPK)excTablepk, (IObjectPK)sourceCurrpk, (IObjectPK)destCurrpk, date);
        return erInfo;
    }

    public static Map<String, Object> getMaterialMmuPrecisions(Context ctx, List<List> ids) throws EASBizException, BOSException {
        HashMap<String, Object> precisionsMap = new HashMap<String, Object>();
        StringBuilder sqlBuilder = new StringBuilder();
        for (int i = 0; i < ids.size(); ++i) {
            List ll = ids.get(i);
            String materialId = (String)ll.get(0);
            String measureUnitId = (String)ll.get(1);
            if (materialId == null || "".equals(materialId) || measureUnitId == null || "".equals(measureUnitId)) continue;
            if (sqlBuilder.length() > 0) {
                sqlBuilder.append(" or ");
            }
            sqlBuilder.append(" (material.id='").append(materialId).append("' and measureUnit.id='").append(measureUnitId).append("') ");
        }
        if (sqlBuilder.length() > 0) {
            String sql = "select material.id, measureUnit.id, qtyPrecision, baseConvsRate where " + sqlBuilder.toString();
            MultiMeasureUnitCollection col = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiMeasureUnitCollection(sql);
            for (int i = 0; i < col.size(); ++i) {
                MultiMeasureUnitInfo info = col.get(i);
                String key = info.getMaterial().getId().toString() + info.getMeasureUnit().getId().toString();
                precisionsMap.put(key, info.getQtyPrecision());
            }
        }
        return precisionsMap;
    }

    public static boolean isEmpty(String str) {
        return null == str || str.trim().length() == 0;
    }
}

