/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.common.client;

import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.eas.common.client.LocaleUtil;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.mm.common.client.AdvMsgBox;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;

class BgPanel
extends KDPanel {
    protected Image bgImg;
    protected String msg;
    protected Vector vecLines;
    protected static final int lineHeight = 15;
    protected static final int x = 150;
    protected static final int y = 28;
    protected static final int maxWidth = 255;
    protected static final int normalLine = 8;
    protected static final int maxLine = 26;
    protected static final int imageWidth = 429;
    protected static final int imageHeight = 138;
    protected static final Color extMsgBgColor = new Color(242, 242, 242);

    public BgPanel(Image bgImg, String msg) {
        this.bgImg = bgImg;
        this.msg = msg;
        this.setBackground(extMsgBgColor);
        this.setPreferredSize(new Dimension(429, 165));
        if (msg != null && !msg.equals("")) {
            this.initStringArray();
        }
    }

    protected void initStringArray() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        StringTokenizer st = new StringTokenizer(this.msg, "\n");
        String paragraphString = null;
        boolean isChinese = false;
        String language = null;
        try {
            language = LocaleUtil.getOriginalLocale((Locale)SysContext.getSysContext().getLocale()).getLanguage();
        }
        catch (Throwable t) {
            language = Locale.getDefault().getLanguage();
        }
        if (language != null && language.equalsIgnoreCase("zh")) {
            isChinese = true;
        }
        this.vecLines = new Vector(26);
        StringBuffer lineString = null;
        while (st.hasMoreTokens() && this.vecLines.size() < 26) {
            paragraphString = st.nextToken().trim();
            paragraphString = isChinese ? "\u3000\u3000" + paragraphString : "  " + paragraphString;
            lineString = new StringBuffer();
            int lineLength = 0;
            for (int i = 0; i < paragraphString.length() && this.vecLines.size() < 26; ++i) {
                char word = paragraphString.charAt(i);
                if ((lineLength += fontMetrics.charWidth(word)) < 255) {
                    lineString.append(word);
                    continue;
                }
                lineString.append(word);
                this.vecLines.add(lineString);
                lineString = new StringBuffer();
                lineLength = 0;
            }
            this.vecLines.add(lineString);
        }
        String lastLineStr = this.vecLines.get(this.vecLines.size() - 1).toString();
        if (lastLineStr.trim().length() == 1 && "!,.?\uff01\uff0c\u3002\uff1f".indexOf(lastLineStr.trim()) != -1) {
            this.vecLines.remove(this.vecLines.size() - 1);
            AdvMsgBox.logger.info((Object)("new line just one char, remove it . this char is:" + lastLineStr.trim()));
        }
        if (this.vecLines.size() > 9 && this.vecLines.size() < 27) {
            int actHeight = this.vecLines.size() * 15;
            this.setPreferredSize(new Dimension(429, actHeight));
        } else if (this.vecLines.size() > 26) {
            this.setPreferredSize(new Dimension(429, 390));
        }
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.drawImage(this.bgImg, 0, 0, this.getSize().width, 138, (ImageObserver)((Object)this));
        if (this.vecLines != null) {
            for (int i = 0; i < this.vecLines.size(); ++i) {
                g.drawString(((StringBuffer)this.vecLines.elementAt(i)).toString(), 150, 28 + i * 15);
            }
        }
    }
}

