/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.common.client;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.mm.basedata.SFCFacadeFactory;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.text.MessageFormat;
import java.util.Map;

public class CalcOperNoHelper {
    private KDTable table;
    private String colName;
    private Map paramStepMap = null;
    private String orgID = null;

    public CalcOperNoHelper(KDTable table, String colName) {
        this.table = table;
        this.colName = colName;
    }

    public void setOrgID(String orgID) {
        if (this.orgID == null || this.orgID != null && !this.orgID.equals(orgID)) {
            this.orgID = orgID;
            this.paramStepMap = null;
        }
    }

    public void checkOperNoIsDuplication(int rowIndex) {
        int colIndex = this.table.getColumnIndex(this.colName);
        int newOperNo = (Integer)this.table.getCell(rowIndex, colIndex).getValue();
        if (newOperNo == 0) {
            String msg = this.getResource("OPERATION_IS_ZERO");
            MsgBox.showInfo((String)msg);
            this.table.getEditManager().editCellAt(rowIndex, colIndex);
        }
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            int theOperNo;
            if (i == rowIndex || newOperNo != (theOperNo = ((Integer)this.table.getCell(i, colIndex).getValue()).intValue())) continue;
            String msg = this.getResource("OPERATION_IS_DUPLICATION");
            msg = MessageFormat.format(msg, new Integer(i + 1));
            MsgBox.showInfo((String)msg);
            this.table.getEditManager().editCellAt(rowIndex, colIndex);
            return;
        }
    }

    private Map getParamStepData() {
        if (this.paramStepMap == null && this.orgID != null) {
            try {
                this.paramStepMap = SFCFacadeFactory.getRemoteInstance().getSFCSysParams(this.orgID);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        return this.paramStepMap;
    }

    public int caculateOperNo(int rowIndex) {
        Map stepData = this.getParamStepData();
        int initOperNo = 1;
        int step = 10;
        if (stepData != null && stepData.get("DMES_PROCESS_STEP") != null) {
            initOperNo = (Integer)stepData.get("DMES_PROCESS_STEP");
            step = (Integer)stepData.get("DMES_PROCESS_STEP");
        }
        int operNo = 1;
        if (rowIndex == 0) {
            operNo = initOperNo;
        } else {
            int preOperNo = (Integer)this.table.getCell(rowIndex - 1, this.colName).getValue();
            operNo = preOperNo / step * step + step;
        }
        return operNo;
    }

    private void handleException(Exception e) {
        MsgBox.showError((String)e.getMessage());
        SysUtil.abort();
    }

    private String getResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.mm.basedata.HelperResource", (String)key);
    }

    public void checkOperNoIsDuplication(int rowIndex, Integer oldValue) {
        int colIndex = this.table.getColumnIndex(this.colName);
        int newOperNo = (Integer)this.table.getCell(rowIndex, colIndex).getValue();
        if (newOperNo == 0) {
            this.table.getCell(rowIndex, colIndex).setValue((Object)oldValue);
            String msg = this.getResource("OPERATION_IS_ZERO");
            MsgBox.showInfo((String)msg);
            this.table.getEditManager().editCellAt(rowIndex, colIndex);
        }
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            int theOperNo;
            if (i == rowIndex || newOperNo != (theOperNo = ((Integer)this.table.getCell(i, colIndex).getValue()).intValue())) continue;
            this.table.getCell(rowIndex, colIndex).setValue((Object)oldValue);
            String msg = this.getResource("OPERATION_IS_DUPLICATION");
            msg = MessageFormat.format(msg, new Integer(i + 1));
            MsgBox.showInfo((String)msg);
            this.table.getEditManager().editCellAt(rowIndex, colIndex);
            SysUtil.abort();
        }
    }
}

