/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.common.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.util.StringUtils;

public class CodingRulerUIHelper {
    private String orgId;
    private EditUI editUI;
    private KDTextField txtNumber;
    private RuleStatus ruleStatus;
    private String numFiledName = "number";
    private ICodingRuleManager codingRuleManager;
    private boolean isEditable;

    public CodingRulerUIHelper(EditUI editUI, KDTextField txtNumber) {
        this.editUI = editUI;
        this.txtNumber = txtNumber;
    }

    public void setNumAfterOrgChg(String newOrgId) {
        if ("ADDNEW".equals(this.editUI.getOprtState())) {
            this.getTxtNumber().setText(null);
        }
        if (this.orgId == null && newOrgId != null || this.orgId != null && !this.orgId.equals(newOrgId)) {
            this.orgId = newOrgId;
            try {
                ICodingRuleManager codingRuleManager = this.getCodingRuleManager();
                IObjectValue ov = this.editUI.getDataObject();
                this.ruleStatus = this.getBindingProperty() != null && this.getBindingProperty().length() > 0 ? codingRuleManager.getRuleStatus(ov, this.orgId, this.getBindingProperty()) : codingRuleManager.getRuleStatus(ov, this.orgId);
            }
            catch (Exception e1) {
                this.editUI.handUIException((Throwable)e1);
            }
        }
        if (this.ruleStatus != null) {
            try {
                if (this.ruleStatus.isExist() && "ADDNEW".equals(this.editUI.getOprtState())) {
                    if (this.ruleStatus.isAddView()) {
                        String oldNum = this.getTxtNumber().getText();
                        String newNum = !StringUtils.isEmpty((String)oldNum) ? oldNum : this.getNewNumberByUnit(this.orgId);
                        this.getTxtNumber().setText(newNum);
                        this.setBillNumber(newNum);
                    } else {
                        this.setBillNumber(null);
                    }
                }
                this.setNumEditableWhenUnitChange(this.orgId);
            }
            catch (Exception e) {
                this.editUI.handUIException((Throwable)e);
            }
        } else {
            this.setBillNumber(null);
        }
    }

    public void setNumBeforeSaved(String orgId) {
        if (this.ruleStatus != null && this.ruleStatus.isExist() && "ADDNEW".equals(this.editUI.getOprtState())) {
            try {
                if (!this.ruleStatus.isAddView()) {
                    try {
                        String number = this.getNewNumberByUnit(orgId);
                        this.getTxtNumber().setText(number);
                    }
                    catch (EASBizException e) {
                        this.editUI.handUIException((Throwable)e);
                    }
                    catch (BOSException e) {
                        this.editUI.handUIException((Throwable)e);
                    }
                }
            }
            catch (CodingRuleException e) {
                this.editUI.handUIException((Throwable)e);
            }
        }
    }

    private void setNumEditableWhenUnitChange(String orgId) {
        try {
            if (this.ruleStatus.isExist()) {
                if (this.ruleStatus.isModifiable()) {
                    if ("VIEW".equals(this.editUI.getOprtState()) || "FINDVIEW".equals(this.editUI.getOprtState())) {
                        this.getTxtNumber().setEditable(false);
                        this.getTxtNumber().setAccessAuthority(1);
                        this.isEditable = false;
                    } else {
                        this.getTxtNumber().setEditable(true);
                        this.getTxtNumber().setAccessAuthority(0);
                        this.getTxtNumber().setEnabled(true);
                        this.isEditable = true;
                        this.getTxtNumber().requestFocus();
                    }
                } else {
                    this.getTxtNumber().setEditable(false);
                    this.getTxtNumber().setAccessAuthority(1);
                    this.isEditable = false;
                }
            } else if ("VIEW".equals(this.editUI.getOprtState()) || "FINDVIEW".equals(this.editUI.getOprtState())) {
                this.getTxtNumber().setEditable(false);
                this.getTxtNumber().setAccessAuthority(1);
                this.isEditable = false;
            } else {
                this.getTxtNumber().setEditable(true);
                this.getTxtNumber().setAccessAuthority(0);
                this.getTxtNumber().setEnabled(true);
                this.isEditable = true;
                this.getTxtNumber().requestFocus();
            }
        }
        catch (Exception e) {
            this.editUI.handUIException((Throwable)e);
        }
    }

    private String getNewNumberByUnit(String bizOrgUnitID) throws EASBizException, BOSException {
        ICodingRuleManager codingRuleManager = this.getCodingRuleManager();
        if (this.editUI.getDataObject().get("CU") == null) {
            this.editUI.getDataObject().put("CU", (Object)this.editUI.getMainOrgInfo().getCU());
        }
        if (this.getBindingProperty() != null && this.getBindingProperty().trim().length() > 0) {
            return codingRuleManager.getNumber(this.editUI.getDataObject(), bizOrgUnitID, this.getBindingProperty());
        }
        return codingRuleManager.getNumber(this.editUI.getDataObject(), bizOrgUnitID);
    }

    private String getBindingProperty() {
        return null;
    }

    private ICodingRuleManager getCodingRuleManager() throws BOSException {
        if (this.codingRuleManager == null) {
            this.codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        }
        return this.codingRuleManager;
    }

    private void setBillNumber(String newNum) {
        this.editUI.getDataObject().setString(this.numFiledName, newNum);
        IObjectValue ov = this.editUI.getDataObject();
        this.editUI.setDataObject(ov);
        this.getTxtNumber().setText(newNum);
    }

    private String getBillNumber() {
        return this.editUI.getDataObject().getString(this.numFiledName);
    }

    public EditUI getEditUI() {
        return this.editUI;
    }

    public void setEditUI(EditUI editUI) {
        this.editUI = editUI;
    }

    public KDTextField getTxtNumber() {
        return this.txtNumber;
    }

    public void setTxtNumber(KDTextField txtNumber) {
        this.txtNumber = txtNumber;
    }

    public String getNumFiledName() {
        return this.numFiledName;
    }

    public void setNumFiledName(String numFiledName) {
        this.numFiledName = numFiledName;
    }

    public boolean isEditable() {
        return this.isEditable;
    }
}

