/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.common.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.mm.common.client.IgetOrgs;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.util.HashSet;

public class CooperateF7SelectorAdaptor
implements SelectorListener {
    private IgetOrgs org;
    private KDBizPromptBox bizPromptBox;

    public CooperateF7SelectorAdaptor(IgetOrgs orgs, KDBizPromptBox bizPromptBox) {
        this.org = orgs;
        this.bizPromptBox = bizPromptBox;
    }

    public void willShow(SelectorEvent e) {
        boolean isHasPorperty = false;
        EntityViewInfo view = this.bizPromptBox.getEntityViewInfo();
        if (view == null) {
            view = new EntityViewInfo();
        }
        FilterInfo newInfo = this.getCooperateOrgFilterInfo();
        if (view != null && view.getFilter() != null) {
            if (view.getFilter().getFilterItems().size() > 0) {
                FilterItemInfo itemInfo = null;
                for (int i = 0; i < view.getFilter().getFilterItems().size(); ++i) {
                    itemInfo = view.getFilter().getFilterItems().get(i);
                    if (newInfo == null || itemInfo.getPropertyName().toLowerCase().indexOf(this.org.getBizOrgPropertyName().toLowerCase()) < 0) continue;
                    view.getFilter().getFilterItems().set(i, newInfo.getFilterItems().get(0));
                    isHasPorperty = true;
                }
            }
            if (view.getFilter() != null && view.getFilter().getFilterItems().size() >= 0) {
                if (view != null && view.getFilter() != null && newInfo != null && !isHasPorperty) {
                    try {
                        view.getFilter().mergeFilter(newInfo, "and");
                    }
                    catch (BOSException e1) {
                        ExceptionHandler.handle((Throwable)e1);
                    }
                }
            } else if (newInfo != null && isHasPorperty) {
                view.setFilter(newInfo);
            }
        } else {
            view.setFilter(newInfo);
        }
        this.bizPromptBox.setEntityViewInfo(view);
        this.bizPromptBox.getQueryAgent().resetRuntimeEntityView();
    }

    private FilterInfo getCooperateOrgFilterInfo() {
        FilterInfo bizFilterInfo = new FilterInfo();
        HashSet<String> set = new HashSet<String>();
        OrgUnitCollection collection = this.org.getOrgs();
        if (collection == null) {
            return null;
        }
        OrgUnitInfo orgUnitInfo = null;
        for (int i = 0; i < collection.size(); ++i) {
            orgUnitInfo = collection.get(i);
            set.add(orgUnitInfo.getId().toString());
        }
        String bizOrgName = this.org.getBizOrgPropertyName();
        if (bizOrgName == null || bizOrgName.trim().equalsIgnoreCase("")) {
            return null;
        }
        bizFilterInfo.getFilterItems().add(new FilterItemInfo(bizOrgName, set, CompareType.INCLUDE));
        return bizFilterInfo;
    }
}

