/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.common.client;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mm.common.client.ITableMultiSelect;
import com.kingdee.eas.mm.common.client.MMUtils;
import java.util.ArrayList;

public class F7MultiSelectHelper {
    private ITableMultiSelect multiSelect = null;
    private KDTable table = null;
    private DataChangeListener dcListener = null;
    private boolean isSupportRepeatData = false;
    private int activeRowIndex = -1;
    private String activeColumnName = null;
    private Object[] insertObjs = null;
    private int insertNum = -1;

    public F7MultiSelectHelper(ITableMultiSelect multiSelect, KDTable table) {
        this.multiSelect = multiSelect;
        this.table = table;
    }

    public KDBizPromptBox registerF7ToColumn(String columnName, String queryInfo) {
        final KDBizPromptBox bizBox = new KDBizPromptBox();
        bizBox.setQueryInfo(queryInfo);
        IColumn column = this.table.getColumn(columnName);
        if (this.dcListener == null) {
            this.dcListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    bizBox.removeDataChangeListener(F7MultiSelectHelper.this.dcListener);
                    F7MultiSelectHelper.this.dataChangedF7(e);
                    bizBox.addDataChangeListener(F7MultiSelectHelper.this.dcListener);
                }
            };
        }
        bizBox.addDataChangeListener(this.dcListener);
        column.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizBox));
        return bizBox;
    }

    private void dataChangedF7(DataChangeEvent e) {
        KDTSelectManager manager = this.table.getSelectManager();
        this.activeRowIndex = manager.getActiveRowIndex();
        int columnIndex = manager.getActiveColumnIndex();
        if (this.activeRowIndex < 0 || columnIndex < 0) {
            return;
        }
        this.activeColumnName = this.table.getColumnKey(columnIndex);
        KDBizPromptBox bizBox = (KDBizPromptBox)e.getSource();
        Object f7ValueObj = bizBox.getValue();
        if (MMUtils.isNull(f7ValueObj)) {
            IRow optRow = this.table.getRow(this.activeRowIndex);
            optRow.getCell(this.activeColumnName).setValue(null);
            bizBox.setValue(null);
            this.insertObjs = null;
            this.insertNum = -1;
            this.multiSelect.afterInsertOperation(null, this.activeRowIndex);
        } else {
            this.insertDataToTable(f7ValueObj);
        }
        this.multiSelect.afterInsertOperation();
    }

    private void insertDataToTable(Object f7ValueObj) {
        IRow optRow = this.table.getRow(this.activeRowIndex);
        ICell optCell = optRow.getCell(this.activeColumnName);
        Object oldValue = optCell.getValue();
        boolean isSame = MMUtils.isEqualCoreBaseInfo(f7ValueObj, oldValue);
        if (isSame) {
            return;
        }
        Object[] f7ValuesArray = null;
        f7ValuesArray = f7ValueObj instanceof Object[] ? (Object[])f7ValueObj : new Object[]{f7ValueObj};
        f7ValuesArray = this.filterData(f7ValuesArray);
        this.insertObjs = f7ValuesArray;
        this.insertNum = this.getInsertNum();
        ICell cell = null;
        int optRowIndex = this.activeRowIndex;
        for (int i = 0; i < this.insertNum; ++i) {
            f7ValueObj = f7ValuesArray[i];
            if (i > 0) {
                optRow = this.table.addRow(++optRowIndex);
            }
            cell = optRow.getCell(this.activeColumnName);
            cell.setValue(null);
            cell.setValue(f7ValueObj);
            this.multiSelect.afterInsertOperation((IObjectValue)f7ValueObj, optRowIndex);
        }
    }

    private Object[] filterData(Object[] valuesArray) {
        if (this.isSupportRepeatData) {
            return valuesArray;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < valuesArray.length; ++i) {
            list.add(valuesArray[i]);
        }
        int rowNum = this.table.getRowCount();
        ICell cell = null;
        Object obj = null;
        CoreBaseInfo baseInfo = null;
        String id = null;
        block1: for (int j = 0; j < rowNum; ++j) {
            if (j == this.activeRowIndex || (obj = (cell = this.table.getCell(j, this.activeColumnName)).getValue()) == null || !(obj instanceof CoreBaseInfo) || (baseInfo = (CoreBaseInfo)obj).getId() == null || StringUtil.isEmptyString((String)baseInfo.getId().toString())) continue;
            id = baseInfo.getId().toString();
            for (int k = 0; k < list.size(); ++k) {
                if (list.get(k) == null || !(list.get(k) instanceof CoreBaseInfo) || (baseInfo = (CoreBaseInfo)list.get(k)).getId() == null || StringUtil.isEmptyString((String)baseInfo.getId().toString()) || !id.equals(baseInfo.getId().toString())) continue;
                list.remove(k);
                continue block1;
            }
        }
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.toArray();
    }

    public boolean isSupportRepeatData() {
        return this.isSupportRepeatData;
    }

    public void setSupportRepeatData(boolean isSupportRepeatData) {
        this.isSupportRepeatData = isSupportRepeatData;
    }

    public int getActiveRowIndex() {
        return this.activeRowIndex;
    }

    public String getActiveColumnName() {
        return this.activeColumnName;
    }

    public int getInsertNum() {
        int defaultNum = 0;
        if (this.insertObjs == null) {
            return defaultNum;
        }
        return this.insertObjs.length;
    }

    public Object[] getInsertObjs() {
        return this.insertObjs;
    }

    public DataChangeListener getDataChangeListener() {
        return this.dcListener;
    }

    public void setDataChangeListener(DataChangeListener dcListener) {
        this.dcListener = dcListener;
    }
}

