/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.common.client;

import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.LicenseUserInfo;
import com.kingdee.eas.base.license.client.LicenseController;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.report.LicensePermissionUtils;
import com.kingdee.eas.base.uiframe.client.LicenseHelper;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.FrameWorkClientUtils;
import com.kingdee.eas.framework.client.service.LicenseService;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;

public final class MMSpecialLicenseAdapter {
    protected String fullName = null;
    protected String functionName = null;

    public MMSpecialLicenseAdapter(String fullName, String functionName) {
        this.fullName = fullName;
        this.functionName = functionName;
    }

    public void checkLicence() throws Exception {
        LicensePermissionUtils.checkLicence((String)this.fullName, (String)this.functionName);
    }

    public void releaseLicense() {
        LicensePermissionUtils.releaseLicense((String)this.fullName);
    }

    public void requestLicenseOrReleaseLicense(boolean flag, IUIObject ui, String uiName) throws Exception {
        if (this.functionName != null && this.functionName.trim().length() > 0) {
            if (flag) {
                ui.getUIContext().put("checkLicense", "false");
                LicenseUserInfo user = (LicenseUserInfo)SysContext.getSysContext().getProperty((Object)"License.UserInfo");
                LicenseController lc = FrameWorkClientUtils.getLicenseController();
                int licenselcFlag = LicenseSrvAgentFactory.getRemoteInstance().reqeustLicenseByModuleAndUIName(LicenseHelper.createLicenseUserInfo(), this.functionName, this.fullName);
                switch (licenselcFlag) {
                    case 4: {
                        MsgBox.showDetailAndOK((Component)((CoreUI)ui), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_License_Invalid"), (String)this.constructMessage(lc, this.fullName, uiName), (int)0);
                        SysUtil.abort();
                        break;
                    }
                    case 2: {
                        MsgBox.showDetailAndOK((Component)((CoreUI)ui), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_License_NO_SURPLUS"), (String)this.constructMessage(lc, this.fullName, uiName), (int)0);
                        SysUtil.abort();
                    }
                }
            } else {
                String sessionId = SysContext.getSysContext().getSessionID();
                LicenseController.getInstance().releaseLicenseBySessionIDAndSubSystem(sessionId, this.functionName);
            }
        }
    }

    private String constructMessage(LicenseController lc, String className, String uiName) throws LicenseException {
        if (lc == null || className == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_ClassName"));
        buffer.append(uiName + "[" + className + "]");
        buffer.append("\n");
        buffer.append(LicenseService.constructLicenseMessage((LicenseController)lc, (String)className));
        return buffer.toString();
    }
}

