/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.common.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.FilterInfoProducerFactory;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.extendcontrols.ext.OrgUnitDelegationFilterInfoProducer;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationEntryCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.btp.client.BTPBillEditImpl;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.DelegationPartsEnum;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.client.CoreBillEditUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.mm.common.MMBaseException;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.client.helper.FormattedEditorFactory;
import com.kingdee.eas.scm.common.service.SCMServiceFactory;
import com.kingdee.eas.scm.common.util.SortUtil;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryCollection;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryFactory;
import com.kingdee.eas.scm.util.numeric.NumericUtil;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Component;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.swing.Action;
import javax.swing.Icon;

public class MMUtils {
    public static final String PLANNINGHORIZONSETQUERY = "com.kingdee.eas.mm.basedata.app.F7PlanningHorizonSetQuery";
    public static final String ICON_RESFILENAME = "com.kingdee.eas.basedata.common.EASImageResource";
    public static final String MM_RESOURCE_PATH = "com.kingdee.eas.mm.common.MMResource";
    public static final int PRECISION_DEFAUL = 2;
    public static final int PRECISION_DEFAUL_DB = 10;
    public static final BigDecimal BIGDECIMAL_ONE;
    public static final BigDecimal EXCHANGERATE_DEFAULT;
    public static final int DEFAULT_MAX_PRICISION = 8;

    public static OrgUnitInfo getDefaultMainBizOrg(OrgType orgType, String strStatus) {
        OrgUnitInfo[] mainOrgs = null;
        try {
            mainOrgs = SCMServiceFactory.getPermissionService().getAuthorizedBizOrgUnits((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), orgType, strStatus);
            if (mainOrgs == null || mainOrgs.length == 0) {
                return null;
            }
            if (mainOrgs.length > 0) {
                mainOrgs = (OrgUnitInfo[])SortUtil.sortDataByNumber((DataBaseInfo[])mainOrgs, (boolean)true);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        OrgUnitInfo currentMainOrg = SysContext.getSysContext().getCurrentOrgUnit(orgType);
        if (mainOrgs == null) {
            return currentMainOrg;
        }
        if (currentMainOrg != null && mainOrgs.length > 0) {
            for (int i = 0; i < mainOrgs.length; ++i) {
                if (!currentMainOrg.getId().toString().equals(mainOrgs[i].getId().toString())) continue;
                return currentMainOrg;
            }
        }
        if (mainOrgs.length > 0) {
            return mainOrgs[0];
        }
        return null;
    }

    public static void initWorkshopF7(KDBizPromptBox workshopBox, StorageOrgUnitInfo storageOrgInfo) throws Exception {
        workshopBox.setQueryInfo("com.kingdee.eas.basedata.org.app.AdminOrgUnitQuery");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isAdminOrgUnit", (Object)"1", CompareType.EQUALS));
        viewInfo.setFilter(filter);
        workshopBox.setEntityViewInfo(viewInfo);
        workshopBox.setQueryInfo("com.kingdee.eas.basedata.org.app.AdminOrgUnitQuery");
        IFilterInfoProducer iProducer = FilterInfoProducerFactory.getOrgUnitDelegationFilterInfoProducer((DelegationPartsEnum)DelegationPartsEnum.THE_TO_UNIT, (OrgType)OrgType.Admin);
        OrgUnitDelegationFilterInfoProducer producer = (OrgUnitDelegationFilterInfoProducer)iProducer;
        producer.getModel().setDoNotUseUserOrgRangeAsFilter();
        workshopBox.setFilterInfoProducer((IFilterInfoProducer)producer);
        workshopBox.setCurrentMainBizOrgUnit((OrgUnitInfo)storageOrgInfo, OrgType.Storage);
    }

    public static void showInformation(CoreUI ui, String msg, int showPolicy) {
        ui.setMessageText(msg);
        ui.setShowMessagePolicy(showPolicy);
        ui.showMessage();
    }

    public static int getQtyPrecision(String materialId, String measureUnitId) {
        int precision = 2;
        try {
            IMultiMeasureUnit imultiUnit = MultiMeasureUnitFactory.getRemoteInstance();
            MultiMeasureUnitInfo multiUnitInfo = imultiUnit.getMultiUnit(materialId, measureUnitId);
            if (multiUnitInfo != null) {
                precision = multiUnitInfo.getQtyPrecision();
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return precision;
    }

    public static CompanyOrgUnitInfo getCompanyOrgByStorageOrg(String storageOrgId) {
        if (storageOrgId == null) {
            return null;
        }
        CompanyOrgUnitInfo ret = null;
        try {
            IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getRemoteInstance();
            OrgUnitCollection orgCol = iUnitRel.getToUnit(storageOrgId, 4, 1);
            if (orgCol != null && orgCol.size() > 0) {
                ret = (CompanyOrgUnitInfo)orgCol.get(0);
            }
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (ret == null) {
            String msg = EASResource.getString((String)MM_RESOURCE_PATH, (String)"CompanyOrtUnit_Is_Null");
            MMBaseException baseException = new MMBaseException(MMBaseException.NULL, new Object[]{msg});
            ExceptionHandler.handle((Throwable)((Object)baseException));
        }
        return ret;
    }

    public static HashSet getCostCenterByCompanyOrg(String companyOrgId) {
        if (companyOrgId == null) {
            return null;
        }
        try {
            IOrgUnitRelation iOrgUnitRel = OrgUnitRelationFactory.getRemoteInstance();
            HashSet<String> set = new HashSet<String>();
            OrgUnitCollection orgIds = iOrgUnitRel.getFromUnit(companyOrgId, 1, 5);
            for (int i = 0; orgIds != null && i < orgIds.size(); ++i) {
                set.add(orgIds.get(i).getId().toString());
            }
            return set;
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return null;
    }

    public static HashSet getAdminOrgByStorageOrg(String storageOrgId) {
        if (storageOrgId == null) {
            return null;
        }
        try {
            IOrgUnitRelation iOrgUnitRel = OrgUnitRelationFactory.getRemoteInstance();
            HashSet<String> set = new HashSet<String>();
            OrgUnitCollection orgIds = iOrgUnitRel.getToUnit(storageOrgId, 4, 0);
            for (int i = 0; orgIds != null && i < orgIds.size(); ++i) {
                set.add(orgIds.get(i).getId().toString());
            }
            return set;
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return null;
    }

    public static HashSet getQualityOrgByStorageOrg(String storageOrgId) {
        if (storageOrgId == null) {
            return null;
        }
        try {
            IOrgUnitRelation iOrgUnitRel = OrgUnitRelationFactory.getRemoteInstance();
            HashSet<String> set = new HashSet<String>();
            OrgUnitCollection orgIds = iOrgUnitRel.getToUnit(storageOrgId, 4, 32);
            for (int i = 0; orgIds != null && i < orgIds.size(); ++i) {
                set.add(orgIds.get(i).getId().toString());
            }
            return set;
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return null;
    }

    public static void initCostCenterF7(HashMap costCenter, String storageOrgId, KDBizPromptBox costCenterF7) {
        if (storageOrgId == null) {
            return;
        }
        HashSet set = new HashSet();
        if (costCenter.containsKey(storageOrgId)) {
            set = (HashSet)costCenter.get(storageOrgId);
        } else {
            CompanyOrgUnitInfo companyOrgInfo = MMUtils.getCompanyOrgByStorageOrg(storageOrgId);
            if (companyOrgInfo != null) {
                set = MMUtils.getCostCenterByCompanyOrg(companyOrgInfo.getId().toString());
            }
            costCenter.put(storageOrgId, set);
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (set.size() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
            filterInfo.getFilterItems().add(new FilterItemInfo("isSealUp", (Object)"false", CompareType.EQUALS));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", null, CompareType.EQUALS));
        }
        viewInfo.setFilter(filterInfo);
        costCenterF7.setEntityViewInfo(viewInfo);
    }

    public static void getSourceBill(KDTable tblMain, SCMBillBaseInfo editData, String billEntryName, String entryIDCol, String destBillType, CoreBillEditUI billEditUI) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        int start = 0;
        int end = 0;
        int size = tblMain.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            KDTSelectBlock sb = tblMain.getSelectManager().get(i);
            if (sb == null || sb.getMode() != 2) continue;
            start = sb.getTop();
            end = sb.getBottom();
            for (int j = start; j < end; ++j) {
                String entryID = tblMain.getRow(j).getCell(entryIDCol).toString();
                list.add(entryID);
            }
        }
        IObjectCollection collection = (IObjectCollection)editData.get(billEntryName);
        for (int i = 0; i < list.size(); ++i) {
            boolean flag = false;
            String id = list.get(i).toString();
            CoreBaseInfo entryInfo = (CoreBaseInfo)collection.getObject(i);
            for (int k = 0; k < collection.size(); ++k) {
                if (!id.equalsIgnoreCase(entryInfo.getId().toString())) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            collection.removeObject((IObjectValue)entryInfo);
        }
        BTPBillEditImpl billEdit = new BTPBillEditImpl(billEditUI);
        billEdit.init();
        billEdit.CreateTo((CoreBillBaseInfo)editData, destBillType);
    }

    public static String getNumberValue(KDBizPromptBox bizPromptBox) {
        String sNumber = null;
        Object data = bizPromptBox.getData();
        if (data == null) {
            return null;
        }
        if (data instanceof IObjectValue[] && ((IObjectValue[])data).length > 0) {
            data = ((IObjectValue[])data)[0];
        }
        if (data instanceof IObjectValue) {
            sNumber = (String)((IObjectValue)data).get("number");
        } else if (data instanceof String) {
            sNumber = (String)data;
        }
        return sNumber;
    }

    public static String getIDValue(KDBizPromptBox bizPromptBox) {
        String sNumber = null;
        Object data = bizPromptBox.getData();
        if (data == null) {
            return null;
        }
        if (data instanceof IObjectValue[] && ((IObjectValue[])data).length > 0) {
            data = ((IObjectValue[])data)[0];
        }
        if (data instanceof IObjectValue) {
            sNumber = ((IObjectValue)data).get("id").toString();
        } else if (data instanceof String) {
            sNumber = (String)data;
        }
        return sNumber;
    }

    public static PurchaseOrgUnitInfo getCompanyInfo(String storageOrgId) throws EASBizException, BOSException {
        if (storageOrgId == null) {
            return null;
        }
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getRemoteInstance();
        PurchaseOrgUnitInfo ret = (PurchaseOrgUnitInfo)iUnitRel.getDefaultToUnit(storageOrgId, 4, 3);
        if (ret == null) {
            OrgUnitCollection orgCol = iUnitRel.getToUnit(storageOrgId, 4, 3);
            ret = (PurchaseOrgUnitInfo)orgCol.get(0);
        }
        return ret;
    }

    public static ArrayList getSelectedKeyValues(KDTable tblMain, String fieldName) {
        ArrayList<String> list = new ArrayList<String>();
        int start = 0;
        int end = 0;
        int size = tblMain.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            KDTSelectBlock sb = tblMain.getSelectManager().get(i);
            start = sb.getTop();
            end = sb.getBottom();
            for (int j = start; j <= end; ++j) {
                String fieldValue = tblMain.getRow(j).getCell(fieldName).getValue().toString();
                list.add(fieldValue);
            }
        }
        if (list.size() <= 0) {
            return null;
        }
        return list;
    }

    public static BigDecimal getExchangeQtyForClient(String materialID, MeasureUnitInfo unitInfo, MeasureUnitInfo otherUnitInfo, BigDecimal qty) throws BOSException, EASBizException {
        if (materialID == null) {
            throw new IllegalArgumentException();
        }
        BigDecimal targetQty = qty;
        IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getRemoteInstance();
        MultiMeasureUnitInfo multiUnifInfo = multiUnit.getMultiUnit(materialID, unitInfo.getId().toString());
        MultiMeasureUnitInfo othermultiUnifInfo = multiUnit.getMultiUnit(materialID, otherUnitInfo.getId().toString());
        if (multiUnifInfo != null && othermultiUnifInfo != null) {
            BigDecimal baseExchangeRate1 = multiUnifInfo.getBaseConvsRate();
            BigDecimal baseExchangeRate2 = othermultiUnifInfo.getBaseConvsRate();
            if (baseExchangeRate1 == null) {
                baseExchangeRate1 = new BigDecimal("1.00");
            }
            if (baseExchangeRate2 == null) {
                baseExchangeRate2 = new BigDecimal("1.00");
            }
            int scale = 10;
            BigDecimal baseQty = MMUtils.effectualNumeric(qty).multiply(baseExchangeRate1).setScale(scale, 4);
            targetQty = MMUtils.effectualNumeric(baseQty).divide(MMUtils.effectualExchangeRate(baseExchangeRate2), scale, 4);
        }
        return targetQty;
    }

    public static BigDecimal getExchangeQtyForClient(MultiMeasureUnitInfo multiUnifInfo, MultiMeasureUnitInfo othermultiUnifInfo, BigDecimal qty) {
        BigDecimal targetQty = qty;
        if (multiUnifInfo != null && othermultiUnifInfo != null) {
            BigDecimal baseExchangeRate1 = multiUnifInfo.getBaseConvsRate();
            BigDecimal baseExchangeRate2 = othermultiUnifInfo.getBaseConvsRate();
            if (baseExchangeRate1 == null) {
                baseExchangeRate1 = BIGDECIMAL_ONE;
            }
            if (baseExchangeRate2 == null) {
                baseExchangeRate2 = BIGDECIMAL_ONE;
            }
            BigDecimal baseQty = NumericUtil.multiplyBigDecimal((BigDecimal)qty, (BigDecimal)baseExchangeRate1, (int)16);
            targetQty = NumericUtil.divideBigDecimal((BigDecimal)baseQty, (BigDecimal)baseExchangeRate2, (int)(baseQty.scale() + qty.scale()));
        }
        return targetQty;
    }

    public static BigDecimal effectualNumeric(BigDecimal v) {
        return MMUtils.equalsZero(v) ? SysConstant.BIGZERO : v;
    }

    public static boolean equalsZero(BigDecimal v) {
        return v == null || SysConstant.BIGZERO.compareTo(v) == 0;
    }

    public static BigDecimal effectualExchangeRate(BigDecimal exchangeRate) {
        return MMUtils.isDistrustExchangeRate(exchangeRate) ? exchangeRate : EXCHANGERATE_DEFAULT;
    }

    public static boolean isDistrustExchangeRate(BigDecimal exchangeRate) {
        return exchangeRate != null && exchangeRate.compareTo(SysConstant.BIGZERO) != 0 && exchangeRate.compareTo(SysConstant.BIGZERO) != -1;
    }

    public static void setDownKeyStatus(KDTable table, CoreUIObject uiObj, Action actionAfterAddRow) {
        if (uiObj.getOprtState().equals(OprtState.VIEW)) {
            KDTableHelper.downArrowAutoAddRow((KDTable)table, (boolean)false, (Action)actionAfterAddRow);
        } else if (!uiObj.getOprtState().equals(OprtState.EXITING)) {
            KDTableHelper.downArrowAutoAddRow((KDTable)table, (boolean)true, (Action)actionAfterAddRow);
        }
    }

    public static boolean isNull(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof Object[]) {
            Object[] objs = (Object[])obj;
            if (objs == null || objs.length == 0) {
                return true;
            }
            boolean hasObj = false;
            for (int i = 0; i < objs.length; ++i) {
                if (objs[i] == null) continue;
                hasObj = true;
                break;
            }
            return !hasObj;
        }
        return false;
    }

    public static boolean isNotNull(Object obj) {
        return !MMUtils.isNull(obj);
    }

    public static boolean isEqualCoreBaseInfo(Object fObj, Object sObj) {
        if (MMUtils.isNull(fObj) && MMUtils.isNull(sObj)) {
            return true;
        }
        if (fObj instanceof CoreBaseInfo && sObj instanceof CoreBaseInfo) {
            CoreBaseInfo fCbi = (CoreBaseInfo)fObj;
            CoreBaseInfo sCbi = (CoreBaseInfo)sObj;
            if (MMUtils.isNull(fCbi) && MMUtils.isNull(sCbi)) {
                return true;
            }
            if (fCbi != null && sCbi != null) {
                if (fCbi.getId() == null && sCbi.getId() == null) {
                    return true;
                }
                if (fCbi.getId() != null && sCbi.getId() != null && fCbi.getId().toString().equals(sCbi.getId().toString())) {
                    return true;
                }
            }
        } else if (fObj instanceof CoreBaseInfo[] && sObj instanceof CoreBaseInfo[]) {
            CoreBaseInfo[] fCbis = (CoreBaseInfo[])fObj;
            CoreBaseInfo[] sCbis = (CoreBaseInfo[])sObj;
            if (fCbis.length != sCbis.length) {
                return false;
            }
            int num = 0;
            for (int i = 0; i < fCbis.length; ++i) {
                if (fCbis[i].getId().toString().equals(sCbis[i].getId().toString())) {
                    ++num;
                    continue;
                }
                return false;
            }
            if (num == fCbis.length) {
                return true;
            }
        }
        return false;
    }

    public static boolean isNotEqualCoreBaseInfo(Object fObj, Object sObj) {
        return !MMUtils.isEqualCoreBaseInfo(fObj, sObj);
    }

    public static Icon getNewIcon(String iconName) {
        Locale locale = SysContext.getSysContext().getLocale();
        return EASCommonResource.getIcon((String)ICON_RESFILENAME, (String)iconName, (Locale)locale);
    }

    public static boolean[] isHasFollowBill(String srcEntityid, String srcObjectID, String[] srcEntryID) throws BOSException, EASBizException {
        return MMUtils.isHasFollowBill(srcEntityid, srcObjectID, srcEntryID, null);
    }

    public static boolean[] isHasFollowBill(String srcEntityid, String srcObjectID, String[] srcEntryID, Set destEntityID) throws BOSException, EASBizException {
        int count = srcEntryID.length;
        boolean[] b = new boolean[count];
        HashMap<String, String> map = new HashMap<String, String>();
        HashSet<String> destObjectIds = new HashSet<String>();
        HashSet<String> hasActIssueEntryIDSet = new HashSet<String>();
        if (count > 0) {
            int i;
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("srcEntityID", (Object)srcEntityid));
            filter.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)srcObjectID));
            if (destEntityID != null && destEntityID.size() > 0) {
                filter.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)destEntityID, CompareType.INCLUDE));
            }
            view.setFilter(filter);
            BOTRelationCollection relationCollection = BOTRelationFactory.getRemoteInstance().getCollection(view);
            int relationSize = relationCollection.size();
            for (i = 0; i < relationSize; ++i) {
                BOTRelationEntryCollection entryCollection = relationCollection.get(i).getRelationEntries();
                int entrySize = entryCollection.size();
                for (int j = 0; j < entrySize; ++j) {
                    map.put(entryCollection.get(j).getSrcEntryID(), entryCollection.get(j).getSrcEntryID());
                }
                if (!"500AB75E".equals(relationCollection.get(i).getDestEntityID()) || entryCollection != null && entryCollection.size() > 0) continue;
                destObjectIds.add(relationCollection.get(i).getDestObjectID());
            }
            if (destObjectIds != null && destObjectIds.size() > 0) {
                HashSet<String> srcEntryIDSet = new HashSet<String>();
                for (int k = 0; k < count; ++k) {
                    srcEntryIDSet.add(srcEntryID[k]);
                }
                EntityViewInfo mrbeView = new EntityViewInfo();
                FilterInfo mrbeFilter = new FilterInfo();
                mrbeFilter.getFilterItems().add(new FilterItemInfo("parent", destObjectIds, CompareType.INCLUDE));
                mrbeFilter.getFilterItems().add(new FilterItemInfo("coreBillEntryID", srcEntryIDSet, CompareType.INCLUDE));
                mrbeView.setFilter(mrbeFilter);
                SelectorItemCollection mrbeSelector = new SelectorItemCollection();
                mrbeSelector.add(new SelectorItemInfo("id"));
                mrbeSelector.add(new SelectorItemInfo("parent.id"));
                mrbeSelector.add(new SelectorItemInfo("coreBillEntryID"));
                mrbeView.setSelector(mrbeSelector);
                MaterialReqBillEntryCollection mrbeCollection = MaterialReqBillEntryFactory.getRemoteInstance().getMaterialReqBillEntryCollection(mrbeView);
                int size = 0;
                if (mrbeCollection != null && mrbeCollection.size() > 0) {
                    size = mrbeCollection.size();
                }
                for (int m = 0; m < size; ++m) {
                    hasActIssueEntryIDSet.add(mrbeCollection.get(m).getCoreBillEntryID());
                }
            }
            for (i = 0; i < count; ++i) {
                b[i] = map.containsKey(srcEntryID[i]) ? true : hasActIssueEntryIDSet.contains(srcEntryID[i]);
            }
        }
        return b;
    }

    public static CurrencyInfo getBaseCurrencyByCompanyOrg(String storageOrgId) {
        CompanyOrgUnitInfo orgUnit = MMUtils.getCompanyOrgByStorageOrg(storageOrgId);
        CurrencyInfo baseCurrInfo = null;
        try {
            ICurrency icurrency = CurrencyFactory.getRemoteInstance();
            if (orgUnit != null && orgUnit.getBaseCurrency() != null) {
                ObjectUuidPK uuidPk = new ObjectUuidPK(orgUnit.getBaseCurrency().getId());
                baseCurrInfo = icurrency.getCurrencyInfo((IObjectPK)uuidPk);
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return baseCurrInfo;
    }

    public static void handleManualInputForF7(KDBizPromptBox[] promptBoxes) {
        if (promptBoxes == null || promptBoxes.length == 0) {
            return;
        }
        for (int i = 0; i < promptBoxes.length; ++i) {
            if (promptBoxes[i] == null) continue;
            KDBizPromptBox promptBox = promptBoxes[i];
            promptBox.setCommitParser(null);
        }
    }

    public static Timestamp[] getDefaultDateRange(Date d) {
        Calendar calendar = Calendar.getInstance();
        if (d != null) {
            calendar.setTime(d);
        }
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        calendar.set(14, 999);
        Timestamp currDate = new Timestamp(calendar.getTimeInMillis());
        calendar.add(2, -1);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        return new Timestamp[]{new Timestamp(calendar.getTimeInMillis()), currDate};
    }

    public static SaleOrgUnitInfo getSaleOrgUnitInfo(String storageOrgId) throws EASBizException, BOSException {
        if (storageOrgId == null) {
            return null;
        }
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getRemoteInstance();
        SaleOrgUnitInfo ret = (SaleOrgUnitInfo)iUnitRel.getDefaultToUnit(storageOrgId, 4, 2);
        if (ret == null) {
            OrgUnitCollection orgCol = iUnitRel.getToUnit(storageOrgId, 4, 2);
            ret = (SaleOrgUnitInfo)orgCol.get(0);
        }
        return ret;
    }

    public static boolean getParamBooleanValue(String orgUnitId, String paramNumber) throws BOSException, EASBizException {
        ObjectUuidPK orgPK;
        boolean rst = false;
        IParamControl iParamControl = ParamControlFactory.getRemoteInstance();
        String paramValue = iParamControl.getParamValue((IObjectPK)(orgPK = new ObjectUuidPK(orgUnitId)), paramNumber);
        if (StringUtil.isEmptyString((String)paramValue)) {
            return false;
        }
        Boolean paramBoolean = Boolean.valueOf(paramValue);
        rst = paramBoolean;
        return rst;
    }

    public static Set getPermissionStorageOrgUnitIdSet(String permissionItem) throws BOSException, EASBizException {
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        String userId = userInfo.getId().toString();
        Set orgSet = com.kingdee.eas.mm.common.util.MMUtils.getPermissionStorageOrgUnitIdSet(null, userId, permissionItem);
        return orgSet;
    }

    public static void changeTableColPrecisionByCol(int precision, KDTable table, String[] fieldNames, boolean isNegatived) {
        KDTDefaultCellEditor editor = FormattedEditorFactory.getBigDecimalCellEditor((int)precision, (boolean)isNegatived);
        IColumn aColumn = null;
        int num = fieldNames.length;
        for (int i = 0; i < num; ++i) {
            aColumn = table.getColumn(fieldNames[i]);
            if (aColumn == null) continue;
            aColumn.setEditor((ICellEditor)editor);
            aColumn.getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
        }
    }

    public static void changeTextFields(int precision, boolean isNegatived, boolean isRemoveingZero, boolean isSupportedEmpty, KDFormattedTextField[] fieldNames) {
        int num = fieldNames.length;
        for (int i = 0; i < num; ++i) {
            fieldNames[i].setPrecision(precision);
            fieldNames[i].setNegatived(isNegatived);
            fieldNames[i].setRemoveingZeroInDispaly(isRemoveingZero);
            fieldNames[i].setSupportedEmpty(isSupportedEmpty);
        }
    }

    public static void filterRangF7Helper(Component from, Component to) {
        KDBizPromptBox prmtFrom = null;
        KDBizPromptBox prmtTo = null;
        if (from instanceof KDBizPromptBox) {
            prmtFrom = (KDBizPromptBox)from;
            prmtTo = (KDBizPromptBox)to;
        }
        if (prmtFrom == null || prmtTo == null) {
            return;
        }
        prmtFrom.addDataChangeListener((DataChangeListener)new RangChangeListener(prmtFrom, prmtTo));
    }

    public static void resetF7CommitParser(KDBizPromptBox[] bizBoxs) {
        if (bizBoxs == null) {
            return;
        }
        for (int i = 0; i < bizBoxs.length; ++i) {
            bizBoxs[i].setCommitParser(null);
        }
    }

    public static void sortTable(KDTable kdtable) {
        KDTSortManager sm = new KDTSortManager(kdtable);
        sm.setSortAuto(true);
        for (int j = 0; j < kdtable.getColumnCount(); ++j) {
            kdtable.getColumn(j).setSortable(true);
        }
    }

    static {
        EXCHANGERATE_DEFAULT = BIGDECIMAL_ONE = new BigDecimal("1.0");
    }

    static class RangChangeListener
    implements DataChangeListener {
        KDBizPromptBox prmtFrom;
        KDBizPromptBox prmtTo;

        public RangChangeListener(KDBizPromptBox from, KDBizPromptBox to) {
            this.prmtFrom = from;
            this.prmtTo = to;
        }

        public void dataChanged(DataChangeEvent eventObj) {
            this.handleRangChanged(eventObj);
        }

        private void handleRangChanged(DataChangeEvent eventObj) {
            if (this.prmtTo.getValue() != null) {
                return;
            }
            Object newValue = eventObj.getNewValue();
            if (newValue != null) {
                this.prmtTo.setValue(newValue);
            }
        }
    }
}

