/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.common.client;

import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.core.util.PrecisionUtil;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.mm.common.client.MultiMeasureUnitHelperVO;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MultiMeasureUnitHelper {
    private EditUI owner;
    private KDTable table;
    private String material;
    private OrgType mainBizOrgType;
    List multiMeasureUnitHelperVOs;
    private String msg;
    private Map pair;
    private Map rePair;
    private Map qtyToBaseQty;
    public static final int UNIT_TYPE = 1;
    public static final int QTY_TYPE = 2;
    public static final int MATERIAL_TYPE = 3;
    public static final int UNDEFINITION_TYPE = 99;
    public static final String MULTIUNITF7_PATH = "com.kingdee.eas.basedata.master.material.app.F7MultiMeasureUnitQuery";
    private Map multiMeasureUnits = null;

    public MultiMeasureUnitHelper(EditUI ownerUi, OrgType mainBizOrgType, KDTable table, String material, List multiMeasureUnitHelperVOs) {
        this.owner = ownerUi;
        this.mainBizOrgType = mainBizOrgType;
        this.table = table;
        table.checkParsed();
        this.material = material;
        this.multiMeasureUnitHelperVOs = multiMeasureUnitHelperVOs;
        this.pair = new HashMap();
        this.rePair = new HashMap();
        this.qtyToBaseQty = new HashMap();
        for (MultiMeasureUnitHelperVO vo : multiMeasureUnitHelperVOs) {
            this.pair.put(vo.getUnit(), vo.getQty());
            this.pair.put(vo.getBaseUnit(), vo.getBaseQty());
            this.rePair.put(vo.getQty(), vo.getUnit());
            this.qtyToBaseQty.put(vo.getQty(), vo.getBaseQty());
            table.getColumn(vo.getBaseUnit()).getStyleAttributes().setLocked(true);
            table.getColumn(vo.getBaseQty()).getStyleAttributes().setLocked(true);
        }
        table.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
                if (OprtState.VIEW.equals(MultiMeasureUnitHelper.this.owner.getOprtState())) {
                    return;
                }
                MultiMeasureUnitHelper.this.widgetEditStarting(e);
            }

            public void editStopped(KDTEditEvent e) {
                if (OprtState.VIEW.equals(MultiMeasureUnitHelper.this.owner.getOprtState())) {
                    return;
                }
                MultiMeasureUnitHelper.this.widgetEditStopped(e);
            }
        });
    }

    protected void widgetEditStarting(KDTEditEvent e) {
        String unitColumnName;
        KDBizPromptBox bizMaterialBox;
        int colIndex = e.getColIndex();
        int rowIndex = e.getRowIndex();
        String columnName = this.table.getColumnKey(colIndex);
        int columnType = this.getColumnType(columnName);
        if (3 != columnType && null == (bizMaterialBox = (KDBizPromptBox)this.table.getColumn(this.material).getEditor().getComponent()).getValue()) {
            if (null == this.msg) {
                this.msg = EASResource.getString((String)"com.kingdee.eas.mm.common.COMMONAutoGenerateResource", (String)"15_MultiMeasureUnitHelper");
            }
            MsgBox.showInfo((Component)this.owner, (String)this.msg);
            bizMaterialBox.requestFocus();
            return;
        }
        if (2 == columnType && null != (unitColumnName = (String)this.rePair.get(columnName)) && null == this.table.getCell(rowIndex, unitColumnName).getValue()) {
            String fieldName = this.table.getColumn(unitColumnName).getFieldName();
            MessageFormat format = BOSLocaleUtil.getMessageFormat((String)"{0}{1}");
            String message = format.format(new Object[]{EASResource.getString((String)"com.kingdee.eas.mm.common.COMMONAutoGenerateResource", (String)"16_MultiMeasureUnitHelper"), fieldName});
            MsgBox.showInfo((Component)this.owner, (String)message);
            this.table.getCell(rowIndex, unitColumnName).getEditor().getComponent().requestFocus();
            return;
        }
    }

    protected void widgetEditStopped(KDTEditEvent e) {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        Object oldObj = e.getOldValue();
        Object newObj = e.getValue();
        String columnName = this.table.getColumnKey(colIndex);
        if (null != newObj && null != oldObj && (newObj instanceof BigDecimal ? 0 == ((BigDecimal)newObj).compareTo((BigDecimal)oldObj) : newObj instanceof CoreBaseInfo && ((CoreBaseInfo)newObj).getId().equals((Object)((CoreBaseInfo)oldObj).getId()))) {
            return;
        }
        int columnType = this.getColumnType(columnName);
        switch (columnType) {
            case 3: {
                this.materialChange((MaterialInfo)newObj, rowIndex);
                break;
            }
            case 1: {
                this.measureUnitChange((MeasureUnitInfo)newObj, rowIndex, columnName);
                break;
            }
            case 2: {
                this.quantityChange((BigDecimal)newObj, rowIndex, columnName);
                break;
            }
            case 99: {
                break;
            }
        }
    }

    protected int getColumnType(String fieldName) {
        if (fieldName.equalsIgnoreCase(this.material)) {
            return 3;
        }
        for (MultiMeasureUnitHelperVO vo : this.multiMeasureUnitHelperVOs) {
            if (fieldName.equalsIgnoreCase(vo.getUnit())) {
                return 1;
            }
            if (!fieldName.equalsIgnoreCase(vo.getQty())) continue;
            return 2;
        }
        return 99;
    }

    protected void setDefaultBaseUnit(MaterialInfo materialInfo, int row) {
        MultiMeasureUnitInfo baseMultiMeasureUnitInfo = this.getBaseMultiMeasureUnitInfo(materialInfo);
        if (null != baseMultiMeasureUnitInfo) {
            for (MultiMeasureUnitHelperVO vo : this.multiMeasureUnitHelperVOs) {
                this.table.getCell(row, vo.getBaseUnit()).setValue((Object)baseMultiMeasureUnitInfo.getMaterial());
            }
        }
    }

    protected void materialChange(MaterialInfo materialInfo, int rowIndex) {
        for (MultiMeasureUnitHelperVO vo : this.multiMeasureUnitHelperVOs) {
            this.table.getCell(rowIndex, vo.getUnit()).setValue(null);
            this.table.getCell(rowIndex, vo.getQty()).setValue(null);
            this.table.getCell(rowIndex, vo.getBaseUnit()).setValue(null);
            this.table.getCell(rowIndex, vo.getBaseQty()).setValue(null);
        }
        if (null == materialInfo) {
            return;
        }
        if (4 == this.mainBizOrgType.getValue()) {
            this.setDefaultBaseUnit(materialInfo, rowIndex);
            this.initMeasureUnitF7(materialInfo.getId().toString(), rowIndex);
        }
    }

    public void initMeasureUnitF7(String materialId, int rowIndex) {
        KDBizPromptBox prmtMeansureUnit = new KDBizPromptBox();
        prmtMeansureUnit.setQueryInfo(MULTIUNITF7_PATH);
        prmtMeansureUnit.setEditFormat("$number$");
        prmtMeansureUnit.setDisplayFormat("$name$");
        prmtMeansureUnit.setCommitFormat("$number$");
        prmtMeansureUnit.setEditable(true);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialId));
        viewInfo.setFilter(filterInfo);
        prmtMeansureUnit.setEntityViewInfo(viewInfo);
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$name$"));
        for (MultiMeasureUnitHelperVO vo : this.multiMeasureUnitHelperVOs) {
            this.table.getColumn(vo.getUnit()).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtMeansureUnit));
            this.table.getColumn(vo.getUnit()).setRenderer((IBasicRender)avr);
            this.table.getCell(rowIndex, vo.getUnit()).getStyleAttributes().setLocked(false);
        }
    }

    private MultiMeasureUnitCollection getMultiMeasureUnits(MaterialInfo materialInfo) {
        MultiMeasureUnitCollection rs = null;
        String materialId = materialInfo.getId().toString();
        if (null == this.multiMeasureUnits) {
            this.multiMeasureUnits = new HashMap();
        }
        if (null == (rs = (MultiMeasureUnitCollection)this.multiMeasureUnits.get(materialId))) {
            try {
                rs = MultiMeasureUnitFactory.getRemoteInstance().getDataByMaterial(materialId);
            }
            catch (Exception e) {
                MessageFormat format = BOSLocaleUtil.getMessageFormat((String)"{0}{1},{2}{3}");
                String message = format.format(new Object[]{EASResource.getString((String)"com.kingdee.eas.mm.common.COMMONAutoGenerateResource", (String)"17_MultiMeasureUnitHelper"), materialInfo.getName(), materialInfo.getNumber(), EASResource.getString((String)"com.kingdee.eas.mm.common.COMMONAutoGenerateResource", (String)"18_MultiMeasureUnitHelper")});
                MsgBox.showError((Component)this.owner, (String)message);
            }
            if (rs != null) {
                this.multiMeasureUnits.put(materialId, rs);
            }
        }
        return rs;
    }

    private MultiMeasureUnitInfo getMultiMeasureUnitInfo(MaterialInfo materialInfo, MeasureUnitInfo measureUnitInfo) {
        MultiMeasureUnitInfo rs = null;
        MultiMeasureUnitCollection multiMeasureUnits = this.getMultiMeasureUnits(materialInfo);
        if (null != multiMeasureUnits) {
            for (MultiMeasureUnitInfo element : multiMeasureUnits) {
                if (null == element || null == element.getMaterial() || !element.getMaterial().getId().equals((Object)measureUnitInfo.getId())) continue;
                rs = element;
                break;
            }
        }
        return rs;
    }

    private MultiMeasureUnitInfo getBaseMultiMeasureUnitInfo(MaterialInfo materialInfo) {
        MultiMeasureUnitInfo rs = null;
        MultiMeasureUnitCollection multiMeasureUnits = this.getMultiMeasureUnits(materialInfo);
        if (null != multiMeasureUnits) {
            for (MultiMeasureUnitInfo element : multiMeasureUnits) {
                if (!element.isIsBasicUnit()) continue;
                rs = element;
                break;
            }
        }
        return rs;
    }

    protected void measureUnitChange(MeasureUnitInfo measureUnitInfo, int rowIndex, String columnName) {
        String qtyColumnName;
        ICell cell;
        if (null == measureUnitInfo) {
            for (MultiMeasureUnitHelperVO vo : this.multiMeasureUnitHelperVOs) {
                if (!columnName.equalsIgnoreCase(vo.getUnit())) continue;
                this.table.getCell(rowIndex, vo.getQty()).setValue(null);
                this.table.getCell(rowIndex, vo.getBaseQty()).setValue(null);
                return;
            }
        }
        if (null != (cell = this.table.getCell(rowIndex, qtyColumnName = (String)this.pair.get(columnName))).getValue()) {
            MaterialInfo materialInfo = (MaterialInfo)this.table.getCell(rowIndex, this.material).getValue();
            MultiMeasureUnitInfo multiMeasureUnitInfo = this.getMultiMeasureUnitInfo(materialInfo, measureUnitInfo);
            String format = PrecisionUtil.getFormatString((int)multiMeasureUnitInfo.getQtyPrecision());
            BigDecimal qty = (BigDecimal)cell.getValue();
            qty = qty.setScale(multiMeasureUnitInfo.getQtyPrecision(), 4);
            cell.getStyleAttributes().setNumberFormat(format);
            BigDecimal baseQty = qty.multiply(multiMeasureUnitInfo.getBaseConvsRate());
            ICell cell2 = this.table.getCell(rowIndex, (String)this.qtyToBaseQty.get(qtyColumnName));
            multiMeasureUnitInfo = this.getBaseMultiMeasureUnitInfo(materialInfo);
            baseQty = baseQty.setScale(multiMeasureUnitInfo.getQtyPrecision(), 4);
            cell2.setValue((Object)baseQty);
            format = PrecisionUtil.getFormatString((int)multiMeasureUnitInfo.getQtyPrecision());
            cell2.getStyleAttributes().setNumberFormat(format);
        }
    }

    protected void quantityChange(BigDecimal quantity, int rowIndex, String columnName) {
        if (null == quantity) {
            for (MultiMeasureUnitHelperVO vo : this.multiMeasureUnitHelperVOs) {
                if (!columnName.equalsIgnoreCase(vo.getQty())) continue;
                this.table.getCell(rowIndex, vo.getBaseQty()).setValue(null);
                return;
            }
        }
        String unitColumnName = (String)this.rePair.get(columnName);
        MaterialInfo materialInfo = (MaterialInfo)this.table.getCell(rowIndex, this.material).getValue();
        MeasureUnitInfo measureUnitInfo = (MeasureUnitInfo)this.table.getCell(rowIndex, unitColumnName).getValue();
        MultiMeasureUnitInfo multiMeasureUnitInfo = this.getMultiMeasureUnitInfo(materialInfo, measureUnitInfo);
        String format = PrecisionUtil.getFormatString((int)multiMeasureUnitInfo.getQtyPrecision());
        quantity = quantity.setScale(multiMeasureUnitInfo.getQtyPrecision(), 4);
        this.table.getCell(rowIndex, columnName).getStyleAttributes().setNumberFormat(format);
        BigDecimal baseQty = quantity.multiply(multiMeasureUnitInfo.getBaseConvsRate());
        ICell cell2 = this.table.getCell(rowIndex, (String)this.qtyToBaseQty.get(columnName));
        multiMeasureUnitInfo = this.getBaseMultiMeasureUnitInfo(materialInfo);
        baseQty = baseQty.setScale(multiMeasureUnitInfo.getQtyPrecision(), 4);
        cell2.setValue((Object)baseQty);
        format = PrecisionUtil.getFormatString((int)multiMeasureUnitInfo.getQtyPrecision());
        cell2.getStyleAttributes().setNumberFormat(format);
    }
}

