/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.common.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.client.FMIsqlUI;
import com.kingdee.eas.mm.common.SQLLogParamFacadeFactory;
import com.kingdee.eas.mm.common.client.AbstractSQLLogParamUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import org.apache.log4j.Logger;

public class SQLLogParamUI
extends AbstractSQLLogParamUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(SQLLogParamUI.class);
    private KDTEditListener kdtEditListener = null;
    private String TB_COL_NAME = "name";
    private String TB_COL_ISLOGOPEN = "isLogOpen";
    private String TB_COL_DATE = "time";

    public void onLoad() throws Exception {
        if (!this.isLogin()) {
            this.abort();
        }
        this.kdtMain.checkParsed();
        super.onLoad();
        KDDatePicker time = new KDDatePicker();
        this.kdtMain.getColumn(this.TB_COL_DATE).getStyleAttributes().setLocked(true);
        this.kdtMain.getColumn(this.TB_COL_DATE).setEditor((ICellEditor)new KDTDefaultCellEditor(time));
        this.kdtMain.getColumn(this.TB_COL_DATE).getStyleAttributes().setNumberFormat("%{yyyy-MM-dd HH:mm:ss}t");
        this.initTable();
    }

    private boolean isLogin() throws EASBizException {
        UserInfo userInfo = ContextHelperFactory.getRemoteInstance().getCurrentUser();
        if (Administrator.isSuperCUAdmin((IObjectPK)new ObjectUuidPK(userInfo.getId()))) {
            return true;
        }
        if ("00000000-0000-0000-0000-00000000000013B7DE7F".equals(userInfo.getId().toString())) {
            return true;
        }
        try {
            userInfo = UserFactory.getRemoteInstance().getUserByID((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-00000000000013B7DE7F"));
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        JPasswordField pwd = new JPasswordField();
        Object[] message = new Object[]{EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"49_FMIsqlUI"), pwd};
        int res = JOptionPane.showConfirmDialog((Component)((Object)this), message, " ", 2, 3);
        if (res != 0) {
            return false;
        }
        String logonPassword = new String(pwd.getPassword());
        return FMIsqlUI.matchPassword((UserInfo)userInfo, (String)logonPassword);
    }

    private void initTable() throws BOSException {
        Map params = SQLLogParamFacadeFactory.getRemoteInstance().query();
        if (params != null) {
            for (Map.Entry entry : params.entrySet()) {
                IRow row = this.addRow();
                row.getCell(this.TB_COL_NAME).setValue(entry.getKey());
                row.getCell(this.TB_COL_DATE).setValue(entry.getValue());
            }
        }
        this.addRow();
        this.removeAction();
        this.initAction();
    }

    private void initAction() {
        this.kdtEditListener = new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                if (SQLLogParamUI.this.kdtMain.getCell(SQLLogParamUI.this.kdtMain.getRowCount() - 1, SQLLogParamUI.this.TB_COL_NAME).getValue() != null) {
                    try {
                        SQLLogParamUI.this.saveSetting();
                    }
                    catch (Exception e1) {
                        SQLLogParamUI.this.handUIException(e1);
                    }
                    SQLLogParamUI.this.addRow();
                }
            }
        };
        this.kdtMain.addKDTEditListener(this.kdtEditListener);
    }

    private void removeAction() {
        if (this.kdtEditListener != null) {
            this.kdtMain.removeKDTEditListener(this.kdtEditListener);
        }
    }

    private IRow addRow() {
        IRow row = this.kdtMain.addRow();
        row.getCell(this.TB_COL_ISLOGOPEN).setValue((Object)Boolean.TRUE);
        return row;
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.saveSetting();
    }

    public void saveSetting() throws Exception {
        int rowCount = this.kdtMain.getRowCount();
        HashMap<Object, Date> params = new HashMap<Object, Date>();
        for (int i = 0; i < rowCount; ++i) {
            Object name = this.kdtMain.getCell(i, this.TB_COL_NAME).getValue();
            Boolean isLogOpen = (Boolean)this.kdtMain.getCell(i, this.TB_COL_ISLOGOPEN).getValue();
            Date date = (Date)this.kdtMain.getCell(i, this.TB_COL_DATE).getValue();
            if (name != null && isLogOpen.booleanValue()) {
                params.put(name, date);
                continue;
            }
            this.kdtMain.removeRow(i);
            --i;
            --rowCount;
        }
        SQLLogParamFacadeFactory.getRemoteInstance().save(params);
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }
}

