/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.common.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.mm.common.client.ITableTreeController;
import com.kingdee.eas.mm.common.client.TableTreeNode;
import com.kingdee.eas.mm.common.client.TreeCellRender;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.util.ArrayList;
import java.util.List;

public class TableTreeHelper {
    private CoreUI uiObject;
    private List tables = new ArrayList();
    private TreeCellRender render;
    private ITableTreeController controller;

    public TableTreeHelper(CoreUI ui, KDTable table, ITableTreeController controller) {
        this(ui, table, null, controller);
    }

    public TableTreeHelper(CoreUI ui, KDTable table, TreeCellRender render, ITableTreeController controller) {
        this.uiObject = ui;
        if (table != null) {
            this.tables.add(table);
        }
        this.render = render;
        this.controller = controller;
        if (render == null) {
            this.render = new TreeCellRender();
        }
        this.initTableTreeListener(table);
    }

    private void initTableTreeListener(KDTable table) {
        table.getColumn(this.controller.getTreeColumn()).setRenderer((IBasicRender)this.render);
        table.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                KDTable currentTable = (KDTable)e.getComponent();
                int row = e.getRowIndex();
                int column = e.getColIndex();
                if (e.getClickCount() == 1) {
                    TableTreeHelper.this.cellClicked(currentTable, row, column, e.getX(), e.getY());
                } else {
                    if (e.getClickCount() != 2) {
                        return;
                    }
                    TableTreeHelper.this.tblDoubleClicked(row, column, e.getX(), e.getY());
                }
            }
        });
        this.controller.insertRow(table, null, 0);
    }

    public void tblDoubleClicked(int row, int column, int x, int y) {
    }

    public void addTable(KDTable[] tables) {
        for (int i = 0; i < tables.length; ++i) {
            this.addTable(tables[i]);
        }
    }

    public void addTable(KDTable table) {
        if (table != null) {
            if (this.tables.contains(table)) {
                return;
            }
            this.initTableTreeListener(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cellClicked(KDTable table, int row, int column, int x, int y) {
        if (table.getRowCount() <= 0 || row <= -1 || column != table.getColumnIndex(this.controller.getTreeColumn())) {
            return;
        }
        TableTreeNode treeNode = (TableTreeNode)table.getRow(row).getCell(column).getValue();
        if (treeNode == null) {
            return;
        }
        try {
            this.uiObject.setCursorOfWair();
            this.doExpand(table, treeNode, row);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        finally {
            this.uiObject.setCursorOfDefault();
        }
    }

    public void doExpand(KDTable table, TableTreeNode treeNode, int rowIndex) {
        boolean insertRowIndex = false;
        boolean insertRowCount = false;
        int rowCount = table.getRowCount();
        if (treeNode.isLeaf() || treeNode.isIconEmpty()) {
            return;
        }
        table.setRefresh(false);
        if (treeNode.isExpanded()) {
            for (int i = rowIndex + 1; i < rowCount; ++i) {
                IRow row2 = table.getRow(i);
                TableTreeNode treeNode2 = (TableTreeNode)row2.getCell(this.controller.getTreeColumn()).getValue();
                if (treeNode2 == null) continue;
                if (treeNode2.getLevel() == treeNode.getLevel()) break;
                if (treeNode2.getLevel() <= treeNode.getLevel()) continue;
                row2.getStyleAttributes().setHided(true);
            }
            treeNode.setExpanded(false);
        } else if (treeNode.isHasExpanded()) {
            this.expandRow(rowIndex, table, this.controller.getTreeColumn());
        } else {
            this.controller.insertRow(table, treeNode, rowIndex);
            treeNode.setExpanded(true);
            treeNode.setHasExpanded(true);
        }
        table.setRefresh(true);
        table.reLayoutAndPaint();
    }

    public int expandRow(int rowIndex, KDTable table, String treeCol) {
        IRow row = table.getRow(rowIndex);
        int rowCount = table.getRowCount();
        TableTreeNode treeNode = (TableTreeNode)row.getCell(treeCol).getValue();
        treeNode.setExpanded(true);
        while (++rowIndex < rowCount) {
            IRow row2 = table.getRow(rowIndex);
            TableTreeNode treeNode2 = (TableTreeNode)row2.getCell(treeCol).getValue();
            if (treeNode2 == null) continue;
            IRow row3 = table.getRow(rowIndex - 1);
            if (treeNode2.isIconEmpty()) {
                row2.getStyleAttributes().setHided(row3.getStyleAttributes().isHided());
            }
            if (treeNode2.getLevel() > treeNode.getLevel()) {
                if (treeNode2.getLevel() == treeNode.getLevel() + 1) {
                    row2.getStyleAttributes().setHided(false);
                    treeNode2.setExpanded(treeNode2.isExpanded());
                    continue;
                }
                boolean isAllExpand = true;
                for (TableTreeNode parent = treeNode2.getParent(); parent != null; parent = parent.getParent()) {
                    if (parent.isExpanded()) continue;
                    isAllExpand = false;
                }
                if (!isAllExpand) continue;
                row2.getStyleAttributes().setHided(false);
                treeNode2.setExpanded(treeNode2.isExpanded());
                continue;
            }
            --rowIndex;
            break;
        }
        return rowIndex;
    }
}

