/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.common.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.mm.basedata.MMBasedataStatusEnum;
import com.kingdee.eas.mm.basedata.TrackNumberCollection;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.common.client.F7CustomProcessor;
import com.kingdee.eas.mm.common.client.TrackNumberSelectUI;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.util.HashSet;
import java.util.Set;
import javax.swing.SwingUtilities;

public class TrackNumberProcessor
extends F7CustomProcessor {
    private KDBizPromptBox mainOrgUnitBox;
    private KDBizPromptBox projectNumberF7;
    private String trackNumbers = null;

    public KDBizPromptBox getProjectNumberF7() {
        return this.projectNumberF7;
    }

    public void setProjectNumberF7(KDBizPromptBox projectNumberF7) {
        this.projectNumberF7 = projectNumberF7;
    }

    public TrackNumberProcessor(KDBizPromptBox mainOrgUnitBox, KDBizPromptBox projectNumberF7, KDBizPromptBox trackNumberF7) {
        super(trackNumberF7);
        this.mainOrgUnitBox = mainOrgUnitBox;
        this.projectNumberF7 = projectNumberF7;
    }

    @Override
    public Object stringToValue(String trackNumbers) {
        ProjectInfo projectInfo;
        this.trackNumbers = trackNumbers;
        if (MMUtils.isEmptyString(trackNumbers)) {
            this.show();
            return this.getSelectorUI().getData();
        }
        String[] trackNumberArray = trackNumbers.split(";");
        HashSet<String> trackNumberSet = new HashSet<String>();
        for (int i = 0; i < trackNumberArray.length; ++i) {
            trackNumberSet.add(trackNumberArray[i].trim());
        }
        CtrlUnitInfo cu = UIHelper.getMainOrgCU(this.mainOrgUnitBox);
        String storageOrgUnitId = cu.getId().toString();
        String projectId = null;
        if (this.projectNumberF7 != null && (projectInfo = (ProjectInfo)this.projectNumberF7.getData()) != null) {
            projectId = projectInfo.getId().toString();
        }
        TrackNumberCollection trackNumberCollection = null;
        try {
            trackNumberCollection = this.getTrackNumberCollection(storageOrgUnitId, projectId, trackNumberSet);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (trackNumberCollection.size() == 1 && trackNumberArray.length == 1) {
            return trackNumberCollection.get(0);
        }
        int size = trackNumberCollection.size();
        Object[] value = new Object[size];
        for (int i = 0; i < size; ++i) {
            value[i] = trackNumberCollection.get(i);
        }
        this.prompt.setValue((Object)value);
        this.show();
        return this.getSelectorUI().getData();
    }

    private TrackNumberCollection getTrackNumberCollection(String storageOrgUnitId, String projectid, Set trackNumberSet) throws BOSException {
        StringBuffer str = new StringBuffer(100);
        if (projectid == null) {
            str.append(" select fid from T_MM_TRACKNUMBER where fnumber in ").append(MMUtils.setToString(trackNumberSet)).append(" and ( fid in ( ").append(" SELECT FDataBaseDID FROM T_BD_DataBaseDAssign WHERE FBOSObjectType = '086E983D' AND FAssignCUID = '").append(storageOrgUnitId).append("' )").append(" or fadminCUid = '").append(storageOrgUnitId).append("')");
        } else {
            str.append(" select t.fid from T_MM_TRACKNUMBER as t ").append("inner join T_MM_ProjectCar as p on p.FTrackNumberID = t.fid ").append(" where t.fstatus =10 and t.fnumber in ").append(MMUtils.setToString(trackNumberSet)).append(" and p.FProjectID = '").append(projectid).append("' and ( t.fid in ( ").append(" SELECT FDataBaseDID FROM T_BD_DataBaseDAssign WHERE FBOSObjectType = '086E983D' AND FAssignCUID = '").append(storageOrgUnitId).append("' )").append(" or t.fadminCUid = '").append(storageOrgUnitId).append("')");
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)str.toString(), CompareType.INNER));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)MMBasedataStatusEnum.SAVED, CompareType.EQUALS));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        return TrackNumberFactory.getRemoteInstance().getTrackNumberCollection(viewInfo);
    }

    @Override
    public void show() {
        if (this.getSelectorUI() == null) {
            Window parent = SwingUtilities.getWindowAncestor((Component)this.prompt);
            this.selectorUI = parent instanceof Dialog ? new TrackNumberSelectUI((Dialog)parent, this.prompt, this, this.prompt.getText()) : (parent instanceof Frame ? new TrackNumberSelectUI((Frame)parent, this.prompt, this, this.prompt.getText()) : new TrackNumberSelectUI(this.prompt, this, this.prompt.getText()));
        }
        this.selectorUI.fValue.setText(this.trackNumbers);
        super.show();
    }
}

