/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.common.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.client.F7CustomProcessor;
import com.kingdee.eas.mm.common.client.F7CustomSelectUI;
import com.kingdee.eas.mm.common.client.TrackNumberProcessor;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public class TrackNumberSelectUI
extends F7CustomSelectUI {
    private static final String TRACK_NUMBER_RESOURCE_PATH = "com.kingdee.eas.mm.basedata.TrackNumberResource";
    protected KDWorkButton btnChecked;
    protected KDWorkButton btnUnchecked;
    private KDLabel from;
    private KDTextField seqFrom;
    private KDLabel to;
    private KDTextField seqTo;
    private int lastrowindex = 0;

    public TrackNumberSelectUI(KDBizPromptBox bizPromtBox, TrackNumberProcessor processor, String input) {
        super((Frame)null, bizPromtBox, (F7CustomProcessor)processor);
        this.fValue.setText(input);
    }

    public TrackNumberSelectUI(Dialog owner, KDBizPromptBox bizPromtBox, TrackNumberProcessor processor, String input) {
        super(owner, null, bizPromtBox, (F7CustomProcessor)processor);
        this.fValue.setText(input);
    }

    public TrackNumberSelectUI(Frame owner, KDBizPromptBox bizPromtBox, TrackNumberProcessor processor, String input) {
        super(owner, null, bizPromtBox, (F7CustomProcessor)processor);
        this.fValue.setText(input);
    }

    @Override
    protected void initToolBar() {
        Icon unChecked;
        super.initToolBar();
        this.btnChecked = new KDWorkButton();
        this.btnUnchecked = new KDWorkButton();
        this.btnChecked.setToolTipText(EASResource.getString((String)TRACK_NUMBER_RESOURCE_PATH, (String)"checked"));
        this.btnUnchecked.setToolTipText(EASResource.getString((String)TRACK_NUMBER_RESOURCE_PATH, (String)"unchecked"));
        this.btnChecked.setText(EASResource.getString((String)TRACK_NUMBER_RESOURCE_PATH, (String)"checked"));
        this.btnUnchecked.setText(EASResource.getString((String)TRACK_NUMBER_RESOURCE_PATH, (String)"unchecked"));
        Icon checked = EASResource.getIcon((String)"imgTbtn_submit");
        if (checked != null) {
            this.btnChecked.setIcon(checked);
        }
        if ((unChecked = EASResource.getIcon((String)"imgTbtn_unsubmit")) != null) {
            this.btnUnchecked.setIcon(unChecked);
        }
        this.btnChecked.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackNumberSelectUI.this.checked_actionPerformed(e);
            }
        });
        this.btnUnchecked.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackNumberSelectUI.this.unchecked_actionPerformed(e);
            }
        });
        this.tb.add((Component)this.btnChecked, 3);
        this.tb.add((Component)this.btnUnchecked, 4);
        this.btnMaintainObject.setVisible(false);
    }

    @Override
    protected KDPanel getPanelForQuickFilterComponents() {
        super.getPanelForQuickFilterComponents();
        this.from = new KDLabel();
        this.from.setBounds(new Rectangle(450, 10, 40, 19));
        this.from.setText(EASResource.getString((String)TRACK_NUMBER_RESOURCE_PATH, (String)"from"));
        this.from.setVisible(true);
        this.seqFrom = new KDTextField();
        this.seqFrom.setBounds(new Rectangle(490, 10, 50, 19));
        this.seqFrom.setText("");
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)this.seqFrom, (KeyStroke)KeyStroke.getKeyStroke(10, 0));
        this.seqFrom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackNumberSelectUI.this.launchQuickFilter();
            }
        });
        this.seqFrom.setVisible(true);
        this.to = new KDLabel();
        this.to.setBounds(new Rectangle(550, 10, 30, 19));
        this.to.setText(EASResource.getString((String)TRACK_NUMBER_RESOURCE_PATH, (String)"to"));
        this.to.setVisible(true);
        this.seqTo = new KDTextField();
        this.seqTo.setBounds(new Rectangle(570, 10, 50, 19));
        this.seqTo.setText("");
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)this.seqTo, (KeyStroke)KeyStroke.getKeyStroke(10, 0));
        this.seqTo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackNumberSelectUI.this.launchQuickFilter();
            }
        });
        this.seqTo.setVisible(true);
        this.quickFilterPanel.add((Component)this.seqFrom, null);
        this.quickFilterPanel.add((Component)this.from, null);
        this.quickFilterPanel.add((Component)this.seqTo, null);
        this.quickFilterPanel.add((Component)this.to, null);
        return this.quickFilterPanel;
    }

    @Override
    public void kdtable_afterDataFill(KDTDataRequestEvent e) {
        this.setPrecisionFormat(e.getFirstRow(), e.getLastRow());
        this.table.getColumn(0).getStyleAttributes().setLocked(false);
        int start = e.getFirstRow();
        int end = e.getLastRow();
        Object value = this.f7bizPromtBox.getValue();
        Object[] trackNumbers = null;
        trackNumbers = value instanceof TrackNumberInfo ? new Object[]{value} : (Object[])value;
        this.manyChecked(start, end, trackNumbers);
        this.lastrowindex = e.getLastRow();
    }

    private void manyChecked(int start, int end, Object[] trackNumbers) {
        if (trackNumbers == null || trackNumbers.length == 0) {
            return;
        }
        TrackNumberInfo trackNumberInfo = null;
        String trackNumber = null;
        String tempValue = null;
        for (int i = 0; i < trackNumbers.length; ++i) {
            trackNumberInfo = (TrackNumberInfo)trackNumbers[i];
            if (trackNumberInfo == null) continue;
            trackNumber = trackNumberInfo.getNumber();
            for (int j = start; j < end + 1; ++j) {
                tempValue = (String)this.table.getRow(j).getCell("number").getValue();
                if (MMUtils.isEmptyString(tempValue) || !tempValue.equals(trackNumber) || this.table.getRow(j).getCell("checkbox") == null) continue;
                this.table.getRow(j).getCell("checkbox").setValue((Object)true);
            }
        }
    }

    protected void checked_actionPerformed(ActionEvent e) {
        this.setCheckBox(true);
    }

    protected void unchecked_actionPerformed(ActionEvent e) {
        this.setCheckBox(false);
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) {
        this.setCanceled(false);
        this.setData(this.buildReturnValue());
        this.dispose();
    }

    private void setCheckBox(Boolean value) {
        String seqFromValue = this.seqFrom.getStringValue();
        String seqToValue = this.seqTo.getStringValue();
        if (MMUtils.isEmptyString(seqFromValue) && MMUtils.isEmptyString(seqToValue)) {
            int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.table);
            if (selectRows.length == 1) {
                this.table.getEditManager().editCellAt(selectRows[0], 0);
            }
            for (int i = 0; i < selectRows.length; ++i) {
                if (this.table.getRow(selectRows[i]).getCell("checkbox") == null) continue;
                this.table.getRow(selectRows[i]).getCell("checkbox").setValue((Object)value);
            }
            return;
        }
        if (this.checkInputNumber(seqFromValue, seqToValue)) {
            int from = Integer.parseInt(seqFromValue);
            int to = Integer.parseInt(seqToValue);
            for (int i = from - 1; i < to; ++i) {
                if (this.table.getRow(i).getCell("checkbox") == null) continue;
                this.table.getRow(i).getCell("checkbox").setValue((Object)value);
            }
            this.seqFrom.setText("");
            this.seqTo.setText("");
        }
    }

    private boolean checkInputNumber(String seqFromValue, String seqToValue) {
        int to;
        if (MMUtils.isEmptyString(seqFromValue) || MMUtils.isEmptyString(seqToValue)) {
            MsgBox.showInfo((String)ResourceUtils.getMessage((String)TRACK_NUMBER_RESOURCE_PATH, (String)"seq_not_null"));
            return false;
        }
        if (!MMUtils.isPositiveInteger(seqFromValue) || !MMUtils.isPositiveInteger(seqToValue)) {
            this.seqFrom.setText("");
            this.seqTo.setText("");
            MsgBox.showInfo((String)ResourceUtils.getMessage((String)TRACK_NUMBER_RESOURCE_PATH, (String)"seq_must_integer"));
            return false;
        }
        int from = Integer.parseInt(seqFromValue);
        if (from > (to = Integer.parseInt(seqToValue))) {
            this.seqFrom.setText("");
            this.seqTo.setText("");
            MsgBox.showInfo((String)ResourceUtils.getMessage((String)TRACK_NUMBER_RESOURCE_PATH, (String)"from_less_than_to"));
            return false;
        }
        if (to > this.table.getRowCount()) {
            this.seqFrom.setText("");
            this.seqTo.setText("");
            MsgBox.showInfo((String)ResourceUtils.getMessage((String)TRACK_NUMBER_RESOURCE_PATH, (String)"to_more_than_all"));
            return false;
        }
        return true;
    }

    @Override
    public void kdtTable_tableClicked(KDTMouseEvent e) {
        if (e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 1) {
            try {
                ArrayList<TrackNumberInfo> trackNumberList = new ArrayList<TrackNumberInfo>();
                int rowCount = this.table.getRowCount();
                Boolean value = null;
                for (int i = 0; i < rowCount; ++i) {
                    value = (Boolean)this.table.getRow(i).getCell("checkbox").getValue();
                    if (!value.booleanValue()) continue;
                    TrackNumberInfo trackNumberInfo = new TrackNumberInfo();
                    trackNumberInfo.setNumber(this.table.getRow(i).getCell("number").getValue().toString());
                    trackNumberList.add(trackNumberInfo);
                }
                this.OrderByForTable(e);
                this.manyChecked(0, rowCount - 1, trackNumberList.toArray());
            }
            catch (Exception exc) {
                ExceptionHandler.handle((Throwable)exc);
            }
        }
        if (e.getClickCount() == 2 && e.getType() == 1) {
            int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.table);
            Boolean value = null;
            for (int i = 0; i < selectRows.length; ++i) {
                if (this.table.getRow(selectRows[i]).getCell("checkbox") == null) continue;
                value = (Boolean)this.table.getRow(selectRows[i]).getCell("checkbox").getValue();
                if (value.booleanValue()) {
                    this.table.getRow(selectRows[i]).getCell("checkbox").setValue((Object)new Boolean(false));
                    continue;
                }
                this.table.getRow(selectRows[i]).getCell("checkbox").setValue((Object)new Boolean(true));
            }
        }
    }

    @Override
    protected ArrayList getSelectedIdValues() {
        ArrayList selectList = null;
        selectList = new ArrayList();
        List selectKeyIdFields = null;
        selectKeyIdFields = this.getQueryPkList();
        return this.getSelectedIdValues(this.table, this.getKeyFieldName(), selectList, selectKeyIdFields);
    }

    public ArrayList getSelectedIdValues(KDTable table, String columnName, ArrayList selectList, List selectIdList) {
        ArrayList<String> list;
        block8: {
            int[] selectRows;
            block9: {
                block7: {
                    list = new ArrayList<String>();
                    selectRows = this.getSelectedRows(table);
                    int size = table.getSelectManager().size();
                    if (size != 1 || selectRows.length != 1) break block7;
                    int rowNum = selectRows[0];
                    ICell cell = table.getRow(rowNum).getCell(columnName);
                    if (cell == null) {
                        MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                        SysUtil.abort();
                    }
                    list.add(cell.getValue().toString());
                    selectList.add(new Integer(rowNum));
                    break block8;
                }
                int mode = 0;
                ArrayList blockList = table.getSelectManager().getBlocks();
                if (blockList != null && blockList.size() == 1) {
                    mode = ((IBlock)table.getSelectManager().getBlocks().get(0)).getMode();
                }
                if (mode != 8 || selectRows.length < 100) break block9;
                int index = 0;
                if (selectIdList == null) break block8;
                for (Object[] idObj : selectIdList) {
                    if (idObj == null) continue;
                    if (!list.contains(idObj[0].toString())) {
                        list.add(idObj[0].toString());
                    }
                    selectList.add(new Integer(index));
                    ++index;
                }
                break block8;
            }
            for (int i = 0; i < selectRows.length; ++i) {
                ICell cell = table.getRow(selectRows[i]).getCell(columnName);
                if (cell == null) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                    SysUtil.abort();
                }
                if (cell.getValue() == null) continue;
                String id = cell.getValue().toString();
                if (!list.contains(id)) {
                    list.add(id);
                }
                selectList.add(new Integer(selectRows[i]));
            }
        }
        return list;
    }

    private int[] getSelectedRows(KDTable table) {
        ArrayList<Integer> rowNumberList = new ArrayList<Integer>();
        Boolean tempValue = null;
        for (int i = 0; i < this.lastrowindex + 1; ++i) {
            if (table.getRow(i).getCell("checkbox") == null || !"true".equals((tempValue = (Boolean)table.getRow(i).getCell("checkbox").getValue()).toString())) continue;
            rowNumberList.add(new Integer(i));
        }
        return this.ListToArrayForBaseType(rowNumberList);
    }

    private int[] ListToArrayForBaseType(List list) {
        if (list == null || list.size() == 0) {
            return new int[0];
        }
        int[] array = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array[i] = (Integer)list.get(i);
        }
        return array;
    }

    @Override
    protected String getKeyFieldName() {
        return "id";
    }
}

