/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.common.client;

import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.SimpleTextRender;
import com.kingdee.bos.ctrl.kdf.util.render.icon.Icon;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.eas.mm.common.client.TableTreeNode;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Hashtable;
import java.util.Map;

public class TreeCellRender
implements IBasicRender {
    protected SimpleTextRender simpleRender = new SimpleTextRender();
    protected Icon cbIcon;
    private Map mapOfTreeNodeLocation = new Hashtable();
    private int treeNodeIndentCell = 16;
    private int treeNodeIconIndentCell = this.treeNodeIndentCell + 6;

    public TreeCellRender() {
        this.cbIcon = new TreeIcon();
    }

    public boolean inRect(TableTreeNode treeNode, int x, int y) {
        String companyId = treeNode.getId();
        Rectangle rec = (Rectangle)this.mapOfTreeNodeLocation.get(companyId);
        if (rec != null) {
            return rec.getX() < (double)x && rec.getX() + rec.getWidth() > (double)x;
        }
        return false;
    }

    public void draw(Graphics g, Shape clip, Object value, Style style) {
        TableTreeNode treeNode = null;
        if (!(value instanceof TableTreeNode)) {
            treeNode = new TableTreeNode();
            treeNode.setName((String)value);
            treeNode.setId("");
            treeNode.setIconEmpty(true);
        } else {
            treeNode = (TableTreeNode)value;
        }
        int ident = 0;
        if (treeNode.getLevel() != 1) {
            ident = (treeNode.getLevel() - 1) * this.treeNodeIconIndentCell;
        }
        Rectangle rect = clip.getBounds();
        int x = rect.x + ident;
        int y = rect.y + (rect.height - this.cbIcon.getHeight()) / 2;
        int v = treeNode.isLeaf() ? 0 : (treeNode.isExpanded() ? 2 : 1);
        if (treeNode.isIconEmpty()) {
            v = 3;
        }
        Color color = style.getFontColor();
        g.setColor(color);
        Rectangle locRec = new Rectangle(x, y, this.cbIcon.getWidth(), this.cbIcon.getWidth());
        String id = treeNode.getId();
        this.mapOfTreeNodeLocation.put(id, locRec);
        int xx = x + this.cbIcon.getWidth() + this.treeNodeIndentCell;
        Rectangle newRec = new Rectangle(xx, rect.y, clip.getBounds().width - this.cbIcon.getWidth() - this.treeNodeIndentCell, (int)clip.getBounds().getHeight());
        this.simpleRender.draw(g, (Shape)newRec, treeNode.toString(), style);
        if (!treeNode.isLeaf() && treeNode.isExpanded() && treeNode.isHasChild()) {
            this.drawVertical(g, (int)((double)newRec.y + newRec.getHeight() / 2.0 + 8.0), (int)((double)(x + this.treeNodeIconIndentCell) + (double)this.cbIcon.getWidth() / 2.0 + 1.0), newRec.y + newRec.height);
        }
        TableTreeNode parent = treeNode.getParent();
        for (int i = 0; i < treeNode.getLevel(); ++i) {
            if (parent != null && !parent.isLast()) {
                this.drawVertical(g, newRec.y, (int)((double)x + (double)this.cbIcon.getWidth() / 2.0) + 1 - this.treeNodeIconIndentCell * (i + 1), newRec.y + newRec.height);
                parent = parent.getParent();
                continue;
            }
            if (parent == null) continue;
            parent = parent.getParent();
        }
        this.drawHorizentol(g, x + this.cbIcon.getWidth(), (int)((double)newRec.y + newRec.getHeight() / 2.0), newRec.x - 4);
        if (treeNode.isLast() && (!treeNode.isFirst() || treeNode.getLevel() != 1)) {
            this.drawVertical(g, newRec.y, (int)((double)x + (double)this.cbIcon.getWidth() / 2.0) + 1, y);
        }
        if (!treeNode.isLast()) {
            if (!treeNode.isFirst() || treeNode.getLevel() != 1) {
                this.drawVertical(g, newRec.y, (int)((double)x + (double)this.cbIcon.getWidth() / 2.0) + 1, y);
            }
            this.drawVertical(g, y + this.cbIcon.getHeight(), (int)((double)x + (double)this.cbIcon.getWidth() / 2.0) + 1, newRec.y + newRec.height);
        }
        if (treeNode.isLeaf()) {
            if (!treeNode.isFirst() || treeNode.isFirst() && treeNode.getLevel() != 1) {
                this.drawVertical(g, newRec.y, (int)((double)x + (double)this.cbIcon.getWidth() / 2.0) + 1, (int)((double)newRec.y + newRec.getHeight() / 2.0));
            }
            if (!treeNode.isLast()) {
                this.drawVertical(g, (int)((double)newRec.y + newRec.getHeight() / 2.0), (int)((double)x + (double)this.cbIcon.getWidth() / 2.0) + 1, newRec.y + newRec.height);
            }
            this.drawHorizentol(g, (int)((double)x + (double)this.cbIcon.getWidth() / 2.0 + 1.0), (int)((double)newRec.y + newRec.getHeight() / 2.0), newRec.x - 4);
            this.cbIcon.paint((Object)new Integer(3), g, x, y);
        } else {
            this.cbIcon.paint((Object)new Integer(v), g, x, y);
        }
    }

    private void drawHorizentol(Graphics g, int x1, int y, int x2) {
        g.setColor(Color.gray);
        g.drawLine(x1, y, x2, y);
        g.setColor(Color.BLACK);
    }

    private void drawVertical(Graphics g, int y1, int x, int y2) {
        g.setColor(Color.gray);
        g.drawLine(x, y1, x, y2);
        g.setColor(Color.BLACK);
    }

    private class TreeIcon
    implements Icon {
        private int iconSize;
        private int margin;

        public TreeIcon() {
            this(9);
        }

        public TreeIcon(int iconSize) {
            this.iconSize = iconSize;
            this.margin = 2;
        }

        public int getWidth() {
            return this.iconSize;
        }

        public int getHeight() {
            return this.iconSize;
        }

        public void paint(Object value, Graphics g, int x, int y) {
            if (!(value instanceof Integer)) {
                return;
            }
            int type = (Integer)value;
            if (type == 3) {
                return;
            }
            if (type == 0) {
                this.drawLeaf(g, x, y);
            } else if (type == 1) {
                this.drawCollapsed(g, x, y);
            } else {
                this.drawExpanded(g, x, y);
            }
        }

        protected void drawLeaf(Graphics g, int x, int y) {
            int lineSize = this.iconSize - 2 * this.margin;
            g.drawLine(x + this.margin, y + this.iconSize / 2, x + this.margin + lineSize, y + this.iconSize / 2);
        }

        protected void drawExpanded(Graphics g, int x, int y) {
            g.drawRect(x, y, this.iconSize, this.iconSize);
            int lineSize = this.iconSize - 2 * this.margin;
            g.drawLine(x + this.margin, y + this.iconSize / 2, x + this.margin + lineSize, y + this.iconSize / 2);
        }

        protected void drawCollapsed(Graphics g, int x, int y) {
            g.drawRect(x, y, this.iconSize, this.iconSize);
            int lineSize = this.iconSize - 2 * this.margin;
            g.drawLine(x + this.margin, y + this.iconSize / 2, x + this.margin + lineSize, y + this.iconSize / 2);
            g.drawLine(x + 1 + this.iconSize / 2, y + this.margin, x + 1 + this.iconSize / 2, y + this.margin + lineSize);
        }
    }
}

