/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.common.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.CommitListener;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialAttributeEnum;
import com.kingdee.eas.basedata.master.material.MaterialCharEnum;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialIssueModeEnum;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MaterialProductEnum;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.mm.basedata.ConsumeTypeEnum;
import com.kingdee.eas.mm.basedata.MMBasedataStatusEnum;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.basedata.client.TrackNumberListUI;
import com.kingdee.eas.mm.common.client.TrackNumberProcessor;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.mm.common.util.UISettingFactory;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.SCMGroupFacadeFactory;
import com.kingdee.eas.scm.common.YesOrNoEnum;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.client.helper.FormattedEditorFactory;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Map;

public final class UIHelper {
    public static final String MATERIAL_PLAN = "com.kingdee.eas.basedata.master.material.app.F7MaterialPlanGroupQuery";
    public static final String MATERIAL_PLAN_NOGROUP = "com.kingdee.eas.basedata.master.material.app.F7MaterialPlanNoGroupQuery";
    public static final String MATERIALSOP_PLAN = "com.kingdee.eas.mm.planning.app.F7MaterialPlanGroupForSOPQuery";
    public static final String MATERIALSOP_PLAN_NOGROUP = "com.kingdee.eas.mm.planning.app.F7MaterialPlanNoGroupForSOPQuery";
    public static final String MATERIALSOPFILTER_PLAN = "com.kingdee.eas.mm.planning.app.F7MaterialPlanGroupForSopFilterQuery";
    public static final String MATERIALSOPFILTER_PLAN_NOGROUP = "com.kingdee.eas.mm.planning.app.F7MaterialPlanNoGroupForSopFilterQuery";

    public static SCMEntryDataVO getDataVO(StorageOrgUnitInfo storageOrgUnit, MaterialInfo[] materialInfos) throws EASBizException, BOSException {
        return UIHelper.getDataVO(storageOrgUnit, materialInfos, null);
    }

    public static SCMEntryDataVO getDataVO(StorageOrgUnitInfo storageOrgUnit, MaterialInfo[] materialInfos, SCMEntryDataVO dataVO) throws EASBizException, BOSException {
        if (dataVO == null) {
            dataVO = new SCMEntryDataVO();
        }
        SCMEntryDataVO voResult = new SCMEntryDataVO();
        dataVO.setIsLoadingMaterialInventory(true);
        StorageOrgUnitInfo[] storageOrgUnitInfos = new StorageOrgUnitInfo[materialInfos.length];
        for (int i = 0; i < materialInfos.length; ++i) {
            storageOrgUnitInfos[i] = storageOrgUnit;
        }
        dataVO.setMaterialInfos(materialInfos);
        dataVO.setIsLoadingMaterialPlan(true);
        dataVO.setIsLoadingMaterialInventory(true);
        dataVO.setStorageOrgUnitInfos(storageOrgUnitInfos);
        voResult = SCMGroupFacadeFactory.getRemoteInstance().loadComplexData(dataVO);
        Map miInfoMap = voResult.getMaterialInventoryInfos();
        Map mpInfoMap = voResult.getMaterialPlanInfos();
        MeasureUnitInfo[] measureUnitInfos = new MeasureUnitInfo[materialInfos.length];
        MeasureUnitInfo[] measureBaseUnitInfos = new MeasureUnitInfo[materialInfos.length];
        MeasureUnitInfo[] assistBaseUnitInfos = new MeasureUnitInfo[materialInfos.length];
        for (int i = 0; i < materialInfos.length; ++i) {
            measureBaseUnitInfos[i] = materialInfos[i].getBaseUnit();
            measureUnitInfos[i] = materialInfos[i].getBaseUnit();
            String key = materialInfos[i].getId().toString() + storageOrgUnit.getId().toString();
            MaterialPlanInfo mpInfo = (MaterialPlanInfo)mpInfoMap.get(key);
            if (mpInfo == null || mpInfo.getProductUnit() == null) continue;
            measureUnitInfos[i] = mpInfo.getProductUnit();
        }
        dataVO.setIsLoadingMou(true);
        dataVO.setIsLoadingMmuPrecision(true);
        dataVO.setIsLoadingMaterialPlan(false);
        dataVO.setIsLoadingMaterialInventory(false);
        dataVO.setMeasureUnitInfos(measureUnitInfos);
        dataVO.setBaseMeasureUnitInfos(measureBaseUnitInfos);
        dataVO.setAssistMeasureUnitInfos(assistBaseUnitInfos);
        voResult = SCMGroupFacadeFactory.getRemoteInstance().loadComplexData(dataVO);
        voResult.setMaterialInventoryInfos(miInfoMap);
        voResult.setMaterialPlanInfos(mpInfoMap);
        return voResult;
    }

    public static String getMaterialPlanQuery(int f7DisplayMode) {
        String queryInfo = null;
        queryInfo = f7DisplayMode == 0 ? MATERIAL_PLAN : MATERIAL_PLAN_NOGROUP;
        return queryInfo;
    }

    public static String getMaterialPlanQueryForSop(int f7DisplayMode) {
        String queryInfo = null;
        queryInfo = f7DisplayMode == 0 ? MATERIALSOP_PLAN : MATERIALSOP_PLAN_NOGROUP;
        return queryInfo;
    }

    public static String getMaterialPlanQueryForSopFilter(int f7DisplayMode) {
        String queryInfo = null;
        queryInfo = f7DisplayMode == 0 ? MATERIALSOPFILTER_PLAN : MATERIALSOPFILTER_PLAN_NOGROUP;
        return queryInfo;
    }

    public static void registerBizMaterialF7(F7ContextManager f7Manager, KDBizPromptBox bizMaterialBox, OrgUnitInfo mainOrg) {
        String queryInfo = UIHelper.getMaterialPlanQuery(f7Manager.getF7DisplayMode());
        f7Manager.registerBizMaterialF7(bizMaterialBox, null, queryInfo, mainOrg, OrgType.Storage, false, true);
    }

    public static void registerBizMaterialForSOPF7(F7ContextManager f7Manager, KDBizPromptBox bizMaterialBox, OrgUnitInfo mainOrg) {
        String queryInfo = null;
        queryInfo = f7Manager.getF7DisplayMode() == 0 ? MATERIALSOPFILTER_PLAN : MATERIALSOPFILTER_PLAN_NOGROUP;
        f7Manager.registerBizMaterialF7(bizMaterialBox, null, queryInfo, mainOrg, OrgType.Storage, false, true);
    }

    public static void registerBizMaterialF7(F7ContextManager f7Manager, KDBizPromptBox bizMaterialBox, OrgUnitInfo mainOrg, boolean isMultiSelected) {
        String queryInfo = UIHelper.getMaterialPlanQuery(f7Manager.getF7DisplayMode());
        f7Manager.registerBizMaterialF7(bizMaterialBox, null, queryInfo, mainOrg, OrgType.Storage, isMultiSelected, true);
    }

    public static IUIWindow openUIWindow(UIContext uiContext, String uiClass) {
        IUIWindow uiWindow = null;
        if (null == uiContext) {
            throw new IllegalArgumentException();
        }
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiClass, (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
        }
        catch (UIException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return uiWindow;
    }

    public static void registerMeasureUnitF7(final KDBizPromptBox bizMaterialBox, final KDBizPromptBox bizUnitBox) {
        bizUnitBox.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MultiMeasureUnitQuery");
        bizUnitBox.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    SCMClientUtils.setMultiToMeasureUnit((KDBizPromptBox)((KDBizPromptBox)e.getSource()));
                }
                catch (Exception exc) {
                    ExceptionHandler.handle((Throwable)exc);
                }
            }
        });
        bizUnitBox.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                MaterialInfo materialInfo = (MaterialInfo)bizMaterialBox.getData();
                String materialId = "null";
                if (materialInfo != null) {
                    materialId = materialInfo.getId().toString();
                }
                SCMClientUtils.setF7MeasureUnit((KDBizPromptBox)bizUnitBox, (String)materialId);
                bizUnitBox.getQueryAgent().resetRuntimeEntityView();
            }
        });
    }

    public static void registerLocationF7(final KDTable table, final String colNameWarehouse, final String colNameLocation) {
        KDBizPromptBox box;
        if (table.getColumn(colNameWarehouse).getEditor() == null) {
            box = new KDBizPromptBox();
            box.setEditable(true);
            box.setDisplayFormat("$name$");
            box.setEditFormat("$number$");
            box.setCommitFormat("$number$");
            table.getColumn(colNameWarehouse).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)box));
        }
        box = (KDBizPromptBox)table.getColumn(colNameLocation).getEditor().getComponent();
        box.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7LocationQuery");
        table.addKDTActiveCellListener(new KDTActiveCellListener(){

            public void activeCellChanged(KDTActiveCellEvent e) {
                int rowIndex = table.getSelectManager().getActiveRowIndex();
                if (rowIndex >= 0) {
                    int colIndex = table.getSelectManager().getActiveColumnIndex();
                    if (table.getColumn(colNameLocation).getColumnIndex() == colIndex) {
                        WarehouseInfo warehouseInfo = (WarehouseInfo)table.getRow(rowIndex).getCell(colNameWarehouse).getValue();
                        if (warehouseInfo != null && warehouseInfo.isHasLocation()) {
                            table.getRow(rowIndex).getCell(colNameLocation).getStyleAttributes().setLocked(false);
                        }
                        String id = "null";
                        if (warehouseInfo != null) {
                            id = warehouseInfo.getId().toString();
                        }
                        EntityViewInfo viewInfo = new EntityViewInfo();
                        FilterInfo filterInfo = new FilterInfo();
                        filterInfo.appendFilterItem("Warehouse.id", (Object)id);
                        viewInfo.setFilter(filterInfo);
                        KDBizPromptBox bizBox = (KDBizPromptBox)table.getColumn(colNameLocation).getEditor().getComponent();
                        bizBox.setEntityViewInfo(viewInfo);
                    }
                }
            }
        });
    }

    public static boolean isDiffrent(Object arg0, Object arg1) {
        boolean isChanged = false;
        if (arg0 == null && arg1 != null || arg0 != null && arg1 == null) {
            isChanged = true;
        } else if (arg0 != null && arg1 != null) {
            if (arg0 instanceof CoreBaseInfo && arg1 instanceof CoreBaseInfo) {
                BOSUuid id0 = ((CoreBaseInfo)arg0).getId();
                BOSUuid id1 = ((CoreBaseInfo)arg1).getId();
                isChanged = !(id0 == null || id1 == null ? id0 == id1 : id0.toString().equals(id1.toString()));
            } else if (arg0 instanceof BigDecimal && arg1 instanceof BigDecimal) {
                BigDecimal oldBigValue = (BigDecimal)arg0;
                BigDecimal newBigValue = (BigDecimal)arg1;
                isChanged = (oldBigValue = oldBigValue.setScale(newBigValue.scale(), 4)).compareTo(newBigValue) != 0;
            } else {
                isChanged = !arg0.equals(arg1);
            }
        }
        return isChanged;
    }

    public static void registerBizOrgF7(KDBizPromptBox bizOrgUnitBox, IColumn col, OrgUnitInfo mainOrg, OrgType mainOrgType, OrgType orgType, boolean isSingleMainOrg) {
        bizOrgUnitBox.setDisplayFormat("$name$");
        bizOrgUnitBox.setEditFormat("$number$");
        bizOrgUnitBox.setCommitFormat("$number$;$code$");
        SCMGroupClientUtils.setBizOrgF7ByType((KDBizPromptBox)bizOrgUnitBox, (OrgType)orgType, (OrgType)mainOrgType, (boolean)isSingleMainOrg);
        if (mainOrg != null) {
            bizOrgUnitBox.setCurrentMainBizOrgUnit(mainOrg, mainOrgType);
        }
        if (col != null) {
            col.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizOrgUnitBox));
        }
        bizOrgUnitBox.setEditable(true);
    }

    public static void changeTableDiscountCol(int precision, KDTable table, String[] fieldNames) {
        KDTDefaultCellEditor editor = FormattedEditorFactory.getDiscountCellEditor((int)precision);
        String colPrecision = PrecisionUtil.getFormatString((int)precision);
        IColumn aColumn = null;
        int num = fieldNames.length;
        for (int i = 0; i < num; ++i) {
            aColumn = table.getColumn(fieldNames[i]);
            if (aColumn == null) continue;
            aColumn.setEditor((ICellEditor)editor);
            aColumn.getStyleAttributes().setNumberFormat(colPrecision);
        }
    }

    public static void registerProjectF7ForFilter(KDBizPromptBox mainOrgUnitBox, KDBizPromptBox projectBox) {
        HashSet<Integer> status = new HashSet<Integer>();
        status.add(new Integer(4));
        status.add(new Integer(7));
        UIHelper.registerProjectF7(mainOrgUnitBox, null, projectBox, status);
    }

    public static void registerProjectF7ForFilter(KDBizPromptBox mainOrgUnitBox, KDBizPromptBox projectBox, boolean isMulSelect) {
        HashSet<Integer> status = new HashSet<Integer>();
        status.add(new Integer(4));
        status.add(new Integer(7));
        projectBox.setEnabledMultiSelection(isMulSelect);
        UIHelper.registerProjectF7(mainOrgUnitBox, null, projectBox, status);
    }

    public static void registerProjectF7ForEdit(KDBizPromptBox mainOrgUnitBox, KDBizPromptBox mainOrgUnitBox2, KDBizPromptBox projectBox) {
        HashSet<Integer> status = new HashSet<Integer>();
        status.add(new Integer(4));
        UIHelper.registerProjectF7(mainOrgUnitBox, mainOrgUnitBox2, projectBox, status);
    }

    public static void registerProjectF7ForEdit(KDBizPromptBox mainOrgUnitBox, KDBizPromptBox mainOrgUnitBox2, KDBizPromptBox projectBox, boolean isMulSelect) {
        HashSet<Integer> status = new HashSet<Integer>();
        status.add(new Integer(4));
        projectBox.setEnabledMultiSelection(isMulSelect);
        UIHelper.registerProjectF7(mainOrgUnitBox, mainOrgUnitBox2, projectBox, status);
    }

    public static void registerProjectF7(final KDBizPromptBox mainOrgUnitBox, final KDBizPromptBox mainOrgUnitBox2, final KDBizPromptBox projectBox, final HashSet status) {
        projectBox.setQueryInfo("com.kingdee.eas.mm.project.app.F7ProjectQuery");
        projectBox.setCommitFormat("$number$");
        projectBox.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent paramCommitEvent) {
                UIHelper.resetProjectF7(mainOrgUnitBox, mainOrgUnitBox2, projectBox, status, false);
            }
        });
        projectBox.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                UIHelper.resetProjectF7(mainOrgUnitBox, mainOrgUnitBox2, projectBox, status, false);
            }
        });
    }

    public static CtrlUnitInfo getMainOrgCU(KDBizPromptBox mainOrgUnitBox) {
        CtrlUnitInfo cu = SysContext.getSysContext().getCurrentCtrlUnit();
        if (mainOrgUnitBox != null && mainOrgUnitBox.getValue() != null) {
            Object[] orgs;
            Object boxVal = mainOrgUnitBox.getValue();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("cu.id"));
            if (boxVal instanceof OrgUnitInfo) {
                OrgUnitInfo orgInfo = (OrgUnitInfo)boxVal;
                try {
                    orgInfo = (OrgUnitInfo)FullOrgUnitFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(orgInfo.getId()), sic);
                }
                catch (EASBizException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                catch (BOSException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                cu = orgInfo.getCU();
            } else if (boxVal instanceof Object[] && (orgs = (Object[])boxVal).length > 0 && orgs[0] instanceof OrgUnitInfo) {
                OrgUnitInfo orgInfo = (OrgUnitInfo)orgs[0];
                try {
                    orgInfo = (OrgUnitInfo)FullOrgUnitFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(orgInfo.getId()), sic);
                }
                catch (EASBizException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                catch (BOSException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                cu = orgInfo.getCU();
            }
        }
        return cu;
    }

    private static void resetProjectF7(KDBizPromptBox mainOrgUnitBox, KDBizPromptBox mainOrgUnitBox2, KDBizPromptBox projectBox, HashSet status, boolean isTemplate) {
        boolean ismulSelect;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (status != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)status, CompareType.INCLUDE));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("isTemplate", (Object)isTemplate, CompareType.EQUALS));
        FilterInfo filter2 = null;
        if (mainOrgUnitBox2 != null) {
            CtrlUnitInfo cu2 = UIHelper.getMainOrgCU(mainOrgUnitBox2);
            ObjectUuidPK cuPK = null;
            cuPK = cu2 == null ? new ObjectUuidPK(BOSUuid.create((BOSObjectType)new ProjectInfo().getBOSType())) : new ObjectUuidPK(cu2.getId());
            try {
                filter2 = ProjectFactory.getRemoteInstance().getDatabaseDFilter((IObjectPK)cuPK, "id", "CU.id");
            }
            catch (EASBizException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        if (filter2 != null) {
            try {
                filterInfo.mergeFilter(filter2, "and");
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        if (!(ismulSelect = UIHelper.isMulSelect(mainOrgUnitBox))) {
            CtrlUnitInfo cu = UIHelper.getMainOrgCU(mainOrgUnitBox);
            projectBox.setCurrentCtrlUnit(cu);
            FilterInfo filter3 = null;
            ObjectUuidPK cuPK = null;
            cuPK = cu == null ? new ObjectUuidPK(BOSUuid.create((BOSObjectType)new ProjectInfo().getBOSType())) : new ObjectUuidPK(cu.getId());
            try {
                filter3 = ProjectFactory.getRemoteInstance().getDatabaseDFilter((IObjectPK)cuPK, "id", "CU.id");
            }
            catch (EASBizException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            projectBox.getQueryAgent().setDefaultFilterInfo(filter3);
        } else {
            projectBox.getQueryAgent().setDefaultFilterInfo(null);
        }
        viewInfo.setFilter(filterInfo);
        projectBox.setEntityViewInfo(viewInfo);
        projectBox.getQueryAgent().resetRuntimeEntityView();
    }

    public static void registerProjectF7(KDBizPromptBox mainOrgUnitBox, KDBizPromptBox mainOrgUnitBox2, KDTable table, String projectCol) {
        UIHelper.registerProjectF7(mainOrgUnitBox, mainOrgUnitBox2, table, projectCol, false);
    }

    public static void registerProjectF7(final KDBizPromptBox mainOrgUnitBox, final KDBizPromptBox mainOrgUnitBox2, final KDTable table, final String projectCol, boolean isMulSelect) {
        final HashSet<Integer> status = new HashSet<Integer>();
        status.add(new Integer(4));
        if (table.getColumn(projectCol).getEditor() == null) {
            KDBizPromptBox bizProjectBox = new KDBizPromptBox();
            bizProjectBox.setEnabledMultiSelection(isMulSelect);
            bizProjectBox.setEditFormat("$number$");
            bizProjectBox.setDisplayFormat("$number$");
            bizProjectBox.setCommitFormat("$number$");
            bizProjectBox.setEditable(true);
            bizProjectBox.setQueryInfo("com.kingdee.eas.mm.project.app.F7ProjectQuery");
            table.getColumn(projectCol).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizProjectBox));
            ObjectValueRender avr = new ObjectValueRender();
            avr.setFormat((IDataFormat)new BizDataFormat("$number$"));
            table.getColumn(projectCol).setRenderer((IBasicRender)avr);
        }
        table.addKDTActiveCellListener(new KDTActiveCellListener(){

            public void activeCellChanged(KDTActiveCellEvent e) {
                int rowIndex = table.getSelectManager().getActiveRowIndex();
                if (rowIndex >= 0) {
                    ICellEditor cellEditor;
                    int colIndex = table.getSelectManager().getActiveColumnIndex();
                    if (table.getColumn(projectCol).getColumnIndex() == colIndex && (cellEditor = table.getColumn(projectCol).getEditor()) != null) {
                        KDBizPromptBox projectBox = (KDBizPromptBox)cellEditor.getComponent();
                        UIHelper.resetProjectF7(mainOrgUnitBox, mainOrgUnitBox2, projectBox, status, false);
                    }
                }
            }
        });
    }

    private static String getprojectIds(KDBizPromptBox projectBox) {
        StringBuffer ids = new StringBuffer();
        ProjectInfo projectInfo = new ProjectInfo();
        if (projectBox != null && projectBox.getValue() != null) {
            Object[] projects;
            boolean isnull;
            Object boxVal = projectBox.getValue();
            if (boxVal instanceof ProjectInfo) {
                projectInfo = (ProjectInfo)boxVal;
                ids.append("'").append(projectInfo.getId().toString()).append("'");
            } else if (boxVal instanceof Object[] && !(isnull = SCMUtils.containsAllIsNull((Object[])(projects = (Object[])boxVal)))) {
                int size = projects.length;
                for (int i = 0; i < size; ++i) {
                    projectInfo = (ProjectInfo)projects[i];
                    if (i == 0) {
                        ids.append("'").append(projectInfo.getId().toString()).append("'");
                        continue;
                    }
                    ids.append(",'").append(projectInfo.getId().toString()).append("'");
                }
            }
        }
        return ids.toString();
    }

    private static void resetTrackNumberF7(KDBizPromptBox mainOrgUnitBox, KDBizPromptBox mainOrgUnitBox2, KDBizPromptBox projectBox, KDBizPromptBox trackNumberBox, HashSet status, boolean isControlByProject) {
        String ids = null;
        if (projectBox != null && projectBox.getValue() != null) {
            ids = UIHelper.getprojectIds(projectBox);
        }
        UIHelper.resetTrackNumberF7(mainOrgUnitBox, mainOrgUnitBox2, ids, projectBox, trackNumberBox, status, false, isControlByProject);
    }

    private static void resetTrackNumberF7(KDBizPromptBox mainOrgUnitBox, KDBizPromptBox mainOrgUnitBox2, String ids, KDBizPromptBox projectBox, KDBizPromptBox trackNumberBox, HashSet status, boolean isProjectAddnew, boolean isControlByProject) {
        String sql;
        trackNumberBox.setDisplayFormat("$number$");
        trackNumberBox.setEditFormat("$number$");
        trackNumberBox.setCommitFormat("$number$");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        trackNumberBox.setHasCUDefaultFilter(true);
        if (isProjectAddnew) {
            filterInfo.getFilterItems().add(new FilterItemInfo("defaultTraceNumberFlag", (Object)new Integer(2), CompareType.EQUALS));
        }
        if (!isProjectAddnew) {
            if (ids != null && ids.length() > 0) {
                sql = "select FTrackNumberID from T_MM_ProjectCar where FProjectID in ( " + ids + ")";
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)sql, CompareType.INNER));
            }
        } else {
            sql = "select FTrackNumberID from T_MM_ProjectCar where FTrackNumberID is not null";
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)sql, CompareType.NOTINNER));
        }
        if (status != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)status, CompareType.INCLUDE));
        }
        FilterInfo filter2 = null;
        if (mainOrgUnitBox2 != null) {
            CtrlUnitInfo cu2 = UIHelper.getMainOrgCU(mainOrgUnitBox2);
            ObjectUuidPK cuPK = null;
            cuPK = cu2 == null ? new ObjectUuidPK(BOSUuid.create((BOSObjectType)new ProjectInfo().getBOSType())) : new ObjectUuidPK(cu2.getId());
            try {
                filter2 = TrackNumberFactory.getRemoteInstance().getDatabaseDFilter((IObjectPK)cuPK, "id", "CU.id");
            }
            catch (EASBizException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        if (filter2 != null) {
            try {
                filterInfo.mergeFilter(filter2, "and");
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        viewInfo.setFilter(filterInfo);
        boolean ismulSelect = UIHelper.isMulSelect(mainOrgUnitBox);
        CtrlUnitInfo cu = UIHelper.getMainOrgCU(mainOrgUnitBox);
        if (!ismulSelect) {
            trackNumberBox.setCurrentCtrlUnit(cu);
            FilterInfo filter3 = null;
            ObjectUuidPK cuPK = null;
            cuPK = cu == null ? new ObjectUuidPK(BOSUuid.create((BOSObjectType)new ProjectInfo().getBOSType())) : new ObjectUuidPK(cu.getId());
            try {
                filter3 = TrackNumberFactory.getRemoteInstance().getDatabaseDFilter((IObjectPK)cuPK, "id", "CU.id");
            }
            catch (EASBizException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            trackNumberBox.getQueryAgent().setDefaultFilterInfo(filter3);
        } else {
            trackNumberBox.getQueryAgent().setDefaultFilterInfo(null);
        }
        trackNumberBox.getQueryAgent().setHasCUDefaultFilter(false);
        trackNumberBox.setEntityViewInfo(viewInfo);
        trackNumberBox.getQueryAgent().resetRuntimeEntityView();
    }

    private static boolean isMulSelect(KDBizPromptBox mainOrgUnitBox) {
        boolean ismulSelect = false;
        if (mainOrgUnitBox != null && mainOrgUnitBox.getValue() != null) {
            Object[] orgs;
            Object boxVal = mainOrgUnitBox.getValue();
            if (boxVal instanceof Object[] && (orgs = (Object[])boxVal).length > 1) {
                ismulSelect = true;
            }
        } else if (mainOrgUnitBox != null && mainOrgUnitBox.getValue() == null) {
            ismulSelect = true;
        }
        return ismulSelect;
    }

    public static void registerTrackNumberF7ForFilter(KDBizPromptBox mainOrgUnitBox, KDBizPromptBox trackNumberBox) {
        HashSet<Integer> status = new HashSet<Integer>();
        status.add(new Integer(10));
        status.add(new Integer(80));
        UIHelper.registerTrackNumberF7(mainOrgUnitBox, null, null, trackNumberBox, status, false);
    }

    public static void registerTrackNumberF7ForFilter(KDBizPromptBox mainOrgUnitBox, KDBizPromptBox trackNumberBox, boolean isMulSelect) {
        HashSet<Integer> status = new HashSet<Integer>();
        status.add(new Integer(10));
        status.add(new Integer(80));
        trackNumberBox.setEnabledMultiSelection(isMulSelect);
        UIHelper.registerTrackNumberF7(mainOrgUnitBox, null, null, trackNumberBox, status, false);
    }

    public static void registerTrackNumberF7ForFilter(KDBizPromptBox mainOrgUnitBox, KDBizPromptBox projectBox, KDBizPromptBox trackNumberBox, boolean isMulSelect) {
        HashSet<Integer> status = new HashSet<Integer>();
        status.add(new Integer(10));
        status.add(new Integer(80));
        trackNumberBox.setEnabledMultiSelection(isMulSelect);
        UIHelper.registerTrackNumberF7(mainOrgUnitBox, null, projectBox, trackNumberBox, status, false);
    }

    public static void registerTrackNumberF7ForEdit(KDBizPromptBox mainOrgUnitBox, KDBizPromptBox mainOrgUnitBox2, KDBizPromptBox projectBox, KDBizPromptBox trackNumberBox, boolean isAutoCreateNew) {
        HashSet<Integer> status = new HashSet<Integer>();
        status.add(new Integer(10));
        UIHelper.registerTrackNumberF7(mainOrgUnitBox, mainOrgUnitBox2, projectBox, trackNumberBox, status, isAutoCreateNew);
    }

    public static void registerTrackNumberF7ForEdit(KDBizPromptBox mainOrgUnitBox, KDBizPromptBox mainOrgUnitBox2, KDBizPromptBox projectBox, KDBizPromptBox trackNumberBox, boolean isAutoCreateNew, boolean isMulSelect) {
        trackNumberBox.setEnabledMultiSelection(isMulSelect);
        HashSet<Integer> status = new HashSet<Integer>();
        status.add(new Integer(10));
        UIHelper.registerTrackNumberF7(mainOrgUnitBox, mainOrgUnitBox2, projectBox, trackNumberBox, status, isAutoCreateNew);
    }

    public static void registerTrackNumberF7ForProjectEdit(final KDBizPromptBox mainOrgUnitBox, final KDBizPromptBox mainOrgUnitBox2, final KDBizPromptBox projectBox, final KDBizPromptBox trackNumberBox, final boolean isAutoCreateNew, boolean isProjectAddNew, boolean isMulSelect, final boolean isControlByProject) {
        trackNumberBox.setEnabledMultiSelection(isMulSelect);
        final HashSet<Integer> status = new HashSet<Integer>();
        status.add(new Integer(10));
        trackNumberBox.setDisplayFormat("$number$");
        trackNumberBox.setEditFormat("$number$");
        trackNumberBox.setCommitFormat("$number$");
        String tracNumber = null;
        try {
            UISettingFactory ui = UISettingFactory.getInstance();
            tracNumber = ui.getTrackNumDisPlayName();
        }
        catch (BOSException e2) {
            ExceptionHandler.handle((Throwable)e2);
        }
        catch (Exception e2) {
            ExceptionHandler.handle((Throwable)e2);
        }
        if (tracNumber != null && tracNumber.equals(EASResource.getString((String)"com.kingdee.eas.mm.basedata.TrackNumberResource", (String)"TrackNumber"))) {
            trackNumberBox.setQueryInfo("com.kingdee.eas.mm.basedata.app.TrackNumberQuery");
        } else {
            trackNumberBox.setQueryInfo("com.kingdee.eas.mm.basedata.app.TrackNumber2Query");
        }
        trackNumberBox.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent paramCommitEvent) {
                UIHelper.resetTrackNumberF7ForProject(mainOrgUnitBox, mainOrgUnitBox2, projectBox, trackNumberBox, status, isControlByProject);
                if (isAutoCreateNew) {
                    RuleStatus ruleStatus = null;
                    try {
                        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
                        ruleStatus = codingRuleManager.getRuleStatus((IObjectValue)new TrackNumberInfo(), ((OrgUnitInfo)mainOrgUnitBox.getValue()).getId().toString());
                    }
                    catch (EASBizException e1) {
                        ExceptionHandler.handle((Throwable)e1);
                    }
                    catch (BOSException e1) {
                        ExceptionHandler.handle((Throwable)e1);
                    }
                    if (!(ruleStatus != null && ruleStatus.isExist() || projectBox == null || projectBox.getValue() != null || paramCommitEvent.getText() == null)) {
                        try {
                            TrackNumberInfo tracknumberInfo = TrackNumberFactory.getRemoteInstance().checknumber(paramCommitEvent.getText(), UIHelper.getMainOrgCU(mainOrgUnitBox));
                            if (tracknumberInfo.getStatus().equals((Object)MMBasedataStatusEnum.SAVED)) {
                                trackNumberBox.setValue((Object)tracknumberInfo);
                            } else {
                                trackNumberBox.setValue(null);
                                String str = EASResource.getString((String)"com.kingdee.eas.mm.basedata.TrackNumberResource", (String)"TrackNumber_Closed");
                                MsgBox.showConfirm2((String)str);
                            }
                        }
                        catch (EASBizException e) {
                            ExceptionHandler.handle((Throwable)e);
                        }
                        catch (BOSException e) {
                            ExceptionHandler.handle((Throwable)e);
                        }
                        paramCommitEvent.setCanceled(true);
                    }
                }
            }
        });
        trackNumberBox.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                UIHelper.resetTrackNumberF7ForProject(mainOrgUnitBox, mainOrgUnitBox2, projectBox, trackNumberBox, status, isControlByProject);
            }
        });
    }

    private static void resetTrackNumberF7ForProject(KDBizPromptBox mainOrgUnitBox, KDBizPromptBox mainOrgUnitBox2, KDBizPromptBox projectBox, KDBizPromptBox trackNumberBox, HashSet status, boolean isControlByProject) {
        String ids = null;
        if (projectBox != null && projectBox.getValue() != null) {
            ids = UIHelper.getprojectIds(projectBox);
        }
        UIHelper.resetTrackNumberF7(mainOrgUnitBox, mainOrgUnitBox2, ids, projectBox, trackNumberBox, status, true, isControlByProject);
    }

    public static void registerTrackNumberF7(KDBizPromptBox mainOrgUnitBox, KDBizPromptBox mainOrgUnitBox2, KDBizPromptBox projectBox, KDBizPromptBox trackNumberBox, HashSet status, boolean isAutoCreateNew) {
        UIHelper.registerTrackNumberF7(mainOrgUnitBox, mainOrgUnitBox2, projectBox, trackNumberBox, status, isAutoCreateNew, true);
    }

    public static void registerTrackNumberF7(final KDBizPromptBox mainOrgUnitBox, final KDBizPromptBox mainOrgUnitBox2, final KDBizPromptBox projectBox, final KDBizPromptBox trackNumberBox, final HashSet status, final boolean isAutoCreateNew, final boolean isControlByProject) {
        trackNumberBox.setDisplayFormat("$number$");
        trackNumberBox.setEditFormat("$number$");
        trackNumberBox.setCommitFormat("$number$");
        String tracNumber = null;
        try {
            UISettingFactory ui = UISettingFactory.getInstance();
            tracNumber = ui.getTrackNumDisPlayName();
        }
        catch (BOSException e2) {
            ExceptionHandler.handle((Throwable)e2);
        }
        catch (Exception e2) {
            ExceptionHandler.handle((Throwable)e2);
        }
        if (tracNumber != null && tracNumber.equals(EASResource.getString((String)"com.kingdee.eas.mm.basedata.TrackNumberResource", (String)"TrackNumber"))) {
            trackNumberBox.setQueryInfo("com.kingdee.eas.mm.basedata.app.TrackNumberQuery");
        } else {
            trackNumberBox.setQueryInfo("com.kingdee.eas.mm.basedata.app.TrackNumber2Query");
        }
        trackNumberBox.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent paramCommitEvent) {
                UIHelper.resetTrackNumberF7(mainOrgUnitBox, mainOrgUnitBox2, projectBox, trackNumberBox, status, isControlByProject);
                if (isAutoCreateNew) {
                    RuleStatus ruleStatus = null;
                    try {
                        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
                        ruleStatus = codingRuleManager.getRuleStatus((IObjectValue)new TrackNumberInfo(), ((OrgUnitInfo)mainOrgUnitBox.getValue()).getId().toString());
                    }
                    catch (EASBizException e1) {
                        ExceptionHandler.handle((Throwable)e1);
                    }
                    catch (BOSException e1) {
                        ExceptionHandler.handle((Throwable)e1);
                    }
                    if (!(ruleStatus != null && ruleStatus.isExist() || projectBox == null || projectBox.getValue() != null || paramCommitEvent.getText() == null)) {
                        try {
                            TrackNumberInfo tracknumberInfo = TrackNumberFactory.getRemoteInstance().checknumber(paramCommitEvent.getText(), UIHelper.getMainOrgCU(mainOrgUnitBox));
                            if (tracknumberInfo.getStatus().equals((Object)MMBasedataStatusEnum.SAVED)) {
                                trackNumberBox.setValue((Object)tracknumberInfo);
                            } else {
                                trackNumberBox.setValue(null);
                                String str = EASResource.getString((String)"com.kingdee.eas.mm.basedata.TrackNumberResource", (String)"TrackNumber_Closed");
                                MsgBox.showConfirm2((String)str);
                            }
                        }
                        catch (EASBizException e) {
                            ExceptionHandler.handle((Throwable)e);
                        }
                        catch (BOSException e) {
                            ExceptionHandler.handle((Throwable)e);
                        }
                        paramCommitEvent.setCanceled(true);
                    }
                }
            }
        });
        trackNumberBox.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                UIHelper.resetTrackNumberF7(mainOrgUnitBox, mainOrgUnitBox2, projectBox, trackNumberBox, status, isControlByProject);
            }
        });
    }

    public static void registerTrackNumberF7(KDBizPromptBox mainOrgUnitBox, KDBizPromptBox mainOrgUnitBox2, KDTable table, String projectCol, String trackNumberCol, boolean isAutoCreateNew) {
        UIHelper.registerTrackNumberF7(mainOrgUnitBox, mainOrgUnitBox2, table, projectCol, trackNumberCol, isAutoCreateNew, false);
    }

    public static void registerTrackNumberF7(final KDBizPromptBox mainOrgUnitBox, final KDBizPromptBox mainOrgUnitBox2, final KDTable table, final String projectCol, final String trackNumberCol, final boolean isAutoCreateNew, boolean isMulSelect) {
        String tracNumber = null;
        try {
            UISettingFactory ui = UISettingFactory.getInstance();
            tracNumber = ui.getTrackNumDisPlayName();
        }
        catch (BOSException e2) {
            ExceptionHandler.handle((Throwable)e2);
        }
        catch (Exception e2) {
            ExceptionHandler.handle((Throwable)e2);
        }
        KDBizPromptBox bizTrackBox = null;
        bizTrackBox = new KDBizPromptBox();
        bizTrackBox.setEnabledMultiSelection(isMulSelect);
        bizTrackBox.setEditFormat("$number$");
        bizTrackBox.setDisplayFormat("$number$");
        bizTrackBox.setCommitFormat("$number$");
        bizTrackBox.setEditable(true);
        if (tracNumber != null && tracNumber.equals(EASResource.getString((String)"com.kingdee.eas.mm.basedata.TrackNumberResource", (String)"TrackNumber"))) {
            bizTrackBox.setQueryInfo("com.kingdee.eas.mm.basedata.app.TrackNumberQuery");
        } else {
            bizTrackBox.setQueryInfo("com.kingdee.eas.mm.basedata.app.TrackNumber2Query");
        }
        table.getColumn(trackNumberCol).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizTrackBox));
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        table.getColumn(trackNumberCol).setRenderer((IBasicRender)avr);
        final HashSet<Integer> status = new HashSet<Integer>();
        status.add(new Integer(10));
        bizTrackBox.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent paramCommitEvent) {
                if (isAutoCreateNew) {
                    int rowIndex;
                    RuleStatus ruleStatus = null;
                    try {
                        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
                        ruleStatus = codingRuleManager.getRuleStatus((IObjectValue)new TrackNumberInfo(), ((OrgUnitInfo)mainOrgUnitBox.getValue()).getId().toString());
                    }
                    catch (EASBizException e1) {
                        ExceptionHandler.handle((Throwable)e1);
                    }
                    catch (BOSException e1) {
                        ExceptionHandler.handle((Throwable)e1);
                    }
                    if (!(ruleStatus != null && ruleStatus.isExist() || (rowIndex = table.getSelectManager().getActiveRowIndex()) < 0)) {
                        KDBizPromptBox projectBox = null;
                        if (table.getColumn(projectCol) != null && table.getColumn(projectCol).getEditor() != null) {
                            ICellEditor cellEditor = table.getColumn(projectCol).getEditor();
                            projectBox = (KDBizPromptBox)cellEditor.getComponent();
                        }
                        boolean isaddnew = false;
                        if (projectCol == null) {
                            isaddnew = true;
                        } else if (projectBox != null && projectBox.getValue() == null && table.getCell(rowIndex, projectCol).getValue() == null) {
                            isaddnew = true;
                        }
                        if (isaddnew && paramCommitEvent.getText() != null) {
                            try {
                                TrackNumberInfo tracknumberInfo = TrackNumberFactory.getRemoteInstance().checknumber(paramCommitEvent.getText(), UIHelper.getMainOrgCU(mainOrgUnitBox));
                                if (tracknumberInfo.getStatus().equals((Object)MMBasedataStatusEnum.SAVED)) {
                                    table.getCell(rowIndex, trackNumberCol).setValue((Object)tracknumberInfo);
                                } else {
                                    table.getCell(rowIndex, trackNumberCol).setValue(null);
                                    String str = EASResource.getString((String)"com.kingdee.eas.mm.basedata.TrackNumberResource", (String)"TrackNumber_Closed");
                                    MsgBox.showConfirm2((String)str);
                                }
                            }
                            catch (EASBizException e) {
                                ExceptionHandler.handle((Throwable)e);
                            }
                            catch (BOSException e) {
                                ExceptionHandler.handle((Throwable)e);
                            }
                            paramCommitEvent.isCanceled();
                        }
                    }
                }
            }
        });
        table.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                int rowIndex = e.getRowIndex();
                if (rowIndex >= 0) {
                    boolean isDiffrent;
                    int colIndex = e.getColIndex();
                    if (projectCol != null && table.getColumn(projectCol).getColumnIndex() == colIndex && (isDiffrent = SCMGroupClientUtils.isDiffrent((Object)e.getValue(), (Object)e.getOldValue()))) {
                        table.getCell(rowIndex, trackNumberCol).setValue(null);
                    }
                }
            }
        });
        table.addKDTActiveCellListener(new KDTActiveCellListener(){

            public void activeCellChanged(KDTActiveCellEvent e) {
                int rowIndex = table.getSelectManager().getActiveRowIndex();
                if (rowIndex >= 0) {
                    int colIndex = table.getSelectManager().getActiveColumnIndex();
                    if (table.getColumn(trackNumberCol).getColumnIndex() == colIndex) {
                        ICellEditor cellEditor;
                        KDBizPromptBox projectBox = null;
                        if (projectCol != null && table.getColumn(projectCol) != null && table.getColumn(projectCol).getEditor() != null) {
                            cellEditor = table.getColumn(projectCol).getEditor();
                            projectBox = (KDBizPromptBox)cellEditor.getComponent();
                        }
                        if ((cellEditor = table.getColumn(trackNumberCol).getEditor()) != null) {
                            KDBizPromptBox trackNumberBox = (KDBizPromptBox)cellEditor.getComponent();
                            String ids = null;
                            if (projectCol != null) {
                                ICell cell = table.getCell(rowIndex, projectCol);
                                ids = UIHelper.getprojectIds(cell);
                                UIHelper.resetTrackNumberF7(mainOrgUnitBox, mainOrgUnitBox2, ids, projectBox, trackNumberBox, status, false, true);
                            } else {
                                UIHelper.resetTrackNumberF7(mainOrgUnitBox, mainOrgUnitBox2, ids, null, trackNumberBox, status, true, true);
                            }
                        }
                    }
                }
            }
        });
    }

    private static String getprojectIds(ICell cell) {
        Object[] projects;
        boolean isnull;
        StringBuffer ids = new StringBuffer();
        ProjectInfo projectInfo = new ProjectInfo();
        Object boxVal = cell.getValue();
        if (boxVal instanceof ProjectInfo) {
            projectInfo = (ProjectInfo)boxVal;
            ids.append("'").append(projectInfo.getId().toString()).append("'");
        } else if (boxVal instanceof Object[] && !(isnull = SCMUtils.containsAllIsNull((Object[])(projects = (Object[])boxVal)))) {
            int size = projects.length;
            for (int i = 0; i < size; ++i) {
                projectInfo = (ProjectInfo)projects[i];
                if (i == 0) {
                    ids.append("'").append(projectInfo.getId().toString()).append("'");
                    continue;
                }
                ids.append(",'").append(projectInfo.getId().toString()).append("'");
            }
        }
        return ids.toString();
    }

    public static void registerTrackNumberF7New(CoreUI uiObject, final KDBizPromptBox mainOrgUnitBox, final KDBizPromptBox projectBox, final KDBizPromptBox trackNumberBox, final HashSet status) {
        UIHelper.setTrackNumberBoxProperty(mainOrgUnitBox, projectBox, trackNumberBox);
        trackNumberBox.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent paramCommitEvent) {
                String ids = UIHelper.getprojectIds(projectBox);
                UIHelper.resetTrackNumberF7(mainOrgUnitBox, null, ids, projectBox, trackNumberBox, status, false, true);
            }
        });
        trackNumberBox.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                String ids = UIHelper.getprojectIds(projectBox);
                UIHelper.resetTrackNumberF7(mainOrgUnitBox, null, ids, projectBox, trackNumberBox, status, false, true);
            }
        });
    }

    public static void registerTrackNumberF7New(CoreUI uiObject, final KDBizPromptBox mainOrgUnitBox, final KDTable table, final String projectCol, String trackNumberCol, final HashSet status) {
        final KDBizPromptBox trackNumberBox = new KDBizPromptBox();
        KDBizPromptBox projectBox = null;
        if (table.getColumn(projectCol) != null && table.getColumn(projectCol).getEditor() != null) {
            ICellEditor cellEditor = table.getColumn(projectCol).getEditor();
            projectBox = (KDBizPromptBox)cellEditor.getComponent();
        }
        UIHelper.setTrackNumberBoxProperty(mainOrgUnitBox, projectBox, trackNumberBox);
        table.getColumn(trackNumberCol).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)trackNumberBox));
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        table.getColumn(trackNumberCol).setRenderer((IBasicRender)avr);
        trackNumberBox.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent paramCommitEvent) {
                ICell icell = null;
                if (table.getColumn(projectCol) != null && table.getColumn(projectCol).getEditor() != null) {
                    int activeRow = table.getSelectManager().getActiveRowIndex();
                    icell = table.getCell(activeRow, projectCol);
                }
                String ids = UIHelper.getprojectIds(icell);
                UIHelper.resetTrackNumberF7(mainOrgUnitBox, null, ids, null, trackNumberBox, status, false, true);
                if (MMUtils.isEmptyString(ids)) {
                    return;
                }
                TrackNumberProcessor processor = (TrackNumberProcessor)trackNumberBox.getCommitParser();
                KDBizPromptBox projectNumberF7 = processor.getProjectNumberF7();
                if (projectNumberF7 != null) {
                    ProjectInfo projectInfo = (ProjectInfo)projectNumberF7.getData();
                    if (projectInfo != null && MMUtils.isNotEmptyString(projectInfo.getId().toString())) {
                        return;
                    }
                    Object boxVal = null;
                    if (null != icell) {
                        boxVal = icell.getValue();
                        if (boxVal instanceof ProjectInfo) {
                            projectInfo = (ProjectInfo)boxVal;
                        } else if (boxVal instanceof Object[]) {
                            Object[] projects = (Object[])boxVal;
                            projectInfo = (ProjectInfo)projects[0];
                        }
                    }
                    projectNumberF7.setData((Object)projectInfo);
                    processor.setProjectNumberF7(projectNumberF7);
                }
            }
        });
        trackNumberBox.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                ICell icell = null;
                if (table.getColumn(projectCol) != null && table.getColumn(projectCol).getEditor() != null) {
                    int activeRow = table.getSelectManager().getActiveRowIndex();
                    icell = table.getCell(activeRow, projectCol);
                }
                String ids = UIHelper.getprojectIds(icell);
                UIHelper.resetTrackNumberF7(mainOrgUnitBox, null, ids, null, trackNumberBox, status, false, true);
            }
        });
    }

    private static void setTrackNumberBoxProperty(KDBizPromptBox mainOrgUnitBox, KDBizPromptBox projectBox, KDBizPromptBox trackNumberBox) {
        trackNumberBox.setDisplayFormat("$number$");
        trackNumberBox.setEditFormat("$number$");
        trackNumberBox.setCommitFormat("$number$");
        trackNumberBox.setEnabledMultiSelection(true);
        String tracNumber = null;
        try {
            UISettingFactory ui = UISettingFactory.getInstance();
            tracNumber = ui.getTrackNumDisPlayName();
        }
        catch (BOSException e2) {
            ExceptionHandler.handle((Throwable)e2);
        }
        catch (Exception e2) {
            ExceptionHandler.handle((Throwable)e2);
        }
        if (tracNumber != null && tracNumber.equals(EASResource.getString((String)"com.kingdee.eas.mm.basedata.TrackNumberResource", (String)"TrackNumber"))) {
            trackNumberBox.setQueryInfo("com.kingdee.eas.mm.basedata.app.TrackNumber3Query");
        } else {
            trackNumberBox.setQueryInfo("com.kingdee.eas.mm.basedata.app.TrackNumber4Query");
        }
        TrackNumberProcessor processor = new TrackNumberProcessor(mainOrgUnitBox, projectBox, trackNumberBox);
        trackNumberBox.setSelector((KDPromptSelector)processor);
        trackNumberBox.setCommitParser((IParser)processor);
    }

    private static void openTrackNumberListUI(String sql, Map uiContext) {
        IUIWindow uiWindow = null;
        String uiName = TrackNumberListUI.class.getName();
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(uiName, uiContext, null, OprtState.VIEW);
            TrackNumberListUI listUI = (TrackNumberListUI)uiWindow.getUIObject();
            listUI.setIsNeedDefaultFilter(false);
            listUI.setUITitle(EASResource.getString((String)"com.kingdee.eas.mm.common.MMResource", (String)"VIEW_BOM_TRACKNUMBER"));
            listUI.disableToolbarBtn();
            uiWindow.show();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)sql, CompareType.INNER));
            listUI.getMainQuery().setFilter(filterInfo);
            listUI.refreshList();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public static void openTrackNumberListUIforBom(String bomId, Map uiContext) {
        String sql = "select FTrackID from T_MM_OrderBomPT where FOrderID='" + bomId + "'";
        UIHelper.openTrackNumberListUI(sql, uiContext);
    }

    public static void openTrackNumberListUIforBomChange(String entryId, boolean isRequest, Map uiContext) {
        String sql = null;
        sql = isRequest ? "select FTrackNumberID from T_MM_ProjectChangeReqPT where FProjChangeReqEntryID='" + entryId + "'" : "select FTrackNumberID from T_MM_ProjectChangeOldPT where FProjChangeEntryID='" + entryId + "'";
        UIHelper.openTrackNumberListUI(sql, uiContext);
    }

    public static void openTrackNumberListUIforBomEntry(String bomEntryId, Map uiContext) {
        String sql = "select FTrackID from T_MM_BomPT where FBomEntryId='" + bomEntryId + "'";
        UIHelper.openTrackNumberListUI(sql, uiContext);
    }

    public static void registerTrackNumberF7New(CoreUI uiObject, final KDBizPromptBox mainOrgUnitBox, KDTable table, final KDBizPromptBox projectBox, String trackNumberCol, final HashSet status) {
        final KDBizPromptBox trackNumberBox = new KDBizPromptBox();
        UIHelper.setTrackNumberBoxProperty(mainOrgUnitBox, projectBox, trackNumberBox);
        table.getColumn(trackNumberCol).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)trackNumberBox));
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        table.getColumn(trackNumberCol).setRenderer((IBasicRender)avr);
        trackNumberBox.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent paramCommitEvent) {
                String ids = UIHelper.getprojectIds(projectBox);
                UIHelper.resetTrackNumberF7(mainOrgUnitBox, null, ids, projectBox, trackNumberBox, status, false, true);
            }
        });
        trackNumberBox.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                String ids = UIHelper.getprojectIds(projectBox);
                UIHelper.resetTrackNumberF7(mainOrgUnitBox, null, ids, projectBox, trackNumberBox, status, false, true);
            }
        });
    }

    public static String getAlias(Object enumObj, int val) {
        YesOrNoEnum yORn;
        String name = null;
        if (enumObj.equals(MaterialAttributeEnum.class)) {
            MaterialAttributeEnum maEnum = MaterialAttributeEnum.getEnum((int)val);
            if (maEnum != null) {
                name = maEnum.getAlias();
            }
        } else if (enumObj.equals(ConsumeTypeEnum.class)) {
            ConsumeTypeEnum ctEnum = ConsumeTypeEnum.getEnum((int)val);
            if (ctEnum != null) {
                name = ctEnum.getAlias();
            }
        } else if (enumObj.equals(MaterialProductEnum.class)) {
            MaterialProductEnum mpEnum = MaterialProductEnum.getEnum((int)val);
            if (mpEnum != null) {
                name = mpEnum.getAlias();
            }
        } else if (enumObj.equals(MaterialCharEnum.class)) {
            MaterialCharEnum mtEnum = MaterialCharEnum.getEnum((int)val);
            if (mtEnum != null) {
                name = mtEnum.getAlias();
            }
        } else if (enumObj.equals(MaterialIssueModeEnum.class)) {
            MaterialIssueModeEnum miEnum = MaterialIssueModeEnum.getEnum((int)val);
            if (miEnum != null) {
                name = miEnum.getAlias();
            }
        } else if (enumObj.equals(YesOrNoEnum.class) && (yORn = YesOrNoEnum.getEnum((int)val)) != null) {
            name = yORn.getAlias();
        }
        return name;
    }

    public static void setIssueModeSelect(KDComboBox cboxPickingMode) {
        HashSet<MaterialIssueModeEnum> modeSet = new HashSet<MaterialIssueModeEnum>();
        modeSet.add(MaterialIssueModeEnum.PRODUCEISSMODE);
        modeSet.add(MaterialIssueModeEnum.STRAIGHT);
        modeSet.add(MaterialIssueModeEnum.NOTISSMODE);
        int count = cboxPickingMode.getItemCount();
        MaterialIssueModeEnum mode = null;
        for (int i = 0; i < count; ++i) {
            mode = (MaterialIssueModeEnum)cboxPickingMode.getItemAt(i);
            if (mode == null || modeSet.contains(mode)) continue;
            cboxPickingMode.removeItem((Object)mode);
            --i;
            count = cboxPickingMode.getItemCount();
        }
    }

    public static void registerTrackNumberF7(final KDBizPromptBox mainOrgUnitBox, final KDBizPromptBox mainOrgUnitBox2, final KDBizPromptBox projectBox, final KDBizPromptBox trackNumberBox, final HashSet status, final boolean isAutoCreateNew, final boolean isControlByProject, final String defaultTrackNumberID) {
        trackNumberBox.setDisplayFormat("$number$");
        trackNumberBox.setEditFormat("$number$");
        trackNumberBox.setCommitFormat("$number$");
        String tracNumber = null;
        try {
            UISettingFactory ui = UISettingFactory.getInstance();
            tracNumber = ui.getTrackNumDisPlayName();
        }
        catch (BOSException e2) {
            ExceptionHandler.handle((Throwable)e2);
        }
        catch (Exception e2) {
            ExceptionHandler.handle((Throwable)e2);
        }
        if (tracNumber != null && tracNumber.equals(EASResource.getString((String)"com.kingdee.eas.mm.basedata.TrackNumberResource", (String)"TrackNumber"))) {
            trackNumberBox.setQueryInfo("com.kingdee.eas.mm.basedata.app.TrackNumberQuery");
        } else {
            trackNumberBox.setQueryInfo("com.kingdee.eas.mm.basedata.app.TrackNumber2Query");
        }
        trackNumberBox.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent paramCommitEvent) {
                UIHelper.resetTrackNumberF7(mainOrgUnitBox, mainOrgUnitBox2, projectBox, trackNumberBox, status, isControlByProject, defaultTrackNumberID);
                if (isAutoCreateNew) {
                    RuleStatus ruleStatus = null;
                    try {
                        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
                        ruleStatus = codingRuleManager.getRuleStatus((IObjectValue)new TrackNumberInfo(), ((OrgUnitInfo)mainOrgUnitBox.getValue()).getId().toString());
                    }
                    catch (EASBizException e1) {
                        ExceptionHandler.handle((Throwable)e1);
                    }
                    catch (BOSException e1) {
                        ExceptionHandler.handle((Throwable)e1);
                    }
                    if (!(ruleStatus != null && ruleStatus.isExist() || projectBox == null || projectBox.getValue() != null || paramCommitEvent.getText() == null)) {
                        try {
                            TrackNumberInfo tracknumberInfo = TrackNumberFactory.getRemoteInstance().checknumber(paramCommitEvent.getText(), UIHelper.getMainOrgCU(mainOrgUnitBox));
                            if (tracknumberInfo.getStatus().equals((Object)MMBasedataStatusEnum.SAVED)) {
                                trackNumberBox.setValue((Object)tracknumberInfo);
                            } else {
                                trackNumberBox.setValue(null);
                                String str = EASResource.getString((String)"com.kingdee.eas.mm.basedata.TrackNumberResource", (String)"TrackNumber_Closed");
                                MsgBox.showConfirm2((String)str);
                            }
                        }
                        catch (EASBizException e) {
                            ExceptionHandler.handle((Throwable)e);
                        }
                        catch (BOSException e) {
                            ExceptionHandler.handle((Throwable)e);
                        }
                        paramCommitEvent.setCanceled(true);
                    }
                }
            }
        });
        trackNumberBox.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                UIHelper.resetTrackNumberF7(mainOrgUnitBox, mainOrgUnitBox2, projectBox, trackNumberBox, status, isControlByProject, defaultTrackNumberID);
            }
        });
    }

    private static void resetTrackNumberF7(KDBizPromptBox mainOrgUnitBox, KDBizPromptBox mainOrgUnitBox2, KDBizPromptBox projectBox, KDBizPromptBox trackNumberBox, HashSet status, boolean isControlByProject, String defaultTrackNumberID) {
        String sql;
        String ids = null;
        FilterInfo defaultTrackNumber = new FilterInfo();
        if (projectBox != null && projectBox.getValue() != null) {
            ids = UIHelper.getprojectIds(projectBox);
        }
        trackNumberBox.setDisplayFormat("$number$");
        trackNumberBox.setEditFormat("$number$");
        trackNumberBox.setCommitFormat("$number$");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        trackNumberBox.setHasCUDefaultFilter(false);
        if (defaultTrackNumberID != null) {
            defaultTrackNumber.getFilterItems().add(new FilterItemInfo("id", (Object)defaultTrackNumberID, CompareType.EQUALS));
        }
        if (!isControlByProject) {
            if (ids != null && ids.length() > 0) {
                sql = "select FTrackNumberID from T_MM_ProjectCar where FProjectID in ( " + ids + ")";
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)sql, CompareType.INNER));
            }
        } else {
            sql = "select FTrackNumberID from T_MM_ProjectCar where FTrackNumberID is not null";
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)sql, CompareType.NOTINNER));
        }
        if (status != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)status, CompareType.INCLUDE));
        }
        FilterInfo filter2 = null;
        if (mainOrgUnitBox2 != null) {
            CtrlUnitInfo cu2 = UIHelper.getMainOrgCU(mainOrgUnitBox2);
            ObjectUuidPK cuPK = null;
            cuPK = cu2 == null ? new ObjectUuidPK(BOSUuid.create((BOSObjectType)new ProjectInfo().getBOSType())) : new ObjectUuidPK(cu2.getId());
            try {
                filter2 = TrackNumberFactory.getRemoteInstance().getDatabaseDFilter((IObjectPK)cuPK, "id", "CU.id");
            }
            catch (EASBizException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        if (filter2 != null) {
            try {
                filterInfo.mergeFilter(filter2, "and");
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        try {
            filterInfo.mergeFilter(defaultTrackNumber, "or");
        }
        catch (BOSException e1) {
            ExceptionHandler.handle((Throwable)e1);
        }
        viewInfo.setFilter(filterInfo);
        boolean ismulSelect = UIHelper.isMulSelect(mainOrgUnitBox);
        CtrlUnitInfo cu = UIHelper.getMainOrgCU(mainOrgUnitBox);
        if (!ismulSelect) {
            trackNumberBox.setCurrentCtrlUnit(cu);
            FilterInfo filter3 = null;
            ObjectUuidPK cuPK = null;
            cuPK = cu == null ? new ObjectUuidPK(BOSUuid.create((BOSObjectType)new ProjectInfo().getBOSType())) : new ObjectUuidPK(cu.getId());
            try {
                filter3 = TrackNumberFactory.getRemoteInstance().getDatabaseDFilter((IObjectPK)cuPK, "id", "CU.id");
            }
            catch (EASBizException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            trackNumberBox.getQueryAgent().setDefaultFilterInfo(filter3);
        } else {
            trackNumberBox.getQueryAgent().setDefaultFilterInfo(null);
        }
        trackNumberBox.getQueryAgent().setHasCUDefaultFilter(false);
        trackNumberBox.setEntityViewInfo(viewInfo);
        trackNumberBox.getQueryAgent().resetRuntimeEntityView();
    }
}

