/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.common.client.dynamiccolumn;

import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.mm.common.client.dynamiccolumn.DynamicColumnTableInfo;
import com.kingdee.eas.mm.common.client.dynamiccolumn.DynamicKey;
import com.kingdee.eas.mm.common.client.dynamiccolumn.DynamicKeyCollection;
import com.kingdee.eas.mm.common.client.dynamiccolumn.DynamicValueInfo;
import com.kingdee.eas.util.client.EASResource;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class DynamicColumnBuilder {
    private static final Logger logger = Logger.getLogger(DynamicColumnBuilder.class);
    private KDTable kdEntrys;
    private DynamicColumnTableInfo info;
    private DynamicKeyCollection dynamickList = new DynamicKeyCollection();
    private int oldCols = -1;
    private HashMap mapData = new HashMap();

    public HashMap getMapData() {
        return this.mapData;
    }

    public DynamicColumnBuilder(KDTable kdEntrys, DynamicColumnTableInfo header) {
        this.kdEntrys = kdEntrys;
        this.info = header;
        this.oldCols = kdEntrys.getColumnCount();
    }

    public void addDynamicKey(DynamicKey dynamicKey) {
        this.dynamickList.add(dynamicKey);
    }

    public void buildDynamicColumn() {
        this.removeDynamicColumn();
        if (this.info.isShowValueCaption() && this.kdEntrys.getHeadRowCount() < 2) {
            this.kdEntrys.addHeadRow();
        }
        for (int i = 0; i < this.dynamickList.size(); ++i) {
            DynamicKey dynamicKey = this.dynamickList.get(i);
            ArrayList valueList = this.info.getValueFieldInfo();
            int left = 0;
            int right = 0;
            for (int j = 0; j < valueList.size(); ++j) {
                IRow row;
                DynamicValueInfo dynamicValueInfo = (DynamicValueInfo)valueList.get(j);
                String key = this.getUniqueKey(dynamicKey, dynamicValueInfo);
                this.kdEntrys.addColumn().setKey(key);
                if (j == 0) {
                    row = this.kdEntrys.getHeadRow(0);
                    row.getCell(key).setValue((Object)dynamicKey.getCaption());
                    left = this.kdEntrys.getColumnCount() - 1;
                }
                if (!this.info.isShowValueCaption()) continue;
                row = this.kdEntrys.getHeadRow(1);
                row.getCell(key).setValue((Object)dynamicValueInfo.getValueCaption());
                right = this.kdEntrys.getColumnCount() - 1;
            }
            if (right <= left) continue;
            this.kdEntrys.getHeadMergeManager().mergeBlock(0, left, 0, right);
        }
    }

    public void removeDynamicColumn() {
        if (this.oldCols > 0) {
            for (int i = this.kdEntrys.getColumnCount() - 1; i >= this.oldCols; --i) {
                this.kdEntrys.removeColumn(i);
            }
        }
    }

    public void storeFields(IObjectCollection d1, Class claz) throws InstantiationException, IllegalAccessException {
        for (int i = 0; i < d1.size(); ++i) {
            IObjectValue vo = d1.getObject(i);
            if (vo.getBOSUuid(vo.getPKField()) == null) {
                vo.setBOSUuid(vo.getPKField(), BOSUuid.create((BOSObjectType)vo.getBOSType()));
            }
            IRow row = this.kdEntrys.getRow(i);
            for (int j = 0; j < this.dynamickList.size(); ++j) {
                DynamicKey dynamicKey = this.dynamickList.get(j);
                ArrayList list = this.info.getValueFieldInfo();
                IObjectValue voD2 = this.getObjectValue(vo.getBOSUuid(vo.getPKField()).toString(), dynamicKey, claz);
                boolean isExistsValue = false;
                for (int k = 0; k < list.size(); ++k) {
                    DynamicValueInfo valueInfo = (DynamicValueInfo)list.get(k);
                    String key = this.getUniqueKey(dynamicKey, valueInfo);
                    Object value = row.getCell(key).getValue();
                    if (value == null) continue;
                    isExistsValue = true;
                    voD2.put(valueInfo.getValueField(), row.getCell(key).getValue());
                }
                if (isExistsValue) {
                    this.putDyanamicKeyToObjectValue(dynamicKey, voD2);
                    voD2.put(this.info.getParentField(), (Object)vo);
                    continue;
                }
                this.removeObjectValue(vo.getBOSUuid(vo.getPKField()).toString(), dynamicKey);
            }
        }
    }

    private void putDyanamicKeyToObjectValue(DynamicKey dynamicKey, IObjectValue voD2) {
        voD2.put(this.info.getCaptionField(), (Object)dynamicKey.getCaption());
        voD2.put(this.info.getKeyField(), (Object)dynamicKey.getKey());
        dynamicKey.putOtherFields(voD2);
    }

    private void removeObjectValue(String parentID, DynamicKey dynamicKey) {
        HashMap map;
        Object object = this.mapData.get(parentID);
        if (object != null && (map = new HashMap()).containsKey(dynamicKey.getKey())) {
            map.remove(dynamicKey.getKey());
        }
    }

    public DynamicKey getDynamicKey(String key) throws Exception {
        return this.checkDynamicKeyExists(key);
    }

    public String getUniqueKey(DynamicKey dynamicKey, DynamicValueInfo valueInfo) {
        String key = dynamicKey.getKey() + valueInfo.getValueField();
        return key;
    }

    public IObjectValue getObjectValue(String parentID, DynamicKey dynamicKey, Class claz) throws InstantiationException, IllegalAccessException {
        HashMap<String, IObjectValue> map;
        Object object = this.mapData.get(parentID);
        if (object == null) {
            map = new HashMap<String, IObjectValue>();
            this.mapData.put(parentID, map);
        } else {
            map = (HashMap<String, IObjectValue>)object;
        }
        String key = dynamicKey.getKey();
        if (map.containsKey(key)) {
            return (IObjectValue)map.get(key);
        }
        if (claz != null) {
            IObjectValue vo = (IObjectValue)claz.newInstance();
            map.put(key, vo);
            return vo;
        }
        return null;
    }

    public IObjectValue getObjectValue(String parentID, DynamicKey dynamicKey) throws InstantiationException, IllegalAccessException {
        return this.getObjectValue(parentID, dynamicKey, null);
    }

    public DynamicKeyCollection loadDynamicData(IObjectCollection d2) {
        this.mapData.clear();
        this.dynamickList.clear();
        HashSet<String> keySet = new HashSet<String>();
        for (int i = 0; i < d2.size(); ++i) {
            HashMap<String, IObjectValue> map;
            IObjectValue value = d2.getObject(i);
            IObjectValue parentObj = (IObjectValue)value.get(this.info.getParentField());
            if (parentObj != null) {
                String parentID = parentObj.getBOSUuid(parentObj.getPKField()).toString();
                map = (HashMap<String, IObjectValue>)this.mapData.get(parentID);
                if (map == null) {
                    map = new HashMap<String, IObjectValue>();
                    this.mapData.put(parentID, map);
                }
            } else {
                logger.error((Object)EASResource.getString((String)"com.kingdee.eas.mm.common.COMMONAutoGenerateResource", (String)"1_DynamicColumnBuilder"));
                return null;
            }
            String key = value.get(this.info.getKeyField()).toString();
            map.put(key, value);
            if (keySet.contains(key)) continue;
            String caption = value.get(this.info.getCaptionField()).toString();
            DynamicKey dynamicKey = new DynamicKey();
            dynamicKey.setKey(key);
            dynamicKey.setCaption(caption);
            this.dynamickList.add(dynamicKey);
            keySet.add(key);
        }
        return this.dynamickList;
    }

    public void loadFields() {
        for (int j = 0; j < this.kdEntrys.getRowCount(); ++j) {
            IRow row = this.kdEntrys.getRow(j);
            IObjectValue vo = (IObjectValue)row.getUserObject();
            this.loadLineFields(row, vo);
        }
    }

    public void loadLineFields(IRow row, IObjectValue vo) {
        HashMap map = (HashMap)this.mapData.get(vo.getBOSUuid(vo.getPKField()).toString());
        if (map != null) {
            for (int i = 0; i < this.dynamickList.size(); ++i) {
                DynamicKey dynamicKey = this.dynamickList.get(i);
                if (!map.containsKey(dynamicKey.getKey())) continue;
                IObjectValue voD2 = (IObjectValue)map.get(dynamicKey.getKey());
                this.loadOneDynamicFields(row, dynamicKey, voD2);
            }
        }
    }

    private void loadOneDynamicFields(IRow row, DynamicKey dynamicKey, IObjectValue voD2) {
        ArrayList valueInfoList = this.info.getValueFieldInfo();
        for (int k = 0; k < valueInfoList.size(); ++k) {
            DynamicValueInfo dynamicValueInfo = (DynamicValueInfo)valueInfoList.get(k);
            ICell cell = row.getCell(this.getUniqueKey(dynamicKey, dynamicValueInfo));
            if (cell == null) continue;
            cell.setValue(voD2.get(dynamicValueInfo.getValueField()));
        }
    }

    public DynamicColumnTableInfo getDynamicKeyInfo() {
        return this.info;
    }

    public void onCopyBill(IObjectCollection d1) {
        for (int i = 0; i < d1.size(); ++i) {
            IObjectValue value = d1.getObject(i);
            if (value.getBOSUuid(value.getPKField()) != null) continue;
            value.setBOSUuid(value.getPKField(), BOSUuid.create((BOSObjectType)value.getBOSType()));
        }
        Iterator it = this.mapData.values().iterator();
        while (it.hasNext()) {
            HashMap map = (HashMap)it.next();
            Iterator itValues = map.values().iterator();
            while (it.hasNext()) {
                IObjectValue value = (IObjectValue)itValues.next();
                value.setBOSUuid(value.getPKField(), null);
            }
        }
    }

    public Object removeOneLine(String parentID) {
        if (this.mapData.containsKey(parentID)) {
            return this.mapData.remove(parentID);
        }
        return null;
    }

    public Object addOneLine(String parentID) {
        if (!this.mapData.containsKey(parentID)) {
            HashMap map = new HashMap();
            this.mapData.put(parentID, map);
            return map;
        }
        return null;
    }

    public void addCellObjectVaue(String parentID, DynamicKey dynamicKey, IObjectValue objectValue) throws Exception {
        if (!this.mapData.containsKey(parentID)) {
            MessageFormat format = BOSLocaleUtil.getMessageFormat((String)"{0}{1}");
            String message = format.format(new Object[]{EASResource.getString((String)"com.kingdee.eas.mm.common.COMMONAutoGenerateResource", (String)"2_DynamicColumnBuilder"), parentID});
            throw new Exception(message);
        }
        this.putDyanamicKeyToObjectValue(dynamicKey, objectValue);
        HashMap map = (HashMap)this.mapData.get(parentID);
        map.put(dynamicKey.getKey(), objectValue);
    }

    private DynamicKey checkDynamicKeyExists(String key) throws Exception {
        if (this.dynamickList.containsKey(key)) {
            return this.dynamickList.get(key);
        }
        MessageFormat format = BOSLocaleUtil.getMessageFormat((String)"{0}{1}{2}");
        String message = format.format(new Object[]{EASResource.getString((String)"com.kingdee.eas.mm.common.COMMONAutoGenerateResource", (String)"3_DynamicColumnBuilder"), key, EASResource.getString((String)"com.kingdee.eas.mm.common.COMMONAutoGenerateResource", (String)"4_DynamicColumnBuilder")});
        throw new Exception(message);
    }

    public DynamicKeyCollection getDynamicKeyCollection() {
        return this.dynamickList;
    }

    public String[] getDynamicColumnKeys(DynamicValueInfo[] valueInfos) {
        if (valueInfos.length > 0) {
            String[] keys = new String[this.dynamickList.size() * valueInfos.length];
            for (int i = 0; i < this.dynamickList.size(); ++i) {
                DynamicKey dynamicKey = this.dynamickList.get(i);
                for (int j = 0; j < valueInfos.length; ++j) {
                    keys[i * valueInfos.length + j] = this.getUniqueKey(dynamicKey, valueInfos[j]);
                }
            }
            return keys;
        }
        return null;
    }
}

