/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.common.client.tableutils;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeListener;
import com.kingdee.eas.mm.common.client.tableutils.ChangeHandler;
import com.kingdee.eas.mm.common.client.tableutils.RowChangeInfo;
import java.math.BigDecimal;
import java.util.HashMap;

public class CellChangeListener
implements KDTPropertyChangeListener {
    private HashMap changedRows = new HashMap();
    private KDTable table;
    private BigDecimal ZERO = new BigDecimal("0");
    ChangeHandler changeHandler;
    private int listenSinceCol;

    public void setChangeHandler(ChangeHandler handler) {
        this.changeHandler = handler;
    }

    public void setKDTable(KDTable table) {
        this.table = table;
    }

    public void propertyChange(KDTPropertyChangeEvent evt) {
        if (evt.getType() == 1 && evt.getPropertyName().equals("cellValue")) {
            if (evt.getColIndex() <= this.listenSinceCol) {
                return;
            }
            if (evt.getRowIndex() % 4 == 3) {
                return;
            }
            Integer rowIndex = new Integer(evt.getRowIndex());
            int colIndex = evt.getColIndex();
            BigDecimal oldValue = (BigDecimal)evt.getOldValue();
            BigDecimal newValue = (BigDecimal)evt.getNewValue();
            if (newValue == null) {
                newValue = this.ZERO;
            }
            if (evt.getOldValue() == null || oldValue.compareTo(newValue) != 0) {
                RowChangeInfo row = (RowChangeInfo)this.changedRows.get(rowIndex);
                if (row == null) {
                    row = new RowChangeInfo(rowIndex);
                    this.changedRows.put(rowIndex, row);
                }
                row.addChangedCell(this.table.getColumnKey(colIndex), (BigDecimal)evt.getOldValue(), (BigDecimal)evt.getNewValue());
            }
        }
    }

    public void submitChanges() throws Exception {
        if (this.changeHandler.submitAll(this.changedRows)) {
            this.changedRows.clear();
        }
    }

    public int getListenSinceCol() {
        return this.listenSinceCol;
    }

    public void setListenSinceCol(int listenSinceCol) {
        this.listenSinceCol = listenSinceCol;
    }

    public boolean isThereDataNotSaved() {
        return this.changedRows.size() > 0;
    }
}

