/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.common.client.tableutils;

import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.eas.mm.common.client.tableutils.DeducedValueUtil;
import com.kingdee.eas.mm.common.client.tableutils.DetailObject;
import com.kingdee.eas.mm.common.client.tableutils.DynamicColumn;
import com.kingdee.eas.mm.common.client.tableutils.DynamicColumnMap;
import com.kingdee.eas.mm.common.client.tableutils.DynamicFields;
import com.kingdee.eas.mm.common.client.tableutils.DynamicLeftHeader;
import com.kingdee.eas.mm.common.client.tableutils.DynamicStyleEnum;
import com.kingdee.eas.mm.common.client.tableutils.FieldDefinition;
import com.kingdee.eas.mm.common.client.tableutils.LeftHeaderObject;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class DynamicEditTable
implements KDTPropertyChangeListener {
    private static final Logger logger = Logger.getLogger(DynamicEditTable.class);
    private KDTable kdtable;
    private DynamicFields dynFields;
    private DynamicColumnMap dynColumns;
    private DynamicStyleEnum dynamicStyle;
    DynamicLeftHeader dynHeader;
    private SortedMap mapData = new TreeMap();
    private Map key2rowMap = new HashMap();
    private Map key2sumMap = new HashMap();
    private int originColCount = -1;
    private boolean isDisplaySumColumn;
    private final String sumFieldKey = "internal-sum";
    private String sumFieldCaption;
    private final String fieldTypeKey = "internal-fieldtype";
    private String fieldTypeCaption;
    private Map precision2editorMap = new HashMap();
    private Color lockedColor = new Color(238, 250, 255);
    private Color defaultColor = new Color(255, 255, 255);
    private DeducedValueUtil deducedUtil;
    private static BigDecimal ZERO = new BigDecimal("0.0");

    public void initTable(DynamicLeftHeader dynHeader, DynamicFields dynFields, DeducedValueUtil util) {
        this.dynHeader = dynHeader;
        this.dynFields = dynFields;
        this.deducedUtil = util;
    }

    public DynamicEditTable(KDTable kdtable, boolean isDisplaySumColumn) {
        this.kdtable = kdtable;
        this.originColCount = kdtable.getColumnCount();
        this.isDisplaySumColumn = isDisplaySumColumn;
    }

    private void removeDynamicColumn() {
        if (this.originColCount > 0) {
            for (int i = this.kdtable.getColumnCount() - 1; i >= this.originColCount; --i) {
                this.kdtable.removeColumn(i);
            }
        }
    }

    private DetailObject createDetailObject(IRowSet rs) throws SQLException {
        DetailObject obj = new DetailObject(this.dynFields.getFieldDefCount());
        obj.setFromData(true);
        obj.setKey(rs.getString(this.dynFields.getKeyField()));
        for (int i = 0; i < this.dynFields.getFieldDefCount(); ++i) {
            FieldDefinition fieldDef = this.dynFields.getFieldDef(i);
            if (fieldDef.isDeducedValue()) continue;
            BigDecimal bd = rs.getBigDecimal(fieldDef.getValueField());
            if (bd == null) {
                obj.setPropertyByIndex(i, ZERO);
                continue;
            }
            obj.setPropertyByIndex(i, bd);
        }
        return obj;
    }

    public int getColumnCountBeforeDynamic() {
        int count = this.dynHeader.getFieldsCount();
        if (this.isDisplaySumColumn) {
            ++count;
        }
        if (this.dynamicStyle == DynamicStyleEnum.ROW) {
            ++count;
        }
        return count;
    }

    private int getColumnIndex(Set colSet, String element) {
        Iterator it = colSet.iterator();
        int i = -1;
        while (it.hasNext()) {
            ++i;
            String curElement = (String)((Map.Entry)it.next()).getKey();
            if (!curElement.equals(element)) continue;
            break;
        }
        if (this.dynamicStyle == DynamicStyleEnum.COLUMN) {
            return i * this.dynFields.getFieldDefCount() + this.getColumnCountBeforeDynamic();
        }
        return i + this.getColumnCountBeforeDynamic();
    }

    private void removeDynamicColumns() {
        int index = this.dynHeader.getFieldsCount();
        for (int i = this.kdtable.getColumnCount() - 1; i >= index; --i) {
            this.kdtable.removeColumn(index);
        }
    }

    public void buildTableHead() throws SQLException {
        if (this.dynamicStyle == DynamicStyleEnum.COLUMN && this.kdtable.getHeadRowCount() < 2) {
            this.kdtable.addHeadRow();
        }
    }

    public void buildDynamicColumn() throws SQLException {
        Set colSet = this.dynColumns.entrySet();
        Iterator it = colSet.iterator();
        while (it.hasNext()) {
            DynamicColumn col = (DynamicColumn)((Map.Entry)it.next()).getValue();
            this.appendOneDynamicColumn(this.dynColumns.entrySet(), col);
        }
    }

    public DynamicColumnMap loadDataAndFillTable(boolean isGetDynColumnsFromData, IRowSet rs) throws SQLException {
        this.kdtable.removeRows();
        this.mapData.clear();
        this.key2rowMap.clear();
        this.removeDynamicColumns();
        this.buildFieldTypeColumn();
        this.buildSumColumn();
        if (isGetDynColumnsFromData) {
            if (this.dynColumns != null) {
                this.dynColumns.clear();
            } else {
                this.dynColumns = new DynamicColumnMap();
            }
        }
        TreeMap<String, DetailObject> keyMap = new TreeMap<String, DetailObject>();
        rs.beforeFirst();
        while (rs.next()) {
            HashMap<String, DetailObject> map;
            String headKey = rs.getString(this.dynFields.getParentField());
            LeftHeaderObject headObj = (LeftHeaderObject)this.mapData.get(headKey);
            if (headObj == null) {
                map = new HashMap<String, DetailObject>();
                headObj = new LeftHeaderObject(headKey, map, this.dynHeader.getFieldsCount());
                this.mapData.put(headKey, headObj);
            }
            map = headObj.getDetails();
            DetailObject obj = this.createDetailObject(rs);
            map.put(obj.getKey(), obj);
            if (!isGetDynColumnsFromData || keyMap.containsKey(obj.getKey())) continue;
            DynamicColumn info = new DynamicColumn();
            info.setKey(obj.getKey());
            info.setCaption(obj.getKey());
            this.dynColumns.add(info);
            keyMap.put(obj.getKey(), obj);
            this.appendOneDynamicColumn(keyMap.entrySet(), info);
        }
        if (!isGetDynColumnsFromData) {
            this.buildDynamicColumn();
            this.loadHeadObject();
        }
        return this.dynColumns;
    }

    public DynamicColumnMap appendData(IRowSet rs) throws SQLException {
        rs.beforeFirst();
        while (rs.next()) {
            HashMap<String, DetailObject> map;
            String headKey = rs.getString(this.dynFields.getParentField());
            LeftHeaderObject headObj = (LeftHeaderObject)this.mapData.get(headKey);
            if (headObj == null) {
                map = new HashMap<String, DetailObject>();
                headObj = new LeftHeaderObject(headKey, map, this.dynHeader.getFieldsCount());
                this.mapData.put(headKey, headObj);
            }
            map = headObj.getDetails();
            DetailObject obj = this.createDetailObject(rs);
            map.put(obj.getKey(), obj);
        }
        this.loadHeadObject();
        return this.dynColumns;
    }

    public void loadHeadObject() throws SQLException {
        this.dynHeader.getRowSet().beforeFirst();
        while (this.dynHeader.getRowSet().next()) {
            String headKey = this.dynHeader.getCurRowId();
            LeftHeaderObject headObj = (LeftHeaderObject)this.mapData.get(headKey);
            if (headObj != null) continue;
            HashMap map = new HashMap();
            headObj = new LeftHeaderObject(headKey, map, this.dynHeader.getFieldsCount());
            this.mapData.put(headKey, headObj);
        }
    }

    public DynamicFields getDynFields() {
        return this.dynFields;
    }

    public DynamicColumnMap getDynColumns() {
        return this.dynColumns;
    }

    private void appendOneDynamicColumn(Set colSet, DynamicColumn dynCol) throws SQLException {
        int colIndex = this.getColumnIndex(colSet, dynCol.getKey());
        IColumn col = this.kdtable.addColumn(colIndex);
        col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        col.setKey(this.getUniqueKey(dynCol, this.dynFields.getFieldDef(0)));
        IRow row = this.kdtable.getHeadRow(0);
        String dynColKey = null;
        dynColKey = this.dynFields.getFieldDefCount() == 1 ? this.getUniqueKey(dynCol, this.dynFields.getFieldDef(0)) : dynCol.getKey();
        row.getCell(dynColKey).setValue((Object)dynCol.getCaption());
        int left = this.kdtable.getColumnCount() - 1;
        if (this.dynamicStyle == DynamicStyleEnum.COLUMN && this.dynFields.getFieldDefCount() > 1) {
            for (int j = 0; j < this.dynFields.getFieldDefCount(); ++j) {
                FieldDefinition fieldDef = this.dynFields.getFieldDef(j);
                String key = this.getUniqueKey(dynCol, fieldDef);
                this.kdtable.addColumn().setKey(key);
                row = this.kdtable.getHeadRow(1);
                row.getCell(key).setValue((Object)fieldDef.getValueCaption());
            }
            int right = this.kdtable.getColumnCount() - 1;
            if (right > left) {
                this.kdtable.getHeadMergeManager().mergeBlock(0, left, 0, right);
            }
        }
    }

    public void setDynamicColumnMap(DynamicColumnMap dynColMap) {
        this.dynColumns = dynColMap;
    }

    public void buildSumColumn() {
        if (this.isDisplaySumColumn) {
            if (this.dynamicStyle == DynamicStyleEnum.ROW) {
                IColumn col = this.kdtable.addColumn();
                col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                col.setKey("internal-sum");
                col.getStyleAttributes().setLocked(true);
                col.getStyleAttributes().setBackground(this.lockedColor);
                this.kdtable.getHeadRow(0).getCell("internal-sum").setValue((Object)this.sumFieldCaption);
            } else {
                for (int i = 0; i < this.dynFields.getFieldDefCount(); ++i) {
                    FieldDefinition fieldDef = this.dynFields.getFieldDef(i);
                    IColumn col = this.kdtable.addColumn();
                    String key = "internal-sum" + fieldDef.getValueField();
                    col.setKey(key);
                    col.getStyleAttributes().setLocked(true);
                    if (this.dynFields.getDisplayFieldCount() == 1) {
                        col.setKey("internal-sum");
                        this.kdtable.getHeadRow(0).getCell("internal-sum").setValue((Object)this.sumFieldCaption);
                        continue;
                    }
                    col.setKey(key);
                    this.kdtable.getHeadRow(0).getCell(key).setValue((Object)(fieldDef.getValueCaption() + this.sumFieldCaption));
                }
            }
        }
    }

    private void lockHeadObjectColumns() {
        for (int i = 0; i < this.kdtable.getRowCount(); ++i) {
            for (int j = 0; j < this.getColumnCountBeforeDynamic(); ++j) {
                StyleAttributes attr = this.kdtable.getCell(i, j).getStyleAttributes();
                attr.setLocked(true);
                attr.setBackground(this.lockedColor);
            }
        }
    }

    private void setCellAttribute(StyleAttributes attr, boolean isHide, boolean isLock) {
        attr.setHided(isHide);
        if (isLock) {
            attr.setBackground(this.lockedColor);
        } else {
            attr.setBackground(this.defaultColor);
        }
        attr.setLocked(isLock);
    }

    public void unlockDynamicColumns() {
        int fromColIndex = this.dynHeader.getFieldsCount();
        if (this.isDisplaySumColumn) {
            ++fromColIndex;
        }
        if (this.dynamicStyle == DynamicStyleEnum.ROW) {
            ++fromColIndex;
        }
        for (int i = fromColIndex - 1; i < this.kdtable.getColumnCount(); ++i) {
            this.kdtable.getColumn(i);
        }
    }

    public boolean isDisplayFieldTypeColumn() {
        return this.dynamicStyle == DynamicStyleEnum.ROW && this.dynFields.getFieldDefCount() > 1;
    }

    public void buildFieldTypeColumn() {
        if (this.isDisplayFieldTypeColumn()) {
            IColumn col = this.kdtable.addColumn();
            col.setKey("internal-fieldtype");
            col.getStyleAttributes().setLocked(true);
            col.getStyleAttributes().setBackground(this.lockedColor);
            this.kdtable.getHeadRow(0).getCell("internal-fieldtype").setValue((Object)this.fieldTypeCaption);
        }
    }

    public void fillTableWithDynamicData() throws Exception {
        if (this.mapData.size() == 0) {
            return;
        }
        this.dynHeader.getRowSet().beforeFirst();
        BigDecimal[] sumArray = new BigDecimal[this.dynFields.getFieldDefCount()];
        while (this.dynHeader.getRowSet().next()) {
            String headKey = this.dynHeader.getCurRowId();
            LeftHeaderObject headObj = (LeftHeaderObject)this.mapData.get(headKey);
            if (headObj == null) continue;
            for (int i = 0; i < sumArray.length; ++i) {
                sumArray[i] = ZERO;
            }
            this.fillOneLogicRow(sumArray, headObj);
        }
    }

    private void setBackGround4Row(IRow row) {
        if (this.dynFields.getDisplayFieldCount() > 1) {
            Color backColor = new Color(255, 255, 164);
            row.getStyleAttributes().setBackground(backColor);
        } else {
            this.resetBackGround4Row(row);
        }
    }

    private void resetBackGround4Row(IRow row) {
        Color backColor = new Color(255, 255, 255);
        row.getStyleAttributes().setBackground(backColor);
    }

    public KDFormattedTextField getEditor(int precision) {
        KDFormattedTextField bigDecimalEditor = (KDFormattedTextField)this.precision2editorMap.get(Integer.toString(precision));
        if (bigDecimalEditor == null) {
            bigDecimalEditor = new KDFormattedTextField();
            bigDecimalEditor.setDataType(1);
            bigDecimalEditor.setPrecision(precision);
            bigDecimalEditor.setRemoveingZeroInDispaly(true);
            bigDecimalEditor.setSupportedEmpty(true);
            bigDecimalEditor.setNegatived(false);
            bigDecimalEditor.setPercentDisplay(false);
            bigDecimalEditor.setHorizontalAlignment(4);
        }
        return bigDecimalEditor;
    }

    private void setEditor(int rowIndex, int precision) {
        int sumIndex = this.kdtable.getColumn("internal-sum").getColumnIndex();
        KDFormattedTextField editor = this.getEditor(precision);
        String formatPattern = SCMClientUtils.getFormatPattern((int)precision);
        for (int i = rowIndex; i < rowIndex + this.dynFields.getDisplayFieldCount(); ++i) {
            for (int j = sumIndex; j < this.kdtable.getColumnCount(); ++j) {
                IRow row = this.kdtable.getRow(i);
                ICell cell = row.getCell(j);
                cell.setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)editor));
                cell.getStyleAttributes().setNumberFormat(formatPattern);
            }
        }
    }

    private void fillOneLogicRow(BigDecimal[] sumArray, LeftHeaderObject headObj) throws Exception {
        IRow row = null;
        if (this.dynamicStyle == DynamicStyleEnum.COLUMN) {
            row = this.kdtable.addRow();
            this.fillLeftHeaderToRow(row, headObj);
        } else {
            for (int i = 0; i < this.dynFields.getFieldDefCount(); ++i) {
                FieldDefinition fieldDef = this.dynFields.getFieldDef(i);
                if (fieldDef.isHide()) continue;
                IRow curRow = this.kdtable.addRow();
                if (row == null) {
                    row = curRow;
                }
                this.fillLeftHeaderToRow(curRow, headObj);
                if (!this.isDisplayFieldTypeColumn()) continue;
                curRow.getCell("internal-fieldtype").setValue((Object)this.dynFields.getFieldDef(i).getValueCaption());
            }
        }
        if (row != null) {
            this.key2rowMap.put(headObj.getHeadKey(), row);
            this.fillDynamicColumn4CurLogicRow(row, headObj, sumArray);
            this.fillSumColumn(row, sumArray, headObj);
            this.setEditor(row.getRowIndex(), headObj.getDefaultPrecision());
        }
    }

    private LeftHeaderObject fillLeftHeaderToRow(IRow row, LeftHeaderObject headObj) throws SQLException {
        if (headObj != null) {
            headObj.setDefaultPrecision(this.dynHeader.getDefaultPrecision());
            for (int i = 0; i < this.dynHeader.getFieldsCount(); ++i) {
                String fieldVal = this.dynHeader.getField(i);
                row.getCell(i).setValue((Object)fieldVal);
                headObj.setField(i, fieldVal);
            }
        }
        return headObj;
    }

    private void fillDynamicColumn4CurLogicRow(IRow row, LeftHeaderObject headObj, BigDecimal[] sumArray) throws Exception {
        HashMap map;
        if (headObj != null && (map = headObj.getDetails()) != null) {
            Set set = this.dynColumns.entrySet();
            Iterator it = set.iterator();
            while (it.hasNext()) {
                DynamicColumn dynCol = (DynamicColumn)((Map.Entry)it.next()).getValue();
                if (!map.containsKey(dynCol.getKey())) continue;
                DetailObject obj = (DetailObject)map.get(dynCol.getKey());
                obj.setPrecision(headObj.getDefaultPrecision());
                this.fillOneDynamicColumn(row, dynCol, obj, sumArray);
            }
        }
    }

    public LeftHeaderObject getHeadObject(String key) {
        LeftHeaderObject headObj = (LeftHeaderObject)this.mapData.get(key);
        return headObj;
    }

    public static String formatNumericTypeData(int nPrecision, BigDecimal bdValue) throws Exception {
        NumberFormat format = BOSLocaleUtil.getDecimalFormat();
        format.setMaximumFractionDigits(nPrecision);
        format.setMinimumFractionDigits(nPrecision);
        return format.format(bdValue).toString();
    }

    private void fillOneDynamicColumn(IRow row, DynamicColumn dynCol, DetailObject obj, BigDecimal[] sumArray) throws Exception {
        int startRowIndex = row.getRowIndex();
        for (int i = 0; i < this.dynFields.getFieldDefCount(); ++i) {
            FieldDefinition fieldDef = this.dynFields.getFieldDef(i);
            if (fieldDef.isHide()) continue;
            ICell cell = null;
            if (this.dynamicStyle == DynamicStyleEnum.COLUMN) {
                cell = row.getCell(this.getUniqueKey(dynCol, fieldDef));
            } else {
                row = this.kdtable.getRow(startRowIndex++);
                cell = row.getCell(this.getUniqueKey(dynCol, fieldDef));
            }
            if (cell == null || fieldDef.isDeducedValue()) continue;
            BigDecimal bd = obj.getPropertyByIndex(i);
            sumArray[i] = sumArray[i].add(bd);
            cell.setValue((Object)bd);
        }
    }

    private void fillSumColumn(IRow row, BigDecimal[] sumArray, LeftHeaderObject headObj) throws Exception {
        int startRowIndex = row.getRowIndex();
        for (int i = 0; i < this.dynFields.getFieldDefCount(); ++i) {
            FieldDefinition fieldDef = this.dynFields.getFieldDef(i);
            if (!fieldDef.isSum() || fieldDef.isHide()) continue;
            ICell cell = null;
            if (this.dynamicStyle == DynamicStyleEnum.COLUMN) {
                cell = row.getCell("internal-sum");
            } else {
                row = this.kdtable.getRow(startRowIndex++);
                cell = row.getCell("internal-sum");
            }
            if (cell != null) {
                cell.setValue((Object)sumArray[i]);
            }
            this.key2sumMap.put(headObj.getHeadKey() + i, sumArray[i]);
        }
    }

    public void changeViewAppearance() {
        Set set = this.dynColumns.entrySet();
        int nFieldCount = this.dynFields.getFieldDefCount();
        IRow firstHeadRow = this.kdtable.getHeadRow(0);
        if (this.dynamicStyle == DynamicStyleEnum.ROW) {
            Iterator it = set.iterator();
            while (it.hasNext()) {
                DynamicColumn col = (DynamicColumn)((Map.Entry)it.next()).getValue();
                firstHeadRow.getCell(col.getKey()).setValue((Object)col.getCaption());
                int matIndex = -1;
                int fieldCountInTable = this.dynFields.getFieldCountInTable();
                Iterator it1 = this.mapData.entrySet().iterator();
                block1: while (it1.hasNext()) {
                    it1.next();
                    ++matIndex;
                    int fieldIndex = 0;
                    Object firstRowOfHead = null;
                    for (int j = 0; j < nFieldCount; ++j) {
                        FieldDefinition field = this.dynFields.getFieldDef(j);
                        if (!field.isFillTable()) continue;
                        int curRowIndex = matIndex * fieldCountInTable + fieldIndex;
                        ++fieldIndex;
                        if (curRowIndex >= this.kdtable.getRowCount()) continue block1;
                        this.kdtable.getColumn(col.getKey()).getStyleAttributes().setHided(col.isHide());
                        this.kdtable.getRow(curRowIndex).getStyleAttributes().setHided(field.isHide());
                        this.setCellAttribute(this.kdtable.getCell(curRowIndex, col.getKey()).getStyleAttributes(), col.isHide() || field.isHide(), col.isLock() || !field.isEditable() || field.isDeducedValue());
                    }
                }
            }
        }
        this.lockHeadObjectColumns();
    }

    public IRow getRowFromHeadObjKey(String key) {
        return (IRow)this.key2rowMap.get(key);
    }

    public String getUniqueKey(DynamicColumn dynCol, FieldDefinition fieldDef) {
        if (this.dynamicStyle == DynamicStyleEnum.COLUMN && this.dynFields.getDisplayFieldCount() > 1) {
            return dynCol.getKey() + fieldDef.getValueField();
        }
        return dynCol.getKey();
    }

    public void removeData(Set headObjIdSet) {
        for (String matId : headObjIdSet) {
            this.mapData.remove(matId);
            for (int i = this.kdtable.getRowCount() - 1; i >= 0; --i) {
                String curId = (String)this.kdtable.getCell(i, 0).getValue();
                if (!curId.equals(matId)) continue;
                this.kdtable.removeRow(i);
            }
        }
        this.key2rowMap.clear();
        if (headObjIdSet.size() > 0) {
            String lastId = "";
            for (int i = 0; i < this.kdtable.getRowCount(); ++i) {
                String id = (String)this.kdtable.getCell(i, 0).getValue();
                if (lastId.equals(id)) continue;
                lastId = id;
                this.key2rowMap.put(id, this.kdtable.getRow(i));
            }
        }
    }

    private void updateSum(int row, int col, BigDecimal oldValue, BigDecimal newValue) {
        if (this.dynamicStyle == DynamicStyleEnum.ROW) {
            if (col <= this.getColumnCountBeforeDynamic()) {
                return;
            }
            FieldDefinition field = this.dynFields.getFieldDef(row % this.dynFields.getFieldDefCount());
            if (field.isSum()) {
                BigDecimal sum = (BigDecimal)this.kdtable.getCell(row, "internal-sum").getValue();
                if (newValue != null) {
                    sum = sum.add(newValue);
                }
                if (oldValue != null) {
                    sum = sum.subtract(oldValue);
                }
                this.kdtable.getCell(row, "internal-sum").setValue((Object)sum);
            }
        }
    }

    public Map getMapData() {
        return this.mapData;
    }

    public void addDynamicColumn(DynamicColumn info) {
        this.dynColumns.add(info);
    }

    public DynamicStyleEnum getDynamicStyle() {
        return this.dynamicStyle;
    }

    public void setDynamicStyle(DynamicStyleEnum dynamicStyle) {
        this.dynamicStyle = dynamicStyle;
    }

    public void setKdtable(KDTable kdtable) {
        this.kdtable = kdtable;
    }

    public DynamicLeftHeader getDynHeader() {
        return this.dynHeader;
    }

    public void setDynHeader(DynamicLeftHeader dynHeader) {
        this.dynHeader = dynHeader;
    }

    public boolean isDisplaySumColumn() {
        return this.isDisplaySumColumn;
    }

    public void setDisplaySumColumn(boolean isDisplaySumColumn) {
        this.isDisplaySumColumn = isDisplaySumColumn;
    }

    public void setDeducedUtil(DeducedValueUtil deducedUtil) {
        this.deducedUtil = deducedUtil;
    }

    public void setDynFields(DynamicFields dynFields) {
        this.dynFields = dynFields;
    }

    public String getSumFieldCaption() {
        return this.sumFieldCaption;
    }

    public void setSumFieldCaption(String sumFieldCaption) {
        this.sumFieldCaption = sumFieldCaption;
    }

    public String getFieldTypeCaption() {
        return this.fieldTypeCaption;
    }

    public void setFieldTypeCaption(String fieldTypeCaption) {
        this.fieldTypeCaption = fieldTypeCaption;
    }

    public void propertyChange(KDTPropertyChangeEvent evt) {
        if (evt.getType() == 1 && evt.getPropertyName().equals("cellValue")) {
            this.updateSum(evt.getRowIndex(), evt.getColIndex(), (BigDecimal)evt.getOldValue(), (BigDecimal)evt.getNewValue());
        }
    }

    public ICell getSumCell(int rowIndex) {
        ICell sumCell = null;
        if (rowIndex < this.kdtable.getRowCount()) {
            sumCell = this.kdtable.getCell(rowIndex, "internal-sum");
        }
        return sumCell;
    }
}

