/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.common.util;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.util.Arrays;
import java.util.HashSet;

public class EditTableUtil {
    public static void addLine(KDTable table, IObjectValue detailData) {
        if (table == null) {
            return;
        }
        if (detailData != null) {
            IRow iRow = table.addRow();
        }
    }

    public static void removeLineNoMsg(KDTable table) {
        if (table == null) {
            return;
        }
        if (table.getSelectManager().size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        EditTableUtil.deleteTableLine(table);
    }

    public static void removeLine(KDTable table) {
        if (table == null) {
            return;
        }
        if (table.getSelectManager().size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        if (EditTableUtil.confirmRemove()) {
            EditTableUtil.deleteTableLine(table);
        }
    }

    private static void deleteTableLine(KDTable table) {
        KDTSelectManager selectManager = table.getSelectManager();
        int size = selectManager.size();
        KDTSelectBlock selectBlock = null;
        HashSet<Integer> indexSet = new HashSet<Integer>();
        for (int blockIndex = 0; blockIndex < size; ++blockIndex) {
            selectBlock = selectManager.get(blockIndex);
            int top = selectBlock.getBeginRow();
            int bottom = selectBlock.getEndRow();
            if (table.getRow(top) == null) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                return;
            }
            for (int i = top; i <= bottom; ++i) {
                indexSet.add(new Integer(i));
            }
        }
        Object[] indexArr = new Integer[indexSet.size()];
        Object[] indexObj = indexSet.toArray();
        System.arraycopy(indexObj, 0, indexArr, 0, indexArr.length);
        Arrays.sort(indexArr);
        if (indexArr == null) {
            return;
        }
        for (int i = indexArr.length - 1; i >= 0; --i) {
            int rowIndex = Integer.parseInt(String.valueOf(indexArr[i]));
            IObjectValue detailData = (IObjectValue)table.getRow(rowIndex).getUserObject();
            table.removeRow(rowIndex);
            IObjectCollection iObjectCollection = (IObjectCollection)table.getUserObject();
        }
        if (table.getRow(0) != null) {
            table.getSelectManager().select(0, 0);
        }
    }

    public static boolean confirmRemove() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")));
    }

    public static void insertLine(KDTable table, IObjectValue detailData) {
        if (table == null) {
            return;
        }
        IRow row = null;
        if (table.getSelectManager().size() > 0) {
            int top = table.getSelectManager().get().getTop();
            row = EditTableUtil.isTableColumnSelected(table) ? table.addRow() : table.addRow(top);
        } else {
            row = table.addRow();
        }
    }

    public static boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    public static void setColLock(KDTable kdtEntry, String[] colNames, boolean isLock) {
        if (kdtEntry != null && colNames != null) {
            int cols = colNames.length;
            for (int i = 0; i < cols; ++i) {
                kdtEntry.getColumn(colNames[i]).getStyleAttributes().setLocked(isLock);
            }
        }
    }

    public static void formatColDate(KDTable kdtEntry, String[] colNames) {
        if (kdtEntry != null && colNames != null) {
            int cols = colNames.length;
            for (int i = 0; i < cols; ++i) {
                kdtEntry.getColumn(colNames[i]).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
            }
        }
    }

    public static void formatColDateTime(KDTable kdtEntry, String[] colNames) {
        if (kdtEntry != null && colNames != null) {
            int cols = colNames.length;
            for (int i = 0; i < cols; ++i) {
                kdtEntry.getColumn(colNames[i]).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateTimeFormatString());
            }
        }
    }

    public static void formatColTime(KDTable kdtEntry, String[] colNames) {
        if (kdtEntry != null && colNames != null) {
            int cols = colNames.length;
            for (int i = 0; i < cols; ++i) {
                kdtEntry.getColumn(colNames[i]).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getTimeFormatString());
            }
        }
    }
}

