/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.common.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.ILocation;
import com.kingdee.eas.basedata.scm.im.inv.IMaterialStorageAssign;
import com.kingdee.eas.basedata.scm.im.inv.LocationFactory;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.LotRuleFactory;
import com.kingdee.eas.basedata.scm.im.inv.LotRuleInfo;
import com.kingdee.eas.basedata.scm.im.inv.MaterialStorageAssignFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.mm.basedata.BomViewOptionEnum;
import com.kingdee.eas.mm.basedata.BooleanAllEnum;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.scm.im.inv.ITransferRule2;
import com.kingdee.eas.scm.im.inv.SupplyRelationInfo;
import com.kingdee.eas.scm.im.inv.TransferRule2Factory;
import com.kingdee.eas.scm.im.inv.TransferRule2Info;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class MMUtils {
    public static final String[] BOOLEAN_ARRAY = new String[]{BooleanAllEnum.Yes.getAlias(), BooleanAllEnum.No.getAlias()};
    public static final String FORMAT = "yyyy-MM-dd";
    public static final String DISABLE_DATE = "2099-12-31";

    public static boolean checkExisted(String[] array, String value) {
        if (MMUtils.isEmptyString(value)) {
            return false;
        }
        for (int i = 0; i < array.length; ++i) {
            if (!value.trim().equals(array[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean checkExisted(int[] array, int value) {
        for (int i = 0; i < array.length; ++i) {
            if (value != array[i]) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmptyString(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static boolean isPositiveInteger(String number) {
        Pattern pattern = Pattern.compile("^\\+?[1-9][0-9]*$");
        Matcher matcher = pattern.matcher(number);
        return matcher.find();
    }

    public static boolean isNotEmptyString(String value) {
        return !MMUtils.isEmptyString(value);
    }

    public static String dateToString(Date date, String format) {
        if (date == null || MMUtils.isEmptyString(format)) {
            return null;
        }
        SimpleDateFormat dateFormater = new SimpleDateFormat(format);
        return dateFormater.format(date);
    }

    public static Date stringToDate(String date, String format) throws ParseException {
        SimpleDateFormat dateFormater = new SimpleDateFormat(format);
        return dateFormater.parse(date);
    }

    public static boolean isNumber(String number) {
        Pattern pattern = Pattern.compile("^(-?\\d+)(\\.\\d+)?$");
        Matcher matcher = pattern.matcher(number);
        return matcher.find();
    }

    public static String setToString(Set valueSet) {
        StringBuffer returnValue = new StringBuffer("(");
        if (valueSet != null && valueSet.size() != 0) {
            Iterator it = valueSet.iterator();
            boolean flag = false;
            String tempValue = null;
            Object obj = null;
            while (it.hasNext()) {
                obj = it.next();
                tempValue = obj instanceof String ? (String)obj : obj.toString();
                if (MMUtils.isEmptyString(tempValue)) continue;
                if (flag) {
                    returnValue.append(",");
                }
                returnValue.append("'");
                returnValue.append(tempValue);
                returnValue.append("'");
                flag = true;
            }
        } else {
            returnValue.append("'null'");
        }
        returnValue.append(")");
        return returnValue.toString();
    }

    public static String getResourceWithParam(String msg, Object[] params) {
        MessageFormat format = new MessageFormat(msg);
        return format.format(params);
    }

    public static String getResourceWithParam(String resource, String key, Locale local, String[] params) {
        String message = ResourceBase.getString((String)resource, (String)key, (Locale)local);
        return MMUtils.getResourceWithParam(message, params);
    }

    public static String setToString(Set valueSet, String compart) {
        if (valueSet == null || valueSet.size() == 0) {
            return "";
        }
        StringBuffer returnValue = new StringBuffer();
        Iterator it = valueSet.iterator();
        boolean flag = false;
        while (it.hasNext()) {
            if (flag) {
                returnValue.append(compart);
            }
            returnValue.append(it.next());
            flag = true;
        }
        return returnValue.toString();
    }

    public static boolean isSameStringValue(String str1, String str2) {
        if (str1 == null) {
            return str2 == null;
        }
        return str1.equals(str2);
    }

    public static String listToString(List ids) {
        StringBuffer idstring = new StringBuffer();
        idstring.append("'");
        for (int i = 0; i < ids.size(); ++i) {
            if (ids.get(i) == null) continue;
            idstring.append(ids.get(i).toString()).append("','");
        }
        idstring.append("'");
        return idstring.toString();
    }

    public static String createTmpTable(Context ctx, String sql) throws BOSException {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            String tableName = pool.createTempTable(sql);
            return tableName;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void releaseTmpTable(Context ctx, String tableName) {
        if (MMUtils.isEmptyString(tableName)) {
            return;
        }
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        pool.releaseTable(tableName);
    }

    public static boolean isIndexExists(Context ctx, String indexName) throws BOSException {
        String sql = "SELECT 1 WHERE EXISTS(SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = ? )";
        try {
            IRowSet rs = SQLUtils.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{indexName});
            return rs.next();
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    public static void createTableIndex(Context ctx, String tableName, String indexName, String[] fieldNames) throws BOSException {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < fieldNames.length; ++i) {
            if (sb.length() == 0) {
                sb.append(fieldNames[i]);
                continue;
            }
            sb.append(",").append(fieldNames[i]);
        }
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            pool.createIndex(tableName, sb.toString(), false, false);
        }
        catch (Exception e) {
            throw new BOSException("create temptable index error.");
        }
    }

    public static void createTableIndex(Context ctx, String tableName, String fieldName) throws BOSException {
        MMUtils.createTableIndex(ctx, tableName, new String[]{fieldName});
    }

    public static void createTableIndex(Context ctx, String tableName, String[] fieldNames) throws BOSException {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < fieldNames.length; ++i) {
            if (sb.length() == 0) {
                sb.append(fieldNames[i]);
                continue;
            }
            sb.append(",").append(fieldNames[i]);
        }
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            pool.createIndex(tableName, sb.toString(), false, false);
        }
        catch (Exception e) {
            throw new BOSException("create temptable index error.");
        }
    }

    public static String getTableIndexName(String tableName) {
        String indexName = "IX_" + tableName.substring(0, 15);
        return indexName;
    }

    public static boolean equalsZero(BigDecimal v) {
        return v == null || SysConstant.BIGZERO.compareTo(v) == 0;
    }

    public static Set getSupplyRelationOrgUnitSet(Context ctx, String reqOrgUnitId, String supplyOrgUnitId) throws BOSException {
        HashSet<String> orgSet = new HashSet<String>();
        ITransferRule2 rule = null;
        rule = ctx == null ? TransferRule2Factory.getRemoteInstance() : TransferRule2Factory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo item = new FilterItemInfo("supplyRelation.requireStorageOrgUnit.id", (Object)reqOrgUnitId, CompareType.EQUALS);
        filter.getFilterItems().add(item);
        if (MMUtils.isNotEmptyString(supplyOrgUnitId)) {
            item = new FilterItemInfo("supplyRelation.supplyStorageOrgUnit.id", (Object)supplyOrgUnitId, CompareType.EQUALS);
            filter.getFilterItems().add(item);
        }
        Integer status = new Integer(1);
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)status, CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add("supplyRelation.supplyStorageOrgUnit.id");
        view.setSelector(coll);
        CoreBaseCollection srColl = rule.getCollection(view);
        TransferRule2Info rule2 = null;
        if (srColl == null || srColl.size() == 0) {
            return null;
        }
        SupplyRelationInfo supplyRelationInfo = null;
        for (int i = 0; i < srColl.size(); ++i) {
            rule2 = (TransferRule2Info)srColl.get(i);
            supplyRelationInfo = rule2.getSupplyRelation();
            orgSet.add(supplyRelationInfo.getSupplyStorageOrgUnit().getId().toString());
        }
        return orgSet;
    }

    public static Set getPermissionStorageOrgUnitIdSet(Context ctx, String userId, String permissionItem) throws BOSException, EASBizException {
        OrgType orgType = OrgType.Storage;
        ObjectUuidPK treePK = new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgType)orgType));
        ObjectUuidPK userPK = new ObjectUuidPK(userId);
        IPermission ipermission = null;
        ipermission = ctx == null ? PermissionFactory.getRemoteInstance() : PermissionFactory.getLocalInstance((Context)ctx);
        FullOrgUnitCollection unitCol = ipermission.getAuthorizedOrg((IObjectPK)userPK, orgType, (IObjectPK)treePK, permissionItem);
        HashSet<String> orgSet = new HashSet<String>();
        if (unitCol != null && unitCol.size() > 0) {
            for (int i = 0; i < unitCol.size(); ++i) {
                orgSet.add(unitCol.get(i).getId().toString());
            }
        }
        return orgSet;
    }

    public static void checkPermission(Context ctx, String userId, String orgId, String permissionItem) throws BOSException, EASBizException {
        IPermission ipermission = PermissionFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK userPK = new ObjectUuidPK(userId);
        ObjectUuidPK orgPK = new ObjectUuidPK(orgId);
        ipermission.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)orgPK, permissionItem);
    }

    public static Set getCrossOrgMaterialSupplyOrgSet(Context ctx, Set inCrossOrgSet) throws BOSException, EASBizException {
        String sql = "select a.fid as material, b.forgunit as supplyorg ";
        sql = sql + " from T_BD_Material a right join T_bd_materialplan b on a.fid=b.fmaterialId and b.fstatus=1 ";
        sql = sql + " where a.fid= ? ";
        HashSet<String> middleCrossOrgSet = new HashSet<String>();
        for (String materialOrg : inCrossOrgSet) {
            String[] array = materialOrg.split("_");
            try {
                IRowSet rs = SQLUtils.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{array[0]});
                while (rs != null && rs.next()) {
                    String strIndex = rs.getString("material") + "_" + rs.getString("supplyorg");
                    if (middleCrossOrgSet.contains(strIndex)) continue;
                    middleCrossOrgSet.add(strIndex);
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        for (String tmp : middleCrossOrgSet) {
            if (!inCrossOrgSet.contains(tmp)) continue;
            inCrossOrgSet.remove(tmp);
        }
        return inCrossOrgSet;
    }

    public static boolean isHideMaterial(BomViewOptionEnum viewOption, Date compareDate, Date effectiveDate, Date disableDate) {
        if (BomViewOptionEnum.ALL_MATERIAL.equals((Object)viewOption)) {
            return false;
        }
        if (effectiveDate == null) {
            Calendar effectiveCalendar = Calendar.getInstance();
            effectiveCalendar.set(1900, 1, 1);
            effectiveCalendar.set(11, 0);
            effectiveCalendar.set(12, 0);
            effectiveCalendar.set(13, 0);
            effectiveCalendar.set(14, 0);
            effectiveDate = effectiveCalendar.getTime();
        }
        if (disableDate == null) {
            Calendar disableCalendar = Calendar.getInstance();
            disableCalendar.set(2099, 11, 31);
            disableCalendar.set(11, 0);
            disableCalendar.set(12, 0);
            disableCalendar.set(13, 0);
            disableCalendar.set(14, 0);
            disableDate = disableCalendar.getTime();
        }
        if (MMUtils.dateToString(effectiveDate, FORMAT).equals(MMUtils.dateToString(disableDate, FORMAT))) {
            return !BomViewOptionEnum.DISABLE_MATERIAL.equals((Object)viewOption);
        }
        return !(BomViewOptionEnum.CURRENT_MATERIAL.equals((Object)viewOption) || BomViewOptionEnum.QUERY_DATE_MATERIAL.equals((Object)viewOption) ? compareDate.compareTo(effectiveDate) >= 0 && compareDate.compareTo(disableDate) < 0 : (BomViewOptionEnum.DISABLE_MATERIAL.equals((Object)viewOption) ? compareDate.compareTo(disableDate) >= 0 : BomViewOptionEnum.WILL_MATERIAL.equals((Object)viewOption) && compareDate.compareTo(effectiveDate) < 0));
    }

    public static LotRuleInfo getProperLotRule(Context ctx, String materialID, String storageOrgUnitID) throws BOSException, EASBizException {
        IRowSet rsMaterial = null;
        IRowSet rsSou = null;
        IRowSet rsRuleByMaterial = null;
        IRowSet rsRuleByMGroup = null;
        try {
            StringBuffer sbSqlMaterial = new StringBuffer();
            sbSqlMaterial.append("SELECT mg.FLongNumber AS mgLongNumber ").append("FROM T_BD_Material m INNER JOIN T_BD_MaterialGroup mg ON m.FMaterialGroupID=mg.FID ").append("WHERE m.FID='").append(materialID).append("'");
            rsMaterial = SQLUtils.executeQuery((Context)ctx, (String)sbSqlMaterial.toString());
            String mgLongNumber = null;
            if (!rsMaterial.next()) {
                return null;
            }
            mgLongNumber = rsMaterial.getString("mgLongNumber");
            StringBuffer sbSqlSou = new StringBuffer();
            sbSqlSou.append("SELECT FLongNumber FROM T_ORG_Storage WHERE FID='").append(storageOrgUnitID).append("'");
            rsSou = SQLUtils.executeQuery((Context)ctx, (String)sbSqlSou.toString());
            String souLongNumber = null;
            if (!rsSou.next()) {
                return null;
            }
            souLongNumber = rsSou.getString("FLongNumber");
            Object[] mgLongNumbers = MMUtils.parseLongNumber(mgLongNumber);
            Object[] souLongNumbers = MMUtils.parseLongNumber(souLongNumber);
            StringBuffer sbSqlRuleByMaterial = new StringBuffer();
            sbSqlRuleByMaterial.append("SELECT TOP 1 lr.FID AS ruleID ").append("FROM T_IN_LotRule lr INNER JOIN T_BD_Material m ON lr.FBusinessObjectID = m.FID ").append("INNER JOIN T_ORG_Storage s ON lr.FSouID = s.FID ").append("WHERE FEnabled = 2 AND m.FID='").append(materialID).append("' AND s.FLongNumber IN (").append(SQLUtil.arrayToString(souLongNumbers)).append(") ORDER BY s.FLongNumber DESC");
            rsRuleByMaterial = SQLUtils.executeQuery((Context)ctx, (String)sbSqlRuleByMaterial.toString());
            if (rsRuleByMaterial.next()) {
                String ruleID = rsRuleByMaterial.getString("ruleID");
                LotRuleInfo lotRule = LotRuleFactory.getLocalInstance((Context)ctx).getLotRuleInfo((IObjectPK)new ObjectUuidPK(ruleID));
                return lotRule;
            }
            StringBuffer sb = new StringBuffer();
            sb.append("SELECT TOP 1 lr.FID AS ruleID ").append("FROM T_IN_LotRule lr INNER JOIN T_BD_MaterialGroup mg ON lr.FBusinessObjectID = mg.FID ").append("INNER JOIN T_ORG_Storage s ").append("ON lr.FSouID = s.FID ").append("WHERE FEnabled = 2 AND mg.FLongNumber IN (").append(SQLUtil.arrayToString(mgLongNumbers)).append(") AND s.FLongNumber IN(").append(SQLUtil.arrayToString(souLongNumbers)).append(") ORDER BY mg.FLongNumber DESC, s.FLongNumber DESC");
            rsRuleByMGroup = SQLUtils.executeQuery((Context)ctx, (String)sb.toString());
            if (rsRuleByMGroup.next()) {
                String ruleID = rsRuleByMGroup.getString("ruleID");
                LotRuleInfo lotRule = LotRuleFactory.getLocalInstance((Context)ctx).getLotRuleInfo((IObjectPK)new ObjectUuidPK(ruleID));
                return lotRule;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    public static String[] parseLongNumber(String longNumber) {
        if (longNumber == null) {
            return null;
        }
        String split = "!";
        ArrayList<String> list = new ArrayList<String>();
        list.add(longNumber);
        while (longNumber.lastIndexOf(split) >= 0) {
            longNumber = longNumber.substring(0, longNumber.lastIndexOf(split));
            list.add(longNumber);
        }
        String[] longNumbers = new String[list.size()];
        list.toArray(longNumbers);
        return longNumbers;
    }

    public static LocationInfo getDefaultLocation(Context ctx, StorageOrgUnitInfo storageOrg, MaterialInfo material, WarehouseInfo warehouse) throws BOSException, EASBizException {
        if (storageOrg != null && material != null && warehouse != null) {
            IObjectPK[] pks;
            int recs;
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("STORAGEORG.ID", (Object)storageOrg.getId().toString(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("isDefaultLocation", (Object)Boolean.TRUE));
            filterInfo.getFilterItems().add(new FilterItemInfo("WAREHOUSE.ID", (Object)warehouse.getId().toString(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("MATERIAL.ID", (Object)material.getId().toString(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("storageAssignType", (Object)new Integer(0), CompareType.EQUALS));
            StringBuffer maskString = new StringBuffer("( ");
            MaterialGroupInfo materialGroupInfo = MMUtils.getMaterialGroupByMaterial(material, ctx);
            if (null != materialGroupInfo) {
                filterInfo.getFilterItems().add(new FilterItemInfo("materialGroup.id", (Object)materialGroupInfo.getId().toString(), CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("storageAssignType", (Object)new Integer(1), CompareType.EQUALS));
                maskString.append(" #0 and #1 and #2  and (#3 and #4 or #5 and #6) ");
            } else {
                maskString.append(" #0 and #1 and #2  and #3 and #4");
            }
            maskString.append(" )");
            filterInfo.setMaskString(maskString.toString());
            viewInfo.setFilter(filterInfo);
            SorterItemCollection sorter = new SorterItemCollection();
            SorterItemInfo item = new SorterItemInfo("material");
            item.setSortType(SortType.DESCEND);
            sorter.add(item);
            viewInfo.setSorter(sorter);
            viewInfo.setFilter(filterInfo);
            IMaterialStorageAssign imsa = null;
            ILocation il = null;
            if (ctx == null) {
                imsa = MaterialStorageAssignFactory.getRemoteInstance();
                il = LocationFactory.getRemoteInstance();
            } else {
                imsa = MaterialStorageAssignFactory.getLocalInstance((Context)ctx);
                il = LocationFactory.getLocalInstance((Context)ctx);
            }
            if (imsa != null && (recs = (pks = imsa.getPKList(filterInfo, null)).length) > 0) {
                if (imsa.getMaterialStorageAssignInfo(pks[0]).getLocation() != null) {
                    ObjectUuidPK pk = new ObjectUuidPK(imsa.getMaterialStorageAssignInfo(pks[0]).getLocation().getBOSUuid("id"));
                    return il.getLocationInfo((IObjectPK)pk);
                }
                return null;
            }
        }
        return null;
    }

    public static MaterialGroupInfo getMaterialGroupByMaterial(MaterialInfo materialInfo, Context ctx) throws EASBizException, BOSException {
        if (null == materialInfo) {
            return null;
        }
        if (null != materialInfo.getMaterialGroup()) {
            return materialInfo.getMaterialGroup();
        }
        IMaterial im = null;
        im = ctx == null ? MaterialFactory.getRemoteInstance() : MaterialFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("materialGroup.id");
        MaterialInfo newMaterialInfo = im.getMaterialInfo((IObjectPK)new ObjectUuidPK(materialInfo.getId()), selector);
        if (null != newMaterialInfo) {
            return newMaterialInfo.getMaterialGroup();
        }
        return null;
    }

    public static boolean isRoundDown(BigDecimal resultVal) {
        BigDecimal a1 = new BigDecimal("0.0");
        BigDecimal a2 = new BigDecimal("0.0");
        for (int i = 0; i < resultVal.scale(); ++i) {
            a1 = i == 0 ? resultVal.multiply(new BigDecimal("10")) : a1.multiply(new BigDecimal("10"));
        }
        a2 = a1.divide(new BigDecimal("10")).setScale(0, 1).multiply(new BigDecimal("10"));
        return a1.subtract(a2).compareTo(new BigDecimal("1")) >= 0 && a1.subtract(a2).compareTo(new BigDecimal("9")) <= 0;
    }
}

