/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.common.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.BOMExtend2FacadeFactory;
import com.kingdee.eas.mm.basedata.BomCollection;
import com.kingdee.eas.mm.basedata.BomFactory;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.IBOMExtend2Facade;
import com.kingdee.eas.mm.basedata.IBom;
import com.kingdee.eas.mm.basedata.IProductionFormula;
import com.kingdee.eas.mm.basedata.ProductLineInfo;
import com.kingdee.eas.mm.basedata.ProductionFormulaCollection;
import com.kingdee.eas.mm.basedata.ProductionFormulaFactory;
import com.kingdee.eas.mm.basedata.ProductionFormulaInfo;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.util.ProductionStrategyHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;

public class ProductionFormulaHelper {
    public static ProductionFormulaInfo getDefaultFormula(Context ctx, Object materialPlan, Object material, Object productLine, Object trackNumber, Object orgUnit, Object defaultFormula) throws BOSException, EASBizException {
        ProductionFormulaInfo formulaInfo = null;
        if (material != null && material instanceof MaterialInfo && productLine != null && productLine instanceof ProductLineInfo && orgUnit != null && orgUnit instanceof StorageOrgUnitInfo) {
            IProductionFormula iformula = null;
            iformula = ctx == null ? ProductionFormulaFactory.getRemoteInstance() : ProductionFormulaFactory.getLocalInstance((Context)ctx);
            ProductionFormulaCollection formulas = null;
            MaterialInfo materialInfo = (MaterialInfo)material;
            ProductLineInfo productLineInfo = (ProductLineInfo)productLine;
            StorageOrgUnitInfo orgUnitInfo = (StorageOrgUnitInfo)orgUnit;
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo normalFilterInfo = new FilterInfo();
            normalFilterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)new Integer(4), CompareType.EQUALS));
            normalFilterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)orgUnitInfo.getId().toString(), CompareType.EQUALS));
            normalFilterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialInfo.getId().toString(), CompareType.EQUALS));
            normalFilterInfo.getFilterItems().add(new FilterItemInfo("productLine.id", (Object)productLineInfo.getId().toString(), CompareType.EQUALS));
            if (trackNumber != null && trackNumber instanceof TrackNumberInfo) {
                String strategyId;
                TrackNumberInfo trackNumberInfo = (TrackNumberInfo)trackNumber;
                MaterialPlanInfo materialPlanInfo = null;
                if (materialPlan != null && materialPlan instanceof MaterialPlanInfo) {
                    materialPlanInfo = (MaterialPlanInfo)materialPlan;
                }
                if ((strategyId = ProductionStrategyHelper.getManufactureStrategy(ctx, materialPlanInfo, (MaterialInfo)material, (StorageOrgUnitInfo)orgUnit)).equals("fpPxtypCS/ihJ30GjB/UJtg0uEU=") || strategyId.equals("qAXoUB/tBg/gQKjAYj0WQ9g0uEU=") || strategyId.equals("qAYbemEdG9ngQKjAYj0V1dg0uEU=") || strategyId.equals("qAYfaBzTrmLgQKjAYj0f3dg0uEU=")) {
                    FilterInfo filterInfo = (FilterInfo)normalFilterInfo.clone();
                    filterInfo.getFilterItems().add(new FilterItemInfo("track.id", (Object)trackNumberInfo.getId().toString(), CompareType.EQUALS));
                    view.setFilter(filterInfo);
                    formulas = iformula.getProductionFormulaCollection(view);
                    if (formulas != null && formulas.size() > 0) {
                        formulaInfo = ProductionFormulaHelper.getDefaultFormula(formulaInfo, formulas);
                    }
                }
            }
            if (formulaInfo == null) {
                FilterInfo defaultInfo = (FilterInfo)normalFilterInfo.clone();
                defaultInfo.getFilterItems().add(new FilterItemInfo("track.id", null, CompareType.EQUALS));
                view.setFilter(defaultInfo);
                formulas = iformula.getProductionFormulaCollection(view);
                if (formulas != null && formulas.size() > 0) {
                    formulaInfo = ProductionFormulaHelper.getDefaultFormula(formulaInfo, formulas);
                }
            }
        }
        if (formulaInfo == null && defaultFormula != null && defaultFormula instanceof ProductionFormulaInfo) {
            formulaInfo = (ProductionFormulaInfo)defaultFormula;
        }
        return formulaInfo;
    }

    public static BomInfo getDefaultBOM(Context ctx, Object material, Object orgUnit, Object defaultBOM) throws BOSException, EASBizException {
        BomInfo bomInfo = null;
        if (material != null && material instanceof MaterialInfo && orgUnit != null && orgUnit instanceof StorageOrgUnitInfo) {
            String materialId = ((MaterialInfo)material).getId().toString();
            String orgId = ((StorageOrgUnitInfo)orgUnit).getId().toString();
            FilterInfo normalFilterInfo = new FilterInfo();
            normalFilterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)new Integer(4), CompareType.EQUALS));
            normalFilterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)orgId, CompareType.EQUALS));
            normalFilterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialId, CompareType.EQUALS));
            normalFilterInfo.getFilterItems().add(new FilterItemInfo("usageType", (Object)new Integer(10), CompareType.EQUALS));
            normalFilterInfo.getFilterItems().add(new FilterItemInfo("bomType", (Object)new Integer(40), CompareType.EQUALS));
            IBom ibom = null;
            ibom = ctx == null ? BomFactory.getRemoteInstance() : BomFactory.getLocalInstance((Context)ctx);
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(normalFilterInfo);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("yield"));
            sic.add(new SelectorItemInfo("productBaseQty"));
            sic.add(new SelectorItemInfo("productQty"));
            view.setSelector(sic);
            BomCollection boms = ibom.getBomCollection(view);
            if (boms != null && boms.size() > 0) {
                return boms.get(0);
            }
        }
        return bomInfo;
    }

    public static BomInfo getDefaultBOM(Context ctx, Object materialPlan, Object material, Object productLine, Object trackNumber, Object orgUnit) throws BOSException, EASBizException {
        if (trackNumber == null) {
            return ProductionFormulaHelper.getDefaultBOM(ctx, material, orgUnit, null);
        }
        return ProductionFormulaHelper.getDefaultBOM(ctx, materialPlan, material, null, trackNumber, orgUnit, null);
    }

    private static ProductionFormulaInfo getDefaultFormula(ProductionFormulaInfo formulaInfo, ProductionFormulaCollection formulas) {
        for (int i = 0; i < formulas.size(); ++i) {
            if (!formulas.get(i).isIsDefault()) continue;
            formulaInfo = formulas.get(i);
        }
        if (formulaInfo == null) {
            formulaInfo = formulas.get(0);
        }
        return formulaInfo;
    }

    public static BomInfo getDefaultBOM(Context ctx, Object materialPlan, Object material, Object productLine, Object trackNumber, Object orgUnit, Object defaultBOM) throws BOSException, EASBizException {
        BomInfo bomInfo = null;
        if (material != null && material instanceof MaterialInfo && orgUnit != null && orgUnit instanceof StorageOrgUnitInfo) {
            IBOMExtend2Facade iBOMExtend = null;
            iBOMExtend = ctx == null ? BOMExtend2FacadeFactory.getRemoteInstance() : BOMExtend2FacadeFactory.getLocalInstance((Context)ctx);
            String materialId = ((MaterialInfo)material).getId().toString();
            String orgId = ((StorageOrgUnitInfo)orgUnit).getId().toString();
            if (trackNumber != null && trackNumber instanceof TrackNumberInfo) {
                String strategyId;
                MaterialPlanInfo materialPlanInfo = null;
                if (materialPlan != null && materialPlan instanceof MaterialPlanInfo) {
                    materialPlanInfo = (MaterialPlanInfo)materialPlan;
                }
                if ((strategyId = ProductionStrategyHelper.getManufactureStrategy(ctx, materialPlanInfo, (MaterialInfo)material, (StorageOrgUnitInfo)orgUnit)).equals("fpPxtypCS/ihJ30GjB/UJtg0uEU=") || strategyId.equals("qAXoUB/tBg/gQKjAYj0WQ9g0uEU=") || strategyId.equals("qAYbemEdG9ngQKjAYj0V1dg0uEU=") || strategyId.equals("qAYfaBzTrmLgQKjAYj0f3dg0uEU=")) {
                    String trackId = ((TrackNumberInfo)trackNumber).getId().toString();
                    bomInfo = iBOMExtend.getBomByTrcAndPrjID(materialId, null, trackId, orgId);
                }
            }
        }
        if (bomInfo == null && defaultBOM != null && defaultBOM instanceof BomInfo) {
            bomInfo = (BomInfo)defaultBOM;
        }
        return bomInfo;
    }

    public static Object[] getFormulaAndBOM(Context ctx, Object materialPlan, Object material, Object productLine, Object trackNumber, Object orgUnit, Object defaultFormula, Object defaultBOM) throws BOSException, EASBizException {
        Object[] result = new Object[2];
        ProductionFormulaInfo formulaInfo = null;
        BomInfo bomInfo = null;
        ProductionFormulaInfo oFormulaInfo = null;
        BomInfo oBomInfo = null;
        if (material != null && material instanceof MaterialInfo && orgUnit != null && orgUnit instanceof StorageOrgUnitInfo) {
            if (defaultFormula != null && defaultFormula instanceof ProductionFormulaInfo) {
                oFormulaInfo = (ProductionFormulaInfo)defaultFormula;
            }
            if (defaultBOM != null && defaultBOM instanceof BomInfo) {
                oBomInfo = (BomInfo)defaultBOM;
            }
            if (oBomInfo == null) {
                formulaInfo = ProductionFormulaHelper.getDefaultFormula(ctx, materialPlan, material, productLine, trackNumber, orgUnit, defaultFormula);
            } else if (oFormulaInfo == null) {
                bomInfo = ProductionFormulaHelper.getDefaultBOM(ctx, materialPlan, material, productLine, trackNumber, orgUnit, defaultBOM);
                IBom iBOM = null;
                iBOM = ctx == null ? BomFactory.getRemoteInstance() : BomFactory.getLocalInstance((Context)ctx);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("number"));
                sic.add(new SelectorItemInfo("name"));
                sic.add(new SelectorItemInfo("yield"));
                sic.add(new SelectorItemInfo("productBaseQty"));
                sic.add(new SelectorItemInfo("productQty"));
                bomInfo = iBOM.getBomInfo((IObjectPK)new ObjectUuidPK(bomInfo.getId().toString()), sic);
            }
        }
        result[0] = formulaInfo;
        result[1] = bomInfo;
        return result;
    }

    public static ProductionFormulaInfo getDefaultFormulaForApp(Context ctx, MaterialInfo material, ProductLineInfo productLine, TrackNumberInfo trackNumber, StorageOrgUnitInfo orgUnit) throws BOSException, EASBizException {
        if (ctx == null || material == null || productLine == null || orgUnit == null) {
            return null;
        }
        ProductionFormulaInfo formulaInfo = null;
        String formulaId = null;
        StringBuffer normalFormula = new StringBuffer();
        normalFormula.append("select top 1 fid from T_MM_ProductionFormula where ").append(" FBaseStatus=").append(4).append(" and FStorageOrgUnitID='").append(orgUnit.getId().toString()).append("' and FMaterialID='").append(material.getId().toString()).append("' and FProductLineID='").append(productLine.getId().toString()).append("' ");
        StringBuffer formula = new StringBuffer();
        formula.append(normalFormula.toString());
        if (trackNumber != null && trackNumber.getId() != null) {
            formula.append(" and FTrackID='").append(trackNumber.getId().toString()).append("'");
        }
        formula.append(" and FMaterialID in (select FMaterialID from T_BD_MaterialPlan where ").append(" FStorageOrgUnitID='").append(orgUnit.getId().toString()).append("' and FMaterialID='").append(material.getId().toString()).append("' and (FManufactureStrategyID='").append("fpPxtypCS/ihJ30GjB/UJtg0uEU=").append("' or FManufactureStrategyID='").append("qAXoUB/tBg/gQKjAYj0WQ9g0uEU=").append("' or FManufactureStrategyID='").append("qAYbemEdG9ngQKjAYj0V1dg0uEU=").append("' or FManufactureStrategyID='").append("qAYfaBzTrmLgQKjAYj0f3dg0uEU=").append("' ").append("))");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)formula.toString());
        try {
            while (rowSet.next()) {
                formulaId = rowSet.getString("fid");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (formulaId == null) {
            formula.setLength(0);
            formula.append(normalFormula.toString()).append(" and FIsDefault=1");
            rowSet = DbUtil.executeQuery((Context)ctx, (String)formula.toString());
            try {
                while (rowSet.next()) {
                    formulaId = rowSet.getString("fid");
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (formulaId != null) {
            IProductionFormula iformula = ProductionFormulaFactory.getLocalInstance((Context)ctx);
            formulaInfo = iformula.getProductionFormulaInfo((IObjectPK)new ObjectUuidPK(formulaId));
        }
        return formulaInfo;
    }

    public static ProductionFormulaInfo getFormulaByTrackNumber(Context ctx, String material, String productLine, String orgUnit, String trackNumber) throws BOSException, EASBizException {
        ProductionFormulaInfo formulaInfo = null;
        String formulaId = null;
        StringBuffer normalFormula = new StringBuffer();
        normalFormula.append("select top 1 fid from T_MM_ProductionFormula where ").append(" FBaseStatus=").append(4).append(" and FStorageOrgUnitID='").append(orgUnit).append("' and FMaterialID='").append(material).append("' and FProductLineID='").append(productLine).append("' ");
        StringBuffer formula = new StringBuffer();
        formula.append(normalFormula.toString());
        if (trackNumber != null && !"".equals(trackNumber)) {
            formula.append(" and FTrackID='").append(trackNumber).append("'");
        }
        formula.append(" and FMaterialID in (select FMaterialID from T_BD_MaterialPlan where ").append(" FStorageOrgUnitID='").append(orgUnit).append("' and FMaterialID='").append(material).append("' and FManufactureStrategyID in ('").append("fpPxtypCS/ihJ30GjB/UJtg0uEU=").append("','").append("qAXoUB/tBg/gQKjAYj0WQ9g0uEU=").append("','").append("qAYbemEdG9ngQKjAYj0V1dg0uEU=").append("','").append("qAYfaBzTrmLgQKjAYj0f3dg0uEU=").append("' ").append("))");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)formula.toString());
        try {
            while (rowSet.next()) {
                formulaId = rowSet.getString("fid");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (formulaId == null) {
            formula.setLength(0);
            formula.append(normalFormula.toString());
            rowSet = DbUtil.executeQuery((Context)ctx, (String)formula.toString());
            try {
                while (rowSet.next()) {
                    formulaId = rowSet.getString("fid");
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (formulaId != null) {
            IProductionFormula iformula = ProductionFormulaFactory.getLocalInstance((Context)ctx);
            formulaInfo = iformula.getProductionFormulaInfo((IObjectPK)new ObjectUuidPK(formulaId));
        }
        return formulaInfo;
    }
}

