/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.pdm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.KDToolkit;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDBntScrollBar;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.CommitListener;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.material.MaterialAttributeEnum;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.client.TreePathUtil;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.mm.pdm.BasedataMatchRelationCollection;
import com.kingdee.eas.mm.pdm.BasedataMatchRelationFactory;
import com.kingdee.eas.mm.pdm.BasedataMatchRelationInfo;
import com.kingdee.eas.mm.pdm.CodeMatchTypeEnum;
import com.kingdee.eas.mm.pdm.IBasedataMatchRelation;
import com.kingdee.eas.mm.pdm.client.AbstractBasedataMatchRelationUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class BasedataMatchRelationUI
extends AbstractBasedataMatchRelationUI {
    private static final long serialVersionUID = 1L;
    private CodeMatchTypeEnum type = CodeMatchTypeEnum.NULL_TYPE;
    private CtrlUnitInfo cuInfo;
    private JScrollBar vBar = new KDDBntScrollBar(1);
    private AdjustmentListener listener = null;
    private TreeSelectionListener treeSelectionListener = null;
    private DataChangeListener controlUnitListener = null;
    private KDTEditAdapter tableChangeListener = null;
    private final String TAB_COL_PDM_CODE = "PDMData";
    private final String TAB_COL_EAS_CODE = "EASdata";
    private final String TAB_COL_EAS_DESC = "EASdataDesc";
    private final String TAB_COL_REMARK = "remark";
    private final String TAB_COL_EAS_ID = "easID";
    private final String TAB_COL_ID = "id";
    private final String TAB_COL_ISADD = "isAdd";
    private final String TAB_COL_ISUPDATE = "isUpdate";
    private KDTreeNode defaultNode = null;
    private KDTreeNode rootNode = null;
    private int tablesize = -1;
    private String tempName = null;
    private int delRowSize;
    private int addRowSize;
    private KDTDefaultCellEditor maAttCellEditor;
    private ObjectValueRender kdtEntrysStorageOrgUnitOVR;
    private Action actionTable;
    private Map hasDataMap;
    public static int defaultPageRow;

    public BasedataMatchRelationUI() throws Exception {
        KDComboBox kdtEASDataComboBox = new KDComboBox();
        ArrayList enumlist = new ArrayList(MaterialAttributeEnum.getEnumList());
        enumlist.remove(MaterialAttributeEnum.SCHEDULEPART);
        kdtEASDataComboBox.addItems(enumlist.toArray());
        this.maAttCellEditor = new KDTDefaultCellEditor((JComboBox)kdtEASDataComboBox);
        this.kdtEntrysStorageOrgUnitOVR = new ObjectValueRender();
        this.kdtEntrysStorageOrgUnitOVR.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.hasDataMap = new HashMap();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.iniTable();
        this.initMenu();
        this.buildTree();
        this.initCtrlUnitF7s();
        this.setDefaultNode();
        this.prmtStorageOrgUnit.setEnabled(false);
        this.prmtStorageOrgUnit.setEditable(false);
        this.addLinsener();
        this.tblMain.getLayoutManager().setVerticalScrollBar(this.vBar);
        this.tblMain.getActionMap().remove("Delete");
        if (this.actionAddLine.isEnabled()) {
            KDTableHelper.downArrowAutoAddRow((KDTable)this.tblMain, (boolean)true, (Action)this.actionTable);
            KDTableHelper.updateEnterWithTab((KDTable)this.tblMain, (boolean)true, (Action)this.actionTable);
        } else {
            KDTableHelper.downArrowAutoAddRow((KDTable)this.tblMain, (boolean)false, (Action)this.actionTable);
            KDTableHelper.updateEnterWithTab((KDTable)this.tblMain, (boolean)false, (Action)this.actionTable);
        }
        this.tblMain.setFocusTraversalKeys(0, new HashSet());
        this.tblMain.getInputMap(1).put(KeyStroke.getKeyStroke(9, 0), "FocusChangeRow");
        this.tblMain.getActionMap().remove("Cut");
        this.tblMain.getActionMap().remove("Paste");
        this.tblMain.getActionMap().remove("Delete");
        this.setStorageOrgUnitEditable(this.defaultNode);
    }

    private void setStorageOrgUnitEditable(KDTreeNode treeNode) {
        if (treeNode == null || treeNode.getUserObject() == null) {
            return;
        }
        CodeMatchTypeEnum nodeType = ((TreeNode)treeNode.getUserObject()).getType();
        if (nodeType == CodeMatchTypeEnum.StandardRooting || nodeType == CodeMatchTypeEnum.Operation || nodeType == CodeMatchTypeEnum.WorkCenter) {
            this.prmtStorageOrgUnit.setEnabled(true);
            this.prmtStorageOrgUnit.setEditable(true);
        } else {
            this.prmtStorageOrgUnit.setEnabled(false);
            this.prmtStorageOrgUnit.setEditable(false);
        }
    }

    private void iniTable() {
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(false);
        this.tblMain.getColumn("EASdataDesc").getStyleAttributes().setLocked(true);
        this.tblMain.getSelectManager().setSelectMode(15);
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        KDTextField txt = new KDTextField();
        txt.setMaxLength(100);
        KDTextField txt1 = new KDTextField();
        txt1.setMaxLength(255);
        this.tblMain.getColumn("PDMData").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txt));
        this.tblMain.getColumn("remark").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txt1));
    }

    private void setDefaultNode() {
        TreePath path = new TreePath(this.rootNode).pathByAddingChild(this.defaultNode);
        this.kDTree.setSelectionPath(TreePathUtil.getNewTreePath((JTree)this.kDTree, (TreeModel)this.kDTree.getModel(), (TreePath)path));
        this.type = ((TreeNode)this.defaultNode.getUserObject()).getType();
        this.refeshTable(((TreeNode)this.defaultNode.getUserObject()).getType());
    }

    private void initMenu() {
        this.btnAuditResult.setVisible(false);
        this.MenuItemAttachment.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.menuItemSave.setAccelerator(KeyStroke.getKeyStroke("ctrl S"));
        this.menuItemAddLine.setAccelerator(KeyStroke.getKeyStroke("ctrl shift N"));
        this.menuItemInsertLine.setAccelerator(KeyStroke.getKeyStroke("ctrl shift I"));
        this.menuItemRemoveLine.setAccelerator(KeyStroke.getKeyStroke("ctrl shift D"));
        this.enableActionMenu();
    }

    protected void initCtrlUnitF7s() {
        try {
            this.cuInfo = this.getDefaultCtrlUnitOrg();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.kDPromptCU.setValue((Object)this.cuInfo);
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.kDPromptCU, (OrgType)OrgType.ControlUnit, (String)"mm_pdm_matchRelation_view");
    }

    private void buildTree() {
        this.kDTreeView.getControlPane().setVisible(false);
        this.kDTree.getSelectionModel().setSelectionMode(1);
        DefaultTreeModel model = (DefaultTreeModel)this.kDTree.getModel();
        this.rootNode = new KDTreeNode((Object)"Root");
        model.setRoot((javax.swing.tree.TreeNode)this.rootNode);
        this.kDTree.setRootVisible(false);
        KDTreeNode srLeaf = null;
        KDTreeNode nullLeaf = new KDTreeNode((Object)new TreeNode(CodeMatchTypeEnum.NULL_TYPE.getAlias(this.getLocale()), CodeMatchTypeEnum.NULL_TYPE));
        srLeaf = new KDTreeNode((Object)new TreeNode(CodeMatchTypeEnum.StandardRooting.getAlias(this.getLocale()), CodeMatchTypeEnum.StandardRooting));
        model.insertNodeInto((MutableTreeNode)nullLeaf, (MutableTreeNode)this.rootNode, 0);
        model.insertNodeInto((MutableTreeNode)srLeaf, (MutableTreeNode)this.rootNode, 1);
        ArrayList<CodeMatchTypeEnum> nullTypeList = new ArrayList<CodeMatchTypeEnum>();
        nullTypeList.add(CodeMatchTypeEnum.MEASUREMENT_UNIT);
        nullTypeList.add(CodeMatchTypeEnum.MATERIAL_TYPE);
        nullTypeList.add(CodeMatchTypeEnum.STUFF_NUMBER);
        nullTypeList.add(CodeMatchTypeEnum.PROJECT_NUMBER);
        nullTypeList.add(CodeMatchTypeEnum.TRACK_NUMBER);
        nullTypeList.add(CodeMatchTypeEnum.STORAGE_UNIT);
        nullTypeList.add(CodeMatchTypeEnum.CONTROL_UNIT);
        KDTreeNode leaf = null;
        for (int i = 0; i < nullTypeList.size(); ++i) {
            CodeMatchTypeEnum cmte = (CodeMatchTypeEnum)((Object)nullTypeList.get(i));
            leaf = new KDTreeNode((Object)new TreeNode(cmte.getAlias(this.getLocale()), cmte));
            model.insertNodeInto((MutableTreeNode)leaf, (MutableTreeNode)nullLeaf, i);
        }
        ArrayList<CodeMatchTypeEnum> srTypeList = new ArrayList<CodeMatchTypeEnum>();
        srTypeList.add(CodeMatchTypeEnum.Operation);
        srTypeList.add(CodeMatchTypeEnum.WorkCenter);
        for (int i = 0; i < srTypeList.size(); ++i) {
            CodeMatchTypeEnum cmte = (CodeMatchTypeEnum)((Object)srTypeList.get(i));
            leaf = new KDTreeNode((Object)new TreeNode(cmte.getAlias(this.getLocale()), cmte));
            model.insertNodeInto((MutableTreeNode)leaf, (MutableTreeNode)srLeaf, i);
        }
        if (model != null && model.getRoot() != null) {
            this.kDTree.expandPath(new TreePath(model.getRoot()));
        }
        TreePath path = new TreePath(this.rootNode).pathByAddingChild(this.rootNode.getChildAt(0));
        this.kDTree.setSelectionPath(TreePathUtil.getNewTreePath((JTree)this.kDTree, (TreeModel)this.kDTree.getModel(), (TreePath)path));
        this.defaultNode = (KDTreeNode)this.rootNode.getChildAt(0);
        this.kDTree.expandOnLevel(3);
    }

    protected void initListener() {
        super.initListener();
        this.actionTable = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BasedataMatchRelationUI.this.getDetailTable() != null) {
                    BasedataMatchRelationUI.this.getDetailTable().removeRow(BasedataMatchRelationUI.this.getDetailTable().getRowCount() - 1);
                    BasedataMatchRelationUI.this.addLine(null);
                }
            }
        };
    }

    private void addLinsener() {
        if (null == this.treeSelectionListener) {
            this.treeSelectionListener = new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    BasedataMatchRelationUI.this.treeSelectChange(e);
                }
            };
        }
        this.kDTree.addTreeSelectionListener(this.treeSelectionListener);
        if (null == this.listener) {
            this.listener = new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent e) {
                    BasedataMatchRelationUI.this.getNextPageData(e);
                }
            };
        }
        this.vBar.addAdjustmentListener(this.listener);
        if (null == this.controlUnitListener) {
            this.controlUnitListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    BasedataMatchRelationUI.this.controlUnitChange(eventObj);
                }
            };
        }
        this.kDPromptCU.addDataChangeListener(this.controlUnitListener);
        if (null == this.tableChangeListener) {
            this.tableChangeListener = new KDTEditAdapter(){

                public void editStopped(KDTEditEvent e) {
                    try {
                        BasedataMatchRelationUI.this.mainTableChange(e);
                    }
                    catch (Exception exc) {
                        BasedataMatchRelationUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.tblMain.addKDTEditListener((KDTEditListener)this.tableChangeListener);
        this.prmtStorageOrgUnit.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                BasedataMatchRelationUI.this.setStorageOrgUnitFilter();
            }
        });
        this.prmtStorageOrgUnit.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                BasedataMatchRelationUI.this.setStorageOrgUnitFilter();
            }
        });
        this.prmtStorageOrgUnit.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                Object newValue;
                Object oldValue = eventObj.getOldValue();
                if (SCMGroupClientUtils.isDiffrent((Object)oldValue, (Object)(newValue = eventObj.getNewValue()))) {
                    BasedataMatchRelationUI.this.removeLinsener();
                    BasedataMatchRelationUI.this.refeshTable(BasedataMatchRelationUI.this.type);
                    BasedataMatchRelationUI.this.addLinsener();
                }
            }
        });
    }

    protected void setStorageOrgUnitFilter() {
        if (this.kDPromptCU.getValue() == null) {
            return;
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("CU.id", (Object)((CtrlUnitInfo)this.kDPromptCU.getValue()).getId().toString()));
        ev.setFilter(fi);
        this.prmtStorageOrgUnit.setEntityViewInfo(ev);
        this.prmtStorageOrgUnit.getQueryAgent().resetRuntimeEntityView();
    }

    private void removeLinsener() {
        int i;
        if (null != this.treeSelectionListener) {
            this.kDTree.removeTreeSelectionListener(this.treeSelectionListener);
        }
        if (null != this.listener) {
            this.vBar.removeAdjustmentListener(this.listener);
        }
        if (null != this.controlUnitListener) {
            this.kDPromptCU.removeDataChangeListener(this.controlUnitListener);
        }
        if (null != this.tableChangeListener) {
            this.tblMain.removeKDTEditListener((KDTEditListener)this.tableChangeListener);
        }
        if (this.prmtStorageOrgUnit.getSelectorListeners().length > 0) {
            for (i = 0; i < this.prmtStorageOrgUnit.getSelectorListeners().length; ++i) {
                this.prmtStorageOrgUnit.removeSelectorListener(this.prmtStorageOrgUnit.getSelectorListeners()[i]);
            }
        }
        if (this.prmtStorageOrgUnit.getCommitListeners().length > 0) {
            for (i = 0; i < this.prmtStorageOrgUnit.getCommitListeners().length; ++i) {
                this.prmtStorageOrgUnit.removeCommitListener(this.prmtStorageOrgUnit.getCommitListeners()[i]);
            }
        }
        if (this.prmtStorageOrgUnit.getChangeListeners().length > 0) {
            for (i = 0; i < this.prmtStorageOrgUnit.getChangeListeners().length; ++i) {
                this.prmtStorageOrgUnit.removeChangeListener(this.prmtStorageOrgUnit.getChangeListeners()[i]);
            }
        }
    }

    private void controlUnitChange(DataChangeEvent eventObj) {
        block9: {
            this.removeLinsener();
            if (this.treatBeforeTableRefresh()) {
                if (eventObj.getNewValue() instanceof String) {
                    String number = (String)eventObj.getNewValue();
                    try {
                        CtrlUnitInfo orgReq = this.getRemoteInstance().getCtrlUnitByNumber(number);
                        if (null == orgReq) {
                            this.kDPromptCU.setValue(eventObj.getOldValue());
                            break block9;
                        }
                        this.cuInfo = orgReq;
                        this.kDPromptCU.setValue((Object)orgReq);
                        this.refeshTable(this.type);
                    }
                    catch (Exception e) {
                        this.handleException(e);
                    }
                } else if (eventObj.getNewValue() != null) {
                    this.cuInfo = (CtrlUnitInfo)eventObj.getNewValue();
                    this.refeshTable(this.type);
                } else {
                    this.kDPromptCU.setValue(eventObj.getOldValue());
                }
            } else {
                this.kDPromptCU.setValue(eventObj.getOldValue());
            }
        }
        this.kDPromptCU.setEntityViewInfo(null);
        this.getUIContext().put(this.getMainBizOrgType(), this.kDPromptCU.getValue());
        this.addLinsener();
    }

    private void treeSelectChange(TreeSelectionEvent e) {
        this.removeLinsener();
        if (this.treatBeforeTableRefresh()) {
            KDTreeNode currentNode = (KDTreeNode)e.getPath().getLastPathComponent();
            TreeNode node = (TreeNode)currentNode.getUserObject();
            this.setStorageOrgUnitEditable(currentNode);
            this.type = node.getType();
            this.refeshTable(this.type);
            if (this.type.equals((Object)CodeMatchTypeEnum.NULL_TYPE) || this.type.equals((Object)CodeMatchTypeEnum.StandardRooting)) {
                this.actionLocate.setEnabled(false);
            } else {
                this.actionLocate.setEnabled(true);
            }
        } else {
            this.kDTree.setSelectionPath(TreePathUtil.getNewTreePath((JTree)this.kDTree, (TreeModel)this.kDTree.getModel(), (TreePath)e.getOldLeadSelectionPath()));
        }
        this.addLinsener();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void mainTableChange(KDTEditEvent e) {
        int colIndex = e.getColIndex();
        int rowIndex = e.getRowIndex();
        if (null == this.tblMain.getRow(rowIndex).getCell("isAdd").getValue() && null != this.tblMain.getRow(rowIndex).getCell("id").getValue()) {
            if (e.getValue() == null) {
                if (e.getOldValue() == null) return;
                this.tblMain.getRow(rowIndex).getCell("isUpdate").setValue((Object)new Integer(1));
            } else {
                if (e.getValue().equals(e.getOldValue())) return;
                this.tblMain.getRow(rowIndex).getCell("isUpdate").setValue((Object)new Integer(1));
            }
        }
        if (colIndex != this.tblMain.getColumn("EASdata").getColumnIndex()) return;
        if (this.type.equals((Object)CodeMatchTypeEnum.MATERIAL_PROPERTY)) {
            MaterialAttributeEnum enumSelected = (MaterialAttributeEnum)e.getValue();
            if (null != enumSelected) {
                this.tblMain.getRow(rowIndex).getCell(colIndex).setValue((Object)enumSelected);
                this.tblMain.getRow(rowIndex).getCell("EASdataDesc").setValue((Object)enumSelected.getAlias());
                return;
            } else {
                this.tblMain.getRow(rowIndex).getCell("EASdataDesc").setValue((Object)"");
            }
            return;
        } else {
            DataBaseInfo info;
            if (null == e.getValue()) {
                this.tblMain.getRow(rowIndex).getCell("EASdataDesc").setValue((Object)"");
                this.tblMain.getRow(rowIndex).getCell("easID").setValue(null);
            }
            if (!(e.getValue() instanceof DataBaseInfo) || null == (info = (DataBaseInfo)e.getValue())) return;
            this.tblMain.getRow(rowIndex).getCell("EASdataDesc").setValue((Object)info.getName());
            this.tblMain.getRow(rowIndex).getCell("easID").setValue((Object)info.getId().toString());
        }
    }

    private void getNextPageData(AdjustmentEvent e) {
        Boolean hasData = (Boolean)this.hasDataMap.get((Object)this.type);
        if (hasData != null && !hasData.booleanValue()) {
            return;
        }
        int last = this.tblMain.getLayoutManager().getVertical(1).getLast();
        this.tablesize = this.tblMain.getRowCount();
        if (last + 3 >= this.tablesize) {
            int start = this.tablesize - this.addRowSize;
            this.getDataWithStart(start);
        }
    }

    private void getDataWithStart(int start) {
        if (this.type.equals((Object)CodeMatchTypeEnum.NULL_TYPE) || this.type.equals((Object)CodeMatchTypeEnum.StandardRooting)) {
            return;
        }
        Map result = null;
        try {
            result = this.getRemoteInstance().getCollectionByVirtualMode(this.getDataParams(), start, defaultPageRow, this.tempName);
        }
        catch (BOSException e1) {
            this.handleException((Exception)((Object)e1));
        }
        RptRowSet rowset = (RptRowSet)result.get("RESULT_ROW");
        this.tempName = (String)result.get("TABLE_NAME");
        this.forRowSet(rowset);
        if (rowset.getVirtualRowCount() == 0) {
            this.hasDataMap.put(this.type, false);
        }
    }

    private void forRowSet(RptRowSet rowset) {
        while (rowset.next()) {
            IRow row = this.tblMain.addRow();
            row.getCell("PDMData").setValue((Object)rowset.getString("FPdmCode"));
            if (this.type.equals((Object)CodeMatchTypeEnum.MATERIAL_PROPERTY)) {
                MaterialAttributeEnum maAttEnum = MaterialAttributeEnum.getEnum((int)Integer.parseInt(rowset.getString("FEasNumber")));
                row.getCell("EASdata").setValue((Object)maAttEnum);
            } else {
                row.getCell("EASdata").setValue((Object)rowset.getString("FEasNumber"));
            }
            row.getCell("EASdataDesc").setValue((Object)rowset.getString("FDescription"));
            row.getCell("remark").setValue((Object)rowset.getString("FRemark"));
            row.getCell("easID").setValue((Object)rowset.getString("FEasID"));
            row.getCell("id").setValue((Object)rowset.getString("FID"));
        }
    }

    private void refeshTable(CodeMatchTypeEnum type) {
        this.tblMain.removeRows();
        if (type.equals((Object)CodeMatchTypeEnum.NULL_TYPE) || type.equals((Object)CodeMatchTypeEnum.StandardRooting)) {
            this.enableActionMenu();
            return;
        }
        this.changeActionState(false);
        if (!type.equals((Object)CodeMatchTypeEnum.MATERIAL_PROPERTY)) {
            String queryPath = this.getQueryPath(type);
            EntityViewInfo viewInfo = this.getDefaultEntityViewInfo(type);
            KDBizPromptBox kdtEASDataPromptBox = new KDBizPromptBox();
            kdtEASDataPromptBox.setQueryInfo(queryPath);
            kdtEASDataPromptBox.setCurrentCtrlUnit(this.cuInfo);
            kdtEASDataPromptBox.setVisible(true);
            kdtEASDataPromptBox.setEditable(true);
            kdtEASDataPromptBox.setRequired(true);
            kdtEASDataPromptBox.setEnabledMultiSelection(false);
            kdtEASDataPromptBox.setDisplayFormat("$number$");
            kdtEASDataPromptBox.setEditFormat("$number$");
            kdtEASDataPromptBox.setCommitFormat("$number$");
            KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((IKDEditor)kdtEASDataPromptBox);
            this.tblMain.getColumn("EASdata").setEditor((ICellEditor)cellEditor);
            this.tblMain.getColumn("EASdata").setRenderer((IBasicRender)this.kdtEntrysStorageOrgUnitOVR);
            kdtEASDataPromptBox.setEntityViewInfo(viewInfo);
        } else {
            this.tblMain.getColumn("EASdata").setEditor((ICellEditor)this.maAttCellEditor);
            this.tblMain.getColumn("EASdata").setRenderer(null);
        }
        this.hasDataMap.put(type, true);
        this.getDataWithStart(0);
        this.clearEditData();
    }

    private String getQueryPath(CodeMatchTypeEnum type) {
        if (type.equals((Object)CodeMatchTypeEnum.MEASUREMENT_UNIT)) {
            return "com.kingdee.eas.basedata.assistant.app.F7MeasureUnitQuery";
        }
        if (type.equals((Object)CodeMatchTypeEnum.MATERIAL_TYPE)) {
            return "com.kingdee.eas.basedata.master.material.app.F7MaterialGroupQuery";
        }
        if (type.equals((Object)CodeMatchTypeEnum.PROJECT_NUMBER)) {
            return "com.kingdee.eas.mm.project.app.F7ProjectCUQuery";
        }
        if (type.equals((Object)CodeMatchTypeEnum.TRACK_NUMBER)) {
            return "com.kingdee.eas.mm.basedata.app.TrackNumberQuery";
        }
        if (type.equals((Object)CodeMatchTypeEnum.CONTROL_UNIT)) {
            return "com.kingdee.eas.basedata.org.app.F7CUQuery";
        }
        if (type.equals((Object)CodeMatchTypeEnum.STORAGE_UNIT)) {
            return "com.kingdee.eas.basedata.org.app.StorageItemQuery";
        }
        if (type.equals((Object)CodeMatchTypeEnum.STUFF_NUMBER)) {
            return "com.kingdee.eas.mm.basedata.app.F7MaterialTrademarkQuery";
        }
        if (type.equals((Object)CodeMatchTypeEnum.Operation)) {
            return "com.kingdee.eas.mm.basedata.app.F7OperationQuery";
        }
        if (type.equals((Object)CodeMatchTypeEnum.WorkCenter)) {
            return "com.kingdee.eas.mm.basedata.app.F7WorkcenterQuery";
        }
        return null;
    }

    private EntityViewInfo getDefaultEntityViewInfo(CodeMatchTypeEnum type) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        String id = "";
        if (null != this.cuInfo) {
            id = this.cuInfo.getId().toString();
        } else if (null != this.kDPromptCU.getValue()) {
            this.cuInfo = (CtrlUnitInfo)this.kDPromptCU.getValue();
            id = this.cuInfo.getId().toString();
        }
        if (!type.equals((Object)CodeMatchTypeEnum.MEASUREMENT_UNIT)) {
            if (type.equals((Object)CodeMatchTypeEnum.MATERIAL_TYPE)) {
                filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)id, CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("groupStandard.standardType", (Object)new Integer(1), CompareType.EQUALS));
            } else if (type.equals((Object)CodeMatchTypeEnum.PROJECT_NUMBER)) {
                filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)id, CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("Project.baseStatus", (Object)new Integer(4), CompareType.EQUALS));
            } else if (type.equals((Object)CodeMatchTypeEnum.TRACK_NUMBER)) {
                filterInfo.getFilterItems().add(new FilterItemInfo("adminCU.id", (Object)id, CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(80), CompareType.NOTEQUALS));
            } else if (type.equals((Object)CodeMatchTypeEnum.STORAGE_UNIT)) {
                filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)id, CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)new Integer(1), CompareType.EQUALS));
            } else if (type.equals((Object)CodeMatchTypeEnum.CONTROL_UNIT)) {
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.EQUALS));
            } else if (type.equals((Object)CodeMatchTypeEnum.STUFF_NUMBER)) {
                filterInfo.getFilterItems().add(new FilterItemInfo("adminCU.id", (Object)id));
                filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)0));
            } else if (type.equals((Object)CodeMatchTypeEnum.Operation)) {
                if (this.prmtStorageOrgUnit.getValue() != null) {
                    String storageOrgUnitID = ((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getId().toString();
                    filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitID));
                    filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)20));
                } else {
                    filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", null));
                }
            } else if (type.equals((Object)CodeMatchTypeEnum.WorkCenter)) {
                if (this.prmtStorageOrgUnit.getValue() != null) {
                    String storageOrgUnitID = ((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getId().toString();
                    filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitID));
                    filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)20));
                } else {
                    filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", null));
                }
            }
        }
        viewInfo.setFilter(filterInfo);
        return viewInfo;
    }

    private void changeActionState(boolean isCanEdit) {
        this.actionAddLine.setEnabled(isCanEdit);
        this.actionInsertLine.setEnabled(isCanEdit);
        this.actionRemoveLine.setEnabled(isCanEdit);
        this.actionExtract.setEnabled(!isCanEdit);
        this.actionSave.setEnabled(isCanEdit);
        this.actionEdit.setEnabled(!isCanEdit);
        this.tblMain.setEditable(isCanEdit);
    }

    private void enableActionMenu() {
        this.actionAddLine.setEnabled(false);
        this.actionInsertLine.setEnabled(false);
        this.actionRemoveLine.setEnabled(false);
        this.actionExtract.setEnabled(true);
        this.actionSave.setEnabled(false);
        this.actionEdit.setEnabled(false);
        this.tblMain.setEditable(false);
    }

    private void clearEditData() {
        this.delRowSize = 0;
        this.addRowSize = 0;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.getRemoteInstance().getLock(this.cuInfo.getId().toString(), String.valueOf((Object)this.type))) {
            this.changeActionState(true);
            KDTableHelper.downArrowAutoAddRow((KDTable)this.tblMain, (boolean)true, (Action)this.actionTable);
            KDTableHelper.updateEnterWithTab((KDTable)this.tblMain, (boolean)true, (Action)this.actionTable);
        } else {
            MsgBox.showConfirm2((String)this.getResource("BASEDATA_MSG_LOCK"));
        }
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        TreeMap<String, Map> saveParams = new TreeMap<String, Map>();
        TreeMap addData = new TreeMap();
        TreeMap updateData = new TreeMap();
        this.getDataForSave(addData, updateData);
        if (addData.size() == 0 && updateData.size() == 0) {
            return;
        }
        if ((this.type.equals((Object)CodeMatchTypeEnum.Operation) || this.type.equals((Object)CodeMatchTypeEnum.WorkCenter)) && this.prmtStorageOrgUnit.getValue() == null) {
            MsgBox.showInfo((String)this.getResource("SOU_CanNotNull"));
            SysUtil.abort();
        }
        saveParams.put("selectParams", this.getDataParams());
        saveParams.put("add", addData);
        saveParams.put("update", updateData);
        Map result = this.getRemoteInstance().save(saveParams);
        this.afterSaveAction(result);
    }

    private void afterSaveAction(Map result) {
        if (!((Boolean)result.get("checkResult")).booleanValue()) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)this.getResource("DASEDATA_SAVE_ERROR_TITLE"), (String)((String)result.get("errorMessage")), (int)0);
        } else {
            this.releaseLock();
            this.changeActionState(false);
            this.clearEditData();
            this.refeshTable(this.type);
            KDTableHelper.downArrowAutoAddRow((KDTable)this.tblMain, (boolean)false, (Action)this.actionTable);
            KDTableHelper.updateEnterWithTab((KDTable)this.tblMain, (boolean)false, (Action)this.actionTable);
            this.setMessageText(EASResource.getString((String)"com.kingdee.eas.common.EASCommonResource.saveSuccessed"));
            this.setIsShowTextOnly(false);
            this.showMessage();
        }
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        IRow row;
        if ((this.type.equals((Object)CodeMatchTypeEnum.Operation) || this.type.equals((Object)CodeMatchTypeEnum.WorkCenter)) && this.prmtStorageOrgUnit.getValue() == null) {
            MsgBox.showInfo((String)this.getResource("SOU_CanNotNull"));
            SysUtil.abort();
        }
        if ((row = this.addLine(null)) != null) {
            this.tblMain.getSelectManager().setActiveRowIndex(row.getRowIndex());
            this.tblMain.getSelectManager().select(row.getRowIndex(), 0);
        }
    }

    @Override
    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        if ((this.type.equals((Object)CodeMatchTypeEnum.Operation) || this.type.equals((Object)CodeMatchTypeEnum.WorkCenter)) && this.prmtStorageOrgUnit.getValue() == null) {
            MsgBox.showInfo((String)this.getResource("SOU_CanNotNull"));
            SysUtil.abort();
        }
        ArrayList blocks = this.tblMain.getSelectManager().getBlocks();
        IRow row = null;
        if (null == blocks || blocks.size() < 1) {
            row = this.tblMain.addRow();
        } else {
            int rowBeginIndex = ((KDTSelectBlock)blocks.get(0)).getBeginRow();
            if (rowBeginIndex < 0) {
                rowBeginIndex = 0;
            }
            row = this.tblMain.addRow(rowBeginIndex);
        }
        if (this.type.equals((Object)CodeMatchTypeEnum.MATERIAL_PROPERTY)) {
            row.getCell("EASdata").setValue((Object)MaterialAttributeEnum.FABRICATEDPART);
            row.getCell("EASdataDesc").setValue((Object)MaterialAttributeEnum.FABRICATEDPART.getAlias());
        }
        row.getCell("isAdd").setValue((Object)new Integer(1));
        this.tblMain.getSelectManager().select(row.getRowIndex(), 0);
        ++this.addRowSize;
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        ArrayList blocks = this.tblMain.getSelectManager().getBlocks();
        int selectSize = blocks.size();
        if (selectSize == 0 || this.getDetailTable().getRowCount() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        int mode = this.tblMain.getSelectManager().get().getMode();
        if (mode == 8) {
            KDTSelectBlock selectBlock = (KDTSelectBlock)blocks.get(0);
            selectBlock.setBottom(0);
            selectBlock.setTop(this.getDetailTable().getRowCount() - 1);
        }
        if (!this.confirmRemove()) {
            return;
        }
        IRow row = null;
        ArrayList<BasedataMatchRelationInfo> ids = new ArrayList<BasedataMatchRelationInfo>();
        ArrayList<Integer> rowIndexs = new ArrayList<Integer>();
        String id = null;
        int tmpRowSize = 0;
        while (selectSize > 0) {
            int endRowIndex;
            KDTSelectBlock block = (KDTSelectBlock)blocks.get(selectSize - 1);
            int startRowIndex = block.getBeginRow();
            if (startRowIndex > (endRowIndex = block.getEndRow())) {
                int tmp = endRowIndex;
                endRowIndex = startRowIndex;
                startRowIndex = tmp;
            }
            while (endRowIndex >= startRowIndex) {
                row = this.tblMain.getRow(endRowIndex);
                id = (String)row.getCell("id").getValue();
                if (null != id) {
                    BasedataMatchRelationInfo info = new BasedataMatchRelationInfo();
                    info.setId(BOSUuid.read((String)id));
                    if (row.getCell("EASdata").getValue() instanceof DataBaseInfo) {
                        DataBaseInfo baseInfo = (DataBaseInfo)row.getCell("EASdata").getValue();
                        info.setEasNumber(baseInfo.getNumber());
                    } else if (row.getCell("EASdata").getValue() instanceof String) {
                        info.setEasNumber((String)row.getCell("EASdata").getValue());
                    } else if (row.getCell("EASdata").getValue() instanceof MaterialAttributeEnum) {
                        info.setEasNumber(String.valueOf(((MaterialAttributeEnum)row.getCell("EASdata").getValue()).getValue()));
                    }
                    ids.add(info);
                    ++this.delRowSize;
                } else {
                    ++tmpRowSize;
                }
                rowIndexs.add(new Integer(endRowIndex));
                if (--endRowIndex >= 0) continue;
            }
            if (--selectSize > 0) continue;
            break;
        }
        boolean isSuccess = true;
        if (ids.size() > 0) {
            try {
                this.getRemoteInstance().delete(ids);
            }
            catch (Exception err) {
                isSuccess = false;
                this.handleException(err);
            }
        }
        if (!isSuccess) {
            return;
        }
        int size = rowIndexs.size();
        for (int i = 0; i < size; ++i) {
            this.tblMain.removeRow(((Integer)rowIndexs.get(i)).intValue());
        }
        this.addRowSize -= tmpRowSize;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    public void actionExtract_actionPerformed(ActionEvent e) throws Exception {
        if (this.getRemoteInstance().getLock(this.cuInfo.getId().toString(), String.valueOf((Object)this.type))) {
            BasedataMatchRelationCollection coll;
            StorageOrgUnitInfo sou = null;
            if (CodeMatchTypeEnum.Operation.equals((Object)this.type) || CodeMatchTypeEnum.WorkCenter.equals((Object)this.type) || CodeMatchTypeEnum.StandardRooting.equals((Object)this.type)) {
                if (this.prmtStorageOrgUnit.getValue() == null) {
                    MsgBox.showInfo((String)this.getResource("SOU_CanNotNull"));
                    SysUtil.abort();
                }
                sou = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
            }
            if ((coll = BasedataMatchRelationFactory.getRemoteInstance().getExtractData(this.type.getValue(), (CtrlUnitInfo)this.kDPromptCU.getValue(), sou)) != null) {
                IRow row = null;
                for (int i = 0; i < coll.size(); ++i) {
                    BasedataMatchRelationInfo info = coll.get(i);
                    row = this.addLine(info);
                }
                if (row != null) {
                    this.tblMain.getSelectManager().setActiveRowIndex(row.getRowIndex());
                    this.tblMain.getSelectManager().select(row.getRowIndex(), 0);
                }
            }
            this.setMessageText(EASResource.getString((String)"com.kingdee.eas.mm.pdm.PDMResource.Extract_Success"));
            this.setIsShowTextOnly(false);
            this.showMessage();
            this.releaseLock();
        } else {
            MsgBox.showConfirm2((String)this.getResource("BASEDATA_MSG_LOCK"));
        }
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"PDMData", "EASdata"};
        return locateNames;
    }

    protected boolean checkBeforeWindowClosing() {
        return this.treatBeforeTableRefresh();
    }

    public String getResource(String sKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.pdm.PDMResource", (String)sKey);
    }

    protected String getEntityBOSType() throws Exception {
        return "457C873B";
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.ControlUnit;
    }

    protected CtrlUnitInfo getDefaultCtrlUnitOrg() throws EASBizException, BOSException {
        CtrlUnitInfo currentMainOrg = (CtrlUnitInfo)SysContext.getSysContext().getCurrentOrgUnit(this.getMainBizOrgType());
        return currentMainOrg;
    }

    protected IBasedataMatchRelation getRemoteInstance() throws BOSException {
        return BasedataMatchRelationFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    private IRow addLine(BasedataMatchRelationInfo info) {
        IRow row = this.tblMain.addRow();
        if (info != null) {
            if (this.type.equals((Object)CodeMatchTypeEnum.MATERIAL_PROPERTY)) {
                row.getCell("EASdata").setValue((Object)MaterialAttributeEnum.getEnum((int)Integer.parseInt(info.getEasNumber())));
            } else {
                row.getCell("EASdata").setValue((Object)info.getEasNumber());
            }
            row.getCell("easID").setValue((Object)info.getEasID());
            row.getCell("EASdataDesc").setValue((Object)info.getDescription());
            row.getCell("id").setValue((Object)info.getId().toString());
            row.getCell("PDMData").setValue((Object)info.getPdmCode());
        } else {
            if (this.type.equals((Object)CodeMatchTypeEnum.MATERIAL_PROPERTY)) {
                row.getCell("EASdata").setValue((Object)MaterialAttributeEnum.FABRICATEDPART);
                row.getCell("EASdataDesc").setValue((Object)MaterialAttributeEnum.FABRICATEDPART.getAlias());
            }
            row.getCell("isAdd").setValue((Object)new Integer(1));
            ++this.addRowSize;
        }
        return row;
    }

    private void getDataForSave(Map addData, Map updateData) {
        if (this.tblMain.getRowCount() <= 0) {
            return;
        }
        addData.clear();
        updateData.clear();
        IRow row = null;
        int rowSize = this.tblMain.getRowCount();
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < rowSize; ++i) {
            row = this.tblMain.getRow(i);
            if (row.getCell("EASdata").getValue() == null) {
                str.append(i + 1).append(",");
                continue;
            }
            if (null != row.getCell("isAdd").getValue()) {
                addData.put(new Integer(i), this.getRowData(row));
                continue;
            }
            if (null == row.getCell("isUpdate").getValue()) continue;
            updateData.put(new Integer(i), this.getRowData(row));
        }
        if (str.length() > 0) {
            String msg = str.substring(0, str.length() - 1);
            msg = MessageFormat.format(this.getResource("DASEDATA_SAVE_ERROR_EASCODE_NULL"), msg);
            MsgBox.showDetailAndOK((Component)((Object)this), (String)this.getResource("DASEDATA_SAVE_ERROR_TITLE"), (String)msg, (int)0);
            SysUtil.abort();
        }
    }

    private BasedataMatchRelationInfo getRowData(IRow row) {
        BasedataMatchRelationInfo info = new BasedataMatchRelationInfo();
        if (null != row.getCell("id").getValue()) {
            BOSUuid id = BOSUuid.read((String)((String)row.getCell("id").getValue()));
            info.setId(id);
        }
        if (row.getCell("EASdata").getValue() instanceof DataBaseInfo) {
            DataBaseInfo baseInfo = (DataBaseInfo)row.getCell("EASdata").getValue();
            info.setEasNumber(baseInfo.getNumber());
            info.setEasID(baseInfo.getId().toString());
        } else if (row.getCell("EASdata").getValue() instanceof String) {
            info.setEasNumber((String)row.getCell("EASdata").getValue());
            info.setEasID((String)row.getCell("easID").getValue());
        } else if (row.getCell("EASdata").getValue() instanceof MaterialAttributeEnum) {
            info.setEasNumber(String.valueOf(((MaterialAttributeEnum)row.getCell("EASdata").getValue()).getValue()));
            info.setEasID(null);
        }
        info.setPdmCode((String)row.getCell("PDMData").getValue());
        info.setDescription((String)row.getCell("EASdataDesc").getValue());
        info.setRemark((String)row.getCell("remark").getValue());
        info.setCu(this.cuInfo);
        info.setType(this.type);
        if (this.type.equals((Object)CodeMatchTypeEnum.Operation) || this.type.equals((Object)CodeMatchTypeEnum.WorkCenter)) {
            info.setStorageOrgUnit((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue());
        }
        return info;
    }

    private boolean treatBeforeTableRefresh() {
        boolean returnValue;
        block11: {
            boolean isChange = false;
            if (this.tblMain.getRowCount() < 0) {
                isChange = false;
            }
            IRow row = null;
            int rowSize = this.tblMain.getRowCount();
            for (int i = 0; i < rowSize; ++i) {
                row = this.tblMain.getRow(i);
                if (null != row.getCell("isAdd").getValue()) {
                    isChange = true;
                    break;
                }
                if (null == row.getCell("isUpdate").getValue()) continue;
                isChange = true;
                break;
            }
            if (!isChange) {
                returnValue = true;
            } else {
                int userChoice = MsgBox.showConfirm3((String)this.getResource("BASEDATA_TABLE_REFRESH_NOTICE_SAVE"));
                if (userChoice == 0) {
                    HashMap<String, Map> saveParams = new HashMap<String, Map>();
                    TreeMap addData = new TreeMap();
                    TreeMap updateData = new TreeMap();
                    this.getDataForSave(addData, updateData);
                    saveParams.put("selectParams", this.getDataParams());
                    saveParams.put("add", addData);
                    saveParams.put("update", updateData);
                    try {
                        Map result = this.getRemoteInstance().save(saveParams);
                        if (!((Boolean)result.get("checkResult")).booleanValue()) {
                            MsgBox.showDetailAndOK((Component)((Object)this), (String)this.getResource("DASEDATA_SAVE_ERROR_TITLE"), (String)((String)result.get("errorMessage")), (int)0);
                            returnValue = false;
                            break block11;
                        }
                        returnValue = true;
                    }
                    catch (BOSException e) {
                        this.handleException((Exception)((Object)e));
                        returnValue = false;
                    }
                } else {
                    returnValue = userChoice == 1;
                }
            }
        }
        if (!this.actionEdit.isEnabled()) {
            this.releaseLock();
        }
        return returnValue;
    }

    private void releaseLock() {
        try {
            this.getRemoteInstance().releaseLock(this.cuInfo.getId().toString(), String.valueOf((Object)this.type));
        }
        catch (BOSException e1) {
            this.handleException((Exception)((Object)e1));
        }
    }

    private Map getDataParams() {
        TreeMap<String, Object> dataParams = new TreeMap<String, Object>();
        dataParams.put("TYPE", (Object)this.type);
        dataParams.put("CU", this.cuInfo);
        dataParams.put("storageOrgUnit", this.prmtStorageOrgUnit.getValue());
        return dataParams;
    }

    protected KDTable getDetailTable() {
        return this.tblMain;
    }

    static {
        Dimension d = KDToolkit.getScreenSize();
        int h = 768;
        if (d != null) {
            h = d.height;
        }
        defaultPageRow = h <= 768 ? 30 : 50;
    }

    private class TreeNode {
        String name;
        CodeMatchTypeEnum type;

        public TreeNode(String name, CodeMatchTypeEnum type) {
            this.name = name;
            this.type = type;
        }

        public CodeMatchTypeEnum getType() {
            return this.type;
        }

        public String toString() {
            return this.name;
        }
    }
}

