/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.pdm.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.mm.pdm.IMaterialMatchRule;
import com.kingdee.eas.mm.pdm.MaterialMatchRuleFactory;
import com.kingdee.eas.mm.pdm.MaterialMatchRuleInfo;
import com.kingdee.eas.mm.pdm.MaterialMatchRuleStateEnum;
import com.kingdee.eas.mm.pdm.client.AbstractMaterialMatchRuleUI;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MaterialMatchRuleUI
extends AbstractMaterialMatchRuleUI {
    private static final long serialVersionUID = 1L;
    private static final String ROLE_DESC = "materialNumberMatchRole";
    private static final String ROLE_NUMBER = "roleNumber";
    private static final String ROLE_STATE = "state";
    private static final String ROLE_ID = "id";

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
    }

    private void init() {
        this.kDTable.checkParsed();
        this.forRowSet();
        this.iniMenu();
        this.menuItemAudit.setMnemonic(83);
        this.menuItemUnaudit.setMnemonic(67);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void forRowSet() {
        this.kDTable.removeRows();
        CoreBaseCollection collection = null;
        try {
            EntityViewInfo view = new EntityViewInfo();
            SorterItemCollection sorter = new SorterItemCollection();
            sorter.add(new SorterItemInfo("number"));
            view.setSorter(sorter);
            collection = this.getBizInterface().getCollection(view);
            MaterialMatchRuleInfo detailData = null;
            if (null != collection && collection.size() > 0) {
                int size = collection.size();
                for (int i = 0; i < size; ++i) {
                    detailData = (MaterialMatchRuleInfo)collection.getObject(i);
                    IRow row = this.kDTable.addRow();
                    row.getCell(ROLE_NUMBER).setValue((Object)detailData.getNumber());
                    row.getCell(ROLE_DESC).setValue((Object)detailData.getName());
                    row.getCell(ROLE_STATE).setValue((Object)detailData.getState());
                    row.getCell(ROLE_ID).setValue((Object)detailData.getId());
                }
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void iniMenu() {
        this.menuItemAudit.setEnabled(true);
        this.menuItemUnaudit.setEnabled(true);
        this.btnAudit.setEnabled(true);
        this.btnUnaudit.setEnabled(true);
        this.kDTable.getStyleAttributes().setLocked(true);
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.doAction(true);
    }

    @Override
    public void actionUnaudit_actionPerformed(ActionEvent e) throws Exception {
        this.doAction(false);
    }

    private void doAction(boolean isAudit) {
        ArrayList blocks = this.kDTable.getSelectManager().getBlocks();
        int selectSize = blocks.size();
        if (selectSize == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getResource("MATERIAL_MATCH_RULE_ACTION_NULL"));
            return;
        }
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        ArrayList<Integer> rows = new ArrayList<Integer>();
        IRow row = null;
        for (int i = 0; i < selectSize; ++i) {
            if (i == 0 && ((KDTSelectBlock)blocks.get(i)).getMode() == 8) {
                for (int j = 0; j < this.kDTable.getRowCount(); ++j) {
                    row = this.kDTable.getRow(j);
                    data.add(new Object[]{new Integer(j), row.getCell(ROLE_ID).getValue().toString(), row.getCell(ROLE_NUMBER).getValue().toString()});
                    rows.add(new Integer(j));
                }
                break;
            }
            int endRow = ((KDTSelectBlock)blocks.get(i)).getEndRow();
            for (int index = ((KDTSelectBlock)blocks.get(i)).getBeginRow(); index <= endRow; ++index) {
                row = this.kDTable.getRow(index);
                data.add(new Object[]{new Integer(index), row.getCell(ROLE_ID).getValue().toString(), row.getCell(ROLE_NUMBER).getValue().toString()});
                rows.add(new Integer(index));
            }
        }
        Map result = null;
        try {
            result = this.getBizInterface().update(data, isAudit);
            this.afterAction(isAudit, result, rows);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void afterAction(boolean isAudit, Map result, List rows) {
        int index;
        StringBuffer detailInfo = new StringBuffer();
        IRow row = null;
        for (int i = 0; i < rows.size(); ++i) {
            index = (Integer)rows.get(i);
            row = this.kDTable.getRow(index);
            if (isAudit) {
                row.getCell(ROLE_STATE).setValue((Object)MaterialMatchRuleStateEnum.OPEN);
                continue;
            }
            row.getCell(ROLE_STATE).setValue((Object)MaterialMatchRuleStateEnum.CLOSE);
        }
        String detailKey = "";
        String makey = "";
        if (isAudit) {
            makey = "MATERIAL_MATCH_RULE_AUDIT_FAIL_TOTAL";
            detailKey = "MATERIAL_MATCH_RULE_AUDIT_FAIL_DETAIL";
        } else {
            makey = "MATERIAL_MATCH_RULE_UNAUDIT_FAIL_TOTAL";
            detailKey = "MATERIAL_MATCH_RULE_UNAUDIT_FAIL_DETAIL";
        }
        if (!result.isEmpty()) {
            Iterator iterator = result.keySet().iterator();
            int failSize = 0;
            while (iterator.hasNext()) {
                ++failSize;
                index = (Integer)iterator.next();
                detailInfo.append(this.getResource(detailKey, new String[]{(String)this.kDTable.getRow(index).getCell(ROLE_NUMBER).getValue()})).append("\n");
            }
            MsgBox.showDetailAndOK((Component)((Object)this), (String)this.getResource(makey, new String[]{String.valueOf(rows.size()), String.valueOf(failSize)}), (String)detailInfo.toString(), (int)0);
        } else {
            if (isAudit) {
                this.setMessageText(this.getResource("MATERIAL_MATCH_RULE_AUDIT_SUCCESS"));
            } else {
                this.setMessageText(this.getResource("MATERIAL_MATCH_RULE_UNAUDIT_SUCCESS"));
            }
            this.showMessage();
        }
    }

    protected IMaterialMatchRule getBizInterface() throws Exception {
        return MaterialMatchRuleFactory.getRemoteInstance();
    }

    public String getResource(String sKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.pdm.PDMResource", (String)sKey);
    }

    private String getResource(String key, String[] params) {
        return ResourceUtils.getMessage((String)"com.kingdee.eas.mm.pdm.PDMResource", (String)key, (String[])params);
    }
}

