/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.pdm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.client.F7BaseSelector;
import com.kingdee.eas.basedata.master.material.client.MaterialClientTools;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.client.NewOrgViewF7PromptDialog;
import com.kingdee.eas.basedata.org.client.f7.NewCtrlF7;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.mm.common.util.MMConstant;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.mm.pdm.ActionResults;
import com.kingdee.eas.mm.pdm.DataFlagTypeEnum;
import com.kingdee.eas.mm.pdm.DataTypeEnum;
import com.kingdee.eas.mm.pdm.IMaterialMiddle;
import com.kingdee.eas.mm.pdm.MaterialMiddleFactory;
import com.kingdee.eas.mm.pdm.MaterialMiddleInfo;
import com.kingdee.eas.mm.pdm.client.AbstractMaterialMiddleEditUI;
import com.kingdee.eas.mm.pdm.client.F7MaterialGroupUI;
import com.kingdee.eas.scm.common.client.GeneralKDPromptSelectorAdaptor;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Map;

public class MaterialMiddleEditUI
extends AbstractMaterialMiddleEditUI {
    private static final long serialVersionUID = 5115722588885075954L;
    public static final String RESOURCE_PATH = "com.kingdee.eas.mm.pdm.PDMResource";
    private DataChangeListener easCuDataChangeListener = null;
    private DataChangeListener lengthUnitDataChangeListener = null;
    private DataChangeListener weightUnitDataChangeListener = null;
    private DataChangeListener volumnUnitDataChangeListener = null;
    private int defaultPresion = 8;

    public void onLoad() throws Exception {
        super.onLoad();
        this.hideWidget();
        this.setWidgetRange();
        this.setF7FilterForUnit();
        NewCtrlF7 ctrlF7 = new NewCtrlF7();
        ctrlF7.setNeedAddOrgRange(true);
        this.prmtCU.setSelector((KDPromptSelector)ctrlF7);
        NewOrgUnitFilterInfoProducer producer = new NewOrgUnitFilterInfoProducer((NewOrgViewF7PromptDialog)ctrlF7);
        this.prmtCU.setFilterInfoProducer((IFilterInfoProducer)producer);
    }

    @Override
    public void loadFields() {
        this.removeListener();
        super.loadFields();
        this.setF7FilterByCu();
        this.setWidgetPrecision();
        this.setToolButtonStatus();
        this.setWidgetStatus();
        this.addListener();
    }

    @Override
    public void storeFields() {
        super.storeFields();
        boolean flag = false;
        this.storeMaterial();
        if (!this.editData.isValueChange()) {
            flag = true;
        }
        if (flag) {
            this.initOldData((IObjectValue)this.editData);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.remove(new SelectorItemInfo("CU.*"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("CU.number"));
        sic.add(new SelectorItemInfo("CU.name"));
        sic.add(new SelectorItemInfo("CU.longNumber"));
        sic.remove(new SelectorItemInfo("link_materialGroup.*"));
        sic.add(new SelectorItemInfo("link_materialGroup.id"));
        sic.add(new SelectorItemInfo("link_materialGroup.number"));
        sic.add(new SelectorItemInfo("link_materialGroup.name"));
        sic.add(new SelectorItemInfo("link_materialGroup.groupStandard.standardType"));
        sic.add(new SelectorItemInfo("link_materialGroup.isLeaf"));
        sic.remove(new SelectorItemInfo("link_baseUnit.*"));
        sic.add(new SelectorItemInfo("link_baseUnit.id"));
        sic.add(new SelectorItemInfo("link_baseUnit.number"));
        sic.add(new SelectorItemInfo("link_baseUnit.name"));
        sic.remove(new SelectorItemInfo("link_lengthUnit.*"));
        sic.add(new SelectorItemInfo("link_lengthUnit.id"));
        sic.add(new SelectorItemInfo("link_lengthUnit.number"));
        sic.add(new SelectorItemInfo("link_lengthUnit.name"));
        sic.remove(new SelectorItemInfo("link_weightUnit.*"));
        sic.add(new SelectorItemInfo("link_weightUnit.id"));
        sic.add(new SelectorItemInfo("link_weightUnit.number"));
        sic.add(new SelectorItemInfo("link_weightUnit.name"));
        sic.remove(new SelectorItemInfo("link_volumnUnit.*"));
        sic.add(new SelectorItemInfo("link_volumnUnit.id"));
        sic.add(new SelectorItemInfo("link_volumnUnit.number"));
        sic.add(new SelectorItemInfo("link_volumnUnit.name"));
        sic.remove(new SelectorItemInfo("transmitUser.*"));
        sic.add(new SelectorItemInfo("transmitUser.id"));
        sic.add(new SelectorItemInfo("transmitUser.number"));
        sic.add(new SelectorItemInfo("transmitUser.name"));
        return sic;
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        if (!this.verify(e.getActionCommand())) {
            SysUtil.abort();
        }
        super.actionSave_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.setWidgetStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionCodeMatch_actionPerformed(ActionEvent e) throws Exception {
        if (!this.verify(e.getActionCommand())) {
            return;
        }
        IMaterialMiddle materialmiddle = (IMaterialMiddle)this.getBizInterface();
        String id = this.editData.getId().toString();
        ActionResults actionResults = new ActionResults();
        try {
            this.setOprtState("VIEW");
            this.pubFireVOChangeListener(id);
            actionResults = materialmiddle.codeMatch(new String[]{id});
        }
        catch (Exception exc) {
            this.handUIExceptionAndAbort(exc);
        }
        catch (Throwable exc) {
            actionResults.addError(id, exc.getMessage());
            this.handUIException(exc);
        }
        finally {
            try {
                this.pubFireVOChangeListener("");
            }
            catch (Throwable exc) {
                this.handUIException(exc);
            }
        }
        this.setMessageText(this.getResource("Code_Match_Finished"));
        this.showMessage();
        this.refreshCurPage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionTransmit_actionPerformed(ActionEvent e) throws Exception {
        if (!this.verify(e.getActionCommand())) {
            return;
        }
        IMaterialMiddle materialmiddle = (IMaterialMiddle)this.getBizInterface();
        String id = this.editData.getId().toString();
        ActionResults actionResults = new ActionResults();
        try {
            this.setOprtState("VIEW");
            this.pubFireVOChangeListener(id);
            actionResults = materialmiddle.transmit(new String[]{id});
        }
        catch (Exception exc) {
            this.handUIExceptionAndAbort(exc);
        }
        catch (Throwable exc) {
            actionResults.addError(id, exc.getMessage());
            this.handUIException(exc);
        }
        finally {
            try {
                this.pubFireVOChangeListener("");
            }
            catch (Throwable exc) {
                this.handUIException(exc);
            }
        }
        this.setMessageText(this.getResource("Transmit_Finished"));
        this.showMessage();
        this.refreshCurPage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionNoTransmit_actionPerformed(ActionEvent e) throws Exception {
        if (!this.verify(e.getActionCommand())) {
            return;
        }
        IMaterialMiddle materialmiddle = MaterialMiddleFactory.getRemoteInstance();
        String id = this.editData.getId().toString();
        ActionResults actionResults = new ActionResults();
        try {
            this.setOprtState("VIEW");
            this.pubFireVOChangeListener(id);
        }
        catch (Exception exc) {
            this.handUIExceptionAndAbort(exc);
        }
        catch (Throwable exc) {
            actionResults.addError(id, exc.getMessage());
            this.handUIException(exc);
        }
        finally {
            try {
                this.pubFireVOChangeListener("");
            }
            catch (Throwable exc) {
                this.handUIException(exc);
            }
        }
        actionResults = materialmiddle.noTransmit(new String[]{id});
        String errorStr = actionResults.getDetailErrors();
        if (MMUtils.isEmptyString((String)errorStr)) {
            this.setMessageText(this.getResource("No_Transmit_Finished"));
            this.showMessage();
        } else {
            String message = this.getResource("No_Transmit_Error");
            Map errorsMap = actionResults.getErrors();
            String msg = null;
            msg = (String)errorsMap.get(id);
            MsgBox.showDetailAndOK((Component)((Object)this), (String)message, (String)msg, (int)8188);
        }
        this.refreshCurPage();
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    public boolean destroyWindow() {
        this.refreshParentListUI();
        return super.destroyWindow();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnCodeMatch.setIcon(EASResource.getIcon((String)"imgTbtn_fmakeknown"));
        this.menuItemCodeMatch.setIcon(EASResource.getIcon((String)"imgTbtn_fmakeknown"));
        this.btnTransmit.setIcon(EASResource.getIcon((String)"imgTbtn_maintenance"));
        this.menuItemTransmit.setIcon(EASResource.getIcon((String)"imgTbtn_maintenance"));
        this.btnNoTransmit.setIcon(EASResource.getIcon((String)"imgTbtn_creat"));
        this.menuItemNoTransmit.setIcon(EASResource.getIcon((String)"imgTbtn_creat"));
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.hideWidget();
    }

    protected IObjectValue createNewData() {
        MaterialMiddleInfo info = new MaterialMiddleInfo();
        return info;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        return null;
    }

    protected KDTable getDetailTable() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return MaterialMiddleFactory.getRemoteInstance();
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtCU;
    }

    private void addListener() {
        if (this.easCuDataChangeListener == null) {
            this.easCuDataChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    MaterialMiddleEditUI.this.easCuChanged(e);
                }
            };
        }
        this.prmtCU.addDataChangeListener(this.easCuDataChangeListener);
        if (this.lengthUnitDataChangeListener == null) {
            this.lengthUnitDataChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    MaterialMiddleEditUI.this.lengthUnitChanged(e);
                }
            };
        }
        this.prmtLengthUnit.addDataChangeListener(this.lengthUnitDataChangeListener);
        if (this.weightUnitDataChangeListener == null) {
            this.weightUnitDataChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    MaterialMiddleEditUI.this.weightUnitChanged(e);
                }
            };
        }
        this.prmtWeightUnit.addDataChangeListener(this.weightUnitDataChangeListener);
        if (this.volumnUnitDataChangeListener == null) {
            this.volumnUnitDataChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    MaterialMiddleEditUI.this.volumeUnitChanged(e);
                }
            };
        }
        this.prmtVolumnUnit.addDataChangeListener(this.volumnUnitDataChangeListener);
    }

    private void removeListener() {
        if (this.easCuDataChangeListener != null) {
            this.prmtCU.removeDataChangeListener(this.easCuDataChangeListener);
        }
        if (this.lengthUnitDataChangeListener != null) {
            this.prmtLengthUnit.removeDataChangeListener(this.lengthUnitDataChangeListener);
        }
        if (this.weightUnitDataChangeListener != null) {
            this.prmtWeightUnit.removeDataChangeListener(this.weightUnitDataChangeListener);
        }
        if (this.volumnUnitDataChangeListener != null) {
            this.prmtVolumnUnit.removeDataChangeListener(this.volumnUnitDataChangeListener);
        }
    }

    private void hideWidget() {
        this.actionAuditResult.setVisible(false);
        this.btnAuditResult.setVisible(false);
        this.actionCreateFrom.setVisible(false);
        this.actionAttachment.setVisible(false);
        this.MenuItemAttachment.setVisible(false);
        this.menuItemPrint.setVisible(false);
        this.menuItemPrintPreview.setVisible(false);
    }

    private void setWidgetStatus() {
        if (this.getOprtState().equals("VIEW")) {
            return;
        }
        DataFlagTypeEnum flag = this.editData.getFlag();
        if (DataFlagTypeEnum.SUCCESS_TRANSMIT.equals((Object)flag) || DataFlagTypeEnum.NO_TRANSMIT.equals((Object)flag)) {
            this.lockUIComponent();
        } else if (DataFlagTypeEnum.SUCCESS_MATCHED.equals((Object)flag) || DataFlagTypeEnum.FAIL_TRANSMIT.equals((Object)flag)) {
            this.setComponentEnabled(false);
        } else {
            this.setComponentEnabled(true);
        }
    }

    private void setToolButtonStatus() {
        DataFlagTypeEnum flag = this.editData.getFlag();
        if (DataFlagTypeEnum.HAS_NOT_TRANSMIT.equals((Object)flag) || DataFlagTypeEnum.FAIL_MATCHED.equals((Object)flag)) {
            this.actionCodeMatch.setEnabled(true);
        } else {
            this.actionCodeMatch.setEnabled(false);
        }
        if (DataFlagTypeEnum.SUCCESS_MATCHED.equals((Object)flag) || DataFlagTypeEnum.FAIL_TRANSMIT.equals((Object)flag)) {
            this.actionTransmit.setEnabled(true);
        } else {
            this.actionTransmit.setEnabled(false);
        }
        if (DataFlagTypeEnum.SUCCESS_TRANSMIT.equals((Object)flag) || DataFlagTypeEnum.NO_TRANSMIT.equals((Object)flag)) {
            this.actionNoTransmit.setEnabled(false);
        } else {
            this.actionNoTransmit.setEnabled(true);
        }
        if (this.getOprtState().equals("VIEW")) {
            if (DataFlagTypeEnum.SUCCESS_TRANSMIT.equals((Object)flag) || DataFlagTypeEnum.NO_TRANSMIT.equals((Object)flag)) {
                this.actionEdit.setEnabled(false);
            } else {
                this.actionEdit.setEnabled(true);
            }
        }
    }

    private boolean verify(String actionCommand) {
        if ((actionCommand = actionCommand.toLowerCase()).endsWith("save")) {
            return this.verifySave();
        }
        if ((actionCommand.endsWith("codematch") || actionCommand.endsWith("transmit") || actionCommand.endsWith("notransmit")) && this.isModify()) {
            String message = this.getResource("IsSaveBeforeOperation");
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)message);
            if (result == 0) {
                try {
                    String command = "com.kingdee.eas.framework.client.AbstractEditUI$ActionSave";
                    ActionEvent event = new ActionEvent(this.btnSave, 1001, command);
                    this.actionSave_actionPerformed(event);
                }
                catch (Exception e) {
                    this.handUIException(e);
                    return false;
                }
            } else {
                return result == 1;
            }
        }
        return true;
    }

    private boolean verifySave() {
        String number;
        boolean rst = true;
        Object materialObj = this.prmtMaterial.getValue();
        if (materialObj != null && materialObj instanceof String && (number = (String)materialObj).length() > 80) {
            MsgBox.showWarning((Component)((Object)this), (String)this.getResource("Material_Number_TooLong"));
            this.prmtMaterial.requestFocus();
            return false;
        }
        String notNullStr = this.getResource("Field_Not_Null");
        String name = this.txtName.getText();
        if (MMUtils.isEmptyString((String)name)) {
            MsgBox.showWarning((Component)((Object)this), (String)(this.getResource("Material_Name") + notNullStr));
            this.txtName.requestFocus();
            return false;
        }
        String materialGroup = this.txtPdmMaterialGroup.getText();
        if (MMUtils.isEmptyString((String)materialGroup)) {
            MsgBox.showWarning((Component)((Object)this), (String)(this.getResource("Pdm_Material_Group") + notNullStr));
            this.txtPdmMaterialGroup.requestFocus();
            return false;
        }
        String baseUnit = this.txtPdmBaseUnit.getText();
        if (MMUtils.isEmptyString((String)baseUnit)) {
            MsgBox.showWarning((Component)((Object)this), (String)(this.getResource("Pdm_Base_Unit") + notNullStr));
            this.txtPdmBaseUnit.requestFocus();
            return false;
        }
        String pdmCu = this.txtPdmCU.getText();
        if (MMUtils.isEmptyString((String)pdmCu)) {
            MsgBox.showWarning((Component)((Object)this), (String)(this.getResource("Pdm_Cu") + notNullStr));
            this.txtPdmCU.requestFocus();
            return false;
        }
        CtrlUnitInfo cu = (CtrlUnitInfo)this.prmtCU.getValue();
        if (cu == null || MMUtils.isEmptyString((String)cu.getId().toString())) {
            MsgBox.showWarning((Component)((Object)this), (String)(this.getResource("Eas_Cu") + notNullStr));
            this.prmtCU.requestFocus();
            return false;
        }
        return rst;
    }

    private void setComponentEnabled(boolean isEnabeld) {
        if (isEnabeld) {
            this.prmtMaterial.setAccessAuthority(0);
            this.prmtCU.setAccessAuthority(0);
        } else {
            this.prmtMaterial.setAccessAuthority(1);
            this.prmtCU.setAccessAuthority(1);
        }
        this.txtPdmMaterialGroup.setEnabled(isEnabeld);
        this.txtPdmBaseUnit.setEnabled(isEnabeld);
        this.txtPdmLengthUnit.setEnabled(isEnabeld);
        this.txtPdmWeightUnit.setEnabled(isEnabeld);
        this.txtPdmVolumnUnit.setEnabled(isEnabeld);
        this.txtPdmCU.setEnabled(isEnabeld);
        this.prmtMaterialGroup.setEnabled(isEnabeld);
        this.prmtBaseUnit.setEnabled(isEnabeld);
        this.prmtLengthUnit.setEnabled(isEnabeld);
        this.prmtWeightUnit.setEnabled(isEnabeld);
        this.prmtVolumnUnit.setEnabled(isEnabeld);
    }

    private void setF7FilterForUnit() {
        MaterialClientTools.setMeasureUnitF7((Component)((Object)this), (KDBizPromptBox)this.prmtBaseUnit);
        MaterialClientTools.setMeasureUnitF7((Component)((Object)this), (KDBizPromptBox)this.prmtLengthUnit);
        MaterialClientTools.setMeasureUnitF7((Component)((Object)this), (KDBizPromptBox)this.prmtWeightUnit);
        MaterialClientTools.setMeasureUnitF7((Component)((Object)this), (KDBizPromptBox)this.prmtVolumnUnit);
    }

    private void setF7FilterByCu() {
        CtrlUnitInfo cu = (CtrlUnitInfo)this.prmtCU.getValue();
        if (cu == null) {
            return;
        }
        this.setMaterialGroupFilter(this.prmtMaterialGroup, cu, (Object)this, false);
        this.initF7Material(cu, this.prmtMaterial);
        KDBizPromptBox box = this.getMainBizOrg();
        this.prmtMaterial.setCurrentCtrlUnit((CtrlUnitInfo)box.getValue());
    }

    private void initF7Material(CtrlUnitInfo cu, KDBizPromptBox prmtMaterial) {
        try {
            prmtMaterial.setEditFormat("$number$");
            prmtMaterial.setDisplayFormat("$number$");
            prmtMaterial.setCommitFormat("$number$;$name$;$model$;$helpCode$");
            int f7DisplayMode = SCMGroupClientUtils.getF7DisplayMode((String)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            if (f7DisplayMode == 0) {
                String materialGroupQuery = "com.kingdee.eas.mm.pdm.app.F7MaterialGroupQuery";
                String materialNoGroupQuery = "com.kingdee.eas.mm.pdm.app.F7MaterialNoGroupQuery";
                GeneralKDPromptSelectorAdaptor selectorLisenterMaterial = new GeneralKDPromptSelectorAdaptor((KDPromptBox)prmtMaterial, "com.kingdee.eas.basedata.master.material.client.F7MaterialTreeListUI", (Object)this, MaterialGroupInfo.getBosType(), materialGroupQuery, "materialGroup.id", null, materialNoGroupQuery);
                selectorLisenterMaterial.setIsMultiSelect(true);
                prmtMaterial.setSelector((KDPromptSelector)selectorLisenterMaterial);
                prmtMaterial.addSelectorListener((SelectorListener)selectorLisenterMaterial);
                entityViewInfo = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                if (cu != null) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cu.getId().toString(), CompareType.EQUALS));
                }
                entityViewInfo.setFilter(filterInfo);
            } else {
                prmtMaterial.setQueryInfo("com.kingdee.eas.mm.pdm.app.F7MaterialNoGroupQuery");
                entityViewInfo = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                if (cu != null) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)cu.getId().toString(), CompareType.EQUALS));
                }
                entityViewInfo.setFilter(filterInfo);
            }
            prmtMaterial.setEditable(true);
            prmtMaterial.setEnabledMultiSelection(false);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void loadMaterial() {
        String number = this.editData.getBase_materialNumber();
        if (MMUtils.isEmptyString((String)number)) {
            this.prmtMaterial.setValue(null);
            return;
        }
        MaterialInfo material = this.editData.getLink_material();
        if (material == null) {
            this.prmtMaterial.setValue((Object)number);
        } else {
            material.setNumber(number);
            this.prmtMaterial.setValue((Object)material);
        }
    }

    private void storeMaterial() {
        Object obj = this.prmtMaterial.getValue();
        if (obj == null) {
            this.editData.setLink_material(null);
            return;
        }
        MaterialInfo material = null;
        if (obj instanceof MaterialInfo) {
            material = (MaterialInfo)obj;
            this.editData.setLink_material(material);
        } else if (obj instanceof String) {
            this.editData.setLink_material(null);
        } else if (obj instanceof MaterialInfo[]) {
            material = ((MaterialInfo[])obj)[0];
            this.editData.setLink_material(material);
        }
    }

    private String getResource(String key) {
        String rst = null;
        rst = EASResource.getString((String)RESOURCE_PATH, (String)key);
        return rst;
    }

    private void setWidgetRange() {
        BigDecimal zeroDecimal = MMConstant.BIGDECIMAL_ZERO;
        this.txtLength.setMinimumValue((Comparable)zeroDecimal);
        this.txtWidth.setMinimumValue((Comparable)zeroDecimal);
        this.txtHeight.setMinimumValue((Comparable)zeroDecimal);
        this.txtGrossWeight.setMinimumValue((Comparable)zeroDecimal);
        this.txtNetWeight.setMinimumValue((Comparable)zeroDecimal);
        this.txtVolume.setMinimumValue((Comparable)zeroDecimal);
    }

    private void easCuChanged(DataChangeEvent e) {
        CtrlUnitInfo oldCU = (CtrlUnitInfo)e.getOldValue();
        CtrlUnitInfo newCU = (CtrlUnitInfo)e.getNewValue();
        if (newCU == null) {
            MsgBox.showWarning((Component)((Object)this), (String)(this.getResource("Eas_Cu") + this.getResource("Field_Not_Null")));
            this.removeListener();
            this.prmtCU.setValue((Object)oldCU);
            this.addListener();
            return;
        }
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)newCU, (Object)oldCU);
        if (isDiffrent) {
            this.prmtMaterial.setValue(null);
            this.prmtMaterialGroup.setValue(null);
            this.setF7FilterByCu();
        }
    }

    private void lengthUnitChanged(DataChangeEvent e) {
        MeasureUnitInfo oldUnit;
        MeasureUnitInfo newUnit = (MeasureUnitInfo)e.getNewValue();
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)newUnit, (Object)(oldUnit = (MeasureUnitInfo)e.getOldValue()));
        if (isDiffrent) {
            this.setLengthWidgetPrecision((KDBizPromptBox)e.getSource());
        }
    }

    private void weightUnitChanged(DataChangeEvent e) {
        MeasureUnitInfo oldUnit;
        MeasureUnitInfo newUnit = (MeasureUnitInfo)e.getNewValue();
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)newUnit, (Object)(oldUnit = (MeasureUnitInfo)e.getOldValue()));
        if (isDiffrent) {
            this.setWeightWidgetPrecision((KDBizPromptBox)e.getSource());
        }
    }

    private void volumeUnitChanged(DataChangeEvent e) {
        MeasureUnitInfo oldUnit;
        MeasureUnitInfo newUnit = (MeasureUnitInfo)e.getNewValue();
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)newUnit, (Object)(oldUnit = (MeasureUnitInfo)e.getOldValue()));
        if (isDiffrent) {
            this.setVolumeWidgetPrecision((KDBizPromptBox)e.getSource());
        }
    }

    private void setLengthWidgetPrecision(KDBizPromptBox box) {
        int precision = this.getPrecision(box);
        KDFormattedTextField[] fields = new KDFormattedTextField[]{this.txtLength, this.txtWidth, this.txtHeight};
        for (int i = 0; i < fields.length; ++i) {
            this.setPrecision(fields[i], precision);
        }
    }

    private void setWeightWidgetPrecision(KDBizPromptBox box) {
        int precision = this.getPrecision(box);
        KDFormattedTextField[] fields = new KDFormattedTextField[]{this.txtGrossWeight, this.txtNetWeight};
        for (int i = 0; i < fields.length; ++i) {
            this.setPrecision(fields[i], precision);
        }
    }

    private void setVolumeWidgetPrecision(KDBizPromptBox box) {
        int precision = this.getPrecision(box);
        this.setPrecision(this.txtVolume, precision);
    }

    private int getPrecision(KDBizPromptBox box) {
        MeasureUnitInfo unit = (MeasureUnitInfo)box.getValue();
        int precision = this.defaultPresion;
        if (unit != null) {
            precision = unit.getQtyPrecision();
        }
        return precision;
    }

    private void setPrecision(KDFormattedTextField field, int precision) {
        field.setDataType(1);
        field.setPrecision(precision);
        BigDecimal valBd = field.getBigDecimalValue();
        if (valBd != null) {
            valBd = valBd.setScale(precision, 4);
            field.setValue((Object)valBd);
        }
    }

    private void setWidgetPrecision() {
        this.setLengthWidgetPrecision(this.prmtLengthUnit);
        this.setWeightWidgetPrecision(this.prmtWeightUnit);
        this.setVolumeWidgetPrecision(this.prmtVolumnUnit);
    }

    private void setMaterialGroupFilter(KDBizPromptBox prmtMaterialGroup, CtrlUnitInfo cu, Object owner, boolean isMulSelect) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("groupStandard.standardType", (Object)new Integer(1)));
        if (!MaterialInfo.isAllowNonLeafGroup()) {
            filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)Boolean.TRUE));
        }
        view.setFilter(filter);
        prmtMaterialGroup.setEntityViewInfo(view);
        UIContext ctx = new UIContext(owner);
        ctx.put((Object)"onlyBaseStandard", (Object)Boolean.TRUE);
        ctx.put((Object)"cu", (Object)cu);
        Class innerUIClass = com.kingdee.eas.basedata.master.material.client.F7MaterialGroupUI.class;
        if (isMulSelect) {
            innerUIClass = F7MaterialGroupUI.class;
        }
        F7BaseSelector f7Selector = new F7BaseSelector(innerUIClass, prmtMaterialGroup, ctx);
        prmtMaterialGroup.setSelector((KDPromptSelector)f7Selector);
    }

    private void setMaterialCommitParser(DataTypeEnum type) {
        if (DataTypeEnum.UPDATE.equals((Object)type)) {
            com.kingdee.eas.mm.common.client.MMUtils.handleManualInputForF7((KDBizPromptBox[])new KDBizPromptBox[]{this.prmtMaterial});
        }
    }

    private void refreshCurPage() throws EASBizException, BOSException, Exception {
        if (this.editData.getId() != null) {
            ObjectUuidPK iObjectPk = new ObjectUuidPK(this.editData.getId());
            IObjectValue iObjectValue = this.getValue((IObjectPK)iObjectPk);
            this.setDataObject(iObjectValue);
            this.loadFields();
            this.initOldData((IObjectValue)this.editData);
            this.setSave(true);
            this.setSaved(true);
        }
    }

    private void refreshParentListUI() {
        Object ui = this.getUIContext().get("Owner");
        if (ui instanceof ListUI) {
            ListUI listui = (ListUI)ui;
            if (ui != null) {
                try {
                    listui.refreshList();
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            }
        }
    }
}

