/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.report.IReport;
import com.kingdee.eas.base.report.IReportServer;
import com.kingdee.eas.base.report.ReportFactory;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.mm.basedata.PlanVersionSetInfo;
import com.kingdee.eas.mm.report.MRPResultReportTitles;
import com.kingdee.eas.mm.report.client.AbstractMRPPlanVersionSetUI;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class MRPPlanVersionSetUI
extends AbstractMRPPlanVersionSetUI {
    private static final Logger logger = CoreUIObject.getLogger(MRPPlanVersionSetUI.class);
    private boolean isConformed = false;
    private boolean isOriginSimulant = false;
    private RptParams filter = null;
    private DataChangeListener prmtPlanVersionListener = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.setUIMenuBar(null);
        this.setComponents();
        this.addListener();
    }

    private void setComponents() throws Exception {
        this.filter = (RptParams)((RptParams)this.getUIContext().get("filter")).clone();
        RptParams totalFilter = null;
        totalFilter = this.filter.getBoolean("isconnect") ? (RptParams)this.filter.getObject("totalfilter") : (RptParams)this.getUIContext().get("filter");
        String stoNumber = totalFilter.getString("storageOrgUnit");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.number", (Object)stoNumber, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(20), CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        this.prmtPlanVersionSet.setEntityViewInfo(viewInfo);
        this.prmtPlanVersionSet.setValue(this.getUIContext().get("planVersion"));
        KDPanel title = (KDPanel)this.getUIContext().get("title");
        String isSimulantResult = ((KDLabel)title.getComponent(12)).getText();
        this.isOriginSimulant = this.getResource("YES").equals(isSimulantResult.split(this.getResource("COLON"))[1].trim());
        this.kDCheckBox1.setSelected(!this.isOriginSimulant);
    }

    public boolean isConfirmed() {
        return this.isConformed;
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (this.prmtPlanVersionSet.getValue() == null) {
            MsgBox.showInfo((String)this.getResource("PLEASE_SELECT_CONTRAST_PLANVERSION"));
            return;
        }
        this.isConformed = true;
        PlanVersionSetInfo pvInfo = (PlanVersionSetInfo)this.prmtPlanVersionSet.getValue();
        if (this.filter.getBoolean("isconnect")) {
            ((HashMap)this.filter.getObject("rowdata")).put("FPLANNUM", pvInfo.getNumber());
            ((RptParams)this.filter.getObject("totalfilter")).setString("isSimulantResult", Boolean.valueOf(this.kDCheckBox1.isSelected()).toString());
        } else {
            this.filter.setString("planNum", pvInfo.getNumber());
            this.filter.setString("isSimulantResult", new Boolean(this.kDCheckBox1.isSelected()).toString());
        }
        IReport report = ReportFactory.createReport((String)"VY6l/mhnQuJvgQABEDWARDs5PzmA=", null);
        report.setFilter(this.filter);
        report.Refresh();
        MRPResultReportTitles titles = (MRPResultReportTitles)report.getReportTitles();
        HashMap<String, Object> statTables = new HashMap<String, Object>();
        statTables.put("tblDispInDay", titles.getUserObject("tblDispInDay"));
        statTables.put("tblDispInWeek", titles.getUserObject("tblDispInWeek"));
        statTables.put("tblDispInMonth", titles.getUserObject("tblDispInMonth"));
        statTables.put("tblDispInPeriods", titles.getUserObject("tblDispInPeriods"));
        statTables.put("mainTable", titles.getUserObject("mainTable"));
        this.getUIContext().put("contarstTables", statTables);
        this.getUIContext().put("contrastPlanVersion", (PlanVersionSetInfo)this.prmtPlanVersionSet.getValue());
        this.getUIContext().put("isContrastSimulant", new Boolean(this.kDCheckBox1.isSelected()));
        this.getUIContext().put("planDate", titles.getUserObject("planDate"));
        this.destroyWindow();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }

    private void addListener() {
        if (this.prmtPlanVersionListener == null) {
            this.prmtPlanVersionListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    try {
                        MRPPlanVersionSetUI.this.prmtPlanVersionChanged(eventObj);
                    }
                    catch (Exception e) {
                        MRPPlanVersionSetUI.this.handUIException(e);
                    }
                }
            };
        }
        this.prmtPlanVersionSet.addDataChangeListener(this.prmtPlanVersionListener);
    }

    private void prmtPlanVersionChanged(DataChangeEvent eventObj) {
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)eventObj.getNewValue(), (Object)eventObj.getOldValue());
        if (!isDiffrent || eventObj.getNewValue() == null) {
            return;
        }
        PlanVersionSetInfo oriPvInfo = (PlanVersionSetInfo)this.getUIContext().get("planVersion");
        PlanVersionSetInfo pvInfo = (PlanVersionSetInfo)eventObj.getNewValue();
        boolean isContrastSimulant = false;
        isContrastSimulant = SCMGroupClientUtils.isDiffrent((Object)oriPvInfo, (Object)pvInfo) ? this.isOriginSimulant : !this.isOriginSimulant;
        this.kDCheckBox1.setSelected(isContrastSimulant);
    }

    private IReportServer getReportServer() throws BOSException {
        IReportServer server = (IReportServer)BOSObjectFactory.createRemoteBOSObject((String)"com.kingdee.eas.mm.report.app.PlanerWorkPlatformReport", IReportServer.class);
        return server;
    }

    private String getResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.mm.report.PlannerResource", (String)key);
    }
}

